# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetServerlessContainerResult',
    'AwaitableGetServerlessContainerResult',
    'get_serverless_container',
    'get_serverless_container_output',
]

@pulumi.output_type
class GetServerlessContainerResult:
    """
    A collection of values returned by getServerlessContainer.
    """
    def __init__(__self__, concurrency=None, connectivity=None, container_id=None, core_fraction=None, cores=None, created_at=None, description=None, execution_timeout=None, folder_id=None, id=None, images=None, labels=None, log_options=None, memory=None, mounts=None, name=None, revision_id=None, runtime=None, secrets=None, service_account_id=None, storage_mounts=None, url=None):
        if concurrency and not isinstance(concurrency, int):
            raise TypeError("Expected argument 'concurrency' to be a int")
        pulumi.set(__self__, "concurrency", concurrency)
        if connectivity and not isinstance(connectivity, dict):
            raise TypeError("Expected argument 'connectivity' to be a dict")
        pulumi.set(__self__, "connectivity", connectivity)
        if container_id and not isinstance(container_id, str):
            raise TypeError("Expected argument 'container_id' to be a str")
        pulumi.set(__self__, "container_id", container_id)
        if core_fraction and not isinstance(core_fraction, int):
            raise TypeError("Expected argument 'core_fraction' to be a int")
        pulumi.set(__self__, "core_fraction", core_fraction)
        if cores and not isinstance(cores, int):
            raise TypeError("Expected argument 'cores' to be a int")
        pulumi.set(__self__, "cores", cores)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if execution_timeout and not isinstance(execution_timeout, str):
            raise TypeError("Expected argument 'execution_timeout' to be a str")
        pulumi.set(__self__, "execution_timeout", execution_timeout)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if images and not isinstance(images, list):
            raise TypeError("Expected argument 'images' to be a list")
        pulumi.set(__self__, "images", images)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if log_options and not isinstance(log_options, list):
            raise TypeError("Expected argument 'log_options' to be a list")
        pulumi.set(__self__, "log_options", log_options)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if mounts and not isinstance(mounts, list):
            raise TypeError("Expected argument 'mounts' to be a list")
        pulumi.set(__self__, "mounts", mounts)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if revision_id and not isinstance(revision_id, str):
            raise TypeError("Expected argument 'revision_id' to be a str")
        pulumi.set(__self__, "revision_id", revision_id)
        if runtime and not isinstance(runtime, dict):
            raise TypeError("Expected argument 'runtime' to be a dict")
        pulumi.set(__self__, "runtime", runtime)
        if secrets and not isinstance(secrets, list):
            raise TypeError("Expected argument 'secrets' to be a list")
        pulumi.set(__self__, "secrets", secrets)
        if service_account_id and not isinstance(service_account_id, str):
            raise TypeError("Expected argument 'service_account_id' to be a str")
        pulumi.set(__self__, "service_account_id", service_account_id)
        if storage_mounts and not isinstance(storage_mounts, list):
            raise TypeError("Expected argument 'storage_mounts' to be a list")
        pulumi.set(__self__, "storage_mounts", storage_mounts)
        if url and not isinstance(url, str):
            raise TypeError("Expected argument 'url' to be a str")
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def concurrency(self) -> int:
        """
        Concurrency of Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "concurrency")

    @property
    @pulumi.getter
    def connectivity(self) -> Optional['outputs.GetServerlessContainerConnectivityResult']:
        """
        Network access. If specified the revision will be attached to specified network
        """
        return pulumi.get(self, "connectivity")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="coreFraction")
    def core_fraction(self) -> int:
        """
        Core fraction (**0...100**) of the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "core_fraction")

    @property
    @pulumi.getter
    def cores(self) -> int:
        return pulumi.get(self, "cores")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> str:
        """
        Execution timeout (duration format) of Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "execution_timeout")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetServerlessContainerImageResult']:
        return pulumi.get(self, "images")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of key/value label pairs assigned to the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="logOptions")
    def log_options(self) -> Sequence['outputs.GetServerlessContainerLogOptionResult']:
        """
        Options for logging from Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "log_options")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Memory in megabytes of Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def mounts(self) -> Sequence['outputs.GetServerlessContainerMountResult']:
        """
        Mounts for Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "mounts")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Last revision ID of the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def runtime(self) -> 'outputs.GetServerlessContainerRuntimeResult':
        """
        Runtime for Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "runtime")

    @property
    @pulumi.getter
    def secrets(self) -> Sequence['outputs.GetServerlessContainerSecretResult']:
        """
        Secrets for Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "secrets")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> str:
        """
        Service account ID of Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "service_account_id")

    @property
    @pulumi.getter(name="storageMounts")
    @_utilities.deprecated("""to manage storage_mountss, please switch to using a separate resource type mounts""")
    def storage_mounts(self) -> Sequence['outputs.GetServerlessContainerStorageMountResult']:
        """
        (**DEPRECATED**, use `mounts.0.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "storage_mounts")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Invoke URL of the Yandex Cloud Serverless Container
        """
        return pulumi.get(self, "url")


class AwaitableGetServerlessContainerResult(GetServerlessContainerResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServerlessContainerResult(
            concurrency=self.concurrency,
            connectivity=self.connectivity,
            container_id=self.container_id,
            core_fraction=self.core_fraction,
            cores=self.cores,
            created_at=self.created_at,
            description=self.description,
            execution_timeout=self.execution_timeout,
            folder_id=self.folder_id,
            id=self.id,
            images=self.images,
            labels=self.labels,
            log_options=self.log_options,
            memory=self.memory,
            mounts=self.mounts,
            name=self.name,
            revision_id=self.revision_id,
            runtime=self.runtime,
            secrets=self.secrets,
            service_account_id=self.service_account_id,
            storage_mounts=self.storage_mounts,
            url=self.url)


def get_serverless_container(connectivity: Optional[Union['GetServerlessContainerConnectivityArgs', 'GetServerlessContainerConnectivityArgsDict']] = None,
                             container_id: Optional[str] = None,
                             folder_id: Optional[str] = None,
                             mounts: Optional[Sequence[Union['GetServerlessContainerMountArgs', 'GetServerlessContainerMountArgsDict']]] = None,
                             name: Optional[str] = None,
                             runtime: Optional[Union['GetServerlessContainerRuntimeArgs', 'GetServerlessContainerRuntimeArgsDict']] = None,
                             secrets: Optional[Sequence[Union['GetServerlessContainerSecretArgs', 'GetServerlessContainerSecretArgsDict']]] = None,
                             storage_mounts: Optional[Sequence[Union['GetServerlessContainerStorageMountArgs', 'GetServerlessContainerStorageMountArgsDict']]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServerlessContainerResult:
    """
    Get information about a Yandex Cloud Serverless Container.

    ## Example Usage

    {{ tffile "examples/serverless_container/d_serverless_container_1.tf" }}

    This data source is used to define Yandex Cloud Container that can be used by other resources.


    :param Union['GetServerlessContainerConnectivityArgs', 'GetServerlessContainerConnectivityArgsDict'] connectivity: Network access. If specified the revision will be attached to specified network
    :param str container_id: Yandex Cloud Serverless Container id used to define container
    :param str folder_id: Folder ID for the Yandex Cloud Serverless Container
           
           > Either `container_id` or `name` must be specified.
    :param Sequence[Union['GetServerlessContainerMountArgs', 'GetServerlessContainerMountArgsDict']] mounts: Mounts for Yandex Cloud Serverless Container
    :param str name: Yandex Cloud Serverless Container name used to define container
    :param Union['GetServerlessContainerRuntimeArgs', 'GetServerlessContainerRuntimeArgsDict'] runtime: Runtime for Yandex Cloud Serverless Container
    :param Sequence[Union['GetServerlessContainerSecretArgs', 'GetServerlessContainerSecretArgsDict']] secrets: Secrets for Yandex Cloud Serverless Container
    :param Sequence[Union['GetServerlessContainerStorageMountArgs', 'GetServerlessContainerStorageMountArgsDict']] storage_mounts: (**DEPRECATED**, use `mounts.0.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container
    """
    __args__ = dict()
    __args__['connectivity'] = connectivity
    __args__['containerId'] = container_id
    __args__['folderId'] = folder_id
    __args__['mounts'] = mounts
    __args__['name'] = name
    __args__['runtime'] = runtime
    __args__['secrets'] = secrets
    __args__['storageMounts'] = storage_mounts
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getServerlessContainer:getServerlessContainer', __args__, opts=opts, typ=GetServerlessContainerResult).value

    return AwaitableGetServerlessContainerResult(
        concurrency=pulumi.get(__ret__, 'concurrency'),
        connectivity=pulumi.get(__ret__, 'connectivity'),
        container_id=pulumi.get(__ret__, 'container_id'),
        core_fraction=pulumi.get(__ret__, 'core_fraction'),
        cores=pulumi.get(__ret__, 'cores'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        execution_timeout=pulumi.get(__ret__, 'execution_timeout'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        images=pulumi.get(__ret__, 'images'),
        labels=pulumi.get(__ret__, 'labels'),
        log_options=pulumi.get(__ret__, 'log_options'),
        memory=pulumi.get(__ret__, 'memory'),
        mounts=pulumi.get(__ret__, 'mounts'),
        name=pulumi.get(__ret__, 'name'),
        revision_id=pulumi.get(__ret__, 'revision_id'),
        runtime=pulumi.get(__ret__, 'runtime'),
        secrets=pulumi.get(__ret__, 'secrets'),
        service_account_id=pulumi.get(__ret__, 'service_account_id'),
        storage_mounts=pulumi.get(__ret__, 'storage_mounts'),
        url=pulumi.get(__ret__, 'url'))
def get_serverless_container_output(connectivity: Optional[pulumi.Input[Optional[Union['GetServerlessContainerConnectivityArgs', 'GetServerlessContainerConnectivityArgsDict']]]] = None,
                                    container_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    mounts: Optional[pulumi.Input[Optional[Sequence[Union['GetServerlessContainerMountArgs', 'GetServerlessContainerMountArgsDict']]]]] = None,
                                    name: Optional[pulumi.Input[Optional[str]]] = None,
                                    runtime: Optional[pulumi.Input[Optional[Union['GetServerlessContainerRuntimeArgs', 'GetServerlessContainerRuntimeArgsDict']]]] = None,
                                    secrets: Optional[pulumi.Input[Optional[Sequence[Union['GetServerlessContainerSecretArgs', 'GetServerlessContainerSecretArgsDict']]]]] = None,
                                    storage_mounts: Optional[pulumi.Input[Optional[Sequence[Union['GetServerlessContainerStorageMountArgs', 'GetServerlessContainerStorageMountArgsDict']]]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServerlessContainerResult]:
    """
    Get information about a Yandex Cloud Serverless Container.

    ## Example Usage

    {{ tffile "examples/serverless_container/d_serverless_container_1.tf" }}

    This data source is used to define Yandex Cloud Container that can be used by other resources.


    :param Union['GetServerlessContainerConnectivityArgs', 'GetServerlessContainerConnectivityArgsDict'] connectivity: Network access. If specified the revision will be attached to specified network
    :param str container_id: Yandex Cloud Serverless Container id used to define container
    :param str folder_id: Folder ID for the Yandex Cloud Serverless Container
           
           > Either `container_id` or `name` must be specified.
    :param Sequence[Union['GetServerlessContainerMountArgs', 'GetServerlessContainerMountArgsDict']] mounts: Mounts for Yandex Cloud Serverless Container
    :param str name: Yandex Cloud Serverless Container name used to define container
    :param Union['GetServerlessContainerRuntimeArgs', 'GetServerlessContainerRuntimeArgsDict'] runtime: Runtime for Yandex Cloud Serverless Container
    :param Sequence[Union['GetServerlessContainerSecretArgs', 'GetServerlessContainerSecretArgsDict']] secrets: Secrets for Yandex Cloud Serverless Container
    :param Sequence[Union['GetServerlessContainerStorageMountArgs', 'GetServerlessContainerStorageMountArgsDict']] storage_mounts: (**DEPRECATED**, use `mounts.0.object_storage` instead) Storage mounts for Yandex Cloud Serverless Container
    """
    __args__ = dict()
    __args__['connectivity'] = connectivity
    __args__['containerId'] = container_id
    __args__['folderId'] = folder_id
    __args__['mounts'] = mounts
    __args__['name'] = name
    __args__['runtime'] = runtime
    __args__['secrets'] = secrets
    __args__['storageMounts'] = storage_mounts
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getServerlessContainer:getServerlessContainer', __args__, opts=opts, typ=GetServerlessContainerResult)
    return __ret__.apply(lambda __response__: GetServerlessContainerResult(
        concurrency=pulumi.get(__response__, 'concurrency'),
        connectivity=pulumi.get(__response__, 'connectivity'),
        container_id=pulumi.get(__response__, 'container_id'),
        core_fraction=pulumi.get(__response__, 'core_fraction'),
        cores=pulumi.get(__response__, 'cores'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        execution_timeout=pulumi.get(__response__, 'execution_timeout'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        images=pulumi.get(__response__, 'images'),
        labels=pulumi.get(__response__, 'labels'),
        log_options=pulumi.get(__response__, 'log_options'),
        memory=pulumi.get(__response__, 'memory'),
        mounts=pulumi.get(__response__, 'mounts'),
        name=pulumi.get(__response__, 'name'),
        revision_id=pulumi.get(__response__, 'revision_id'),
        runtime=pulumi.get(__response__, 'runtime'),
        secrets=pulumi.get(__response__, 'secrets'),
        service_account_id=pulumi.get(__response__, 'service_account_id'),
        storage_mounts=pulumi.get(__response__, 'storage_mounts'),
        url=pulumi.get(__response__, 'url')))
