# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSmartcaptchaCaptchaResult',
    'AwaitableGetSmartcaptchaCaptchaResult',
    'get_smartcaptcha_captcha',
    'get_smartcaptcha_captcha_output',
]

@pulumi.output_type
class GetSmartcaptchaCaptchaResult:
    """
    A collection of values returned by getSmartcaptchaCaptcha.
    """
    def __init__(__self__, allowed_sites=None, captcha_id=None, challenge_type=None, client_key=None, cloud_id=None, complexity=None, created_at=None, deletion_protection=None, folder_id=None, id=None, name=None, override_variants=None, pre_check_type=None, security_rules=None, style_json=None, suspend=None, turn_off_hostname_check=None):
        if allowed_sites and not isinstance(allowed_sites, list):
            raise TypeError("Expected argument 'allowed_sites' to be a list")
        pulumi.set(__self__, "allowed_sites", allowed_sites)
        if captcha_id and not isinstance(captcha_id, str):
            raise TypeError("Expected argument 'captcha_id' to be a str")
        pulumi.set(__self__, "captcha_id", captcha_id)
        if challenge_type and not isinstance(challenge_type, str):
            raise TypeError("Expected argument 'challenge_type' to be a str")
        pulumi.set(__self__, "challenge_type", challenge_type)
        if client_key and not isinstance(client_key, str):
            raise TypeError("Expected argument 'client_key' to be a str")
        pulumi.set(__self__, "client_key", client_key)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if complexity and not isinstance(complexity, str):
            raise TypeError("Expected argument 'complexity' to be a str")
        pulumi.set(__self__, "complexity", complexity)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if override_variants and not isinstance(override_variants, list):
            raise TypeError("Expected argument 'override_variants' to be a list")
        pulumi.set(__self__, "override_variants", override_variants)
        if pre_check_type and not isinstance(pre_check_type, str):
            raise TypeError("Expected argument 'pre_check_type' to be a str")
        pulumi.set(__self__, "pre_check_type", pre_check_type)
        if security_rules and not isinstance(security_rules, list):
            raise TypeError("Expected argument 'security_rules' to be a list")
        pulumi.set(__self__, "security_rules", security_rules)
        if style_json and not isinstance(style_json, str):
            raise TypeError("Expected argument 'style_json' to be a str")
        pulumi.set(__self__, "style_json", style_json)
        if suspend and not isinstance(suspend, bool):
            raise TypeError("Expected argument 'suspend' to be a bool")
        pulumi.set(__self__, "suspend", suspend)
        if turn_off_hostname_check and not isinstance(turn_off_hostname_check, bool):
            raise TypeError("Expected argument 'turn_off_hostname_check' to be a bool")
        pulumi.set(__self__, "turn_off_hostname_check", turn_off_hostname_check)

    @property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> Sequence[str]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[str]:
        return pulumi.get(self, "captcha_id")

    @property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> str:
        """
        Additional task type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "challenge_type")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> str:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def complexity(self) -> str:
        """
        Complexity of the captcha.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The Captcha creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Determines whether captcha is protected from being deleted.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the rule. The name is unique within the captcha. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> Sequence['outputs.GetSmartcaptchaCaptchaOverrideVariantResult']:
        """
        List of variants to use in security_rules. The structure is documented below.
        """
        return pulumi.get(self, "override_variants")

    @property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> str:
        """
        Additional task type of the captcha.
        """
        return pulumi.get(self, "pre_check_type")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Sequence['outputs.GetSmartcaptchaCaptchaSecurityRuleResult']:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> str:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @property
    @pulumi.getter
    def suspend(self) -> bool:
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> bool:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")


class AwaitableGetSmartcaptchaCaptchaResult(GetSmartcaptchaCaptchaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSmartcaptchaCaptchaResult(
            allowed_sites=self.allowed_sites,
            captcha_id=self.captcha_id,
            challenge_type=self.challenge_type,
            client_key=self.client_key,
            cloud_id=self.cloud_id,
            complexity=self.complexity,
            created_at=self.created_at,
            deletion_protection=self.deletion_protection,
            folder_id=self.folder_id,
            id=self.id,
            name=self.name,
            override_variants=self.override_variants,
            pre_check_type=self.pre_check_type,
            security_rules=self.security_rules,
            style_json=self.style_json,
            suspend=self.suspend,
            turn_off_hostname_check=self.turn_off_hostname_check)


def get_smartcaptcha_captcha(captcha_id: Optional[str] = None,
                             cloud_id: Optional[str] = None,
                             folder_id: Optional[str] = None,
                             name: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSmartcaptchaCaptchaResult:
    """
    Get information about Yandex SmartCaptcha. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

    This data source is used to define Captcha that can be used by other resources.

    ## Example Usage

    {{ tffile "examples/smartcaptcha_captcha/d_smartcaptcha_captcha_1.tf" }}

    {{ tffile "examples/smartcaptcha_captcha/d_smartcaptcha_captcha_2.tf" }}


    :param str captcha_id: ID of the Captcha.
           
           > One of `captcha_id` or `name` should be specified.
    :param str name: Name of the Captcha.
    """
    __args__ = dict()
    __args__['captchaId'] = captcha_id
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSmartcaptchaCaptcha:getSmartcaptchaCaptcha', __args__, opts=opts, typ=GetSmartcaptchaCaptchaResult).value

    return AwaitableGetSmartcaptchaCaptchaResult(
        allowed_sites=pulumi.get(__ret__, 'allowed_sites'),
        captcha_id=pulumi.get(__ret__, 'captcha_id'),
        challenge_type=pulumi.get(__ret__, 'challenge_type'),
        client_key=pulumi.get(__ret__, 'client_key'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        complexity=pulumi.get(__ret__, 'complexity'),
        created_at=pulumi.get(__ret__, 'created_at'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        override_variants=pulumi.get(__ret__, 'override_variants'),
        pre_check_type=pulumi.get(__ret__, 'pre_check_type'),
        security_rules=pulumi.get(__ret__, 'security_rules'),
        style_json=pulumi.get(__ret__, 'style_json'),
        suspend=pulumi.get(__ret__, 'suspend'),
        turn_off_hostname_check=pulumi.get(__ret__, 'turn_off_hostname_check'))
def get_smartcaptcha_captcha_output(captcha_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    cloud_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    name: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSmartcaptchaCaptchaResult]:
    """
    Get information about Yandex SmartCaptcha. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

    This data source is used to define Captcha that can be used by other resources.

    ## Example Usage

    {{ tffile "examples/smartcaptcha_captcha/d_smartcaptcha_captcha_1.tf" }}

    {{ tffile "examples/smartcaptcha_captcha/d_smartcaptcha_captcha_2.tf" }}


    :param str captcha_id: ID of the Captcha.
           
           > One of `captcha_id` or `name` should be specified.
    :param str name: Name of the Captcha.
    """
    __args__ = dict()
    __args__['captchaId'] = captcha_id
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSmartcaptchaCaptcha:getSmartcaptchaCaptcha', __args__, opts=opts, typ=GetSmartcaptchaCaptchaResult)
    return __ret__.apply(lambda __response__: GetSmartcaptchaCaptchaResult(
        allowed_sites=pulumi.get(__response__, 'allowed_sites'),
        captcha_id=pulumi.get(__response__, 'captcha_id'),
        challenge_type=pulumi.get(__response__, 'challenge_type'),
        client_key=pulumi.get(__response__, 'client_key'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        complexity=pulumi.get(__response__, 'complexity'),
        created_at=pulumi.get(__response__, 'created_at'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        override_variants=pulumi.get(__response__, 'override_variants'),
        pre_check_type=pulumi.get(__response__, 'pre_check_type'),
        security_rules=pulumi.get(__response__, 'security_rules'),
        style_json=pulumi.get(__response__, 'style_json'),
        suspend=pulumi.get(__response__, 'suspend'),
        turn_off_hostname_check=pulumi.get(__response__, 'turn_off_hostname_check')))
