# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSwsSecurityProfileResult',
    'AwaitableGetSwsSecurityProfileResult',
    'get_sws_security_profile',
    'get_sws_security_profile_output',
]

@pulumi.output_type
class GetSwsSecurityProfileResult:
    """
    A collection of values returned by getSwsSecurityProfile.
    """
    def __init__(__self__, advanced_rate_limiter_profile_id=None, captcha_id=None, cloud_id=None, created_at=None, default_action=None, description=None, folder_id=None, id=None, labels=None, name=None, security_profile_id=None, security_rules=None):
        if advanced_rate_limiter_profile_id and not isinstance(advanced_rate_limiter_profile_id, str):
            raise TypeError("Expected argument 'advanced_rate_limiter_profile_id' to be a str")
        pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if captcha_id and not isinstance(captcha_id, str):
            raise TypeError("Expected argument 'captcha_id' to be a str")
        pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if default_action and not isinstance(default_action, str):
            raise TypeError("Expected argument 'default_action' to be a str")
        pulumi.set(__self__, "default_action", default_action)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if security_profile_id and not isinstance(security_profile_id, str):
            raise TypeError("Expected argument 'security_profile_id' to be a str")
        pulumi.set(__self__, "security_profile_id", security_profile_id)
        if security_rules and not isinstance(security_rules, list):
            raise TypeError("Expected argument 'security_rules' to be a list")
        pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> str:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> str:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> str:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> str:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description of the rule. 0-512 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the rule. The name is unique within the security profile. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityProfileId")
    def security_profile_id(self) -> Optional[str]:
        return pulumi.get(self, "security_profile_id")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Sequence['outputs.GetSwsSecurityProfileSecurityRuleResult']:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")


class AwaitableGetSwsSecurityProfileResult(GetSwsSecurityProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwsSecurityProfileResult(
            advanced_rate_limiter_profile_id=self.advanced_rate_limiter_profile_id,
            captcha_id=self.captcha_id,
            cloud_id=self.cloud_id,
            created_at=self.created_at,
            default_action=self.default_action,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            security_profile_id=self.security_profile_id,
            security_rules=self.security_rules)


def get_sws_security_profile(cloud_id: Optional[str] = None,
                             folder_id: Optional[str] = None,
                             name: Optional[str] = None,
                             security_profile_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwsSecurityProfileResult:
    """
    Get information about SecurityProfile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

    This data source is used to define SecurityProfile that can be used by other resources.

    ## Example Usage

    {{ tffile "examples/sws_security_profile/d_sws_security_profile_1.tf" }}

    {{ tffile "examples/sws_security_profile/d_sws_security_profile_2.tf" }}


    :param str name: Name of the security profile.
    :param str security_profile_id: ID of the security profile.
           
           > One of `security_profile_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityProfileId'] = security_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSwsSecurityProfile:getSwsSecurityProfile', __args__, opts=opts, typ=GetSwsSecurityProfileResult).value

    return AwaitableGetSwsSecurityProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__ret__, 'advanced_rate_limiter_profile_id'),
        captcha_id=pulumi.get(__ret__, 'captcha_id'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        created_at=pulumi.get(__ret__, 'created_at'),
        default_action=pulumi.get(__ret__, 'default_action'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        security_profile_id=pulumi.get(__ret__, 'security_profile_id'),
        security_rules=pulumi.get(__ret__, 'security_rules'))
def get_sws_security_profile_output(cloud_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    name: Optional[pulumi.Input[Optional[str]]] = None,
                                    security_profile_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwsSecurityProfileResult]:
    """
    Get information about SecurityProfile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

    This data source is used to define SecurityProfile that can be used by other resources.

    ## Example Usage

    {{ tffile "examples/sws_security_profile/d_sws_security_profile_1.tf" }}

    {{ tffile "examples/sws_security_profile/d_sws_security_profile_2.tf" }}


    :param str name: Name of the security profile.
    :param str security_profile_id: ID of the security profile.
           
           > One of `security_profile_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['securityProfileId'] = security_profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSwsSecurityProfile:getSwsSecurityProfile', __args__, opts=opts, typ=GetSwsSecurityProfileResult)
    return __ret__.apply(lambda __response__: GetSwsSecurityProfileResult(
        advanced_rate_limiter_profile_id=pulumi.get(__response__, 'advanced_rate_limiter_profile_id'),
        captcha_id=pulumi.get(__response__, 'captcha_id'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        created_at=pulumi.get(__response__, 'created_at'),
        default_action=pulumi.get(__response__, 'default_action'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        security_profile_id=pulumi.get(__response__, 'security_profile_id'),
        security_rules=pulumi.get(__response__, 'security_rules')))
