# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetSwsWafProfileResult',
    'AwaitableGetSwsWafProfileResult',
    'get_sws_waf_profile',
    'get_sws_waf_profile_output',
]

@pulumi.output_type
class GetSwsWafProfileResult:
    """
    A collection of values returned by getSwsWafProfile.
    """
    def __init__(__self__, analyze_request_bodies=None, cloud_id=None, core_rule_sets=None, created_at=None, description=None, exclusion_rules=None, folder_id=None, id=None, labels=None, name=None, rules=None, waf_profile_id=None):
        if analyze_request_bodies and not isinstance(analyze_request_bodies, list):
            raise TypeError("Expected argument 'analyze_request_bodies' to be a list")
        pulumi.set(__self__, "analyze_request_bodies", analyze_request_bodies)
        if cloud_id and not isinstance(cloud_id, str):
            raise TypeError("Expected argument 'cloud_id' to be a str")
        pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_sets and not isinstance(core_rule_sets, list):
            raise TypeError("Expected argument 'core_rule_sets' to be a list")
        pulumi.set(__self__, "core_rule_sets", core_rule_sets)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if exclusion_rules and not isinstance(exclusion_rules, list):
            raise TypeError("Expected argument 'exclusion_rules' to be a list")
        pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if waf_profile_id and not isinstance(waf_profile_id, str):
            raise TypeError("Expected argument 'waf_profile_id' to be a str")
        pulumi.set(__self__, "waf_profile_id", waf_profile_id)

    @property
    @pulumi.getter(name="analyzeRequestBodies")
    def analyze_request_bodies(self) -> Sequence['outputs.GetSwsWafProfileAnalyzeRequestBodyResult']:
        """
        Parameters for request body analyzer. The structure is documented below.
        """
        return pulumi.get(self, "analyze_request_bodies")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> str:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter(name="coreRuleSets")
    def core_rule_sets(self) -> Sequence['outputs.GetSwsWafProfileCoreRuleSetResult']:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        """
        return pulumi.get(self, "core_rule_sets")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional description of the rule. 0-512 characters long.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Sequence['outputs.GetSwsWafProfileExclusionRuleResult']:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        """
        return pulumi.get(self, "exclusion_rules")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of exclusion rule.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetSwsWafProfileRuleResult']:
        """
        Settings for each rule in rule set. The structure is documented below.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="wafProfileId")
    def waf_profile_id(self) -> Optional[str]:
        return pulumi.get(self, "waf_profile_id")


class AwaitableGetSwsWafProfileResult(GetSwsWafProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSwsWafProfileResult(
            analyze_request_bodies=self.analyze_request_bodies,
            cloud_id=self.cloud_id,
            core_rule_sets=self.core_rule_sets,
            created_at=self.created_at,
            description=self.description,
            exclusion_rules=self.exclusion_rules,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            rules=self.rules,
            waf_profile_id=self.waf_profile_id)


def get_sws_waf_profile(cloud_id: Optional[str] = None,
                        folder_id: Optional[str] = None,
                        name: Optional[str] = None,
                        waf_profile_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSwsWafProfileResult:
    """
    Get information about WAF Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

    ## Example Usage

    {{ tffile "examples/sws_waf_profile/d_sws_waf_profile_1.tf" }}

    {{ tffile "examples/sws_waf_profile/d_sws_waf_profile_2.tf" }}

    This data source is used to define WAF Profile that can be used by other resources.


    :param str folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
    :param str name: Name of the WAF profile.
    :param str waf_profile_id: ID of the WAF profile.
           
           > One of `waf_profile_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['wafProfileId'] = waf_profile_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getSwsWafProfile:getSwsWafProfile', __args__, opts=opts, typ=GetSwsWafProfileResult).value

    return AwaitableGetSwsWafProfileResult(
        analyze_request_bodies=pulumi.get(__ret__, 'analyze_request_bodies'),
        cloud_id=pulumi.get(__ret__, 'cloud_id'),
        core_rule_sets=pulumi.get(__ret__, 'core_rule_sets'),
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        exclusion_rules=pulumi.get(__ret__, 'exclusion_rules'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        rules=pulumi.get(__ret__, 'rules'),
        waf_profile_id=pulumi.get(__ret__, 'waf_profile_id'))
def get_sws_waf_profile_output(cloud_id: Optional[pulumi.Input[Optional[str]]] = None,
                               folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                               name: Optional[pulumi.Input[Optional[str]]] = None,
                               waf_profile_id: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSwsWafProfileResult]:
    """
    Get information about WAF Profile. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

    ## Example Usage

    {{ tffile "examples/sws_waf_profile/d_sws_waf_profile_1.tf" }}

    {{ tffile "examples/sws_waf_profile/d_sws_waf_profile_2.tf" }}

    This data source is used to define WAF Profile that can be used by other resources.


    :param str folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
    :param str name: Name of the WAF profile.
    :param str waf_profile_id: ID of the WAF profile.
           
           > One of `waf_profile_id` or `name` should be specified.
    """
    __args__ = dict()
    __args__['cloudId'] = cloud_id
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['wafProfileId'] = waf_profile_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getSwsWafProfile:getSwsWafProfile', __args__, opts=opts, typ=GetSwsWafProfileResult)
    return __ret__.apply(lambda __response__: GetSwsWafProfileResult(
        analyze_request_bodies=pulumi.get(__response__, 'analyze_request_bodies'),
        cloud_id=pulumi.get(__response__, 'cloud_id'),
        core_rule_sets=pulumi.get(__response__, 'core_rule_sets'),
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        exclusion_rules=pulumi.get(__response__, 'exclusion_rules'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        rules=pulumi.get(__response__, 'rules'),
        waf_profile_id=pulumi.get(__response__, 'waf_profile_id')))
