# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcGatewayResult',
    'AwaitableGetVpcGatewayResult',
    'get_vpc_gateway',
    'get_vpc_gateway_output',
]

@pulumi.output_type
class GetVpcGatewayResult:
    """
    A collection of values returned by getVpcGateway.
    """
    def __init__(__self__, created_at=None, description=None, folder_id=None, gateway_id=None, id=None, labels=None, name=None, shared_egress_gateway=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if gateway_id and not isinstance(gateway_id, str):
            raise TypeError("Expected argument 'gateway_id' to be a str")
        pulumi.set(__self__, "gateway_id", gateway_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if shared_egress_gateway and not isinstance(shared_egress_gateway, dict):
            raise TypeError("Expected argument 'shared_egress_gateway' to be a dict")
        pulumi.set(__self__, "shared_egress_gateway", shared_egress_gateway)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of this VPC Gateway.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the VPC Gateway.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="gatewayId")
    def gateway_id(self) -> str:
        return pulumi.get(self, "gateway_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels assigned to this VPC Gateway.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="sharedEgressGateway")
    def shared_egress_gateway(self) -> Optional['outputs.GetVpcGatewaySharedEgressGatewayResult']:
        """
        Shared egress gateway configuration
        """
        return pulumi.get(self, "shared_egress_gateway")


class AwaitableGetVpcGatewayResult(GetVpcGatewayResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcGatewayResult(
            created_at=self.created_at,
            description=self.description,
            folder_id=self.folder_id,
            gateway_id=self.gateway_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            shared_egress_gateway=self.shared_egress_gateway)


def get_vpc_gateway(folder_id: Optional[str] = None,
                    gateway_id: Optional[str] = None,
                    name: Optional[str] = None,
                    shared_egress_gateway: Optional[Union['GetVpcGatewaySharedEgressGatewayArgs', 'GetVpcGatewaySharedEgressGatewayArgsDict']] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcGatewayResult:
    """
    Get information about a Yandex VPC gateway. For more information, see [Yandex Cloud VPC](https://yandex.cloud/docs/vpc/concepts).

    ## Example Usage

    {{ tffile "examples/vpc_gateway/d_vpc_gateway_1.tf" }}

    This data source is used to define [VPC Gateways](https://yandex.cloud/docs/vpc/concepts/gateways) that can be used by other resources.


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param str gateway_id: ID of the VPC Gateway.
    :param str name: Name of the VPC Gateway.
           
           > One of `gateway_id` or `name` should be specified.
    :param Union['GetVpcGatewaySharedEgressGatewayArgs', 'GetVpcGatewaySharedEgressGatewayArgsDict'] shared_egress_gateway: Shared egress gateway configuration
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['gatewayId'] = gateway_id
    __args__['name'] = name
    __args__['sharedEgressGateway'] = shared_egress_gateway
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getVpcGateway:getVpcGateway', __args__, opts=opts, typ=GetVpcGatewayResult).value

    return AwaitableGetVpcGatewayResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        gateway_id=pulumi.get(__ret__, 'gateway_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        shared_egress_gateway=pulumi.get(__ret__, 'shared_egress_gateway'))
def get_vpc_gateway_output(folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                           gateway_id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           shared_egress_gateway: Optional[pulumi.Input[Optional[Union['GetVpcGatewaySharedEgressGatewayArgs', 'GetVpcGatewaySharedEgressGatewayArgsDict']]]] = None,
                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcGatewayResult]:
    """
    Get information about a Yandex VPC gateway. For more information, see [Yandex Cloud VPC](https://yandex.cloud/docs/vpc/concepts).

    ## Example Usage

    {{ tffile "examples/vpc_gateway/d_vpc_gateway_1.tf" }}

    This data source is used to define [VPC Gateways](https://yandex.cloud/docs/vpc/concepts/gateways) that can be used by other resources.


    :param str folder_id: Folder that the resource belongs to. If value is omitted, the default provider folder is used.
    :param str gateway_id: ID of the VPC Gateway.
    :param str name: Name of the VPC Gateway.
           
           > One of `gateway_id` or `name` should be specified.
    :param Union['GetVpcGatewaySharedEgressGatewayArgs', 'GetVpcGatewaySharedEgressGatewayArgsDict'] shared_egress_gateway: Shared egress gateway configuration
    """
    __args__ = dict()
    __args__['folderId'] = folder_id
    __args__['gatewayId'] = gateway_id
    __args__['name'] = name
    __args__['sharedEgressGateway'] = shared_egress_gateway
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getVpcGateway:getVpcGateway', __args__, opts=opts, typ=GetVpcGatewayResult)
    return __ret__.apply(lambda __response__: GetVpcGatewayResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        gateway_id=pulumi.get(__response__, 'gateway_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        shared_egress_gateway=pulumi.get(__response__, 'shared_egress_gateway')))
