# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVpcPrivateEndpointResult',
    'AwaitableGetVpcPrivateEndpointResult',
    'get_vpc_private_endpoint',
    'get_vpc_private_endpoint_output',
]

@pulumi.output_type
class GetVpcPrivateEndpointResult:
    """
    A collection of values returned by getVpcPrivateEndpoint.
    """
    def __init__(__self__, created_at=None, description=None, dns_options=None, endpoint_addresses=None, folder_id=None, id=None, labels=None, name=None, network_id=None, object_storages=None, private_endpoint_id=None, status=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if dns_options and not isinstance(dns_options, list):
            raise TypeError("Expected argument 'dns_options' to be a list")
        pulumi.set(__self__, "dns_options", dns_options)
        if endpoint_addresses and not isinstance(endpoint_addresses, list):
            raise TypeError("Expected argument 'endpoint_addresses' to be a list")
        pulumi.set(__self__, "endpoint_addresses", endpoint_addresses)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if object_storages and not isinstance(object_storages, list):
            raise TypeError("Expected argument 'object_storages' to be a list")
        pulumi.set(__self__, "object_storages", object_storages)
        if private_endpoint_id and not isinstance(private_endpoint_id, str):
            raise TypeError("Expected argument 'private_endpoint_id' to be a str")
        pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Creation timestamp of this private endpoint.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the private endpoint.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Sequence['outputs.GetVpcPrivateEndpointDnsOptionResult']:
        """
        DNS options of private endpoint.
        """
        return pulumi.get(self, "dns_options")

    @property
    @pulumi.getter(name="endpointAddresses")
    def endpoint_addresses(self) -> Sequence['outputs.GetVpcPrivateEndpointEndpointAddressResult']:
        """
        Address information of private endpoint.
        """
        return pulumi.get(self, "endpoint_addresses")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> str:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels assigned to this private endpoint.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        ID of the network which private endpoint belongs to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="objectStorages")
    def object_storages(self) -> Optional[Sequence['outputs.GetVpcPrivateEndpointObjectStorageResult']]:
        return pulumi.get(self, "object_storages")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> str:
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")


class AwaitableGetVpcPrivateEndpointResult(GetVpcPrivateEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVpcPrivateEndpointResult(
            created_at=self.created_at,
            description=self.description,
            dns_options=self.dns_options,
            endpoint_addresses=self.endpoint_addresses,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            name=self.name,
            network_id=self.network_id,
            object_storages=self.object_storages,
            private_endpoint_id=self.private_endpoint_id,
            status=self.status)


def get_vpc_private_endpoint(name: Optional[str] = None,
                             object_storages: Optional[Sequence[Union['GetVpcPrivateEndpointObjectStorageArgs', 'GetVpcPrivateEndpointObjectStorageArgsDict']]] = None,
                             private_endpoint_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVpcPrivateEndpointResult:
    """
    Get information about a Yandex VPC Private Endpoint. For more information, see [Yandex Cloud VPC](https://cloud.yandex.com/docs/vpc/concepts/index).

    ## Example Usage

    {{ tffile "examples/vpc_private_endpoint/d_vpc_private_endpoint_1.tf" }}

    This data source is used to define [VPC Private Endpoint](https://cloud.yandex.com/docs/vpc/concepts/private-endpoint) that can be used by other resources.


    :param str name: Name of the private endpoint.
           
           > One of `private_endpoint_id` or `name` should be specified.
    :param str private_endpoint_id: ID of the private endpoint.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['objectStorages'] = object_storages
    __args__['privateEndpointId'] = private_endpoint_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getVpcPrivateEndpoint:getVpcPrivateEndpoint', __args__, opts=opts, typ=GetVpcPrivateEndpointResult).value

    return AwaitableGetVpcPrivateEndpointResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        description=pulumi.get(__ret__, 'description'),
        dns_options=pulumi.get(__ret__, 'dns_options'),
        endpoint_addresses=pulumi.get(__ret__, 'endpoint_addresses'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        object_storages=pulumi.get(__ret__, 'object_storages'),
        private_endpoint_id=pulumi.get(__ret__, 'private_endpoint_id'),
        status=pulumi.get(__ret__, 'status'))
def get_vpc_private_endpoint_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                                    object_storages: Optional[pulumi.Input[Optional[Sequence[Union['GetVpcPrivateEndpointObjectStorageArgs', 'GetVpcPrivateEndpointObjectStorageArgsDict']]]]] = None,
                                    private_endpoint_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVpcPrivateEndpointResult]:
    """
    Get information about a Yandex VPC Private Endpoint. For more information, see [Yandex Cloud VPC](https://cloud.yandex.com/docs/vpc/concepts/index).

    ## Example Usage

    {{ tffile "examples/vpc_private_endpoint/d_vpc_private_endpoint_1.tf" }}

    This data source is used to define [VPC Private Endpoint](https://cloud.yandex.com/docs/vpc/concepts/private-endpoint) that can be used by other resources.


    :param str name: Name of the private endpoint.
           
           > One of `private_endpoint_id` or `name` should be specified.
    :param str private_endpoint_id: ID of the private endpoint.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['objectStorages'] = object_storages
    __args__['privateEndpointId'] = private_endpoint_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getVpcPrivateEndpoint:getVpcPrivateEndpoint', __args__, opts=opts, typ=GetVpcPrivateEndpointResult)
    return __ret__.apply(lambda __response__: GetVpcPrivateEndpointResult(
        created_at=pulumi.get(__response__, 'created_at'),
        description=pulumi.get(__response__, 'description'),
        dns_options=pulumi.get(__response__, 'dns_options'),
        endpoint_addresses=pulumi.get(__response__, 'endpoint_addresses'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        object_storages=pulumi.get(__response__, 'object_storages'),
        private_endpoint_id=pulumi.get(__response__, 'private_endpoint_id'),
        status=pulumi.get(__response__, 'status')))
