# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetYdbDatabaseDedicatedResult',
    'AwaitableGetYdbDatabaseDedicatedResult',
    'get_ydb_database_dedicated',
    'get_ydb_database_dedicated_output',
]

@pulumi.output_type
class GetYdbDatabaseDedicatedResult:
    """
    A collection of values returned by getYdbDatabaseDedicated.
    """
    def __init__(__self__, assign_public_ips=None, created_at=None, database_id=None, database_path=None, deletion_protection=None, description=None, folder_id=None, id=None, labels=None, location_id=None, locations=None, name=None, network_id=None, resource_preset_id=None, scale_policies=None, status=None, storage_configs=None, subnet_ids=None, tls_enabled=None, ydb_api_endpoint=None, ydb_full_endpoint=None):
        if assign_public_ips and not isinstance(assign_public_ips, bool):
            raise TypeError("Expected argument 'assign_public_ips' to be a bool")
        pulumi.set(__self__, "assign_public_ips", assign_public_ips)
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_path and not isinstance(database_path, str):
            raise TypeError("Expected argument 'database_path' to be a str")
        pulumi.set(__self__, "database_path", database_path)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location_id and not isinstance(location_id, str):
            raise TypeError("Expected argument 'location_id' to be a str")
        pulumi.set(__self__, "location_id", location_id)
        if locations and not isinstance(locations, list):
            raise TypeError("Expected argument 'locations' to be a list")
        pulumi.set(__self__, "locations", locations)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if network_id and not isinstance(network_id, str):
            raise TypeError("Expected argument 'network_id' to be a str")
        pulumi.set(__self__, "network_id", network_id)
        if resource_preset_id and not isinstance(resource_preset_id, str):
            raise TypeError("Expected argument 'resource_preset_id' to be a str")
        pulumi.set(__self__, "resource_preset_id", resource_preset_id)
        if scale_policies and not isinstance(scale_policies, list):
            raise TypeError("Expected argument 'scale_policies' to be a list")
        pulumi.set(__self__, "scale_policies", scale_policies)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if storage_configs and not isinstance(storage_configs, list):
            raise TypeError("Expected argument 'storage_configs' to be a list")
        pulumi.set(__self__, "storage_configs", storage_configs)
        if subnet_ids and not isinstance(subnet_ids, list):
            raise TypeError("Expected argument 'subnet_ids' to be a list")
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tls_enabled and not isinstance(tls_enabled, bool):
            raise TypeError("Expected argument 'tls_enabled' to be a bool")
        pulumi.set(__self__, "tls_enabled", tls_enabled)
        if ydb_api_endpoint and not isinstance(ydb_api_endpoint, str):
            raise TypeError("Expected argument 'ydb_api_endpoint' to be a str")
        pulumi.set(__self__, "ydb_api_endpoint", ydb_api_endpoint)
        if ydb_full_endpoint and not isinstance(ydb_full_endpoint, str):
            raise TypeError("Expected argument 'ydb_full_endpoint' to be a str")
        pulumi.set(__self__, "ydb_full_endpoint", ydb_full_endpoint)

    @property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> bool:
        """
        Whether public IP addresses are assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The Yandex Database cluster creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[str]:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> str:
        """
        Full database path of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Inhibits deletion of the database. Can be either `true` or `false`
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the Yandex Database cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of key/value label pairs assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> str:
        """
        Location ID of the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def locations(self) -> Sequence['outputs.GetYdbDatabaseDedicatedLocationResult']:
        """
        Location of the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> str:
        """
        ID of the network the Yandex Database cluster is attached to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> str:
        """
        The Yandex Database cluster preset.
        """
        return pulumi.get(self, "resource_preset_id")

    @property
    @pulumi.getter(name="scalePolicies")
    def scale_policies(self) -> Sequence['outputs.GetYdbDatabaseDedicatedScalePolicyResult']:
        """
        Scaling policy of the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "scale_policies")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Yandex Database cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageConfigs")
    def storage_configs(self) -> Sequence['outputs.GetYdbDatabaseDedicatedStorageConfigResult']:
        """
        A list of storage configuration options of the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "storage_configs")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        List of subnet IDs the Yandex Database cluster is attached to.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> bool:
        """
        Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> str:
        """
        API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> str:
        """
        Full endpoint of the Yandex Database cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")


class AwaitableGetYdbDatabaseDedicatedResult(GetYdbDatabaseDedicatedResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetYdbDatabaseDedicatedResult(
            assign_public_ips=self.assign_public_ips,
            created_at=self.created_at,
            database_id=self.database_id,
            database_path=self.database_path,
            deletion_protection=self.deletion_protection,
            description=self.description,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            location_id=self.location_id,
            locations=self.locations,
            name=self.name,
            network_id=self.network_id,
            resource_preset_id=self.resource_preset_id,
            scale_policies=self.scale_policies,
            status=self.status,
            storage_configs=self.storage_configs,
            subnet_ids=self.subnet_ids,
            tls_enabled=self.tls_enabled,
            ydb_api_endpoint=self.ydb_api_endpoint,
            ydb_full_endpoint=self.ydb_full_endpoint)


def get_ydb_database_dedicated(database_id: Optional[str] = None,
                               deletion_protection: Optional[bool] = None,
                               folder_id: Optional[str] = None,
                               name: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetYdbDatabaseDedicatedResult:
    """
    Get information about a Yandex Database (dedicated) cluster. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

    ## Example Usage

    {{ tffile "examples/ydb_database_dedicated/d_ydb_database_dedicated_1.tf" }}


    :param str database_id: ID of the Yandex Database cluster.
    :param bool deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
    :param str folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `database_id` is not specified `name` and `folder_id` will be used to designate Yandex Database cluster.
    :param str name: Name of the Yandex Database cluster.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getYdbDatabaseDedicated:getYdbDatabaseDedicated', __args__, opts=opts, typ=GetYdbDatabaseDedicatedResult).value

    return AwaitableGetYdbDatabaseDedicatedResult(
        assign_public_ips=pulumi.get(__ret__, 'assign_public_ips'),
        created_at=pulumi.get(__ret__, 'created_at'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_path=pulumi.get(__ret__, 'database_path'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location_id=pulumi.get(__ret__, 'location_id'),
        locations=pulumi.get(__ret__, 'locations'),
        name=pulumi.get(__ret__, 'name'),
        network_id=pulumi.get(__ret__, 'network_id'),
        resource_preset_id=pulumi.get(__ret__, 'resource_preset_id'),
        scale_policies=pulumi.get(__ret__, 'scale_policies'),
        status=pulumi.get(__ret__, 'status'),
        storage_configs=pulumi.get(__ret__, 'storage_configs'),
        subnet_ids=pulumi.get(__ret__, 'subnet_ids'),
        tls_enabled=pulumi.get(__ret__, 'tls_enabled'),
        ydb_api_endpoint=pulumi.get(__ret__, 'ydb_api_endpoint'),
        ydb_full_endpoint=pulumi.get(__ret__, 'ydb_full_endpoint'))
def get_ydb_database_dedicated_output(database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      deletion_protection: Optional[pulumi.Input[Optional[bool]]] = None,
                                      folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetYdbDatabaseDedicatedResult]:
    """
    Get information about a Yandex Database (dedicated) cluster. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

    ## Example Usage

    {{ tffile "examples/ydb_database_dedicated/d_ydb_database_dedicated_1.tf" }}


    :param str database_id: ID of the Yandex Database cluster.
    :param bool deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
    :param str folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `database_id` is not specified `name` and `folder_id` will be used to designate Yandex Database cluster.
    :param str name: Name of the Yandex Database cluster.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getYdbDatabaseDedicated:getYdbDatabaseDedicated', __args__, opts=opts, typ=GetYdbDatabaseDedicatedResult)
    return __ret__.apply(lambda __response__: GetYdbDatabaseDedicatedResult(
        assign_public_ips=pulumi.get(__response__, 'assign_public_ips'),
        created_at=pulumi.get(__response__, 'created_at'),
        database_id=pulumi.get(__response__, 'database_id'),
        database_path=pulumi.get(__response__, 'database_path'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location_id=pulumi.get(__response__, 'location_id'),
        locations=pulumi.get(__response__, 'locations'),
        name=pulumi.get(__response__, 'name'),
        network_id=pulumi.get(__response__, 'network_id'),
        resource_preset_id=pulumi.get(__response__, 'resource_preset_id'),
        scale_policies=pulumi.get(__response__, 'scale_policies'),
        status=pulumi.get(__response__, 'status'),
        storage_configs=pulumi.get(__response__, 'storage_configs'),
        subnet_ids=pulumi.get(__response__, 'subnet_ids'),
        tls_enabled=pulumi.get(__response__, 'tls_enabled'),
        ydb_api_endpoint=pulumi.get(__response__, 'ydb_api_endpoint'),
        ydb_full_endpoint=pulumi.get(__response__, 'ydb_full_endpoint')))
