# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetYdbDatabaseServerlessResult',
    'AwaitableGetYdbDatabaseServerlessResult',
    'get_ydb_database_serverless',
    'get_ydb_database_serverless_output',
]

@pulumi.output_type
class GetYdbDatabaseServerlessResult:
    """
    A collection of values returned by getYdbDatabaseServerless.
    """
    def __init__(__self__, created_at=None, database_id=None, database_path=None, deletion_protection=None, description=None, document_api_endpoint=None, folder_id=None, id=None, labels=None, location_id=None, name=None, serverless_databases=None, status=None, tls_enabled=None, ydb_api_endpoint=None, ydb_full_endpoint=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if database_id and not isinstance(database_id, str):
            raise TypeError("Expected argument 'database_id' to be a str")
        pulumi.set(__self__, "database_id", database_id)
        if database_path and not isinstance(database_path, str):
            raise TypeError("Expected argument 'database_path' to be a str")
        pulumi.set(__self__, "database_path", database_path)
        if deletion_protection and not isinstance(deletion_protection, bool):
            raise TypeError("Expected argument 'deletion_protection' to be a bool")
        pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if document_api_endpoint and not isinstance(document_api_endpoint, str):
            raise TypeError("Expected argument 'document_api_endpoint' to be a str")
        pulumi.set(__self__, "document_api_endpoint", document_api_endpoint)
        if folder_id and not isinstance(folder_id, str):
            raise TypeError("Expected argument 'folder_id' to be a str")
        pulumi.set(__self__, "folder_id", folder_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if location_id and not isinstance(location_id, str):
            raise TypeError("Expected argument 'location_id' to be a str")
        pulumi.set(__self__, "location_id", location_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if serverless_databases and not isinstance(serverless_databases, list):
            raise TypeError("Expected argument 'serverless_databases' to be a list")
        pulumi.set(__self__, "serverless_databases", serverless_databases)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tls_enabled and not isinstance(tls_enabled, bool):
            raise TypeError("Expected argument 'tls_enabled' to be a bool")
        pulumi.set(__self__, "tls_enabled", tls_enabled)
        if ydb_api_endpoint and not isinstance(ydb_api_endpoint, str):
            raise TypeError("Expected argument 'ydb_api_endpoint' to be a str")
        pulumi.set(__self__, "ydb_api_endpoint", ydb_api_endpoint)
        if ydb_full_endpoint and not isinstance(ydb_full_endpoint, str):
            raise TypeError("Expected argument 'ydb_full_endpoint' to be a str")
        pulumi.set(__self__, "ydb_full_endpoint", ydb_full_endpoint)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The Yandex Database serverless cluster creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[str]:
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> str:
        """
        Full database path of the Yandex Database serverless cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> bool:
        """
        Inhibits deletion of the database. Can be either `true` or `false`
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="documentApiEndpoint")
    def document_api_endpoint(self) -> str:
        """
        Document API endpoint of the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "document_api_endpoint")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of key/value label pairs assigned to the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> str:
        """
        Location ID of the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="serverlessDatabases")
    def serverless_databases(self) -> Sequence['outputs.GetYdbDatabaseServerlessServerlessDatabaseResult']:
        return pulumi.get(self, "serverless_databases")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> bool:
        """
        Whether TLS is enabled for the Yandex Database serverless cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> str:
        """
        API endpoint of the Yandex Database serverless cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> str:
        """
        Full endpoint of the Yandex Database serverless cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")


class AwaitableGetYdbDatabaseServerlessResult(GetYdbDatabaseServerlessResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetYdbDatabaseServerlessResult(
            created_at=self.created_at,
            database_id=self.database_id,
            database_path=self.database_path,
            deletion_protection=self.deletion_protection,
            description=self.description,
            document_api_endpoint=self.document_api_endpoint,
            folder_id=self.folder_id,
            id=self.id,
            labels=self.labels,
            location_id=self.location_id,
            name=self.name,
            serverless_databases=self.serverless_databases,
            status=self.status,
            tls_enabled=self.tls_enabled,
            ydb_api_endpoint=self.ydb_api_endpoint,
            ydb_full_endpoint=self.ydb_full_endpoint)


def get_ydb_database_serverless(database_id: Optional[str] = None,
                                deletion_protection: Optional[bool] = None,
                                folder_id: Optional[str] = None,
                                name: Optional[str] = None,
                                serverless_databases: Optional[Sequence[Union['GetYdbDatabaseServerlessServerlessDatabaseArgs', 'GetYdbDatabaseServerlessServerlessDatabaseArgsDict']]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetYdbDatabaseServerlessResult:
    """
    Get information about a Yandex Database serverless cluster. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

    ## Example Usage

    {{ tffile "examples/ydb_database_serverless/d_ydb_database_serverless_1.tf" }}


    :param str database_id: ID of the Yandex Database serverless cluster.
    :param bool deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
    :param str folder_id: ID of the folder that the Yandex Database serverless cluster belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `database_id` is not specified `name` and `folder_id` will be used to designate Yandex Database serverless cluster.
    :param str name: Name of the Yandex Database serverless cluster.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['serverlessDatabases'] = serverless_databases
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('yandex:index/getYdbDatabaseServerless:getYdbDatabaseServerless', __args__, opts=opts, typ=GetYdbDatabaseServerlessResult).value

    return AwaitableGetYdbDatabaseServerlessResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        database_id=pulumi.get(__ret__, 'database_id'),
        database_path=pulumi.get(__ret__, 'database_path'),
        deletion_protection=pulumi.get(__ret__, 'deletion_protection'),
        description=pulumi.get(__ret__, 'description'),
        document_api_endpoint=pulumi.get(__ret__, 'document_api_endpoint'),
        folder_id=pulumi.get(__ret__, 'folder_id'),
        id=pulumi.get(__ret__, 'id'),
        labels=pulumi.get(__ret__, 'labels'),
        location_id=pulumi.get(__ret__, 'location_id'),
        name=pulumi.get(__ret__, 'name'),
        serverless_databases=pulumi.get(__ret__, 'serverless_databases'),
        status=pulumi.get(__ret__, 'status'),
        tls_enabled=pulumi.get(__ret__, 'tls_enabled'),
        ydb_api_endpoint=pulumi.get(__ret__, 'ydb_api_endpoint'),
        ydb_full_endpoint=pulumi.get(__ret__, 'ydb_full_endpoint'))
def get_ydb_database_serverless_output(database_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       deletion_protection: Optional[pulumi.Input[Optional[bool]]] = None,
                                       folder_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       name: Optional[pulumi.Input[Optional[str]]] = None,
                                       serverless_databases: Optional[pulumi.Input[Optional[Sequence[Union['GetYdbDatabaseServerlessServerlessDatabaseArgs', 'GetYdbDatabaseServerlessServerlessDatabaseArgsDict']]]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetYdbDatabaseServerlessResult]:
    """
    Get information about a Yandex Database serverless cluster. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

    ## Example Usage

    {{ tffile "examples/ydb_database_serverless/d_ydb_database_serverless_1.tf" }}


    :param str database_id: ID of the Yandex Database serverless cluster.
    :param bool deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
    :param str folder_id: ID of the folder that the Yandex Database serverless cluster belongs to. It will be deduced from provider configuration if not set explicitly.
           
           > If `database_id` is not specified `name` and `folder_id` will be used to designate Yandex Database serverless cluster.
    :param str name: Name of the Yandex Database serverless cluster.
    """
    __args__ = dict()
    __args__['databaseId'] = database_id
    __args__['deletionProtection'] = deletion_protection
    __args__['folderId'] = folder_id
    __args__['name'] = name
    __args__['serverlessDatabases'] = serverless_databases
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('yandex:index/getYdbDatabaseServerless:getYdbDatabaseServerless', __args__, opts=opts, typ=GetYdbDatabaseServerlessResult)
    return __ret__.apply(lambda __response__: GetYdbDatabaseServerlessResult(
        created_at=pulumi.get(__response__, 'created_at'),
        database_id=pulumi.get(__response__, 'database_id'),
        database_path=pulumi.get(__response__, 'database_path'),
        deletion_protection=pulumi.get(__response__, 'deletion_protection'),
        description=pulumi.get(__response__, 'description'),
        document_api_endpoint=pulumi.get(__response__, 'document_api_endpoint'),
        folder_id=pulumi.get(__response__, 'folder_id'),
        id=pulumi.get(__response__, 'id'),
        labels=pulumi.get(__response__, 'labels'),
        location_id=pulumi.get(__response__, 'location_id'),
        name=pulumi.get(__response__, 'name'),
        serverless_databases=pulumi.get(__response__, 'serverless_databases'),
        status=pulumi.get(__response__, 'status'),
        tls_enabled=pulumi.get(__response__, 'tls_enabled'),
        ydb_api_endpoint=pulumi.get(__response__, 'ydb_api_endpoint'),
        ydb_full_endpoint=pulumi.get(__response__, 'ydb_full_endpoint')))
