# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['IotCoreDeviceArgs', 'IotCoreDevice']

@pulumi.input_type
class IotCoreDeviceArgs:
    def __init__(__self__, *,
                 registry_id: pulumi.Input[str],
                 aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a IotCoreDevice resource.
        :param pulumi.Input[str] registry_id: IoT Core Registry ID for the IoT Core Device
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] aliases: A set of key/value aliases pairs to assign to the IoT Core Device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of certificate's fingerprints for the IoT Core Device
        :param pulumi.Input[str] description: Description of the IoT Core Device
        :param pulumi.Input[str] name: IoT Core Device name used to define device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passwords: A set of passwords's id for the IoT Core Device
        """
        pulumi.set(__self__, "registry_id", registry_id)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Input[str]:
        """
        IoT Core Registry ID for the IoT Core Device
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "registry_id", value)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value aliases pairs to assign to the IoT Core Device
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of certificate's fingerprints for the IoT Core Device
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the IoT Core Device
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IoT Core Device name used to define device
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of passwords's id for the IoT Core Device
        """
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "passwords", value)


@pulumi.input_type
class _IotCoreDeviceState:
    def __init__(__self__, *,
                 aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering IotCoreDevice resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] aliases: A set of key/value aliases pairs to assign to the IoT Core Device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of certificate's fingerprints for the IoT Core Device
        :param pulumi.Input[str] created_at: Creation timestamp of the IoT Core Device
        :param pulumi.Input[str] description: Description of the IoT Core Device
        :param pulumi.Input[str] name: IoT Core Device name used to define device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passwords: A set of passwords's id for the IoT Core Device
        :param pulumi.Input[str] registry_id: IoT Core Registry ID for the IoT Core Device
        """
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if certificates is not None:
            pulumi.set(__self__, "certificates", certificates)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if passwords is not None:
            pulumi.set(__self__, "passwords", passwords)
        if registry_id is not None:
            pulumi.set(__self__, "registry_id", registry_id)

    @property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value aliases pairs to assign to the IoT Core Device
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "aliases", value)

    @property
    @pulumi.getter
    def certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of certificate's fingerprints for the IoT Core Device
        """
        return pulumi.get(self, "certificates")

    @certificates.setter
    def certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "certificates", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the IoT Core Device
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the IoT Core Device
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        IoT Core Device name used to define device
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def passwords(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of passwords's id for the IoT Core Device
        """
        return pulumi.get(self, "passwords")

    @passwords.setter
    def passwords(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "passwords", value)

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> Optional[pulumi.Input[str]]:
        """
        IoT Core Registry ID for the IoT Core Device
        """
        return pulumi.get(self, "registry_id")

    @registry_id.setter
    def registry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registry_id", value)


class IotCoreDevice(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud IoT Device](https://cloud.yandex.com/docs/iot-core/quickstart).

        ## Example Usage

        {{ tffile "examples/iot_core_device/r_iot_core_device_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] aliases: A set of key/value aliases pairs to assign to the IoT Core Device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of certificate's fingerprints for the IoT Core Device
        :param pulumi.Input[str] description: Description of the IoT Core Device
        :param pulumi.Input[str] name: IoT Core Device name used to define device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passwords: A set of passwords's id for the IoT Core Device
        :param pulumi.Input[str] registry_id: IoT Core Registry ID for the IoT Core Device
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IotCoreDeviceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud IoT Device](https://cloud.yandex.com/docs/iot-core/quickstart).

        ## Example Usage

        {{ tffile "examples/iot_core_device/r_iot_core_device_1.tf" }}

        :param str resource_name: The name of the resource.
        :param IotCoreDeviceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IotCoreDeviceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 passwords: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 registry_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IotCoreDeviceArgs.__new__(IotCoreDeviceArgs)

            __props__.__dict__["aliases"] = aliases
            __props__.__dict__["certificates"] = certificates
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["passwords"] = None if passwords is None else pulumi.Output.secret(passwords)
            if registry_id is None and not opts.urn:
                raise TypeError("Missing required property 'registry_id'")
            __props__.__dict__["registry_id"] = registry_id
            __props__.__dict__["created_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["passwords"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IotCoreDevice, __self__).__init__(
            'yandex:index/iotCoreDevice:IotCoreDevice',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aliases: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            certificates: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            passwords: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            registry_id: Optional[pulumi.Input[str]] = None) -> 'IotCoreDevice':
        """
        Get an existing IotCoreDevice resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] aliases: A set of key/value aliases pairs to assign to the IoT Core Device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] certificates: A set of certificate's fingerprints for the IoT Core Device
        :param pulumi.Input[str] created_at: Creation timestamp of the IoT Core Device
        :param pulumi.Input[str] description: Description of the IoT Core Device
        :param pulumi.Input[str] name: IoT Core Device name used to define device
        :param pulumi.Input[Sequence[pulumi.Input[str]]] passwords: A set of passwords's id for the IoT Core Device
        :param pulumi.Input[str] registry_id: IoT Core Registry ID for the IoT Core Device
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IotCoreDeviceState.__new__(_IotCoreDeviceState)

        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["certificates"] = certificates
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["passwords"] = passwords
        __props__.__dict__["registry_id"] = registry_id
        return IotCoreDevice(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value aliases pairs to assign to the IoT Core Device
        """
        return pulumi.get(self, "aliases")

    @property
    @pulumi.getter
    def certificates(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of certificate's fingerprints for the IoT Core Device
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the IoT Core Device
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the IoT Core Device
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        IoT Core Device name used to define device
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def passwords(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of passwords's id for the IoT Core Device
        """
        return pulumi.get(self, "passwords")

    @property
    @pulumi.getter(name="registryId")
    def registry_id(self) -> pulumi.Output[str]:
        """
        IoT Core Registry ID for the IoT Core Device
        """
        return pulumi.get(self, "registry_id")

