# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LockboxSecretArgs', 'LockboxSecret']

@pulumi.input_type
class LockboxSecretArgs:
    def __init__(__self__, *,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_payload_specification: Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']] = None):
        """
        The set of arguments for constructing a LockboxSecret resource.
        :param pulumi.Input[bool] deletion_protection: Whether the Yandex Cloud Lockbox secret is protected from deletion.
        :param pulumi.Input[str] description: A description for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[str] kms_key_id: The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] name: Name for the Yandex Cloud Lockbox secret.
        :param pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs'] password_payload_specification: Payload specification for password generation.
               
               The `password_payload_specification` block contains:
        """
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_payload_specification is not None:
            pulumi.set(__self__, "password_payload_specification", password_payload_specification)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Yandex Cloud Lockbox secret is protected from deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordPayloadSpecification")
    def password_payload_specification(self) -> Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']]:
        """
        Payload specification for password generation.

        The `password_payload_specification` block contains:
        """
        return pulumi.get(self, "password_payload_specification")

    @password_payload_specification.setter
    def password_payload_specification(self, value: Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']]):
        pulumi.set(self, "password_payload_specification", value)


@pulumi.input_type
class _LockboxSecretState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_payload_specification: Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LockboxSecret resources.
        :param pulumi.Input[str] created_at: The Yandex Cloud Lockbox secret creation timestamp.
        :param pulumi.Input[bool] deletion_protection: Whether the Yandex Cloud Lockbox secret is protected from deletion.
        :param pulumi.Input[str] description: A description for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[str] kms_key_id: The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] name: Name for the Yandex Cloud Lockbox secret.
        :param pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs'] password_payload_specification: Payload specification for password generation.
               
               The `password_payload_specification` block contains:
        :param pulumi.Input[str] status: The Yandex Cloud Lockbox secret status.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password_payload_specification is not None:
            pulumi.set(__self__, "password_payload_specification", password_payload_specification)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The Yandex Cloud Lockbox secret creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the Yandex Cloud Lockbox secret is protected from deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="passwordPayloadSpecification")
    def password_payload_specification(self) -> Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']]:
        """
        Payload specification for password generation.

        The `password_payload_specification` block contains:
        """
        return pulumi.get(self, "password_payload_specification")

    @password_payload_specification.setter
    def password_payload_specification(self, value: Optional[pulumi.Input['LockboxSecretPasswordPayloadSpecificationArgs']]):
        pulumi.set(self, "password_payload_specification", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Yandex Cloud Lockbox secret status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class LockboxSecret(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_payload_specification: Optional[pulumi.Input[Union['LockboxSecretPasswordPayloadSpecificationArgs', 'LockboxSecretPasswordPayloadSpecificationArgsDict']]] = None,
                 __props__=None):
        """
        Yandex Cloud Lockbox secret resource. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

        ## Example Usage

        {{ tffile "examples/lockbox_secret/r_lockbox_secret_1.tf" }}

        Use `LockboxSecretVersion` to add entries to the secret.

        {{ tffile "examples/lockbox_secret/r_lockbox_secret_2.tf" }}

        The created secret will contain a version with the generated password. You can use `LockboxSecretVersion` to create new versions.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] deletion_protection: Whether the Yandex Cloud Lockbox secret is protected from deletion.
        :param pulumi.Input[str] description: A description for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[str] kms_key_id: The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] name: Name for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Union['LockboxSecretPasswordPayloadSpecificationArgs', 'LockboxSecretPasswordPayloadSpecificationArgsDict']] password_payload_specification: Payload specification for password generation.
               
               The `password_payload_specification` block contains:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LockboxSecretArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Cloud Lockbox secret resource. For more information, see [the official documentation](https://yandex.cloud/docs/lockbox/).

        ## Example Usage

        {{ tffile "examples/lockbox_secret/r_lockbox_secret_1.tf" }}

        Use `LockboxSecretVersion` to add entries to the secret.

        {{ tffile "examples/lockbox_secret/r_lockbox_secret_2.tf" }}

        The created secret will contain a version with the generated password. You can use `LockboxSecretVersion` to create new versions.

        :param str resource_name: The name of the resource.
        :param LockboxSecretArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LockboxSecretArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password_payload_specification: Optional[pulumi.Input[Union['LockboxSecretPasswordPayloadSpecificationArgs', 'LockboxSecretPasswordPayloadSpecificationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LockboxSecretArgs.__new__(LockboxSecretArgs)

            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["password_payload_specification"] = password_payload_specification
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(LockboxSecret, __self__).__init__(
            'yandex:index/lockboxSecret:LockboxSecret',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password_payload_specification: Optional[pulumi.Input[Union['LockboxSecretPasswordPayloadSpecificationArgs', 'LockboxSecretPasswordPayloadSpecificationArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'LockboxSecret':
        """
        Get an existing LockboxSecret resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: The Yandex Cloud Lockbox secret creation timestamp.
        :param pulumi.Input[bool] deletion_protection: Whether the Yandex Cloud Lockbox secret is protected from deletion.
        :param pulumi.Input[str] description: A description for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[str] kms_key_id: The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        :param pulumi.Input[str] name: Name for the Yandex Cloud Lockbox secret.
        :param pulumi.Input[Union['LockboxSecretPasswordPayloadSpecificationArgs', 'LockboxSecretPasswordPayloadSpecificationArgsDict']] password_payload_specification: Payload specification for password generation.
               
               The `password_payload_specification` block contains:
        :param pulumi.Input[str] status: The Yandex Cloud Lockbox secret status.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LockboxSecretState.__new__(_LockboxSecretState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["password_payload_specification"] = password_payload_specification
        __props__.__dict__["status"] = status
        return LockboxSecret(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The Yandex Cloud Lockbox secret creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the Yandex Cloud Lockbox secret is protected from deletion.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder that the Yandex Cloud Lockbox secret belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The KMS key used to encrypt the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name for the Yandex Cloud Lockbox secret.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="passwordPayloadSpecification")
    def password_payload_specification(self) -> pulumi.Output[Optional['outputs.LockboxSecretPasswordPayloadSpecification']]:
        """
        Payload specification for password generation.

        The `password_payload_specification` block contains:
        """
        return pulumi.get(self, "password_payload_specification")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The Yandex Cloud Lockbox secret status.
        """
        return pulumi.get(self, "status")

