# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbKafkaClusterArgs', 'MdbKafkaCluster']

@pulumi.input_type
class MdbKafkaClusterArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['MdbKafkaClusterConfigArgs'],
                 network_id: pulumi.Input[str],
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbKafkaCluster resource.
        :param pulumi.Input['MdbKafkaClusterConfigArgs'] config: Configuration of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] network_id: ID of the network, to which the Kafka cluster belongs.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the Kafka cluster.
        :param pulumi.Input[str] environment: Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_group_ids: A list of IDs of the host groups to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Kafka cluster.
        :param pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the Kafka cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security group ids, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: IDs of the subnets, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]] topics: To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "network_id", network_id)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if topics is not None:
            warnings.warn("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""", DeprecationWarning)
            pulumi.log.warn("""topics is deprecated: to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['MdbKafkaClusterConfigArgs']:
        """
        Configuration of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['MdbKafkaClusterConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        ID of the network, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Kafka cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs of the host groups to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Kafka cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Kafka cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security group ids, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the subnets, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]]:
        """
        To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbKafkaClusterState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['MdbKafkaClusterConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 health: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbKafkaCluster resources.
        :param pulumi.Input['MdbKafkaClusterConfigArgs'] config: Configuration of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] created_at: Timestamp of cluster creation.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the Kafka cluster.
        :param pulumi.Input[str] environment: Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[str] health: Health of the host.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_group_ids: A list of IDs of the host groups to place VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterHostArgs']]] hosts: A host of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Kafka cluster.
        :param pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the Kafka cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security group ids, to which the Kafka cluster belongs.
        :param pulumi.Input[str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://cloud.yandex.com/docs/managed-kafka/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: IDs of the subnets, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]] topics: To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if topics is not None:
            warnings.warn("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""", DeprecationWarning)
            pulumi.log.warn("""topics is deprecated: to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
        if topics is not None:
            pulumi.set(__self__, "topics", topics)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['MdbKafkaClusterConfigArgs']]:
        """
        Configuration of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['MdbKafkaClusterConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of cluster creation.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the Kafka cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[str]]:
        """
        Health of the host.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IDs of the host groups to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterHostArgs']]]]:
        """
        A host of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Kafka cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbKafkaClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Kafka cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Security group ids, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://cloud.yandex.com/docs/managed-kafka/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        IDs of the subnets, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
    def topics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]]:
        """
        To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        """
        return pulumi.get(self, "topics")

    @topics.setter
    def topics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterTopicArgs']]]]):
        pulumi.set(self, "topics", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


class MdbKafkaCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbKafkaClusterConfigArgs', 'MdbKafkaClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbKafkaClusterMaintenanceWindowArgs', 'MdbKafkaClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterTopicArgs', 'MdbKafkaClusterTopicArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterUserArgs', 'MdbKafkaClusterUserArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_1.tf" }}

        Example of creating a HA Kafka Cluster with two brokers per AZ (6 brokers + 3 Zookepeers)

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_2.tf" }}

        Example of creating Kafka Cluster with KRaft-controller subcluster instead of Zookeeper subcluster.

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_3.tf" }}

        Example of creating multihost Kafka Cluster without subcluster of controllers, using KRaft-combine quorum.

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_4.tf" }}

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbKafkaCluster:MdbKafkaCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbKafkaClusterConfigArgs', 'MdbKafkaClusterConfigArgsDict']] config: Configuration of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the Kafka cluster.
        :param pulumi.Input[str] environment: Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_group_ids: A list of IDs of the host groups to place VMs of the cluster on.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Kafka cluster.
        :param pulumi.Input[Union['MdbKafkaClusterMaintenanceWindowArgs', 'MdbKafkaClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the Kafka cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security group ids, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: IDs of the subnets, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterTopicArgs', 'MdbKafkaClusterTopicArgsDict']]]] topics: To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterUserArgs', 'MdbKafkaClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbKafkaClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_1.tf" }}

        Example of creating a HA Kafka Cluster with two brokers per AZ (6 brokers + 3 Zookepeers)

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_2.tf" }}

        Example of creating Kafka Cluster with KRaft-controller subcluster instead of Zookeeper subcluster.

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_3.tf" }}

        Example of creating multihost Kafka Cluster without subcluster of controllers, using KRaft-combine quorum.

        {{ tffile "examples/mdb_kafka_cluster/r_mdb_kafka_cluster_4.tf" }}

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbKafkaCluster:MdbKafkaCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param MdbKafkaClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbKafkaClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbKafkaClusterConfigArgs', 'MdbKafkaClusterConfigArgsDict']]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbKafkaClusterMaintenanceWindowArgs', 'MdbKafkaClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterTopicArgs', 'MdbKafkaClusterTopicArgsDict']]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterUserArgs', 'MdbKafkaClusterUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbKafkaClusterArgs.__new__(MdbKafkaClusterArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["topics"] = topics
            __props__.__dict__["users"] = users
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["hosts"] = None
            __props__.__dict__["status"] = None
        super(MdbKafkaCluster, __self__).__init__(
            'yandex:index/mdbKafkaCluster:MdbKafkaCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['MdbKafkaClusterConfigArgs', 'MdbKafkaClusterConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            health: Optional[pulumi.Input[str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterHostArgs', 'MdbKafkaClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbKafkaClusterMaintenanceWindowArgs', 'MdbKafkaClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            topics: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterTopicArgs', 'MdbKafkaClusterTopicArgsDict']]]]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterUserArgs', 'MdbKafkaClusterUserArgsDict']]]]] = None) -> 'MdbKafkaCluster':
        """
        Get an existing MdbKafkaCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbKafkaClusterConfigArgs', 'MdbKafkaClusterConfigArgsDict']] config: Configuration of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] created_at: Timestamp of cluster creation.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the Kafka cluster.
        :param pulumi.Input[str] environment: Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[str] health: Health of the host.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] host_group_ids: A list of IDs of the host groups to place VMs of the cluster on.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterHostArgs', 'MdbKafkaClusterHostArgsDict']]]] hosts: A host of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Kafka cluster.
        :param pulumi.Input[Union['MdbKafkaClusterMaintenanceWindowArgs', 'MdbKafkaClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the Kafka cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the Kafka cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: Security group ids, to which the Kafka cluster belongs.
        :param pulumi.Input[str] status: Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://cloud.yandex.com/docs/managed-kafka/api-ref/Cluster/).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: IDs of the subnets, to which the Kafka cluster belongs.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterTopicArgs', 'MdbKafkaClusterTopicArgsDict']]]] topics: To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaClusterUserArgs', 'MdbKafkaClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbKafkaClusterState.__new__(_MdbKafkaClusterState)

        __props__.__dict__["config"] = config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["topics"] = topics
        __props__.__dict__["users"] = users
        return MdbKafkaCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.MdbKafkaClusterConfig']:
        """
        Configuration of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp of cluster creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the Kafka cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[Optional[str]]:
        """
        Deployment environment of the Kafka cluster. Can be either `PRESTABLE` or `PRODUCTION`. The default is `PRODUCTION`.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[str]:
        """
        Health of the host.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of IDs of the host groups to place VMs of the cluster on.
        """
        return pulumi.get(self, "host_group_ids")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbKafkaClusterHost']]:
        """
        A host of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A set of key/value label pairs to assign to the Kafka cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbKafkaClusterMaintenanceWindow']:
        """
        Maintenance policy of the Kafka cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Kafka cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        ID of the network, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Security group ids, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the cluster. Can be either `CREATING`, `STARTING`, `RUNNING`, `UPDATING`, `STOPPING`, `STOPPED`, `ERROR` or `STATUS_UNKNOWN`. For more information see `status` field of JSON representation in [the official documentation](https://cloud.yandex.com/docs/managed-kafka/api-ref/Cluster/).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        IDs of the subnets, to which the Kafka cluster belongs.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage topics, please switch to using a separate resource type yandex_mdb_kafka_topic""")
    def topics(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaClusterTopic']]]:
        """
        To manage topics, please switch to using a separate resource type `MdbKafkaTopic`.
        """
        return pulumi.get(self, "topics")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_kafka_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaClusterUser']]]:
        """
        To manage users, please switch to using a separate resource type `MdbKafkaUser`.
        """
        return pulumi.get(self, "users")

