# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbKafkaConnectorArgs', 'MdbKafkaConnector']

@pulumi.input_type
class MdbKafkaConnectorArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks_max: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a MdbKafkaConnector resource.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]] connector_config_mirrormakers: Params for MirrorMaker2 connector. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]] connector_config_s3_sinks: Params for S3 Sink connector. The structure is documented below.
        :param pulumi.Input[str] name: The name of the connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties for connector.
        :param pulumi.Input[int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        if connector_config_mirrormakers is not None:
            pulumi.set(__self__, "connector_config_mirrormakers", connector_config_mirrormakers)
        if connector_config_s3_sinks is not None:
            pulumi.set(__self__, "connector_config_s3_sinks", connector_config_s3_sinks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tasks_max is not None:
            pulumi.set(__self__, "tasks_max", tasks_max)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]:
        """
        Params for MirrorMaker2 connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @connector_config_mirrormakers.setter
    def connector_config_mirrormakers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]):
        pulumi.set(self, "connector_config_mirrormakers", value)

    @property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]:
        """
        Params for S3 Sink connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @connector_config_s3_sinks.setter
    def connector_config_s3_sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]):
        pulumi.set(self, "connector_config_s3_sinks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers
        """
        return pulumi.get(self, "tasks_max")

    @tasks_max.setter
    def tasks_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tasks_max", value)


@pulumi.input_type
class _MdbKafkaConnectorState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks_max: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering MdbKafkaConnector resources.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]] connector_config_mirrormakers: Params for MirrorMaker2 connector. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]] connector_config_s3_sinks: Params for S3 Sink connector. The structure is documented below.
        :param pulumi.Input[str] name: The name of the connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties for connector.
        :param pulumi.Input[int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if connector_config_mirrormakers is not None:
            pulumi.set(__self__, "connector_config_mirrormakers", connector_config_mirrormakers)
        if connector_config_s3_sinks is not None:
            pulumi.set(__self__, "connector_config_s3_sinks", connector_config_s3_sinks)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if tasks_max is not None:
            pulumi.set(__self__, "tasks_max", tasks_max)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]:
        """
        Params for MirrorMaker2 connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @connector_config_mirrormakers.setter
    def connector_config_mirrormakers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigMirrormakerArgs']]]]):
        pulumi.set(self, "connector_config_mirrormakers", value)

    @property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]:
        """
        Params for S3 Sink connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @connector_config_s3_sinks.setter
    def connector_config_s3_sinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbKafkaConnectorConnectorConfigS3SinkArgs']]]]):
        pulumi.set(self, "connector_config_s3_sinks", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers
        """
        return pulumi.get(self, "tasks_max")

    @tasks_max.setter
    def tasks_max(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tasks_max", value)


class MdbKafkaConnector(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks_max: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages a connector of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_connector/r_mdb_kafka_connector_1.tf" }}

        ## Import

        Kafka connector can be imported using following format:

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector foo {cluster_id}:{connector_name}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]] connector_config_mirrormakers: Params for MirrorMaker2 connector. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]] connector_config_s3_sinks: Params for S3 Sink connector. The structure is documented below.
        :param pulumi.Input[str] name: The name of the connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties for connector.
        :param pulumi.Input[int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbKafkaConnectorArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a connector of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_connector/r_mdb_kafka_connector_1.tf" }}

        ## Import

        Kafka connector can be imported using following format:

        ```sh
        $ pulumi import yandex:index/mdbKafkaConnector:MdbKafkaConnector foo {cluster_id}:{connector_name}
        ```

        :param str resource_name: The name of the resource.
        :param MdbKafkaConnectorArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbKafkaConnectorArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
                 connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tasks_max: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbKafkaConnectorArgs.__new__(MdbKafkaConnectorArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["connector_config_mirrormakers"] = connector_config_mirrormakers
            __props__.__dict__["connector_config_s3_sinks"] = connector_config_s3_sinks
            __props__.__dict__["name"] = name
            __props__.__dict__["properties"] = properties
            __props__.__dict__["tasks_max"] = tasks_max
        super(MdbKafkaConnector, __self__).__init__(
            'yandex:index/mdbKafkaConnector:MdbKafkaConnector',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            connector_config_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]]] = None,
            connector_config_s3_sinks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tasks_max: Optional[pulumi.Input[int]] = None) -> 'MdbKafkaConnector':
        """
        Get an existing MdbKafkaConnector resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigMirrormakerArgs', 'MdbKafkaConnectorConnectorConfigMirrormakerArgsDict']]]] connector_config_mirrormakers: Params for MirrorMaker2 connector. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbKafkaConnectorConnectorConfigS3SinkArgs', 'MdbKafkaConnectorConnectorConfigS3SinkArgsDict']]]] connector_config_s3_sinks: Params for S3 Sink connector. The structure is documented below.
        :param pulumi.Input[str] name: The name of the connector.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] properties: Additional properties for connector.
        :param pulumi.Input[int] tasks_max: The number of the connector's parallel working tasks. Default is the number of brokers
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbKafkaConnectorState.__new__(_MdbKafkaConnectorState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["connector_config_mirrormakers"] = connector_config_mirrormakers
        __props__.__dict__["connector_config_s3_sinks"] = connector_config_s3_sinks
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["tasks_max"] = tasks_max
        return MdbKafkaConnector(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="connectorConfigMirrormakers")
    def connector_config_mirrormakers(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaConnectorConnectorConfigMirrormaker']]]:
        """
        Params for MirrorMaker2 connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_mirrormakers")

    @property
    @pulumi.getter(name="connectorConfigS3Sinks")
    def connector_config_s3_sinks(self) -> pulumi.Output[Optional[Sequence['outputs.MdbKafkaConnectorConnectorConfigS3Sink']]]:
        """
        Params for S3 Sink connector. The structure is documented below.
        """
        return pulumi.get(self, "connector_config_s3_sinks")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the connector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Additional properties for connector.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="tasksMax")
    def tasks_max(self) -> pulumi.Output[Optional[int]]:
        """
        The number of the connector's parallel working tasks. Default is the number of brokers
        """
        return pulumi.get(self, "tasks_max")

