# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbKafkaTopicArgs', 'MdbKafkaTopic']

@pulumi.input_type
class MdbKafkaTopicArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 partitions: pulumi.Input[int],
                 replication_factor: pulumi.Input[int],
                 name: Optional[pulumi.Input[str]] = None,
                 topic_config: Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']] = None):
        """
        The set of arguments for constructing a MdbKafkaTopic resource.
        :param pulumi.Input[int] partitions: The number of the topic's partitions.
        :param pulumi.Input[int] replication_factor: Amount of data copies (replicas) for the topic in the cluster.
        :param pulumi.Input[str] name: The name of the topic.
        :param pulumi.Input['MdbKafkaTopicTopicConfigArgs'] topic_config: User-defined settings for the topic. The structure is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "replication_factor", replication_factor)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if topic_config is not None:
            pulumi.set(__self__, "topic_config", topic_config)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[int]:
        """
        The number of the topic's partitions.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Input[int]:
        """
        Amount of data copies (replicas) for the topic in the cluster.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: pulumi.Input[int]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="topicConfig")
    def topic_config(self) -> Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']]:
        """
        User-defined settings for the topic. The structure is documented below.
        """
        return pulumi.get(self, "topic_config")

    @topic_config.setter
    def topic_config(self, value: Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']]):
        pulumi.set(self, "topic_config", value)


@pulumi.input_type
class _MdbKafkaTopicState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 topic_config: Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']] = None):
        """
        Input properties used for looking up and filtering MdbKafkaTopic resources.
        :param pulumi.Input[str] name: The name of the topic.
        :param pulumi.Input[int] partitions: The number of the topic's partitions.
        :param pulumi.Input[int] replication_factor: Amount of data copies (replicas) for the topic in the cluster.
        :param pulumi.Input['MdbKafkaTopicTopicConfigArgs'] topic_config: User-defined settings for the topic. The structure is documented below.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if topic_config is not None:
            pulumi.set(__self__, "topic_config", topic_config)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the topic's partitions.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[int]]:
        """
        Amount of data copies (replicas) for the topic in the cluster.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter(name="topicConfig")
    def topic_config(self) -> Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']]:
        """
        User-defined settings for the topic. The structure is documented below.
        """
        return pulumi.get(self, "topic_config")

    @topic_config.setter
    def topic_config(self, value: Optional[pulumi.Input['MdbKafkaTopicTopicConfigArgs']]):
        pulumi.set(self, "topic_config", value)


class MdbKafkaTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 topic_config: Optional[pulumi.Input[Union['MdbKafkaTopicTopicConfigArgs', 'MdbKafkaTopicTopicConfigArgsDict']]] = None,
                 __props__=None):
        """
        Manages a topic of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_topic/r_mdb_kafka_topic_1.tf" }}

        ## Import

        Kafka topic can be imported using following format:

        ```sh
        $ pulumi import yandex:index/mdbKafkaTopic:MdbKafkaTopic foo {cluster_id}:{topic_name}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the topic.
        :param pulumi.Input[int] partitions: The number of the topic's partitions.
        :param pulumi.Input[int] replication_factor: Amount of data copies (replicas) for the topic in the cluster.
        :param pulumi.Input[Union['MdbKafkaTopicTopicConfigArgs', 'MdbKafkaTopicTopicConfigArgsDict']] topic_config: User-defined settings for the topic. The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbKafkaTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a topic of a Kafka cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-kafka/concepts).

        ## Example Usage

        {{ tffile "examples/mdb_kafka_topic/r_mdb_kafka_topic_1.tf" }}

        ## Import

        Kafka topic can be imported using following format:

        ```sh
        $ pulumi import yandex:index/mdbKafkaTopic:MdbKafkaTopic foo {cluster_id}:{topic_name}
        ```

        :param str resource_name: The name of the resource.
        :param MdbKafkaTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbKafkaTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 replication_factor: Optional[pulumi.Input[int]] = None,
                 topic_config: Optional[pulumi.Input[Union['MdbKafkaTopicTopicConfigArgs', 'MdbKafkaTopicTopicConfigArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbKafkaTopicArgs.__new__(MdbKafkaTopicArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["name"] = name
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            if replication_factor is None and not opts.urn:
                raise TypeError("Missing required property 'replication_factor'")
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["topic_config"] = topic_config
        super(MdbKafkaTopic, __self__).__init__(
            'yandex:index/mdbKafkaTopic:MdbKafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partitions: Optional[pulumi.Input[int]] = None,
            replication_factor: Optional[pulumi.Input[int]] = None,
            topic_config: Optional[pulumi.Input[Union['MdbKafkaTopicTopicConfigArgs', 'MdbKafkaTopicTopicConfigArgsDict']]] = None) -> 'MdbKafkaTopic':
        """
        Get an existing MdbKafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: The name of the topic.
        :param pulumi.Input[int] partitions: The number of the topic's partitions.
        :param pulumi.Input[int] replication_factor: Amount of data copies (replicas) for the topic in the cluster.
        :param pulumi.Input[Union['MdbKafkaTopicTopicConfigArgs', 'MdbKafkaTopicTopicConfigArgsDict']] topic_config: User-defined settings for the topic. The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbKafkaTopicState.__new__(_MdbKafkaTopicState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["name"] = name
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["topic_config"] = topic_config
        return MdbKafkaTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[int]:
        """
        The number of the topic's partitions.
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[int]:
        """
        Amount of data copies (replicas) for the topic in the cluster.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="topicConfig")
    def topic_config(self) -> pulumi.Output[Optional['outputs.MdbKafkaTopicTopicConfig']]:
        """
        User-defined settings for the topic. The structure is documented below.
        """
        return pulumi.get(self, "topic_config")

