# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbMysqlClusterArgs', 'MdbMysqlCluster']

@pulumi.input_type
class MdbMysqlClusterArgs:
    def __init__(__self__, *,
                 environment: pulumi.Input[str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]],
                 network_id: pulumi.Input[str],
                 resources: pulumi.Input['MdbMysqlClusterResourcesArgs'],
                 version: pulumi.Input[str],
                 access: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']] = None,
                 allow_regeneration_host: Optional[pulumi.Input[bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 performance_diagnostics: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbMysqlCluster resource.
        :param pulumi.Input[str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]] hosts: A host of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[str] network_id: ID of the network, to which the MySQL cluster uses.
        :param pulumi.Input['MdbMysqlClusterResourcesArgs'] resources: Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        :param pulumi.Input['MdbMysqlClusterAccessArgs'] access: Access policy to the MySQL cluster. The structure is documented below.
        :param pulumi.Input[int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbMysqlClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the MySQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the MySQL cluster.
        :param pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] mysql_config: MySQL cluster config. Detail info in "MySQL config" section (documented below).
        :param pulumi.Input[str] name: Name of the MySQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs'] performance_diagnostics: Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        :param pulumi.Input['MdbMysqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "version", version)
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allow_regeneration_host is not None:
            warnings.warn("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""", DeprecationWarning)
            pulumi.log.warn("""allow_regeneration_host is deprecated: You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
        if allow_regeneration_host is not None:
            pulumi.set(__self__, "allow_regeneration_host", allow_regeneration_host)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if mysql_config is not None:
            pulumi.set(__self__, "mysql_config", mysql_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if performance_diagnostics is not None:
            pulumi.set(__self__, "performance_diagnostics", performance_diagnostics)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[str]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]:
        """
        A host of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        ID of the network, to which the MySQL cluster uses.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Input['MdbMysqlClusterResourcesArgs']:
        """
        Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: pulumi.Input['MdbMysqlClusterResourcesArgs']):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]:
        """
        Access policy to the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_regeneration_host")

    @allow_regeneration_host.setter
    def allow_regeneration_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_regeneration_host", value)

    @property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC. The structure is documented below.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the MySQL cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the MySQL cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        MySQL cluster config. Detail info in "MySQL config" section (documented below).
        """
        return pulumi.get(self, "mysql_config")

    @mysql_config.setter
    def mysql_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "mysql_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the MySQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]:
        """
        Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        """
        return pulumi.get(self, "performance_diagnostics")

    @performance_diagnostics.setter
    def performance_diagnostics(self, value: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]):
        pulumi.set(self, "performance_diagnostics", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbMysqlClusterState:
    def __init__(__self__, *,
                 access: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']] = None,
                 allow_regeneration_host: Optional[pulumi.Input[bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[int]] = None,
                 backup_window_start: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 health: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 performance_diagnostics: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']] = None,
                 resources: Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']] = None,
                 restore: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MdbMysqlCluster resources.
        :param pulumi.Input['MdbMysqlClusterAccessArgs'] access: Access policy to the MySQL cluster. The structure is documented below.
        :param pulumi.Input[int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input['MdbMysqlClusterBackupWindowStartArgs'] backup_window_start: Time to start the daily backup, in the UTC. The structure is documented below.
        :param pulumi.Input[str] created_at: Creation timestamp of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the MySQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]] hosts: A host of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the MySQL cluster.
        :param pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] mysql_config: MySQL cluster config. Detail info in "MySQL config" section (documented below).
        :param pulumi.Input[str] name: Name of the MySQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the MySQL cluster uses.
        :param pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs'] performance_diagnostics: Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        :param pulumi.Input['MdbMysqlClusterResourcesArgs'] resources: Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        :param pulumi.Input['MdbMysqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        if access is not None:
            pulumi.set(__self__, "access", access)
        if allow_regeneration_host is not None:
            warnings.warn("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""", DeprecationWarning)
            pulumi.log.warn("""allow_regeneration_host is deprecated: You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
        if allow_regeneration_host is not None:
            pulumi.set(__self__, "allow_regeneration_host", allow_regeneration_host)
        if backup_retain_period_days is not None:
            pulumi.set(__self__, "backup_retain_period_days", backup_retain_period_days)
        if backup_window_start is not None:
            pulumi.set(__self__, "backup_window_start", backup_window_start)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if mysql_config is not None:
            pulumi.set(__self__, "mysql_config", mysql_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if performance_diagnostics is not None:
            pulumi.set(__self__, "performance_diagnostics", performance_diagnostics)
        if resources is not None:
            pulumi.set(__self__, "resources", resources)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def access(self) -> Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]:
        """
        Access policy to the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "access")

    @access.setter
    def access(self, value: Optional[pulumi.Input['MdbMysqlClusterAccessArgs']]):
        pulumi.set(self, "access", value)

    @property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "allow_regeneration_host")

    @allow_regeneration_host.setter
    def allow_regeneration_host(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_regeneration_host", value)

    @property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> Optional[pulumi.Input[int]]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @backup_retain_period_days.setter
    def backup_retain_period_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_retain_period_days", value)

    @property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]:
        """
        Time to start the daily backup, in the UTC. The structure is documented below.
        """
        return pulumi.get(self, "backup_window_start")

    @backup_window_start.setter
    def backup_window_start(self, value: Optional[pulumi.Input['MdbMysqlClusterBackupWindowStartArgs']]):
        pulumi.set(self, "backup_window_start", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the MySQL cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]]:
        """
        A host of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the MySQL cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbMysqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        MySQL cluster config. Detail info in "MySQL config" section (documented below).
        """
        return pulumi.get(self, "mysql_config")

    @mysql_config.setter
    def mysql_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "mysql_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the MySQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network, to which the MySQL cluster uses.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]:
        """
        Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        """
        return pulumi.get(self, "performance_diagnostics")

    @performance_diagnostics.setter
    def performance_diagnostics(self, value: Optional[pulumi.Input['MdbMysqlClusterPerformanceDiagnosticsArgs']]):
        pulumi.set(self, "performance_diagnostics", value)

    @property
    @pulumi.getter
    def resources(self) -> Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']]:
        """
        Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "resources")

    @resources.setter
    def resources(self, value: Optional[pulumi.Input['MdbMysqlClusterResourcesArgs']]):
        pulumi.set(self, "resources", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbMysqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbMysqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class MdbMysqlCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
                 allow_regeneration_host: Optional[pulumi.Input[bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a MySQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

        ## Example Usage

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_1.tf" }}

        Example of creating a High-Availability(HA) MySQL Cluster.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_2.tf" }}

        Example of creating a MySQL Cluster with cascade replicas: HA-group consist of 'na-1' and 'na-2', cascade replicas form a chain 'na-1' > 'nb-1' > 'nb-2'

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_3.tf" }}

        Example of creating a MySQL Cluster with different backup priorities. Backup will be created from nb-2, if it's not master. na-2 will be used as a backup source as a last resort.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_4.tf" }}

        Example of creating a MySQL Cluster with different host priorities. During failover master will be set to nb-2

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_5.tf" }}

        Example of creating a Single Node MySQL with user params.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_6.tf" }}

        ## MySQL config

        If not specified `mysql_config` then does not make any changes.

        * `sql_mode` default value: `ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION`

        some of:
        - 1: "ALLOW_INVALID_DATES" - 2: "ANSI_QUOTES" - 3: "ERROR_FOR_DIVISION_BY_ZERO" - 4: "HIGH_NOT_PRECEDENCE" - 5: "IGNORE_SPACE" - 6: "NO_AUTO_VALUE_ON_ZERO" - 7: "NO_BACKSLASH_ESCAPES" - 8: "NO_ENGINE_SUBSTITUTION" - 9: "NO_UNSIGNED_SUBTRACTION" - 10: "NO_ZERO_DATE" - 11: "NO_ZERO_IN_DATE" - 15: "ONLY_FULL_GROUP_BY" - 16: "PAD_CHAR_TO_FULL_LENGTH" - 17: "PIPES_AS_CONCAT" - 18: "REAL_AS_FLOAT" - 19: "STRICT_ALL_TABLES" - 20: "STRICT_TRANS_TABLES" - 21: "TIME_TRUNCATE_FRACTIONAL" - 22: "ANSI" - 23: "TRADITIONAL" - 24: "NO_DIR_IN_CREATE" or:
        - 0: "SQLMODE_UNSPECIFIED"

        ### MysqlConfig 8.0
        * `audit_log` boolean

        * `auto_increment_increment` integer

        * `auto_increment_offset` integer

        * `binlog_cache_size` integer

        * `binlog_group_commit_sync_delay` integer

        * `binlog_row_image` one of:
          - 0: "BINLOG_ROW_IMAGE_UNSPECIFIED"
          - 1: "FULL"
          - 2: "MINIMAL"
          - 3: "NOBLOB"

        * `binlog_rows_query_log_events` boolean

        * `character_set_server` text

        * `collation_server` text

        * `default_authentication_plugin` one of:
          - 0: "AUTH_PLUGIN_UNSPECIFIED"
          - 1: "MYSQL_NATIVE_PASSWORD"
          - 2: "CACHING_SHA2_PASSWORD"
          - 3: "SHA256_PASSWORD"

        * `default_time_zone` text

        * `explicit_defaults_for_timestamp` boolean

        * `general_log` boolean

        * `group_concat_max_len` integer

        * `innodb_adaptive_hash_index` boolean

        * `innodb_buffer_pool_size` integer

        * `innodb_flush_log_at_trx_commit` integer

        * `innodb_ft_max_token_size` integer

        * `innodb_ft_min_token_size` integer

        * `innodb_io_capacity` integer

        * `innodb_io_capacity_max` integer

        * `innodb_lock_wait_timeout` integer

        * `innodb_log_buffer_size` integer

        * `innodb_log_file_size` integer

        * `innodb_numa_interleave` boolean

        * `innodb_online_alter_log_max_size` integer

        * `innodb_page_size` integer (create-only option)

        * `innodb_print_all_deadlocks` boolean

        * `innodb_purge_threads` integer

        * `innodb_read_io_threads` integer

        * `innodb_temp_data_file_max_size` integer

        * `innodb_thread_concurrency` integer

        * `innodb_write_io_threads` integer

        * `interactive_timeout` integer

        * `join_buffer_size` integer

        * `log_slow_rate_limit` intger

        * `log_slow_rate_type` one of:
          - 0: "SESSION"
          - 1: "QUERY"

        * `log_slow_sp_statements` boolean

        * `long_query_time` float

        * `lower_case_table_names` boolean (create-only option)

        * `max_allowed_packet` integer

        * `max_connections` integer

        * `max_heap_table_size` integer

        * `mdb_offline_mode_disable_lag` integer

        * `mdb_offline_mode_enable_lag` integer

        * `mdb_preserve_binlog_bytes` integer

        * `mdb_priority_choice_max_lag` integer

        * `net_read_timeout` integer

        * `net_write_timeout` integer

        * `range_optimizer_max_mem_size` integer

        * `regexp_time_limit` integer

        * `rpl_semi_sync_master_wait_for_slave_count` integer

        * `slave_parallel_type` one of:
          - 0: "SLAVE_PARALLEL_TYPE_UNSPECIFIED"
          - 1: "DATABASE"
          - 2: "LOGICAL_CLOCK"

        * `slow_query_log` boolean

        * `slow_query_log_always_write_time` float

        * `slave_parallel_workers` integer

        * `sort_buffer_size` integer

        * `sync_binlog` integer

        * `table_definition_cache` integer

        * `table_open_cache` integer

        * `table_open_cache_instances` integer

        * `thread_cache_size` integer

        * `thread_stack` integer

        * `tmp_table_size` integer

        * `transaction_isolation` one of:
          - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"
          - 1: "READ_COMMITTED"
          - 2: "REPEATABLE_READ"
          - 3: "SERIALIZABLE"

        * `wait_timeout` integer

        ### MysqlConfig 5.7
        * `audit_log` boolean

        * `auto_increment_increment` integer

        * `auto_increment_offset` integer

        * `binlog_cache_size` integer

        * `binlog_group_commit_sync_delay` integer

        * `binlog_row_image` one of:
          - 0: "BINLOG_ROW_IMAGE_UNSPECIFIED"
          - 1: "FULL"
          - 2: "MINIMAL"
          - 3: "NOBLOB"

        * `binlog_rows_query_log_events` boolean

        * `character_set_server` text

        * `collation_server` text

        * `default_authentication_plugin` one of:
          - 0: "AUTH_PLUGIN_UNSPECIFIED"
          - 1: "MYSQL_NATIVE_PASSWORD"
          - 2: "CACHING_SHA2_PASSWORD"
          - 3: "SHA256_PASSWORD"

        * `default_time_zone` text

        * `explicit_defaults_for_timestamp` boolean

        * `general_log` boolean

        * `group_concat_max_len` integer

        * `innodb_adaptive_hash_index` boolean

        * `innodb_buffer_pool_size` integer

        * `innodb_flush_log_at_trx_commit` integer

        * `innodb_ft_max_token_size` integer

        * `innodb_ft_min_token_size` integer

        * `innodb_io_capacity` integer

        * `innodb_io_capacity_max` integer

        * `innodb_lock_wait_timeout` integer

        * `innodb_log_buffer_size` integer

        * `innodb_log_file_size` integer

        * `innodb_numa_interleave` boolean

        * `innodb_online_alter_log_max_size` integer

        * `innodb_page_size` integer (create-only option)

        * `innodb_print_all_deadlocks` boolean

        * `innodb_purge_threads` integer

        * `innodb_read_io_threads` integer

        * `innodb_temp_data_file_max_size` integer

        * `innodb_thread_concurrency` integer

        * `innodb_write_io_threads` integer

        * `interactive_timeout` integer

        * `join_buffer_size` integer

        * `log_slow_rate_limit` integer

        * `log_slow_rate_type` one of:
          - 0: "SESSION"
          - 1: "QUERY"

        * `log_slow_sp_statements` boolean

        * `long_query_time` float

        * `lower_case_table_names` boolean (create-only option)

        * `max_allowed_packet` integer

        * `max_connections` integer

        * `max_heap_table_size` integer

        * `mdb_offline_mode_disable_lag` integer

        * `mdb_offline_mode_enable_lag` integer

        * `mdb_preserve_binlog_bytes` integer

        * `mdb_priority_choice_max_lag` integer

        * `net_read_timeout` integer

        * `net_write_timeout` integer

        * `range_optimizer_max_mem_size` integer

        * `rpl_semi_sync_master_wait_for_slave_count` integer

        * `show_compatibility_56` boolean

        * `slave_parallel_type` one of:
          - 0: "SLAVE_PARALLEL_TYPE_UNSPECIFIED"
          - 1: "DATABASE"
          - 2: "LOGICAL_CLOCK"

        * `slow_query_log` boolean

        * `slow_query_log_always_write_time` float

        * `slave_parallel_workers` integer

        * `sort_buffer_size` integer

        * `sync_binlog` integer

        * `table_definition_cache` integer

        * `table_open_cache` integer

        * `table_open_cache_instances` integer

        * `thread_cache_size` integer

        * `thread_stack` integer

        * `tmp_table_size` integer

        * `transaction_isolation` one of:
          - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"
          - 1: "READ_COMMITTED"
          - 2: "REPEATABLE_READ"
          - 3: "SERIALIZABLE"

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']] access: Access policy to the MySQL cluster. The structure is documented below.
        :param pulumi.Input[int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the MySQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]] hosts: A host of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] mysql_config: MySQL cluster config. Detail info in "MySQL config" section (documented below).
        :param pulumi.Input[str] name: Name of the MySQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the MySQL cluster uses.
        :param pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']] performance_diagnostics: Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        :param pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']] resources: Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbMysqlClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MySQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-mysql/).

        ## Example Usage

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_1.tf" }}

        Example of creating a High-Availability(HA) MySQL Cluster.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_2.tf" }}

        Example of creating a MySQL Cluster with cascade replicas: HA-group consist of 'na-1' and 'na-2', cascade replicas form a chain 'na-1' > 'nb-1' > 'nb-2'

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_3.tf" }}

        Example of creating a MySQL Cluster with different backup priorities. Backup will be created from nb-2, if it's not master. na-2 will be used as a backup source as a last resort.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_4.tf" }}

        Example of creating a MySQL Cluster with different host priorities. During failover master will be set to nb-2

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_5.tf" }}

        Example of creating a Single Node MySQL with user params.

        {{ tffile "examples/mdb_mysql_cluster/r_mdb_mysql_cluster_6.tf" }}

        ## MySQL config

        If not specified `mysql_config` then does not make any changes.

        * `sql_mode` default value: `ONLY_FULL_GROUP_BY,STRICT_TRANS_TABLES,NO_ZERO_IN_DATE,NO_ZERO_DATE,ERROR_FOR_DIVISION_BY_ZERO,NO_ENGINE_SUBSTITUTION`

        some of:
        - 1: "ALLOW_INVALID_DATES" - 2: "ANSI_QUOTES" - 3: "ERROR_FOR_DIVISION_BY_ZERO" - 4: "HIGH_NOT_PRECEDENCE" - 5: "IGNORE_SPACE" - 6: "NO_AUTO_VALUE_ON_ZERO" - 7: "NO_BACKSLASH_ESCAPES" - 8: "NO_ENGINE_SUBSTITUTION" - 9: "NO_UNSIGNED_SUBTRACTION" - 10: "NO_ZERO_DATE" - 11: "NO_ZERO_IN_DATE" - 15: "ONLY_FULL_GROUP_BY" - 16: "PAD_CHAR_TO_FULL_LENGTH" - 17: "PIPES_AS_CONCAT" - 18: "REAL_AS_FLOAT" - 19: "STRICT_ALL_TABLES" - 20: "STRICT_TRANS_TABLES" - 21: "TIME_TRUNCATE_FRACTIONAL" - 22: "ANSI" - 23: "TRADITIONAL" - 24: "NO_DIR_IN_CREATE" or:
        - 0: "SQLMODE_UNSPECIFIED"

        ### MysqlConfig 8.0
        * `audit_log` boolean

        * `auto_increment_increment` integer

        * `auto_increment_offset` integer

        * `binlog_cache_size` integer

        * `binlog_group_commit_sync_delay` integer

        * `binlog_row_image` one of:
          - 0: "BINLOG_ROW_IMAGE_UNSPECIFIED"
          - 1: "FULL"
          - 2: "MINIMAL"
          - 3: "NOBLOB"

        * `binlog_rows_query_log_events` boolean

        * `character_set_server` text

        * `collation_server` text

        * `default_authentication_plugin` one of:
          - 0: "AUTH_PLUGIN_UNSPECIFIED"
          - 1: "MYSQL_NATIVE_PASSWORD"
          - 2: "CACHING_SHA2_PASSWORD"
          - 3: "SHA256_PASSWORD"

        * `default_time_zone` text

        * `explicit_defaults_for_timestamp` boolean

        * `general_log` boolean

        * `group_concat_max_len` integer

        * `innodb_adaptive_hash_index` boolean

        * `innodb_buffer_pool_size` integer

        * `innodb_flush_log_at_trx_commit` integer

        * `innodb_ft_max_token_size` integer

        * `innodb_ft_min_token_size` integer

        * `innodb_io_capacity` integer

        * `innodb_io_capacity_max` integer

        * `innodb_lock_wait_timeout` integer

        * `innodb_log_buffer_size` integer

        * `innodb_log_file_size` integer

        * `innodb_numa_interleave` boolean

        * `innodb_online_alter_log_max_size` integer

        * `innodb_page_size` integer (create-only option)

        * `innodb_print_all_deadlocks` boolean

        * `innodb_purge_threads` integer

        * `innodb_read_io_threads` integer

        * `innodb_temp_data_file_max_size` integer

        * `innodb_thread_concurrency` integer

        * `innodb_write_io_threads` integer

        * `interactive_timeout` integer

        * `join_buffer_size` integer

        * `log_slow_rate_limit` intger

        * `log_slow_rate_type` one of:
          - 0: "SESSION"
          - 1: "QUERY"

        * `log_slow_sp_statements` boolean

        * `long_query_time` float

        * `lower_case_table_names` boolean (create-only option)

        * `max_allowed_packet` integer

        * `max_connections` integer

        * `max_heap_table_size` integer

        * `mdb_offline_mode_disable_lag` integer

        * `mdb_offline_mode_enable_lag` integer

        * `mdb_preserve_binlog_bytes` integer

        * `mdb_priority_choice_max_lag` integer

        * `net_read_timeout` integer

        * `net_write_timeout` integer

        * `range_optimizer_max_mem_size` integer

        * `regexp_time_limit` integer

        * `rpl_semi_sync_master_wait_for_slave_count` integer

        * `slave_parallel_type` one of:
          - 0: "SLAVE_PARALLEL_TYPE_UNSPECIFIED"
          - 1: "DATABASE"
          - 2: "LOGICAL_CLOCK"

        * `slow_query_log` boolean

        * `slow_query_log_always_write_time` float

        * `slave_parallel_workers` integer

        * `sort_buffer_size` integer

        * `sync_binlog` integer

        * `table_definition_cache` integer

        * `table_open_cache` integer

        * `table_open_cache_instances` integer

        * `thread_cache_size` integer

        * `thread_stack` integer

        * `tmp_table_size` integer

        * `transaction_isolation` one of:
          - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"
          - 1: "READ_COMMITTED"
          - 2: "REPEATABLE_READ"
          - 3: "SERIALIZABLE"

        * `wait_timeout` integer

        ### MysqlConfig 5.7
        * `audit_log` boolean

        * `auto_increment_increment` integer

        * `auto_increment_offset` integer

        * `binlog_cache_size` integer

        * `binlog_group_commit_sync_delay` integer

        * `binlog_row_image` one of:
          - 0: "BINLOG_ROW_IMAGE_UNSPECIFIED"
          - 1: "FULL"
          - 2: "MINIMAL"
          - 3: "NOBLOB"

        * `binlog_rows_query_log_events` boolean

        * `character_set_server` text

        * `collation_server` text

        * `default_authentication_plugin` one of:
          - 0: "AUTH_PLUGIN_UNSPECIFIED"
          - 1: "MYSQL_NATIVE_PASSWORD"
          - 2: "CACHING_SHA2_PASSWORD"
          - 3: "SHA256_PASSWORD"

        * `default_time_zone` text

        * `explicit_defaults_for_timestamp` boolean

        * `general_log` boolean

        * `group_concat_max_len` integer

        * `innodb_adaptive_hash_index` boolean

        * `innodb_buffer_pool_size` integer

        * `innodb_flush_log_at_trx_commit` integer

        * `innodb_ft_max_token_size` integer

        * `innodb_ft_min_token_size` integer

        * `innodb_io_capacity` integer

        * `innodb_io_capacity_max` integer

        * `innodb_lock_wait_timeout` integer

        * `innodb_log_buffer_size` integer

        * `innodb_log_file_size` integer

        * `innodb_numa_interleave` boolean

        * `innodb_online_alter_log_max_size` integer

        * `innodb_page_size` integer (create-only option)

        * `innodb_print_all_deadlocks` boolean

        * `innodb_purge_threads` integer

        * `innodb_read_io_threads` integer

        * `innodb_temp_data_file_max_size` integer

        * `innodb_thread_concurrency` integer

        * `innodb_write_io_threads` integer

        * `interactive_timeout` integer

        * `join_buffer_size` integer

        * `log_slow_rate_limit` integer

        * `log_slow_rate_type` one of:
          - 0: "SESSION"
          - 1: "QUERY"

        * `log_slow_sp_statements` boolean

        * `long_query_time` float

        * `lower_case_table_names` boolean (create-only option)

        * `max_allowed_packet` integer

        * `max_connections` integer

        * `max_heap_table_size` integer

        * `mdb_offline_mode_disable_lag` integer

        * `mdb_offline_mode_enable_lag` integer

        * `mdb_preserve_binlog_bytes` integer

        * `mdb_priority_choice_max_lag` integer

        * `net_read_timeout` integer

        * `net_write_timeout` integer

        * `range_optimizer_max_mem_size` integer

        * `rpl_semi_sync_master_wait_for_slave_count` integer

        * `show_compatibility_56` boolean

        * `slave_parallel_type` one of:
          - 0: "SLAVE_PARALLEL_TYPE_UNSPECIFIED"
          - 1: "DATABASE"
          - 2: "LOGICAL_CLOCK"

        * `slow_query_log` boolean

        * `slow_query_log_always_write_time` float

        * `slave_parallel_workers` integer

        * `sort_buffer_size` integer

        * `sync_binlog` integer

        * `table_definition_cache` integer

        * `table_open_cache` integer

        * `table_open_cache_instances` integer

        * `thread_cache_size` integer

        * `thread_stack` integer

        * `tmp_table_size` integer

        * `transaction_isolation` one of:
          - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"
          - 1: "READ_COMMITTED"
          - 2: "REPEATABLE_READ"
          - 3: "SERIALIZABLE"

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbMysqlCluster:MdbMysqlCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param MdbMysqlClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbMysqlClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
                 allow_regeneration_host: Optional[pulumi.Input[bool]] = None,
                 backup_retain_period_days: Optional[pulumi.Input[int]] = None,
                 backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
                 mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
                 resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
                 restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbMysqlClusterArgs.__new__(MdbMysqlClusterArgs)

            __props__.__dict__["access"] = access
            __props__.__dict__["allow_regeneration_host"] = allow_regeneration_host
            __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
            __props__.__dict__["backup_window_start"] = backup_window_start
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["mysql_config"] = mysql_config
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["performance_diagnostics"] = performance_diagnostics
            if resources is None and not opts.urn:
                raise TypeError("Missing required property 'resources'")
            __props__.__dict__["resources"] = resources
            __props__.__dict__["restore"] = restore
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["users"] = users
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbMysqlCluster, __self__).__init__(
            'yandex:index/mdbMysqlCluster:MdbMysqlCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access: Optional[pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']]] = None,
            allow_regeneration_host: Optional[pulumi.Input[bool]] = None,
            backup_retain_period_days: Optional[pulumi.Input[int]] = None,
            backup_window_start: Optional[pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            health: Optional[pulumi.Input[str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']]] = None,
            mysql_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            performance_diagnostics: Optional[pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']]] = None,
            resources: Optional[pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']]] = None,
            restore: Optional[pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'MdbMysqlCluster':
        """
        Get an existing MdbMysqlCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbMysqlClusterAccessArgs', 'MdbMysqlClusterAccessArgsDict']] access: Access policy to the MySQL cluster. The structure is documented below.
        :param pulumi.Input[int] backup_retain_period_days: The period in days during which backups are stored.
        :param pulumi.Input[Union['MdbMysqlClusterBackupWindowStartArgs', 'MdbMysqlClusterBackupWindowStartArgsDict']] backup_window_start: Time to start the daily backup, in the UTC. The structure is documented below.
        :param pulumi.Input[str] created_at: Creation timestamp of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterDatabaseArgs', 'MdbMysqlClusterDatabaseArgsDict']]]] databases: To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the MySQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the MySQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[str] health: Aggregated health of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterHostArgs', 'MdbMysqlClusterHostArgsDict']]]] hosts: A host of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the MySQL cluster.
        :param pulumi.Input[Union['MdbMysqlClusterMaintenanceWindowArgs', 'MdbMysqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] mysql_config: MySQL cluster config. Detail info in "MySQL config" section (documented below).
        :param pulumi.Input[str] name: Name of the MySQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the MySQL cluster uses.
        :param pulumi.Input[Union['MdbMysqlClusterPerformanceDiagnosticsArgs', 'MdbMysqlClusterPerformanceDiagnosticsArgsDict']] performance_diagnostics: Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        :param pulumi.Input[Union['MdbMysqlClusterResourcesArgs', 'MdbMysqlClusterResourcesArgsDict']] resources: Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        :param pulumi.Input[Union['MdbMysqlClusterRestoreArgs', 'MdbMysqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[str] status: Status of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbMysqlClusterUserArgs', 'MdbMysqlClusterUserArgsDict']]]] users: To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        :param pulumi.Input[str] version: Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbMysqlClusterState.__new__(_MdbMysqlClusterState)

        __props__.__dict__["access"] = access
        __props__.__dict__["allow_regeneration_host"] = allow_regeneration_host
        __props__.__dict__["backup_retain_period_days"] = backup_retain_period_days
        __props__.__dict__["backup_window_start"] = backup_window_start
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["mysql_config"] = mysql_config
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["performance_diagnostics"] = performance_diagnostics
        __props__.__dict__["resources"] = resources
        __props__.__dict__["restore"] = restore
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        __props__.__dict__["version"] = version
        return MdbMysqlCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def access(self) -> pulumi.Output['outputs.MdbMysqlClusterAccess']:
        """
        Access policy to the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "access")

    @property
    @pulumi.getter(name="allowRegenerationHost")
    @_utilities.deprecated("""You can safely remove this option. There is no need to recreate host if assign_public_ip is changed.""")
    def allow_regeneration_host(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "allow_regeneration_host")

    @property
    @pulumi.getter(name="backupRetainPeriodDays")
    def backup_retain_period_days(self) -> pulumi.Output[int]:
        """
        The period in days during which backups are stored.
        """
        return pulumi.get(self, "backup_retain_period_days")

    @property
    @pulumi.getter(name="backupWindowStart")
    def backup_window_start(self) -> pulumi.Output['outputs.MdbMysqlClusterBackupWindowStart']:
        """
        Time to start the daily backup, in the UTC. The structure is documented below.
        """
        return pulumi.get(self, "backup_window_start")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_mysql_database""")
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MdbMysqlClusterDatabase']]]:
        """
        To manage databases, please switch to using a separate resource type `yandex_mdb_mysql_databases`.
        """
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the MySQL cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        Deployment environment of the MySQL cluster.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "host_group_ids")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbMysqlClusterHost']]:
        """
        A host of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the MySQL cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbMysqlClusterMaintenanceWindow']:
        """
        Maintenance policy of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="mysqlConfig")
    def mysql_config(self) -> pulumi.Output[Mapping[str, str]]:
        """
        MySQL cluster config. Detail info in "MySQL config" section (documented below).
        """
        return pulumi.get(self, "mysql_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the MySQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        ID of the network, to which the MySQL cluster uses.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="performanceDiagnostics")
    def performance_diagnostics(self) -> pulumi.Output['outputs.MdbMysqlClusterPerformanceDiagnostics']:
        """
        Cluster performance diagnostics settings. The structure is documented below. [YC Documentation](https://yandex.cloud/docs/managed-mysql/api-ref/grpc/cluster_service#PerformanceDiagnostics)
        """
        return pulumi.get(self, "performance_diagnostics")

    @property
    @pulumi.getter
    def resources(self) -> pulumi.Output['outputs.MdbMysqlClusterResources']:
        """
        Resources allocated to hosts of the MySQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.MdbMysqlClusterRestore']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_mysql_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbMysqlClusterUser']]]:
        """
        To manage users, please switch to using a separate resource type `MdbMysqlUser`.
        """
        return pulumi.get(self, "users")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Version of the MySQL cluster. (allowed versions are: 5.7, 8.0)
        """
        return pulumi.get(self, "version")

