# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbPostgresqlClusterArgs', 'MdbPostgresqlCluster']

@pulumi.input_type
class MdbPostgresqlClusterArgs:
    def __init__(__self__, *,
                 config: pulumi.Input['MdbPostgresqlClusterConfigArgs'],
                 environment: pulumi.Input[str],
                 hosts: pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]],
                 network_id: pulumi.Input[str],
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_master_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 restore: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]] = None):
        """
        The set of arguments for constructing a MdbPostgresqlCluster resource.
        :param pulumi.Input['MdbPostgresqlClusterConfigArgs'] config: Configuration of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]] hosts: A host of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] network_id: ID of the network, to which the PostgreSQL cluster belongs.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the PostgreSQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        :param pulumi.Input[str] host_master_name: It sets name of master host. It works only when `host.name` is set.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the PostgreSQL cluster.
        :param pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input['MdbPostgresqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "hosts", hosts)
        pulumi.set(__self__, "network_id", network_id)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if host_master_name is not None:
            warnings.warn("""This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""", DeprecationWarning)
            pulumi.log.warn("""host_master_name is deprecated: This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
        if host_master_name is not None:
            pulumi.set(__self__, "host_master_name", host_master_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Input['MdbPostgresqlClusterConfigArgs']:
        """
        Configuration of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: pulumi.Input['MdbPostgresqlClusterConfigArgs']):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Input[str]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: pulumi.Input[str]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]:
        """
        A host of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        ID of the network, to which the PostgreSQL cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]:
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the PostgreSQL cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> Optional[pulumi.Input[str]]:
        """
        It sets name of master host. It works only when `host.name` is set.
        """
        return pulumi.get(self, "host_master_name")

    @host_master_name.setter
    def host_master_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_master_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the PostgreSQL cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]:
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


@pulumi.input_type
class _MdbPostgresqlClusterState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 health: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_master_name: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 restore: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]] = None):
        """
        Input properties used for looking up and filtering MdbPostgresqlCluster resources.
        :param pulumi.Input['MdbPostgresqlClusterConfigArgs'] config: Configuration of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] created_at: Timestamp of cluster creation.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the PostgreSQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        :param pulumi.Input[str] health: Aggregated health of the cluster.
        :param pulumi.Input[str] host_master_name: It sets name of master host. It works only when `host.name` is set.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]] hosts: A host of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the PostgreSQL cluster.
        :param pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs'] maintenance_window: Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the PostgreSQL cluster belongs.
        :param pulumi.Input['MdbPostgresqlClusterRestoreArgs'] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[str] status: Status of the cluster.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if databases is not None:
            warnings.warn("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""", DeprecationWarning)
            pulumi.log.warn("""databases is deprecated: to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if health is not None:
            pulumi.set(__self__, "health", health)
        if host_group_ids is not None:
            pulumi.set(__self__, "host_group_ids", host_group_ids)
        if host_master_name is not None:
            warnings.warn("""This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""", DeprecationWarning)
            pulumi.log.warn("""host_master_name is deprecated: This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
        if host_master_name is not None:
            pulumi.set(__self__, "host_master_name", host_master_name)
        if hosts is not None:
            pulumi.set(__self__, "hosts", hosts)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if restore is not None:
            pulumi.set(__self__, "restore", restore)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if users is not None:
            warnings.warn("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""", DeprecationWarning)
            pulumi.log.warn("""users is deprecated: to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
        if users is not None:
            pulumi.set(__self__, "users", users)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']]:
        """
        Configuration of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['MdbPostgresqlClusterConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Timestamp of cluster creation.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]:
        return pulumi.get(self, "databases")

    @databases.setter
    def databases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterDatabaseArgs']]]]):
        pulumi.set(self, "databases", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the PostgreSQL cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def health(self) -> Optional[pulumi.Input[str]]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @health.setter
    def health(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "health", value)

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "host_group_ids")

    @host_group_ids.setter
    def host_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "host_group_ids", value)

    @property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> Optional[pulumi.Input[str]]:
        """
        It sets name of master host. It works only when `host.name` is set.
        """
        return pulumi.get(self, "host_master_name")

    @host_master_name.setter
    def host_master_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_master_name", value)

    @property
    @pulumi.getter
    def hosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]]:
        """
        A host of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @hosts.setter
    def hosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterHostArgs']]]]):
        pulumi.set(self, "hosts", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the PostgreSQL cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]:
        """
        Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MdbPostgresqlClusterMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network, to which the PostgreSQL cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def restore(self) -> Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @restore.setter
    def restore(self, value: Optional[pulumi.Input['MdbPostgresqlClusterRestoreArgs']]):
        pulumi.set(self, "restore", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]:
        return pulumi.get(self, "users")

    @users.setter
    def users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlClusterUserArgs']]]]):
        pulumi.set(self, "users", value)


class MdbPostgresqlCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_master_name: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-postgresql/). [How to connect to the DB](https://yandex.cloud/docs/managed-postgresql/quickstart#connect). To connect, use port 6432. The port number is not configurable.

        ## Example Usage

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_1.tf" }}

        Example of creating a High-Availability (HA) PostgreSQL Cluster.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_2.tf" }}

        Example of creating a High-Availability (HA) PostgreSQL Cluster.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_3.tf" }}

        Example of creating a Single Node PostgreSQL from backup.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_4.tf" }}

        ## PostgreSQL cluster settings

        More information about config:
        * https://cloud.yandex.com/docs/managed-postgresql/concepts/settings-list
        * https://www.postgresql.org/docs/current/runtime-config-connection.html
        * https://www.postgresql.org/docs/current/runtime-config-resource.html
        * https://www.postgresql.org/docs/current/runtime-config-wal.html
        * https://www.postgresql.org/docs/current/runtime-config-query.html
        * https://www.postgresql.org/docs/current/runtime-config-logging.html
        * https://www.postgresql.org/docs/current/runtime-config-autovacuum.html
        * https://www.postgresql.org/docs/current/runtime-config-client.html
        * https://www.postgresql.org/docs/current/runtime-config-locks.html
        * https://www.postgresql.org/docs/current/runtime-config-compatible.html

        | Setting name and type \\ PostgreSQL version                                                                                                                                                                                                                                                                                                                                            | 11        | 12        | 13        | 14        | 15        |
        |---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------|-----------|-----------|-----------|-----------|
        | archive_timeout : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | array_nulls : boolean                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | auto_explain_log_analyze : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_log_buffers : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_log_min_duration : integer                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | auto_explain_log_nested_statements : boolean                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | auto_explain_log_timing : boolean                                                                                                                                                                                                                                                                                                                                                     | supported | supported | supported | supported | supported |
        | auto_explain_log_triggers : boolean                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | auto_explain_log_verbose : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_sample_rate : float                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | autovacuum_analyze_scale_factor : float                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | autovacuum_max_workers : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | autovacuum_naptime : integer                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_cost_delay : integer                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_cost_limit : integer                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_insert_scale_factor : float                                                                                                                                                                                                                                                                                                                                         | -         | -         | supported | supported | supported |
        | autovacuum_vacuum_insert_threshold : integer                                                                                                                                                                                                                                                                                                                                          | -         | -         | supported | supported | supported |
        | autovacuum_vacuum_scale_factor : float                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_work_mem : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | backend_flush_after : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | backslash_quote : one of<br> - 0: "BACKSLASH_QUOTE_UNSPECIFIED"<br> - 1: "BACKSLASH_QUOTE"<br> - 2: "BACKSLASH_QUOTE_ON"<br> - 3: "BACKSLASH_QUOTE_OFF"<br> - 4: "BACKSLASH_QUOTE_SAFE_ENCODING"                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | bgwriter_delay : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | bgwriter_flush_after : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | bgwriter_lru_maxpages : integer                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | bgwriter_lru_multiplier : float                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | bytea_output : one of<br> - 0: "BYTEA_OUTPUT_UNSPECIFIED"<br> - 1: "BYTEA_OUTPUT_HEX"<br> - 2: "BYTEA_OUTPUT_ESCAPED"                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | checkpoint_completion_target : float                                                                                                                                                                                                                                                                                                                                                  | supported | supported | supported | supported | supported |
        | checkpoint_flush_after : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | checkpoint_timeout : integer                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | client_min_messages : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"        | supported | supported | supported | supported | supported |
        | constraint_exclusion : one of<br> - 0: "CONSTRAINT_EXCLUSION_UNSPECIFIED"<br> - 1: "CONSTRAINT_EXCLUSION_ON"<br> - 2: "CONSTRAINT_EXCLUSION_OFF"<br> - 3: "CONSTRAINT_EXCLUSION_PARTITION"                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | cursor_tuple_fraction : float                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | deadlock_timeout : integer                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | default_statistics_target : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | default_transaction_isolation : one of<br> - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"<br> - 1: "TRANSACTION_ISOLATION_READ_UNCOMMITTED"<br> - 2: "TRANSACTION_ISOLATION_READ_COMMITTED"<br> - 3: "TRANSACTION_ISOLATION_REPEATABLE_READ"<br> - 4: "TRANSACTION_ISOLATION_SERIALIZABLE"                                                                                                  | supported | supported | supported | supported | supported |
        | default_transaction_read_only : boolean                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | default_with_oids : boolean                                                                                                                                                                                                                                                                                                                                                           | supported | -         | -         | -         | -         |
        | effective_cache_size : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | effective_io_concurrency : integer                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | enable_bitmapscan : boolean                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | enable_hashagg : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_hashjoin : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_incremental_sort : boolean                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | enable_indexonlyscan : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | enable_indexscan : boolean                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | enable_material : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_mergejoin : boolean                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | enable_nestloop : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_parallel_append : boolean                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | enable_parallel_hash : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | enable_partition_pruning : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | enable_partitionwise_aggregate : boolean                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_partitionwise_join : boolean                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | enable_seqscan : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_sort : boolean                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | enable_tidscan : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | escape_string_warning : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | exit_on_error : boolean                                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | force_parallel_mode : one of<br> - 0: "FORCE_PARALLEL_MODE_UNSPECIFIED"<br> - 1: "FORCE_PARALLEL_MODE_ON"<br> - 2: "FORCE_PARALLEL_MODE_OFF"<br> - 3: "FORCE_PARALLEL_MODE_REGRESS"                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | from_collapse_limit : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | gin_pending_list_limit : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | hash_mem_multiplier : float                                                                                                                                                                                                                                                                                                                                                           | -         | -         | supported | supported | supported |
        | idle_in_transaction_session_timeout : integer                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | jit : boolean                                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | join_collapse_limit : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | lo_compat_privileges : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | lock_timeout : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | log_checkpoints : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | log_connections : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | log_disconnections : boolean                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | log_duration : boolean                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | log_error_verbosity : one of<br> - 0: "LOG_ERROR_VERBOSITY_UNSPECIFIED"<br> - 1: "LOG_ERROR_VERBOSITY_TERSE"<br> - 2: "LOG_ERROR_VERBOSITY_DEFAULT"<br> - 3: "LOG_ERROR_VERBOSITY_VERBOSE"                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | log_lock_waits : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | log_min_duration_sample : integer                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | log_min_duration_statement : integer                                                                                                                                                                                                                                                                                                                                                  | supported | supported | supported | supported | supported |
        | log_min_error_statement : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"    | supported | supported | supported | supported | supported |
        | log_min_messages : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"           | supported | supported | supported | supported | supported |
        | log_parameter_max_length : integer                                                                                                                                                                                                                                                                                                                                                    | -         | -         | supported | supported | supported |
        | log_parameter_max_length_on_error : integer                                                                                                                                                                                                                                                                                                                                           | -         | -         | supported | supported | supported |
        | log_statement : one of<br> - 0: "LOG_STATEMENT_UNSPECIFIED"<br> - 1: "LOG_STATEMENT_NONE"<br> - 2: "LOG_STATEMENT_DDL"<br> - 3: "LOG_STATEMENT_MOD"<br> - 4: "LOG_STATEMENT_ALL"                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | log_statement_sample_rate : float                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | log_temp_files : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | log_transaction_sample_rate : float                                                                                                                                                                                                                                                                                                                                                   | -         | supported | supported | supported | supported |
        | logical_decoding_work_mem : integer                                                                                                                                                                                                                                                                                                                                                   | -         | -         | supported | supported | supported |
        | maintenance_io_concurrency : integer                                                                                                                                                                                                                                                                                                                                                  | -         | -         | supported | supported | supported |
        | maintenance_work_mem : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | max_connections : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | max_locks_per_transaction : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | max_parallel_maintenance_workers : integer                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | max_parallel_workers : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | max_parallel_workers_per_gather : integer                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | max_pred_locks_per_transaction : integer                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | max_prepared_transactions : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | max_slot_wal_keep_size : integer                                                                                                                                                                                                                                                                                                                                                      | -         | -         | supported | supported | supported |
        | max_standby_streaming_delay : integer                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | max_wal_size : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | max_worker_processes : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | min_wal_size : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | old_snapshot_threshold : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | operator_precedence_warning : boolean                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | -         | -         |
        | parallel_leader_participation : boolean                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | pg_hint_plan_debug_print : one of<br> - 0: "PG_HINT_PLAN_DEBUG_PRINT_UNSPECIFIED"<br> - 1: "PG_HINT_PLAN_DEBUG_PRINT_OFF"<br> - 2: "PG_HINT_PLAN_DEBUG_PRINT_ON"<br> - 3: "PG_HINT_PLAN_DEBUG_PRINT_DETAILED"<br> - 4: "PG_HINT_PLAN_DEBUG_PRINT_VERBOSE"                                                                                                                             | supported | supported | supported | supported | supported |
        | pg_hint_plan_enable_hint : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | pg_hint_plan_enable_hint_table : boolean                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | pg_hint_plan_message_level : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC" | supported | supported | supported | supported | supported |
        | plan_cache_mode : one of<br> - 0: "PLAN_CACHE_MODE_UNSPECIFIED"<br> - 1: "PLAN_CACHE_MODE_AUTO"<br> - 2: "PLAN_CACHE_MODE_FORCE_CUSTOM_PLAN"<br> - 3: "PLAN_CACHE_MODE_FORCE_GENERIC_PLAN"                                                                                                                                                                                            | -         | supported | supported | supported | supported |
        | quote_all_identifiers : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | random_page_cost : float                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | row_security : boolean                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | search_path : text                                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | seq_page_cost : float                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | shared_buffers : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | shared_preload_libraries : override if not set. one of<br> - "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN<br> - "SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN"<br> - "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN"<br> - "SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN"<br> - NO value                                                                                                                          | supported | supported | supported | supported | supported |
        | standard_conforming_strings : boolean                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | statement_timeout : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | synchronize_seqscans : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | synchronous_commit : one of<br> - 0: "SYNCHRONOUS_COMMIT_UNSPECIFIED"<br> - 1: "SYNCHRONOUS_COMMIT_ON"<br> - 2: "SYNCHRONOUS_COMMIT_OFF"<br> - 3: "SYNCHRONOUS_COMMIT_LOCAL"<br> - 4: "SYNCHRONOUS_COMMIT_REMOTE_WRITE"<br> - 5: "SYNCHRONOUS_COMMIT_REMOTE_APPLY"                                                                                                                    | supported | supported | supported | supported | supported |
        | temp_buffers : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | temp_file_limit : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | timezone : text                                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | track_activity_query_size : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | transform_null_equals : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | vacuum_cleanup_index_scale_factor : float                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | -         | -         |
        | vacuum_cost_delay : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | vacuum_cost_limit : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | vacuum_cost_page_dirty : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | vacuum_cost_page_hit : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | vacuum_cost_page_miss : integer                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | wal_keep_size : integer                                                                                                                                                                                                                                                                                                                                                               | -         | -         | supported | supported | supported |
        | wal_level : one of<br> - 0: "WAL_LEVEL_UNSPECIFIED"<br> - 1: "WAL_LEVEL_REPLICA"<br> - 2: "WAL_LEVEL_LOGICAL"                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | work_mem : integer                                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | xmlbinary : one of<br> - 0: "XML_BINARY_UNSPECIFIED"<br> - 1: "XML_BINARY_BASE64"<br> - 2: "XML_BINARY_HEX"                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | xmloption : one of<br> - 0: "XML_OPTION_UNSPECIFIED"<br> - 1: "XML_OPTION_DOCUMENT"<br> - 2: "XML_OPTION_CONTENT"                                                                                                                                                                                                                                                                     | supported | supported | supported | supported | supported |

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']] config: Configuration of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the PostgreSQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        :param pulumi.Input[str] host_master_name: It sets name of master host. It works only when `host.name` is set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]] hosts: A host of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the PostgreSQL cluster.
        :param pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the PostgreSQL cluster belongs.
        :param pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbPostgresqlClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL cluster within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-postgresql/). [How to connect to the DB](https://yandex.cloud/docs/managed-postgresql/quickstart#connect). To connect, use port 6432. The port number is not configurable.

        ## Example Usage

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_1.tf" }}

        Example of creating a High-Availability (HA) PostgreSQL Cluster.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_2.tf" }}

        Example of creating a High-Availability (HA) PostgreSQL Cluster.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_3.tf" }}

        Example of creating a Single Node PostgreSQL from backup.

        {{ tffile "examples/mdb_postgresql_cluster/r_mdb_postgresql_cluster_4.tf" }}

        ## PostgreSQL cluster settings

        More information about config:
        * https://cloud.yandex.com/docs/managed-postgresql/concepts/settings-list
        * https://www.postgresql.org/docs/current/runtime-config-connection.html
        * https://www.postgresql.org/docs/current/runtime-config-resource.html
        * https://www.postgresql.org/docs/current/runtime-config-wal.html
        * https://www.postgresql.org/docs/current/runtime-config-query.html
        * https://www.postgresql.org/docs/current/runtime-config-logging.html
        * https://www.postgresql.org/docs/current/runtime-config-autovacuum.html
        * https://www.postgresql.org/docs/current/runtime-config-client.html
        * https://www.postgresql.org/docs/current/runtime-config-locks.html
        * https://www.postgresql.org/docs/current/runtime-config-compatible.html

        | Setting name and type \\ PostgreSQL version                                                                                                                                                                                                                                                                                                                                            | 11        | 12        | 13        | 14        | 15        |
        |---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------|-----------|-----------|-----------|-----------|
        | archive_timeout : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | array_nulls : boolean                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | auto_explain_log_analyze : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_log_buffers : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_log_min_duration : integer                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | auto_explain_log_nested_statements : boolean                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | auto_explain_log_timing : boolean                                                                                                                                                                                                                                                                                                                                                     | supported | supported | supported | supported | supported |
        | auto_explain_log_triggers : boolean                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | auto_explain_log_verbose : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | auto_explain_sample_rate : float                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | autovacuum_analyze_scale_factor : float                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | autovacuum_max_workers : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | autovacuum_naptime : integer                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_cost_delay : integer                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_cost_limit : integer                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_vacuum_insert_scale_factor : float                                                                                                                                                                                                                                                                                                                                         | -         | -         | supported | supported | supported |
        | autovacuum_vacuum_insert_threshold : integer                                                                                                                                                                                                                                                                                                                                          | -         | -         | supported | supported | supported |
        | autovacuum_vacuum_scale_factor : float                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | autovacuum_work_mem : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | backend_flush_after : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | backslash_quote : one of<br> - 0: "BACKSLASH_QUOTE_UNSPECIFIED"<br> - 1: "BACKSLASH_QUOTE"<br> - 2: "BACKSLASH_QUOTE_ON"<br> - 3: "BACKSLASH_QUOTE_OFF"<br> - 4: "BACKSLASH_QUOTE_SAFE_ENCODING"                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | bgwriter_delay : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | bgwriter_flush_after : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | bgwriter_lru_maxpages : integer                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | bgwriter_lru_multiplier : float                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | bytea_output : one of<br> - 0: "BYTEA_OUTPUT_UNSPECIFIED"<br> - 1: "BYTEA_OUTPUT_HEX"<br> - 2: "BYTEA_OUTPUT_ESCAPED"                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | checkpoint_completion_target : float                                                                                                                                                                                                                                                                                                                                                  | supported | supported | supported | supported | supported |
        | checkpoint_flush_after : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | checkpoint_timeout : integer                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | client_min_messages : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"        | supported | supported | supported | supported | supported |
        | constraint_exclusion : one of<br> - 0: "CONSTRAINT_EXCLUSION_UNSPECIFIED"<br> - 1: "CONSTRAINT_EXCLUSION_ON"<br> - 2: "CONSTRAINT_EXCLUSION_OFF"<br> - 3: "CONSTRAINT_EXCLUSION_PARTITION"                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | cursor_tuple_fraction : float                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | deadlock_timeout : integer                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | default_statistics_target : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | default_transaction_isolation : one of<br> - 0: "TRANSACTION_ISOLATION_UNSPECIFIED"<br> - 1: "TRANSACTION_ISOLATION_READ_UNCOMMITTED"<br> - 2: "TRANSACTION_ISOLATION_READ_COMMITTED"<br> - 3: "TRANSACTION_ISOLATION_REPEATABLE_READ"<br> - 4: "TRANSACTION_ISOLATION_SERIALIZABLE"                                                                                                  | supported | supported | supported | supported | supported |
        | default_transaction_read_only : boolean                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | default_with_oids : boolean                                                                                                                                                                                                                                                                                                                                                           | supported | -         | -         | -         | -         |
        | effective_cache_size : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | effective_io_concurrency : integer                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | enable_bitmapscan : boolean                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | enable_hashagg : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_hashjoin : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_incremental_sort : boolean                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | enable_indexonlyscan : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | enable_indexscan : boolean                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | enable_material : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_mergejoin : boolean                                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | enable_nestloop : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | enable_parallel_append : boolean                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | enable_parallel_hash : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | enable_partition_pruning : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | enable_partitionwise_aggregate : boolean                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_partitionwise_join : boolean                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | enable_seqscan : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | enable_sort : boolean                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | enable_tidscan : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | escape_string_warning : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | exit_on_error : boolean                                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | force_parallel_mode : one of<br> - 0: "FORCE_PARALLEL_MODE_UNSPECIFIED"<br> - 1: "FORCE_PARALLEL_MODE_ON"<br> - 2: "FORCE_PARALLEL_MODE_OFF"<br> - 3: "FORCE_PARALLEL_MODE_REGRESS"                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | from_collapse_limit : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | gin_pending_list_limit : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | hash_mem_multiplier : float                                                                                                                                                                                                                                                                                                                                                           | -         | -         | supported | supported | supported |
        | idle_in_transaction_session_timeout : integer                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | jit : boolean                                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | join_collapse_limit : integer                                                                                                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | lo_compat_privileges : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | lock_timeout : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | log_checkpoints : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | log_connections : boolean                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | log_disconnections : boolean                                                                                                                                                                                                                                                                                                                                                          | supported | supported | supported | supported | supported |
        | log_duration : boolean                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | log_error_verbosity : one of<br> - 0: "LOG_ERROR_VERBOSITY_UNSPECIFIED"<br> - 1: "LOG_ERROR_VERBOSITY_TERSE"<br> - 2: "LOG_ERROR_VERBOSITY_DEFAULT"<br> - 3: "LOG_ERROR_VERBOSITY_VERBOSE"                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | log_lock_waits : boolean                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | log_min_duration_sample : integer                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | log_min_duration_statement : integer                                                                                                                                                                                                                                                                                                                                                  | supported | supported | supported | supported | supported |
        | log_min_error_statement : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"    | supported | supported | supported | supported | supported |
        | log_min_messages : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC"           | supported | supported | supported | supported | supported |
        | log_parameter_max_length : integer                                                                                                                                                                                                                                                                                                                                                    | -         | -         | supported | supported | supported |
        | log_parameter_max_length_on_error : integer                                                                                                                                                                                                                                                                                                                                           | -         | -         | supported | supported | supported |
        | log_statement : one of<br> - 0: "LOG_STATEMENT_UNSPECIFIED"<br> - 1: "LOG_STATEMENT_NONE"<br> - 2: "LOG_STATEMENT_DDL"<br> - 3: "LOG_STATEMENT_MOD"<br> - 4: "LOG_STATEMENT_ALL"                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | log_statement_sample_rate : float                                                                                                                                                                                                                                                                                                                                                     | -         | -         | supported | supported | supported |
        | log_temp_files : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | log_transaction_sample_rate : float                                                                                                                                                                                                                                                                                                                                                   | -         | supported | supported | supported | supported |
        | logical_decoding_work_mem : integer                                                                                                                                                                                                                                                                                                                                                   | -         | -         | supported | supported | supported |
        | maintenance_io_concurrency : integer                                                                                                                                                                                                                                                                                                                                                  | -         | -         | supported | supported | supported |
        | maintenance_work_mem : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | max_connections : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | max_locks_per_transaction : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | max_parallel_maintenance_workers : integer                                                                                                                                                                                                                                                                                                                                            | supported | supported | supported | supported | supported |
        | max_parallel_workers : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | max_parallel_workers_per_gather : integer                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | max_pred_locks_per_transaction : integer                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | max_prepared_transactions : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | max_slot_wal_keep_size : integer                                                                                                                                                                                                                                                                                                                                                      | -         | -         | supported | supported | supported |
        | max_standby_streaming_delay : integer                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | max_wal_size : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | max_worker_processes : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | min_wal_size : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | old_snapshot_threshold : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | operator_precedence_warning : boolean                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | -         | -         |
        | parallel_leader_participation : boolean                                                                                                                                                                                                                                                                                                                                               | supported | supported | supported | supported | supported |
        | pg_hint_plan_debug_print : one of<br> - 0: "PG_HINT_PLAN_DEBUG_PRINT_UNSPECIFIED"<br> - 1: "PG_HINT_PLAN_DEBUG_PRINT_OFF"<br> - 2: "PG_HINT_PLAN_DEBUG_PRINT_ON"<br> - 3: "PG_HINT_PLAN_DEBUG_PRINT_DETAILED"<br> - 4: "PG_HINT_PLAN_DEBUG_PRINT_VERBOSE"                                                                                                                             | supported | supported | supported | supported | supported |
        | pg_hint_plan_enable_hint : boolean                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | pg_hint_plan_enable_hint_table : boolean                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | pg_hint_plan_message_level : one of<br> - 0: "LOG_LEVEL_UNSPECIFIED"<br> - 1: "LOG_LEVEL_DEBUG5"<br> - 2: "LOG_LEVEL_DEBUG4"<br> - 3: "LOG_LEVEL_DEBUG3"<br> - 4: "LOG_LEVEL_DEBUG2"<br> - 5: "LOG_LEVEL_DEBUG1"<br> - 6: "LOG_LEVEL_LOG"<br> - 7: "LOG_LEVEL_NOTICE"<br> - 8: "LOG_LEVEL_WARNING"<br> - 9: "LOG_LEVEL_ERROR"<br> - 10: "LOG_LEVEL_FATAL"<br> - 11: "LOG_LEVEL_PANIC" | supported | supported | supported | supported | supported |
        | plan_cache_mode : one of<br> - 0: "PLAN_CACHE_MODE_UNSPECIFIED"<br> - 1: "PLAN_CACHE_MODE_AUTO"<br> - 2: "PLAN_CACHE_MODE_FORCE_CUSTOM_PLAN"<br> - 3: "PLAN_CACHE_MODE_FORCE_GENERIC_PLAN"                                                                                                                                                                                            | -         | supported | supported | supported | supported |
        | quote_all_identifiers : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | random_page_cost : float                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | row_security : boolean                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | search_path : text                                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | seq_page_cost : float                                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | shared_buffers : integer                                                                                                                                                                                                                                                                                                                                                              | supported | supported | supported | supported | supported |
        | shared_preload_libraries : override if not set. one of<br> - "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN<br> - "SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN"<br> - "SHARED_PRELOAD_LIBRARIES_AUTO_EXPLAIN"<br> - "SHARED_PRELOAD_LIBRARIES_PG_HINT_PLAN"<br> - NO value                                                                                                                          | supported | supported | supported | supported | supported |
        | standard_conforming_strings : boolean                                                                                                                                                                                                                                                                                                                                                 | supported | supported | supported | supported | supported |
        | statement_timeout : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | synchronize_seqscans : boolean                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | synchronous_commit : one of<br> - 0: "SYNCHRONOUS_COMMIT_UNSPECIFIED"<br> - 1: "SYNCHRONOUS_COMMIT_ON"<br> - 2: "SYNCHRONOUS_COMMIT_OFF"<br> - 3: "SYNCHRONOUS_COMMIT_LOCAL"<br> - 4: "SYNCHRONOUS_COMMIT_REMOTE_WRITE"<br> - 5: "SYNCHRONOUS_COMMIT_REMOTE_APPLY"                                                                                                                    | supported | supported | supported | supported | supported |
        | temp_buffers : integer                                                                                                                                                                                                                                                                                                                                                                | supported | supported | supported | supported | supported |
        | temp_file_limit : integer                                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | supported | supported |
        | timezone : text                                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | track_activity_query_size : integer                                                                                                                                                                                                                                                                                                                                                   | supported | supported | supported | supported | supported |
        | transform_null_equals : boolean                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | vacuum_cleanup_index_scale_factor : float                                                                                                                                                                                                                                                                                                                                             | supported | supported | supported | -         | -         |
        | vacuum_cost_delay : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | vacuum_cost_limit : integer                                                                                                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | vacuum_cost_page_dirty : integer                                                                                                                                                                                                                                                                                                                                                      | supported | supported | supported | supported | supported |
        | vacuum_cost_page_hit : integer                                                                                                                                                                                                                                                                                                                                                        | supported | supported | supported | supported | supported |
        | vacuum_cost_page_miss : integer                                                                                                                                                                                                                                                                                                                                                       | supported | supported | supported | supported | supported |
        | wal_keep_size : integer                                                                                                                                                                                                                                                                                                                                                               | -         | -         | supported | supported | supported |
        | wal_level : one of<br> - 0: "WAL_LEVEL_UNSPECIFIED"<br> - 1: "WAL_LEVEL_REPLICA"<br> - 2: "WAL_LEVEL_LOGICAL"                                                                                                                                                                                                                                                                         | supported | supported | supported | supported | supported |
        | work_mem : integer                                                                                                                                                                                                                                                                                                                                                                    | supported | supported | supported | supported | supported |
        | xmlbinary : one of<br> - 0: "XML_BINARY_UNSPECIFIED"<br> - 1: "XML_BINARY_BASE64"<br> - 2: "XML_BINARY_HEX"                                                                                                                                                                                                                                                                           | supported | supported | supported | supported | supported |
        | xmloption : one of<br> - 0: "XML_OPTION_UNSPECIFIED"<br> - 1: "XML_OPTION_DOCUMENT"<br> - 2: "XML_OPTION_CONTENT"                                                                                                                                                                                                                                                                     | supported | supported | supported | supported | supported |

        ## Import

        A cluster can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster foo cluster_id
        ```

        :param str resource_name: The name of the resource.
        :param MdbPostgresqlClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbPostgresqlClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
                 databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 host_master_name: Optional[pulumi.Input[str]] = None,
                 hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbPostgresqlClusterArgs.__new__(MdbPostgresqlClusterArgs)

            if config is None and not opts.urn:
                raise TypeError("Missing required property 'config'")
            __props__.__dict__["config"] = config
            __props__.__dict__["databases"] = databases
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            if environment is None and not opts.urn:
                raise TypeError("Missing required property 'environment'")
            __props__.__dict__["environment"] = environment
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["host_group_ids"] = host_group_ids
            __props__.__dict__["host_master_name"] = host_master_name
            if hosts is None and not opts.urn:
                raise TypeError("Missing required property 'hosts'")
            __props__.__dict__["hosts"] = hosts
            __props__.__dict__["labels"] = labels
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["restore"] = restore
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["users"] = users
            __props__.__dict__["created_at"] = None
            __props__.__dict__["health"] = None
            __props__.__dict__["status"] = None
        super(MdbPostgresqlCluster, __self__).__init__(
            'yandex:index/mdbPostgresqlCluster:MdbPostgresqlCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            databases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterDatabaseArgs', 'MdbPostgresqlClusterDatabaseArgsDict']]]]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            environment: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            health: Optional[pulumi.Input[str]] = None,
            host_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            host_master_name: Optional[pulumi.Input[str]] = None,
            hosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            maintenance_window: Optional[pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            restore: Optional[pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            users: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterUserArgs', 'MdbPostgresqlClusterUserArgsDict']]]]] = None) -> 'MdbPostgresqlCluster':
        """
        Get an existing MdbPostgresqlCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['MdbPostgresqlClusterConfigArgs', 'MdbPostgresqlClusterConfigArgsDict']] config: Configuration of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] created_at: Timestamp of cluster creation.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the cluster. Can be either `true` or `false`.
        :param pulumi.Input[str] description: Description of the PostgreSQL cluster.
        :param pulumi.Input[str] environment: Deployment environment of the PostgreSQL cluster.
        :param pulumi.Input[str] folder_id: The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        :param pulumi.Input[str] health: Aggregated health of the cluster.
        :param pulumi.Input[str] host_master_name: It sets name of master host. It works only when `host.name` is set.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlClusterHostArgs', 'MdbPostgresqlClusterHostArgsDict']]]] hosts: A host of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the PostgreSQL cluster.
        :param pulumi.Input[Union['MdbPostgresqlClusterMaintenanceWindowArgs', 'MdbPostgresqlClusterMaintenanceWindowArgsDict']] maintenance_window: Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        :param pulumi.Input[str] name: Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        :param pulumi.Input[str] network_id: ID of the network, to which the PostgreSQL cluster belongs.
        :param pulumi.Input[Union['MdbPostgresqlClusterRestoreArgs', 'MdbPostgresqlClusterRestoreArgsDict']] restore: The cluster will be created from the specified backup. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A set of ids of security groups assigned to hosts of the cluster.
        :param pulumi.Input[str] status: Status of the cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbPostgresqlClusterState.__new__(_MdbPostgresqlClusterState)

        __props__.__dict__["config"] = config
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["databases"] = databases
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["environment"] = environment
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["health"] = health
        __props__.__dict__["host_group_ids"] = host_group_ids
        __props__.__dict__["host_master_name"] = host_master_name
        __props__.__dict__["hosts"] = hosts
        __props__.__dict__["labels"] = labels
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["restore"] = restore
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["status"] = status
        __props__.__dict__["users"] = users
        return MdbPostgresqlCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output['outputs.MdbPostgresqlClusterConfig']:
        """
        Configuration of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Timestamp of cluster creation.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage databases, please switch to using a separate resource type yandex_mdb_postgresql_database""")
    def databases(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlClusterDatabase']]]:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[bool]:
        """
        Inhibits deletion of the cluster. Can be either `true` or `false`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of the PostgreSQL cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> pulumi.Output[str]:
        """
        Deployment environment of the PostgreSQL cluster.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        The ID of the folder that the resource belongs to. If it is unset, the default provider `folder_id` is used for create.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def health(self) -> pulumi.Output[str]:
        """
        Aggregated health of the cluster.
        """
        return pulumi.get(self, "health")

    @property
    @pulumi.getter(name="hostGroupIds")
    def host_group_ids(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "host_group_ids")

    @property
    @pulumi.getter(name="hostMasterName")
    @_utilities.deprecated("""This field does not guarantee that a specific host will always be the master. We do not recommend using it. This functionality will be removed in future versions. If you are absolutely certain that you need this functionality, please contact technical support.""")
    def host_master_name(self) -> pulumi.Output[str]:
        """
        It sets name of master host. It works only when `host.name` is set.
        """
        return pulumi.get(self, "host_master_name")

    @property
    @pulumi.getter
    def hosts(self) -> pulumi.Output[Sequence['outputs.MdbPostgresqlClusterHost']]:
        """
        A host of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "hosts")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A set of key/value label pairs to assign to the PostgreSQL cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output['outputs.MdbPostgresqlClusterMaintenanceWindow']:
        """
        Maintenance policy of the PostgreSQL cluster. The structure is documented below.
        """
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the PostgreSQL cluster. Provided by the client when the cluster is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        ID of the network, to which the PostgreSQL cluster belongs.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def restore(self) -> pulumi.Output[Optional['outputs.MdbPostgresqlClusterRestore']]:
        """
        The cluster will be created from the specified backup. The structure is documented below.
        """
        return pulumi.get(self, "restore")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of ids of security groups assigned to hosts of the cluster.
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    @_utilities.deprecated("""to manage users, please switch to using a separate resource type yandex_mdb_postgresql_user""")
    def users(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlClusterUser']]]:
        return pulumi.get(self, "users")

