# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MdbPostgresqlUserArgs', 'MdbPostgresqlUser']

@pulumi.input_type
class MdbPostgresqlUserArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 password: pulumi.Input[str],
                 conn_limit: Optional[pulumi.Input[int]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a MdbPostgresqlUser resource.
        :param pulumi.Input[str] password: The password of the user.
        :param pulumi.Input[int] conn_limit: The maximum number of connections per user. (Default 50)
        :param pulumi.Input[str] deletion_protection: Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grants: List of the user's grants.
        :param pulumi.Input[bool] login: User's ability to login.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]] permissions: Set of permissions granted to the user. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of user settings. List of settings is documented below.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "password", password)
        if conn_limit is not None:
            pulumi.set(__self__, "conn_limit", conn_limit)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections per user. (Default 50)
        """
        return pulumi.get(self, "conn_limit")

    @conn_limit.setter
    def conn_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "conn_limit", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user. The structure is documented below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of user settings. List of settings is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)


@pulumi.input_type
class _MdbPostgresqlUserState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 conn_limit: Optional[pulumi.Input[int]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering MdbPostgresqlUser resources.
        :param pulumi.Input[int] conn_limit: The maximum number of connections per user. (Default 50)
        :param pulumi.Input[str] deletion_protection: Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grants: List of the user's grants.
        :param pulumi.Input[bool] login: User's ability to login.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]] permissions: Set of permissions granted to the user. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of user settings. List of settings is documented below.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if conn_limit is not None:
            pulumi.set(__self__, "conn_limit", conn_limit)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of connections per user. (Default 50)
        """
        return pulumi.get(self, "conn_limit")

    @conn_limit.setter
    def conn_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "conn_limit", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter
    def login(self) -> Optional[pulumi.Input[bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @login.setter
    def login(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "login", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]:
        """
        Set of permissions granted to the user. The structure is documented below.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MdbPostgresqlUserPermissionArgs']]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of user settings. List of settings is documented below.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)


class MdbPostgresqlUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 conn_limit: Optional[pulumi.Input[int]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a PostgreSQL user within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-postgresql/).

        ## Example Usage

        {{ tffile "examples/mdb_postgresql_user/r_mdb_postgresql_user_1.tf" }}

        ## Import

        A PostgreSQL user can be imported using the following format:

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser foo {cluster_id}:{username}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] conn_limit: The maximum number of connections per user. (Default 50)
        :param pulumi.Input[str] deletion_protection: Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grants: List of the user's grants.
        :param pulumi.Input[bool] login: User's ability to login.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of user settings. List of settings is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MdbPostgresqlUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a PostgreSQL user within the Yandex Cloud. For more information, see [the official documentation](https://cloud.yandex.com/docs/managed-postgresql/).

        ## Example Usage

        {{ tffile "examples/mdb_postgresql_user/r_mdb_postgresql_user_1.tf" }}

        ## Import

        A PostgreSQL user can be imported using the following format:

        ```sh
        $ pulumi import yandex:index/mdbPostgresqlUser:MdbPostgresqlUser foo {cluster_id}:{username}
        ```

        :param str resource_name: The name of the resource.
        :param MdbPostgresqlUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MdbPostgresqlUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 conn_limit: Optional[pulumi.Input[int]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 login: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MdbPostgresqlUserArgs.__new__(MdbPostgresqlUserArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["conn_limit"] = conn_limit
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["grants"] = grants
            __props__.__dict__["login"] = login
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["permissions"] = permissions
            __props__.__dict__["settings"] = settings
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(MdbPostgresqlUser, __self__).__init__(
            'yandex:index/mdbPostgresqlUser:MdbPostgresqlUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            conn_limit: Optional[pulumi.Input[int]] = None,
            deletion_protection: Optional[pulumi.Input[str]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            login: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            permissions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'MdbPostgresqlUser':
        """
        Get an existing MdbPostgresqlUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] conn_limit: The maximum number of connections per user. (Default 50)
        :param pulumi.Input[str] deletion_protection: Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] grants: List of the user's grants.
        :param pulumi.Input[bool] login: User's ability to login.
        :param pulumi.Input[str] name: The name of the user.
        :param pulumi.Input[str] password: The password of the user.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MdbPostgresqlUserPermissionArgs', 'MdbPostgresqlUserPermissionArgsDict']]]] permissions: Set of permissions granted to the user. The structure is documented below.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of user settings. List of settings is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MdbPostgresqlUserState.__new__(_MdbPostgresqlUserState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["conn_limit"] = conn_limit
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["grants"] = grants
        __props__.__dict__["login"] = login
        __props__.__dict__["name"] = name
        __props__.__dict__["password"] = password
        __props__.__dict__["permissions"] = permissions
        __props__.__dict__["settings"] = settings
        return MdbPostgresqlUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="connLimit")
    def conn_limit(self) -> pulumi.Output[int]:
        """
        The maximum number of connections per user. (Default 50)
        """
        return pulumi.get(self, "conn_limit")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[str]]:
        """
        Inhibits deletion of the user. Can either be `true`, `false` or `unspecified`.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of the user's grants.
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter
    def login(self) -> pulumi.Output[Optional[bool]]:
        """
        User's ability to login.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the user.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The password of the user.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def permissions(self) -> pulumi.Output[Optional[Sequence['outputs.MdbPostgresqlUserPermission']]]:
        """
        Set of permissions granted to the user. The structure is documented below.
        """
        return pulumi.get(self, "permissions")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of user settings. List of settings is documented below.
        """
        return pulumi.get(self, "settings")

