# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SmartcaptchaCaptchaArgs', 'SmartcaptchaCaptcha']

@pulumi.input_type
class SmartcaptchaCaptchaArgs:
    def __init__(__self__, *,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 challenge_type: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 complexity: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]] = None,
                 pre_check_type: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]] = None,
                 style_json: Optional[pulumi.Input[str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a SmartcaptchaCaptcha resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[str] challenge_type: Additional task type of the captcha. Possible values are documented below.
        :param pulumi.Input[str] complexity: Complexity of the captcha. Possible values are documented below.
        :param pulumi.Input[bool] deletion_protection: Determines whether captcha is protected from being deleted.
        :param pulumi.Input[str] folder_id: ID of the folder to create a captcha in. If omitted, the provider folder is used.
        :param pulumi.Input[str] name: Name of the captcha. The name must be unique within the folder.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]] override_variants: List of variants to use in security_rules. The structure is documented below.
        :param pulumi.Input[str] pre_check_type: Basic check type of the captcha. Possible values are documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]] security_rules: List of security rules. The structure is documented below.
        :param pulumi.Input[str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        if allowed_sites is not None:
            pulumi.set(__self__, "allowed_sites", allowed_sites)
        if challenge_type is not None:
            pulumi.set(__self__, "challenge_type", challenge_type)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_variants is not None:
            pulumi.set(__self__, "override_variants", override_variants)
        if pre_check_type is not None:
            pulumi.set(__self__, "pre_check_type", pre_check_type)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if style_json is not None:
            pulumi.set(__self__, "style_json", style_json)
        if turn_off_hostname_check is not None:
            pulumi.set(__self__, "turn_off_hostname_check", turn_off_hostname_check)

    @property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @allowed_sites.setter
    def allowed_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_sites", value)

    @property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Additional task type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "challenge_type")

    @challenge_type.setter
    def challenge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "challenge_type", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[str]]:
        """
        Complexity of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether captcha is protected from being deleted.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a captcha in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the captcha. The name must be unique within the folder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]:
        """
        List of variants to use in security_rules. The structure is documented below.
        """
        return pulumi.get(self, "override_variants")

    @override_variants.setter
    def override_variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]):
        pulumi.set(self, "override_variants", value)

    @property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Basic check type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "pre_check_type")

    @pre_check_type.setter
    def pre_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_check_type", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> Optional[pulumi.Input[str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @style_json.setter
    def style_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "style_json", value)

    @property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

    @turn_off_hostname_check.setter
    def turn_off_hostname_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "turn_off_hostname_check", value)


@pulumi.input_type
class _SmartcaptchaCaptchaState:
    def __init__(__self__, *,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 challenge_type: Optional[pulumi.Input[str]] = None,
                 client_key: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 complexity: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]] = None,
                 pre_check_type: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]] = None,
                 style_json: Optional[pulumi.Input[str]] = None,
                 suspend: Optional[pulumi.Input[bool]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering SmartcaptchaCaptcha resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[str] challenge_type: Additional task type of the captcha. Possible values are documented below.
        :param pulumi.Input[str] client_key: Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        :param pulumi.Input[str] complexity: Complexity of the captcha. Possible values are documented below.
        :param pulumi.Input[str] created_at: The Captcha creation timestamp.
        :param pulumi.Input[bool] deletion_protection: Determines whether captcha is protected from being deleted.
        :param pulumi.Input[str] folder_id: ID of the folder to create a captcha in. If omitted, the provider folder is used.
        :param pulumi.Input[str] name: Name of the captcha. The name must be unique within the folder.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]] override_variants: List of variants to use in security_rules. The structure is documented below.
        :param pulumi.Input[str] pre_check_type: Basic check type of the captcha. Possible values are documented below.
        :param pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]] security_rules: List of security rules. The structure is documented below.
        :param pulumi.Input[str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        if allowed_sites is not None:
            pulumi.set(__self__, "allowed_sites", allowed_sites)
        if challenge_type is not None:
            pulumi.set(__self__, "challenge_type", challenge_type)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if complexity is not None:
            pulumi.set(__self__, "complexity", complexity)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if override_variants is not None:
            pulumi.set(__self__, "override_variants", override_variants)
        if pre_check_type is not None:
            pulumi.set(__self__, "pre_check_type", pre_check_type)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)
        if style_json is not None:
            pulumi.set(__self__, "style_json", style_json)
        if suspend is not None:
            pulumi.set(__self__, "suspend", suspend)
        if turn_off_hostname_check is not None:
            pulumi.set(__self__, "turn_off_hostname_check", turn_off_hostname_check)

    @property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @allowed_sites.setter
    def allowed_sites(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_sites", value)

    @property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> Optional[pulumi.Input[str]]:
        """
        Additional task type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "challenge_type")

    @challenge_type.setter
    def challenge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "challenge_type", value)

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[pulumi.Input[str]]:
        """
        Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        """
        return pulumi.get(self, "client_key")

    @client_key.setter
    def client_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_key", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter
    def complexity(self) -> Optional[pulumi.Input[str]]:
        """
        Complexity of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "complexity")

    @complexity.setter
    def complexity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "complexity", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The Captcha creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines whether captcha is protected from being deleted.
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a captcha in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the captcha. The name must be unique within the folder.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]:
        """
        List of variants to use in security_rules. The structure is documented below.
        """
        return pulumi.get(self, "override_variants")

    @override_variants.setter
    def override_variants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaOverrideVariantArgs']]]]):
        pulumi.set(self, "override_variants", value)

    @property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> Optional[pulumi.Input[str]]:
        """
        Basic check type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "pre_check_type")

    @pre_check_type.setter
    def pre_check_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pre_check_type", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SmartcaptchaCaptchaSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)

    @property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> Optional[pulumi.Input[str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @style_json.setter
    def style_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "style_json", value)

    @property
    @pulumi.getter
    def suspend(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "suspend")

    @suspend.setter
    def suspend(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "suspend", value)

    @property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> Optional[pulumi.Input[bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

    @turn_off_hostname_check.setter
    def turn_off_hostname_check(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "turn_off_hostname_check", value)


class SmartcaptchaCaptcha(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 challenge_type: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 complexity: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
                 pre_check_type: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
                 style_json: Optional[pulumi.Input[str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates a Captcha in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

        ## Example Usage

        {{ tffile "examples/smartcaptcha_captcha/r_smartcaptcha_captcha_1.tf" }}

        {{ tffile "examples/smartcaptcha_captcha/r_smartcaptcha_captcha_2.tf" }}

        ## Import

        Resource can be imported using the following syntax:

        {{ codefile "shell" "examples/smartcaptcha_captcha/import.sh" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[str] challenge_type: Additional task type of the captcha. Possible values are documented below.
        :param pulumi.Input[str] complexity: Complexity of the captcha. Possible values are documented below.
        :param pulumi.Input[bool] deletion_protection: Determines whether captcha is protected from being deleted.
        :param pulumi.Input[str] folder_id: ID of the folder to create a captcha in. If omitted, the provider folder is used.
        :param pulumi.Input[str] name: Name of the captcha. The name must be unique within the folder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]] override_variants: List of variants to use in security_rules. The structure is documented below.
        :param pulumi.Input[str] pre_check_type: Basic check type of the captcha. Possible values are documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]] security_rules: List of security rules. The structure is documented below.
        :param pulumi.Input[str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SmartcaptchaCaptchaArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a Captcha in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartcaptcha/).

        ## Example Usage

        {{ tffile "examples/smartcaptcha_captcha/r_smartcaptcha_captcha_1.tf" }}

        {{ tffile "examples/smartcaptcha_captcha/r_smartcaptcha_captcha_2.tf" }}

        ## Import

        Resource can be imported using the following syntax:

        {{ codefile "shell" "examples/smartcaptcha_captcha/import.sh" }}

        :param str resource_name: The name of the resource.
        :param SmartcaptchaCaptchaArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SmartcaptchaCaptchaArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 challenge_type: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 complexity: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
                 pre_check_type: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
                 style_json: Optional[pulumi.Input[str]] = None,
                 turn_off_hostname_check: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SmartcaptchaCaptchaArgs.__new__(SmartcaptchaCaptchaArgs)

            __props__.__dict__["allowed_sites"] = allowed_sites
            __props__.__dict__["challenge_type"] = challenge_type
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["complexity"] = complexity
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["name"] = name
            __props__.__dict__["override_variants"] = override_variants
            __props__.__dict__["pre_check_type"] = pre_check_type
            __props__.__dict__["security_rules"] = security_rules
            __props__.__dict__["style_json"] = style_json
            __props__.__dict__["turn_off_hostname_check"] = turn_off_hostname_check
            __props__.__dict__["client_key"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["suspend"] = None
        super(SmartcaptchaCaptcha, __self__).__init__(
            'yandex:index/smartcaptchaCaptcha:SmartcaptchaCaptcha',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_sites: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            challenge_type: Optional[pulumi.Input[str]] = None,
            client_key: Optional[pulumi.Input[str]] = None,
            cloud_id: Optional[pulumi.Input[str]] = None,
            complexity: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            override_variants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]]] = None,
            pre_check_type: Optional[pulumi.Input[str]] = None,
            security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]]] = None,
            style_json: Optional[pulumi.Input[str]] = None,
            suspend: Optional[pulumi.Input[bool]] = None,
            turn_off_hostname_check: Optional[pulumi.Input[bool]] = None) -> 'SmartcaptchaCaptcha':
        """
        Get an existing SmartcaptchaCaptcha resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_sites: List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        :param pulumi.Input[str] challenge_type: Additional task type of the captcha. Possible values are documented below.
        :param pulumi.Input[str] client_key: Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        :param pulumi.Input[str] complexity: Complexity of the captcha. Possible values are documented below.
        :param pulumi.Input[str] created_at: The Captcha creation timestamp.
        :param pulumi.Input[bool] deletion_protection: Determines whether captcha is protected from being deleted.
        :param pulumi.Input[str] folder_id: ID of the folder to create a captcha in. If omitted, the provider folder is used.
        :param pulumi.Input[str] name: Name of the captcha. The name must be unique within the folder.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaOverrideVariantArgs', 'SmartcaptchaCaptchaOverrideVariantArgsDict']]]] override_variants: List of variants to use in security_rules. The structure is documented below.
        :param pulumi.Input[str] pre_check_type: Basic check type of the captcha. Possible values are documented below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SmartcaptchaCaptchaSecurityRuleArgs', 'SmartcaptchaCaptchaSecurityRuleArgsDict']]]] security_rules: List of security rules. The structure is documented below.
        :param pulumi.Input[str] style_json: JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        :param pulumi.Input[bool] turn_off_hostname_check: Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SmartcaptchaCaptchaState.__new__(_SmartcaptchaCaptchaState)

        __props__.__dict__["allowed_sites"] = allowed_sites
        __props__.__dict__["challenge_type"] = challenge_type
        __props__.__dict__["client_key"] = client_key
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["complexity"] = complexity
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["name"] = name
        __props__.__dict__["override_variants"] = override_variants
        __props__.__dict__["pre_check_type"] = pre_check_type
        __props__.__dict__["security_rules"] = security_rules
        __props__.__dict__["style_json"] = style_json
        __props__.__dict__["suspend"] = suspend
        __props__.__dict__["turn_off_hostname_check"] = turn_off_hostname_check
        return SmartcaptchaCaptcha(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedSites")
    def allowed_sites(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of allowed host names, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "allowed_sites")

    @property
    @pulumi.getter(name="challengeType")
    def challenge_type(self) -> pulumi.Output[Optional[str]]:
        """
        Additional task type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "challenge_type")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> pulumi.Output[str]:
        """
        Client key of the captcha, see [CAPTCHA keys](https://yandex.cloud/docs/smartcaptcha/concepts/keys).
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def complexity(self) -> pulumi.Output[Optional[str]]:
        """
        Complexity of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "complexity")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The Captcha creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines whether captcha is protected from being deleted.
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder to create a captcha in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the captcha. The name must be unique within the folder.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="overrideVariants")
    def override_variants(self) -> pulumi.Output[Optional[Sequence['outputs.SmartcaptchaCaptchaOverrideVariant']]]:
        """
        List of variants to use in security_rules. The structure is documented below.
        """
        return pulumi.get(self, "override_variants")

    @property
    @pulumi.getter(name="preCheckType")
    def pre_check_type(self) -> pulumi.Output[Optional[str]]:
        """
        Basic check type of the captcha. Possible values are documented below.
        """
        return pulumi.get(self, "pre_check_type")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SmartcaptchaCaptchaSecurityRule']]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @property
    @pulumi.getter(name="styleJson")
    def style_json(self) -> pulumi.Output[Optional[str]]:
        """
        JSON with variables to define the captcha appearance. For more details see generated JSON in cloud console.
        """
        return pulumi.get(self, "style_json")

    @property
    @pulumi.getter
    def suspend(self) -> pulumi.Output[bool]:
        return pulumi.get(self, "suspend")

    @property
    @pulumi.getter(name="turnOffHostnameCheck")
    def turn_off_hostname_check(self) -> pulumi.Output[Optional[bool]]:
        """
        Turn off host name check, see [Domain validation](https://yandex.cloud/docs/smartcaptcha/concepts/domain-validation).
        """
        return pulumi.get(self, "turn_off_hostname_check")

