# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StorageBucketArgs', 'StorageBucket']

@pulumi.input_type
class StorageBucketArgs:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_prefix: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]] = None,
                 https: Optional[pulumi.Input['StorageBucketHttpsArgs']] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 object_lock_configuration: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input['StorageBucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['StorageBucketWebsiteArgs']] = None,
                 website_domain: Optional[pulumi.Input[str]] = None,
                 website_endpoint: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a StorageBucket resource.
        :param pulumi.Input[str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[str] acl: The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
               
               > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        :param pulumi.Input[str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]] grants: An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]] loggings: A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        :param pulumi.Input['StorageBucketObjectLockConfigurationArgs'] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        :param pulumi.Input[str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input['StorageBucketVersioningArgs'] versioning: A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketWebsiteArgs'] website: A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        :param pulumi.Input[str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if anonymous_access_flags is not None:
            pulumi.set(__self__, "anonymous_access_flags", anonymous_access_flags)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.

        > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]:
        return pulumi.get(self, "anonymous_access_flags")

    @anonymous_access_flags.setter
    def anonymous_access_flags(self, value: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]):
        pulumi.set(self, "anonymous_access_flags", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_prefix", value)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input['StorageBucketHttpsArgs']]:
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input['StorageBucketHttpsArgs']]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]:
        """
        A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]:
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['StorageBucketVersioningArgs']]:
        """
        A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['StorageBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['StorageBucketWebsiteArgs']]:
        """
        A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['StorageBucketWebsiteArgs']]):
        pulumi.set(self, "website", value)

    @property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_domain", value)

    @property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_endpoint", value)


@pulumi.input_type
class _StorageBucketState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[str]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_domain_name: Optional[pulumi.Input[str]] = None,
                 bucket_prefix: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]] = None,
                 https: Optional[pulumi.Input['StorageBucketHttpsArgs']] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 object_lock_configuration: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input['StorageBucketVersioningArgs']] = None,
                 website: Optional[pulumi.Input['StorageBucketWebsiteArgs']] = None,
                 website_domain: Optional[pulumi.Input[str]] = None,
                 website_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StorageBucket resources.
        :param pulumi.Input[str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[str] acl: The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
               
               > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        :param pulumi.Input[str] bucket_domain_name: The bucket domain name.
        :param pulumi.Input[str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]] grants: An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]] lifecycle_rules: A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        :param pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]] loggings: A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        :param pulumi.Input['StorageBucketObjectLockConfigurationArgs'] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        :param pulumi.Input[str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input['StorageBucketVersioningArgs'] versioning: A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input['StorageBucketWebsiteArgs'] website: A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        :param pulumi.Input[str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if acl is not None:
            pulumi.set(__self__, "acl", acl)
        if anonymous_access_flags is not None:
            pulumi.set(__self__, "anonymous_access_flags", anonymous_access_flags)
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if bucket_domain_name is not None:
            pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        if bucket_prefix is not None:
            pulumi.set(__self__, "bucket_prefix", bucket_prefix)
        if cors_rules is not None:
            pulumi.set(__self__, "cors_rules", cors_rules)
        if default_storage_class is not None:
            pulumi.set(__self__, "default_storage_class", default_storage_class)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if grants is not None:
            pulumi.set(__self__, "grants", grants)
        if https is not None:
            pulumi.set(__self__, "https", https)
        if lifecycle_rules is not None:
            pulumi.set(__self__, "lifecycle_rules", lifecycle_rules)
        if loggings is not None:
            pulumi.set(__self__, "loggings", loggings)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if object_lock_configuration is not None:
            pulumi.set(__self__, "object_lock_configuration", object_lock_configuration)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption_configuration is not None:
            pulumi.set(__self__, "server_side_encryption_configuration", server_side_encryption_configuration)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if versioning is not None:
            pulumi.set(__self__, "versioning", versioning)
        if website is not None:
            pulumi.set(__self__, "website", website)
        if website_domain is not None:
            pulumi.set(__self__, "website_domain", website_domain)
        if website_endpoint is not None:
            pulumi.set(__self__, "website_endpoint", website_endpoint)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_key", value)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.

        > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)

    @property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]:
        return pulumi.get(self, "anonymous_access_flags")

    @anonymous_access_flags.setter
    def anonymous_access_flags(self, value: Optional[pulumi.Input['StorageBucketAnonymousAccessFlagsArgs']]):
        pulumi.set(self, "anonymous_access_flags", value)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket domain name.
        """
        return pulumi.get(self, "bucket_domain_name")

    @bucket_domain_name.setter
    def bucket_domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_domain_name", value)

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @bucket_prefix.setter
    def bucket_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_prefix", value)

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @cors_rules.setter
    def cors_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketCorsRuleArgs']]]]):
        pulumi.set(self, "cors_rules", value)

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "default_storage_class")

    @default_storage_class.setter
    def default_storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_storage_class", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_destroy", value)

    @property
    @pulumi.getter
    def grants(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]:
        """
        An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @grants.setter
    def grants(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketGrantArgs']]]]):
        pulumi.set(self, "grants", value)

    @property
    @pulumi.getter
    def https(self) -> Optional[pulumi.Input['StorageBucketHttpsArgs']]:
        return pulumi.get(self, "https")

    @https.setter
    def https(self, value: Optional[pulumi.Input['StorageBucketHttpsArgs']]):
        pulumi.set(self, "https", value)

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]:
        """
        A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @lifecycle_rules.setter
    def lifecycle_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLifecycleRuleArgs']]]]):
        pulumi.set(self, "lifecycle_rules", value)

    @property
    @pulumi.getter
    def loggings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]:
        """
        A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        """
        return pulumi.get(self, "loggings")

    @loggings.setter
    def loggings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StorageBucketLoggingArgs']]]]):
        pulumi.set(self, "loggings", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        """
        return pulumi.get(self, "object_lock_configuration")

    @object_lock_configuration.setter
    def object_lock_configuration(self, value: Optional[pulumi.Input['StorageBucketObjectLockConfigurationArgs']]):
        pulumi.set(self, "object_lock_configuration", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_key", value)

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]:
        return pulumi.get(self, "server_side_encryption_configuration")

    @server_side_encryption_configuration.setter
    def server_side_encryption_configuration(self, value: Optional[pulumi.Input['StorageBucketServerSideEncryptionConfigurationArgs']]):
        pulumi.set(self, "server_side_encryption_configuration", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def versioning(self) -> Optional[pulumi.Input['StorageBucketVersioningArgs']]:
        """
        A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @versioning.setter
    def versioning(self, value: Optional[pulumi.Input['StorageBucketVersioningArgs']]):
        pulumi.set(self, "versioning", value)

    @property
    @pulumi.getter
    def website(self) -> Optional[pulumi.Input['StorageBucketWebsiteArgs']]:
        """
        A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        """
        return pulumi.get(self, "website")

    @website.setter
    def website(self, value: Optional[pulumi.Input['StorageBucketWebsiteArgs']]):
        pulumi.set(self, "website", value)

    @property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @website_domain.setter
    def website_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_domain", value)

    @property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

    @website_endpoint.setter
    def website_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "website_endpoint", value)


class StorageBucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_prefix: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
                 https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
                 website_domain: Optional[pulumi.Input[str]] = None,
                 website_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Allows management of [Yandex Cloud Storage Bucket](https://yandex.cloud/docs/storage/concepts/bucket).

        > By default, for authentication, you need to use [IAM token](https://yandex.cloud/docs/iam/concepts/authorization/iam-token) with the necessary permissions.

        > Alternatively, you can provide [static access keys](https://yandex.cloud/docs/iam/concepts/authorization/access-key) (Access and Secret). To generate these keys, you will need a Service Account with the appropriate permissions.

        > For extended API usage, such as setting the `max_size`, `folder_id`, `anonymous_access_flags`, `default_storage_class`, and `https` parameters for a bucket,
        only the default authorization method will be used. This means the `IAM` token from the `provider` block will be applied.
        This can be confusing in cases where a separate service account is used for managing buckets because, in such scenarios,
        buckets may be accessed by two different accounts, each with potentially different permissions for the buckets.

        > In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource,
        as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys,
        folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.

        ## Example Usage

        {{ tffile "examples/storage_bucket/r_storage_bucket_1.tf" }}

        ### Simple Private Bucket With Static Access Keys

        {{ tffile "examples/storage_bucket/r_storage_bucket_2.tf" }}

        ### Static Website Hosting

        {{ tffile "examples/storage_bucket/r_storage_bucket_3.tf" }}

        ### Using ACL policy grants

        {{ tffile "examples/storage_bucket/r_storage_bucket_4.tf" }}

        ### Using CORS

        {{ tffile "examples/storage_bucket/r_storage_bucket_5.tf" }}

        ### Using versioning

        {{ tffile "examples/storage_bucket/r_storage_bucket_6.tf" }}

        ### Using Object Lock Configuration

        {{ tffile "examples/storage_bucket/r_storage_bucket_11.tf" }}

        ### Bucket Tagging

        {{ tffile "examples/storage_bucket/r_storage_bucket_12.tf" }}

        ### Bucket Max Size

        {{ tffile "examples/storage_bucket/r_storage_bucket_13.tf" }}

        ### Bucket Folder Id

        {{ tffile "examples/storage_bucket/r_storage_bucket_14.tf" }}

        ### Bucket Anonymous Access Flags

        {{ tffile "examples/storage_bucket/r_storage_bucket_15.tf" }}

        ### Bucket HTTPS Certificate

        {{ tffile "examples/storage_bucket/r_storage_bucket_16.tf" }}

        ### Bucket Default Storage Class

        {{ tffile "examples/storage_bucket/r_storage_bucket_17.tf" }}

        ### All settings example

        {{ tffile "examples/storage_bucket/r_storage_bucket_18.tf" }}

        ## Import

        Storage bucket can be imported using the `bucket`, e.g.

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket bucket bucket-name
        ```
        ~> Terraform will import this resource with `force_destroy` set to `false` in state. If you've set it to `true` in config, run `pulumi up` to update the value set in state. If you delete this resource before updating the value, objects in the bucket will not be destroyed.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[str] acl: The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
               
               > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        :param pulumi.Input[str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]] grants: An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]] loggings: A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        :param pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        :param pulumi.Input[str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']] versioning: A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']] website: A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        :param pulumi.Input[str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[StorageBucketArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows management of [Yandex Cloud Storage Bucket](https://yandex.cloud/docs/storage/concepts/bucket).

        > By default, for authentication, you need to use [IAM token](https://yandex.cloud/docs/iam/concepts/authorization/iam-token) with the necessary permissions.

        > Alternatively, you can provide [static access keys](https://yandex.cloud/docs/iam/concepts/authorization/access-key) (Access and Secret). To generate these keys, you will need a Service Account with the appropriate permissions.

        > For extended API usage, such as setting the `max_size`, `folder_id`, `anonymous_access_flags`, `default_storage_class`, and `https` parameters for a bucket,
        only the default authorization method will be used. This means the `IAM` token from the `provider` block will be applied.
        This can be confusing in cases where a separate service account is used for managing buckets because, in such scenarios,
        buckets may be accessed by two different accounts, each with potentially different permissions for the buckets.

        > In case you are using IAM token from UserAccount, you are needed to explicitly specify folder_id in the resource,
        as it cannot be identified from such type of account. In case you are using IAM token from ServiceAccount or static access keys,
        folder_id does not need to be specified unless you want to create the resource in a different folder than the account folder.

        ## Example Usage

        {{ tffile "examples/storage_bucket/r_storage_bucket_1.tf" }}

        ### Simple Private Bucket With Static Access Keys

        {{ tffile "examples/storage_bucket/r_storage_bucket_2.tf" }}

        ### Static Website Hosting

        {{ tffile "examples/storage_bucket/r_storage_bucket_3.tf" }}

        ### Using ACL policy grants

        {{ tffile "examples/storage_bucket/r_storage_bucket_4.tf" }}

        ### Using CORS

        {{ tffile "examples/storage_bucket/r_storage_bucket_5.tf" }}

        ### Using versioning

        {{ tffile "examples/storage_bucket/r_storage_bucket_6.tf" }}

        ### Using Object Lock Configuration

        {{ tffile "examples/storage_bucket/r_storage_bucket_11.tf" }}

        ### Bucket Tagging

        {{ tffile "examples/storage_bucket/r_storage_bucket_12.tf" }}

        ### Bucket Max Size

        {{ tffile "examples/storage_bucket/r_storage_bucket_13.tf" }}

        ### Bucket Folder Id

        {{ tffile "examples/storage_bucket/r_storage_bucket_14.tf" }}

        ### Bucket Anonymous Access Flags

        {{ tffile "examples/storage_bucket/r_storage_bucket_15.tf" }}

        ### Bucket HTTPS Certificate

        {{ tffile "examples/storage_bucket/r_storage_bucket_16.tf" }}

        ### Bucket Default Storage Class

        {{ tffile "examples/storage_bucket/r_storage_bucket_17.tf" }}

        ### All settings example

        {{ tffile "examples/storage_bucket/r_storage_bucket_18.tf" }}

        ## Import

        Storage bucket can be imported using the `bucket`, e.g.

        ```sh
        $ pulumi import yandex:index/storageBucket:StorageBucket bucket bucket-name
        ```
        ~> Terraform will import this resource with `force_destroy` set to `false` in state. If you've set it to `true` in config, run `pulumi up` to update the value set in state. If you delete this resource before updating the value, objects in the bucket will not be destroyed.

        :param str resource_name: The name of the resource.
        :param StorageBucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StorageBucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[str]] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 bucket_prefix: Optional[pulumi.Input[str]] = None,
                 cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
                 default_storage_class: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 force_destroy: Optional[pulumi.Input[bool]] = None,
                 grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
                 https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
                 lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
                 loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 secret_key: Optional[pulumi.Input[str]] = None,
                 server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
                 website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
                 website_domain: Optional[pulumi.Input[str]] = None,
                 website_endpoint: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StorageBucketArgs.__new__(StorageBucketArgs)

            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["acl"] = acl
            __props__.__dict__["anonymous_access_flags"] = anonymous_access_flags
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["bucket_prefix"] = bucket_prefix
            __props__.__dict__["cors_rules"] = cors_rules
            __props__.__dict__["default_storage_class"] = default_storage_class
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["grants"] = grants
            __props__.__dict__["https"] = https
            __props__.__dict__["lifecycle_rules"] = lifecycle_rules
            __props__.__dict__["loggings"] = loggings
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["object_lock_configuration"] = object_lock_configuration
            __props__.__dict__["policy"] = policy
            __props__.__dict__["secret_key"] = None if secret_key is None else pulumi.Output.secret(secret_key)
            __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
            __props__.__dict__["tags"] = tags
            __props__.__dict__["versioning"] = versioning
            __props__.__dict__["website"] = website
            __props__.__dict__["website_domain"] = website_domain
            __props__.__dict__["website_endpoint"] = website_endpoint
            __props__.__dict__["bucket_domain_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["secretKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(StorageBucket, __self__).__init__(
            'yandex:index/storageBucket:StorageBucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[str]] = None,
            acl: Optional[pulumi.Input[str]] = None,
            anonymous_access_flags: Optional[pulumi.Input[Union['StorageBucketAnonymousAccessFlagsArgs', 'StorageBucketAnonymousAccessFlagsArgsDict']]] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            bucket_domain_name: Optional[pulumi.Input[str]] = None,
            bucket_prefix: Optional[pulumi.Input[str]] = None,
            cors_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]]] = None,
            default_storage_class: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            force_destroy: Optional[pulumi.Input[bool]] = None,
            grants: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]]] = None,
            https: Optional[pulumi.Input[Union['StorageBucketHttpsArgs', 'StorageBucketHttpsArgsDict']]] = None,
            lifecycle_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]]] = None,
            loggings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            object_lock_configuration: Optional[pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            secret_key: Optional[pulumi.Input[str]] = None,
            server_side_encryption_configuration: Optional[pulumi.Input[Union['StorageBucketServerSideEncryptionConfigurationArgs', 'StorageBucketServerSideEncryptionConfigurationArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            versioning: Optional[pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']]] = None,
            website: Optional[pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']]] = None,
            website_domain: Optional[pulumi.Input[str]] = None,
            website_endpoint: Optional[pulumi.Input[str]] = None) -> 'StorageBucket':
        """
        Get an existing StorageBucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] access_key: The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[str] acl: The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.
               
               > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        :param pulumi.Input[str] bucket_domain_name: The bucket domain name.
        :param pulumi.Input[str] bucket_prefix: Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketCorsRuleArgs', 'StorageBucketCorsRuleArgsDict']]]] cors_rules: A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        :param pulumi.Input[bool] force_destroy: A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketGrantArgs', 'StorageBucketGrantArgsDict']]]] grants: An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLifecycleRuleArgs', 'StorageBucketLifecycleRuleArgsDict']]]] lifecycle_rules: A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        :param pulumi.Input[Sequence[pulumi.Input[Union['StorageBucketLoggingArgs', 'StorageBucketLoggingArgsDict']]]] loggings: A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        :param pulumi.Input[Union['StorageBucketObjectLockConfigurationArgs', 'StorageBucketObjectLockConfigurationArgsDict']] object_lock_configuration: A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        :param pulumi.Input[str] secret_key: The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        :param pulumi.Input[Union['StorageBucketVersioningArgs', 'StorageBucketVersioningArgsDict']] versioning: A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)
               
               > To manage `versioning` argument, service account with `storage.admin` role should be used.
        :param pulumi.Input[Union['StorageBucketWebsiteArgs', 'StorageBucketWebsiteArgsDict']] website: A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        :param pulumi.Input[str] website_domain: The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        :param pulumi.Input[str] website_endpoint: The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StorageBucketState.__new__(_StorageBucketState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["acl"] = acl
        __props__.__dict__["anonymous_access_flags"] = anonymous_access_flags
        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["bucket_domain_name"] = bucket_domain_name
        __props__.__dict__["bucket_prefix"] = bucket_prefix
        __props__.__dict__["cors_rules"] = cors_rules
        __props__.__dict__["default_storage_class"] = default_storage_class
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["grants"] = grants
        __props__.__dict__["https"] = https
        __props__.__dict__["lifecycle_rules"] = lifecycle_rules
        __props__.__dict__["loggings"] = loggings
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["object_lock_configuration"] = object_lock_configuration
        __props__.__dict__["policy"] = policy
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["server_side_encryption_configuration"] = server_side_encryption_configuration
        __props__.__dict__["tags"] = tags
        __props__.__dict__["versioning"] = versioning
        __props__.__dict__["website"] = website
        __props__.__dict__["website_domain"] = website_domain
        __props__.__dict__["website_endpoint"] = website_endpoint
        return StorageBucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[Optional[str]]:
        """
        The access key to use when applying changes. This value can also be provided as `storage_access_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[Optional[str]]:
        """
        The [predefined ACL](https://cloud.yandex.com/docs/storage/concepts/acl#predefined_acls) to apply. Defaults to `private`. Conflicts with `grant`.

        > To change ACL after creation, service account with `storage.admin` role should be used, though this role is not necessary to create a bucket with any ACL.
        """
        return pulumi.get(self, "acl")

    @property
    @pulumi.getter(name="anonymousAccessFlags")
    def anonymous_access_flags(self) -> pulumi.Output['outputs.StorageBucketAnonymousAccessFlags']:
        return pulumi.get(self, "anonymous_access_flags")

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> pulumi.Output[str]:
        """
        The bucket domain name.
        """
        return pulumi.get(self, "bucket_domain_name")

    @property
    @pulumi.getter(name="bucketPrefix")
    def bucket_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Creates a unique bucket name beginning with the specified prefix. Conflicts with `bucket`.
        """
        return pulumi.get(self, "bucket_prefix")

    @property
    @pulumi.getter(name="corsRules")
    def cors_rules(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketCorsRule']]]:
        """
        A rule of [Cross-Origin Resource Sharing](https://cloud.yandex.com/docs/storage/concepts/cors) (documented below).
        """
        return pulumi.get(self, "cors_rules")

    @property
    @pulumi.getter(name="defaultStorageClass")
    def default_storage_class(self) -> pulumi.Output[str]:
        return pulumi.get(self, "default_storage_class")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[bool]]:
        """
        A boolean that indicates all objects should be deleted from the bucket so that the bucket can be destroyed without error. These objects are *not* recoverable.
        """
        return pulumi.get(self, "force_destroy")

    @property
    @pulumi.getter
    def grants(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketGrant']]]:
        """
        An [ACL policy grant](https://cloud.yandex.com/docs/storage/concepts/acl#permissions-types). Conflicts with `acl`.
        """
        return pulumi.get(self, "grants")

    @property
    @pulumi.getter
    def https(self) -> pulumi.Output[Optional['outputs.StorageBucketHttps']]:
        return pulumi.get(self, "https")

    @property
    @pulumi.getter(name="lifecycleRules")
    def lifecycle_rules(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketLifecycleRule']]]:
        """
        A configuration of [object lifecycle management](https://cloud.yandex.com/docs/storage/concepts/lifecycles) (documented below).
        """
        return pulumi.get(self, "lifecycle_rules")

    @property
    @pulumi.getter
    def loggings(self) -> pulumi.Output[Optional[Sequence['outputs.StorageBucketLogging']]]:
        """
        A settings of [bucket logging](https://cloud.yandex.com/docs/storage/concepts/server-logs) (documented below).
        """
        return pulumi.get(self, "loggings")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="objectLockConfiguration")
    def object_lock_configuration(self) -> pulumi.Output[Optional['outputs.StorageBucketObjectLockConfiguration']]:
        """
        A configuration of [object lock management](https://yandex.cloud/docs/storage/concepts/object-lock) (documented below).
        """
        return pulumi.get(self, "object_lock_configuration")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[Optional[str]]:
        """
        The secret key to use when applying changes. This value can also be provided as `storage_secret_key` specified in provider config (explicitly or within `shared_credentials_file`) is used.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="serverSideEncryptionConfiguration")
    def server_side_encryption_configuration(self) -> pulumi.Output[Optional['outputs.StorageBucketServerSideEncryptionConfiguration']]:
        return pulumi.get(self, "server_side_encryption_configuration")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def versioning(self) -> pulumi.Output['outputs.StorageBucketVersioning']:
        """
        A state of [versioning](https://cloud.yandex.com/docs/storage/concepts/versioning) (documented below)

        > To manage `versioning` argument, service account with `storage.admin` role should be used.
        """
        return pulumi.get(self, "versioning")

    @property
    @pulumi.getter
    def website(self) -> pulumi.Output[Optional['outputs.StorageBucketWebsite']]:
        """
        A [website object](https://cloud.yandex.com/docs/storage/concepts/hosting) (documented below).
        """
        return pulumi.get(self, "website")

    @property
    @pulumi.getter(name="websiteDomain")
    def website_domain(self) -> pulumi.Output[str]:
        """
        The domain of the website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_domain")

    @property
    @pulumi.getter(name="websiteEndpoint")
    def website_endpoint(self) -> pulumi.Output[str]:
        """
        The website endpoint, if the bucket is configured with a website. If not, this will be an empty string.
        """
        return pulumi.get(self, "website_endpoint")

