# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwsSecurityProfileArgs', 'SwsSecurityProfile']

@pulumi.input_type
class SwsSecurityProfileArgs:
    def __init__(__self__, *,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[str]] = None,
                 captcha_id: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SwsSecurityProfile resource.
        :param pulumi.Input[str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[str] description: Optional description of the security profile.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the security profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]] security_rules: List of security rules. The structure is documented below.
        """
        if advanced_rate_limiter_profile_id is not None:
            pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @advanced_rate_limiter_profile_id.setter
    def advanced_rate_limiter_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advanced_rate_limiter_profile_id", value)

    @property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "captcha_id", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional description of the security profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the security profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


@pulumi.input_type
class _SwsSecurityProfileState:
    def __init__(__self__, *,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[str]] = None,
                 captcha_id: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwsSecurityProfile resources.
        :param pulumi.Input[str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] created_at: The Security Profile creation timestamp.
        :param pulumi.Input[str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[str] description: Optional description of the security profile.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the security profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]] security_rules: List of security rules. The structure is documented below.
        """
        if advanced_rate_limiter_profile_id is not None:
            pulumi.set(__self__, "advanced_rate_limiter_profile_id", advanced_rate_limiter_profile_id)
        if captcha_id is not None:
            pulumi.set(__self__, "captcha_id", captcha_id)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if security_rules is not None:
            pulumi.set(__self__, "security_rules", security_rules)

    @property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @advanced_rate_limiter_profile_id.setter
    def advanced_rate_limiter_profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "advanced_rate_limiter_profile_id", value)

    @property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> Optional[pulumi.Input[str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @captcha_id.setter
    def captcha_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "captcha_id", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The Security Profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional description of the security profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the security profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

    @security_rules.setter
    def security_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsSecurityProfileSecurityRuleArgs']]]]):
        pulumi.set(self, "security_rules", value)


class SwsSecurityProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[str]] = None,
                 captcha_id: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        With security profiles you can protect your infrastructure from DDoS attacks at the application level (L7).

        Creates a Security Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

        ## Example Usage

        {{ tffile "examples/sws_security_profile/r_sws_security_profile_1.tf" }}

        {{ tffile "examples/sws_security_profile/r_sws_security_profile_2.tf" }}

        ## Import

        A Security Profile can be imported using the `id` of the resource, e.g.:

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile demo-profile-simple security_profile_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[str] description: Optional description of the security profile.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the security profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]] security_rules: List of security rules. The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwsSecurityProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With security profiles you can protect your infrastructure from DDoS attacks at the application level (L7).

        Creates a Security Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/concepts/profiles).

        ## Example Usage

        {{ tffile "examples/sws_security_profile/r_sws_security_profile_1.tf" }}

        {{ tffile "examples/sws_security_profile/r_sws_security_profile_2.tf" }}

        ## Import

        A Security Profile can be imported using the `id` of the resource, e.g.:

        ```sh
        $ pulumi import yandex:index/swsSecurityProfile:SwsSecurityProfile demo-profile-simple security_profile_id
        ```

        :param str resource_name: The name of the resource.
        :param SwsSecurityProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwsSecurityProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 advanced_rate_limiter_profile_id: Optional[pulumi.Input[str]] = None,
                 captcha_id: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwsSecurityProfileArgs.__new__(SwsSecurityProfileArgs)

            __props__.__dict__["advanced_rate_limiter_profile_id"] = advanced_rate_limiter_profile_id
            __props__.__dict__["captcha_id"] = captcha_id
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["default_action"] = default_action
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["security_rules"] = security_rules
            __props__.__dict__["created_at"] = None
        super(SwsSecurityProfile, __self__).__init__(
            'yandex:index/swsSecurityProfile:SwsSecurityProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            advanced_rate_limiter_profile_id: Optional[pulumi.Input[str]] = None,
            captcha_id: Optional[pulumi.Input[str]] = None,
            cloud_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            default_action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            security_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]]] = None) -> 'SwsSecurityProfile':
        """
        Get an existing SwsSecurityProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] advanced_rate_limiter_profile_id: Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] captcha_id: Captcha ID to use with this security profile. Set empty to use default.
        :param pulumi.Input[str] created_at: The Security Profile creation timestamp.
        :param pulumi.Input[str] default_action: Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        :param pulumi.Input[str] description: Optional description of the security profile.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the security profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsSecurityProfileSecurityRuleArgs', 'SwsSecurityProfileSecurityRuleArgsDict']]]] security_rules: List of security rules. The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwsSecurityProfileState.__new__(_SwsSecurityProfileState)

        __props__.__dict__["advanced_rate_limiter_profile_id"] = advanced_rate_limiter_profile_id
        __props__.__dict__["captcha_id"] = captcha_id
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["security_rules"] = security_rules
        return SwsSecurityProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="advancedRateLimiterProfileId")
    def advanced_rate_limiter_profile_id(self) -> pulumi.Output[Optional[str]]:
        """
        Advanced rate limiter profile ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "advanced_rate_limiter_profile_id")

    @property
    @pulumi.getter(name="captchaId")
    def captcha_id(self) -> pulumi.Output[Optional[str]]:
        """
        Captcha ID to use with this security profile. Set empty to use default.
        """
        return pulumi.get(self, "captcha_id")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The Security Profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[str]]:
        """
        Action to perform if none of rules matched. Possible values: `ALLOW` or `DENY`.
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Optional description of the security profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the security profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="securityRules")
    def security_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsSecurityProfileSecurityRule']]]:
        """
        List of security rules. The structure is documented below.
        """
        return pulumi.get(self, "security_rules")

