# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwsWafProfileArgs', 'SwsWafProfile']

@pulumi.input_type
class SwsWafProfileArgs:
    def __init__(__self__, *,
                 analyze_request_body: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 core_rule_set: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]] = None):
        """
        The set of arguments for constructing a SwsWafProfile resource.
        :param pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs'] analyze_request_body: Parameters for request body analyzer. The structure is documented below.
        :param pulumi.Input['SwsWafProfileCoreRuleSetArgs'] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        :param pulumi.Input[str] description: Optional description of the WAF profile.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]] rules: Settings for each rule in rule set. The structure is documented below.
        """
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_set is not None:
            pulumi.set(__self__, "core_rule_set", core_rule_set)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclusion_rules is not None:
            pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]:
        """
        Parameters for request body analyzer. The structure is documented below.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        """
        return pulumi.get(self, "core_rule_set")

    @core_rule_set.setter
    def core_rule_set(self, value: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]):
        pulumi.set(self, "core_rule_set", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional description of the WAF profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        """
        return pulumi.get(self, "exclusion_rules")

    @exclusion_rules.setter
    def exclusion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]):
        pulumi.set(self, "exclusion_rules", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]:
        """
        Settings for each rule in rule set. The structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class _SwsWafProfileState:
    def __init__(__self__, *,
                 analyze_request_body: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 core_rule_set: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwsWafProfile resources.
        :param pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs'] analyze_request_body: Parameters for request body analyzer. The structure is documented below.
        :param pulumi.Input['SwsWafProfileCoreRuleSetArgs'] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        :param pulumi.Input[str] created_at: The WAF Profile creation timestamp.
        :param pulumi.Input[str] description: Optional description of the WAF profile.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]] rules: Settings for each rule in rule set. The structure is documented below.
        """
        if analyze_request_body is not None:
            pulumi.set(__self__, "analyze_request_body", analyze_request_body)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if core_rule_set is not None:
            pulumi.set(__self__, "core_rule_set", core_rule_set)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exclusion_rules is not None:
            pulumi.set(__self__, "exclusion_rules", exclusion_rules)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]:
        """
        Parameters for request body analyzer. The structure is documented below.
        """
        return pulumi.get(self, "analyze_request_body")

    @analyze_request_body.setter
    def analyze_request_body(self, value: Optional[pulumi.Input['SwsWafProfileAnalyzeRequestBodyArgs']]):
        pulumi.set(self, "analyze_request_body", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        """
        return pulumi.get(self, "core_rule_set")

    @core_rule_set.setter
    def core_rule_set(self, value: Optional[pulumi.Input['SwsWafProfileCoreRuleSetArgs']]):
        pulumi.set(self, "core_rule_set", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The WAF Profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional description of the WAF profile.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        """
        return pulumi.get(self, "exclusion_rules")

    @exclusion_rules.setter
    def exclusion_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileExclusionRuleArgs']]]]):
        pulumi.set(self, "exclusion_rules", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]:
        """
        Settings for each rule in rule set. The structure is documented below.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwsWafProfileRuleArgs']]]]):
        pulumi.set(self, "rules", value)


class SwsWafProfile(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None,
                 __props__=None):
        """
        Creates a WAF Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

        ## Example Usage

        {{ tffile "examples/sws_waf_profile/r_sws_waf_profile_1.tf" }}

        {{ tffile "examples/sws_waf_profile/r_sws_waf_profile_2.tf" }}

        ## Import

        A WAF Profile can be imported using the `id` of the resource, e.g.:

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile default waf_profile_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Parameters for request body analyzer. The structure is documented below.
        :param pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        :param pulumi.Input[str] description: Optional description of the WAF profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]] rules: Settings for each rule in rule set. The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SwsWafProfileArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a WAF Profile in the specified folder. For more information, see [the official documentation](https://yandex.cloud/docs/smartwebsecurity/quickstart#waf).

        ## Example Usage

        {{ tffile "examples/sws_waf_profile/r_sws_waf_profile_1.tf" }}

        {{ tffile "examples/sws_waf_profile/r_sws_waf_profile_2.tf" }}

        ## Import

        A WAF Profile can be imported using the `id` of the resource, e.g.:

        ```sh
        $ pulumi import yandex:index/swsWafProfile:SwsWafProfile default waf_profile_id
        ```

        :param str resource_name: The name of the resource.
        :param SwsWafProfileArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwsWafProfileArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwsWafProfileArgs.__new__(SwsWafProfileArgs)

            __props__.__dict__["analyze_request_body"] = analyze_request_body
            __props__.__dict__["cloud_id"] = cloud_id
            __props__.__dict__["core_rule_set"] = core_rule_set
            __props__.__dict__["description"] = description
            __props__.__dict__["exclusion_rules"] = exclusion_rules
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            __props__.__dict__["rules"] = rules
            __props__.__dict__["created_at"] = None
        super(SwsWafProfile, __self__).__init__(
            'yandex:index/swsWafProfile:SwsWafProfile',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            analyze_request_body: Optional[pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']]] = None,
            cloud_id: Optional[pulumi.Input[str]] = None,
            core_rule_set: Optional[pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            exclusion_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]]] = None) -> 'SwsWafProfile':
        """
        Get an existing SwsWafProfile resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['SwsWafProfileAnalyzeRequestBodyArgs', 'SwsWafProfileAnalyzeRequestBodyArgsDict']] analyze_request_body: Parameters for request body analyzer. The structure is documented below.
        :param pulumi.Input[Union['SwsWafProfileCoreRuleSetArgs', 'SwsWafProfileCoreRuleSetArgsDict']] core_rule_set: Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        :param pulumi.Input[str] created_at: The WAF Profile creation timestamp.
        :param pulumi.Input[str] description: Optional description of the WAF profile.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileExclusionRuleArgs', 'SwsWafProfileExclusionRuleArgsDict']]]] exclusion_rules: List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        :param pulumi.Input[str] folder_id: ID of the folder to create a profile in. If omitted, the provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels as key:value pairs. Maximum of 64 per resource.
        :param pulumi.Input[str] name: Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwsWafProfileRuleArgs', 'SwsWafProfileRuleArgsDict']]]] rules: Settings for each rule in rule set. The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwsWafProfileState.__new__(_SwsWafProfileState)

        __props__.__dict__["analyze_request_body"] = analyze_request_body
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["core_rule_set"] = core_rule_set
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["exclusion_rules"] = exclusion_rules
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["rules"] = rules
        return SwsWafProfile(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyzeRequestBody")
    def analyze_request_body(self) -> pulumi.Output[Optional['outputs.SwsWafProfileAnalyzeRequestBody']]:
        """
        Parameters for request body analyzer. The structure is documented below.
        """
        return pulumi.get(self, "analyze_request_body")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter(name="coreRuleSet")
    def core_rule_set(self) -> pulumi.Output[Optional['outputs.SwsWafProfileCoreRuleSet']]:
        """
        Core rule set settings. See [Basic rule set](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#rules-set) for details. The structure is documented below.
        """
        return pulumi.get(self, "core_rule_set")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The WAF Profile creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Optional description of the WAF profile.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="exclusionRules")
    def exclusion_rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsWafProfileExclusionRule']]]:
        """
        List of exclusion rules. See [Rules](https://yandex.cloud/en/docs/smartwebsecurity/concepts/waf#exclusion-rules). The structure is documented below.
        """
        return pulumi.get(self, "exclusion_rules")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder to create a profile in. If omitted, the provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Labels as key:value pairs. Maximum of 64 per resource.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the WAF profile. The name is unique within the folder. 1-50 characters long.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rules(self) -> pulumi.Output[Optional[Sequence['outputs.SwsWafProfileRule']]]:
        """
        Settings for each rule in rule set. The structure is documented below.
        """
        return pulumi.get(self, "rules")

