# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['VpcPrivateEndpointArgs', 'VpcPrivateEndpoint']

@pulumi.input_type
class VpcPrivateEndpointArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 object_storage: pulumi.Input['VpcPrivateEndpointObjectStorageArgs'],
                 description: Optional[pulumi.Input[str]] = None,
                 dns_options: Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']] = None,
                 endpoint_address: Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a VpcPrivateEndpoint resource.
        :param pulumi.Input[str] network_id: ID of the network which private endpoint belongs to.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['VpcPrivateEndpointDnsOptionsArgs'] dns_options: Private endpoint DNS options block.
        :param pulumi.Input['VpcPrivateEndpointEndpointAddressArgs'] endpoint_address: Private endpoint address specification block.
        :param pulumi.Input[str] folder_id: ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this resource. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the private endpoint. Provided by the client when the private endpoint is created.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "object_storage", object_storage)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_options is not None:
            pulumi.set(__self__, "dns_options", dns_options)
        if endpoint_address is not None:
            pulumi.set(__self__, "endpoint_address", endpoint_address)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        ID of the network which private endpoint belongs to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> pulumi.Input['VpcPrivateEndpointObjectStorageArgs']:
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: pulumi.Input['VpcPrivateEndpointObjectStorageArgs']):
        pulumi.set(self, "object_storage", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']]:
        """
        Private endpoint DNS options block.
        """
        return pulumi.get(self, "dns_options")

    @dns_options.setter
    def dns_options(self, value: Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']]):
        pulumi.set(self, "dns_options", value)

    @property
    @pulumi.getter(name="endpointAddress")
    def endpoint_address(self) -> Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']]:
        """
        Private endpoint address specification block.
        """
        return pulumi.get(self, "endpoint_address")

    @endpoint_address.setter
    def endpoint_address(self, value: Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']]):
        pulumi.set(self, "endpoint_address", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this resource. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the private endpoint. Provided by the client when the private endpoint is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _VpcPrivateEndpointState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_options: Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']] = None,
                 endpoint_address: Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input['VpcPrivateEndpointObjectStorageArgs']] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering VpcPrivateEndpoint resources.
        :param pulumi.Input[str] created_at: Creation timestamp of the key.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input['VpcPrivateEndpointDnsOptionsArgs'] dns_options: Private endpoint DNS options block.
        :param pulumi.Input['VpcPrivateEndpointEndpointAddressArgs'] endpoint_address: Private endpoint address specification block.
        :param pulumi.Input[str] folder_id: ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this resource. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the private endpoint. Provided by the client when the private endpoint is created.
        :param pulumi.Input[str] network_id: ID of the network which private endpoint belongs to.
        :param pulumi.Input[str] status: Status of the private endpoint.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_options is not None:
            pulumi.set(__self__, "dns_options", dns_options)
        if endpoint_address is not None:
            pulumi.set(__self__, "endpoint_address", endpoint_address)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if object_storage is not None:
            pulumi.set(__self__, "object_storage", object_storage)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        Creation timestamp of the key.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']]:
        """
        Private endpoint DNS options block.
        """
        return pulumi.get(self, "dns_options")

    @dns_options.setter
    def dns_options(self, value: Optional[pulumi.Input['VpcPrivateEndpointDnsOptionsArgs']]):
        pulumi.set(self, "dns_options", value)

    @property
    @pulumi.getter(name="endpointAddress")
    def endpoint_address(self) -> Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']]:
        """
        Private endpoint address specification block.
        """
        return pulumi.get(self, "endpoint_address")

    @endpoint_address.setter
    def endpoint_address(self, value: Optional[pulumi.Input['VpcPrivateEndpointEndpointAddressArgs']]):
        pulumi.set(self, "endpoint_address", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels to apply to this resource. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the private endpoint. Provided by the client when the private endpoint is created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network which private endpoint belongs to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> Optional[pulumi.Input['VpcPrivateEndpointObjectStorageArgs']]:
        return pulumi.get(self, "object_storage")

    @object_storage.setter
    def object_storage(self, value: Optional[pulumi.Input['VpcPrivateEndpointObjectStorageArgs']]):
        pulumi.set(self, "object_storage", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the private endpoint.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class VpcPrivateEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_options: Optional[pulumi.Input[Union['VpcPrivateEndpointDnsOptionsArgs', 'VpcPrivateEndpointDnsOptionsArgsDict']]] = None,
                 endpoint_address: Optional[pulumi.Input[Union['VpcPrivateEndpointEndpointAddressArgs', 'VpcPrivateEndpointEndpointAddressArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input[Union['VpcPrivateEndpointObjectStorageArgs', 'VpcPrivateEndpointObjectStorageArgsDict']]] = None,
                 __props__=None):
        """
        Manages a VPC Private Endpoint within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/private-endpoint).

        * How-to Guides
          * [Cloud Networking](https://cloud.yandex.com/docs/vpc/)

        ## Example Usage

        {{ tffile "examples/vpc_private_endpoint/r_vpc_private_endpoint_1.tf" }}

        ## Import

        Private endpoint can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/vpcPrivateEndpoint:VpcPrivateEndpoint pe private_endpoint_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['VpcPrivateEndpointDnsOptionsArgs', 'VpcPrivateEndpointDnsOptionsArgsDict']] dns_options: Private endpoint DNS options block.
        :param pulumi.Input[Union['VpcPrivateEndpointEndpointAddressArgs', 'VpcPrivateEndpointEndpointAddressArgsDict']] endpoint_address: Private endpoint address specification block.
        :param pulumi.Input[str] folder_id: ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this resource. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the private endpoint. Provided by the client when the private endpoint is created.
        :param pulumi.Input[str] network_id: ID of the network which private endpoint belongs to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: VpcPrivateEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a VPC Private Endpoint within the Yandex Cloud. For more information, see [the official documentation](https://yandex.cloud/docs/vpc/concepts/private-endpoint).

        * How-to Guides
          * [Cloud Networking](https://cloud.yandex.com/docs/vpc/)

        ## Example Usage

        {{ tffile "examples/vpc_private_endpoint/r_vpc_private_endpoint_1.tf" }}

        ## Import

        Private endpoint can be imported using the `id` of the resource, e.g.

        ```sh
        $ pulumi import yandex:index/vpcPrivateEndpoint:VpcPrivateEndpoint pe private_endpoint_id
        ```

        :param str resource_name: The name of the resource.
        :param VpcPrivateEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(VpcPrivateEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_options: Optional[pulumi.Input[Union['VpcPrivateEndpointDnsOptionsArgs', 'VpcPrivateEndpointDnsOptionsArgsDict']]] = None,
                 endpoint_address: Optional[pulumi.Input[Union['VpcPrivateEndpointEndpointAddressArgs', 'VpcPrivateEndpointEndpointAddressArgsDict']]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 object_storage: Optional[pulumi.Input[Union['VpcPrivateEndpointObjectStorageArgs', 'VpcPrivateEndpointObjectStorageArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = VpcPrivateEndpointArgs.__new__(VpcPrivateEndpointArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["dns_options"] = dns_options
            __props__.__dict__["endpoint_address"] = endpoint_address
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if object_storage is None and not opts.urn:
                raise TypeError("Missing required property 'object_storage'")
            __props__.__dict__["object_storage"] = object_storage
            __props__.__dict__["created_at"] = None
            __props__.__dict__["status"] = None
        super(VpcPrivateEndpoint, __self__).__init__(
            'yandex:index/vpcPrivateEndpoint:VpcPrivateEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_options: Optional[pulumi.Input[Union['VpcPrivateEndpointDnsOptionsArgs', 'VpcPrivateEndpointDnsOptionsArgsDict']]] = None,
            endpoint_address: Optional[pulumi.Input[Union['VpcPrivateEndpointEndpointAddressArgs', 'VpcPrivateEndpointEndpointAddressArgsDict']]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            object_storage: Optional[pulumi.Input[Union['VpcPrivateEndpointObjectStorageArgs', 'VpcPrivateEndpointObjectStorageArgsDict']]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'VpcPrivateEndpoint':
        """
        Get an existing VpcPrivateEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created_at: Creation timestamp of the key.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[Union['VpcPrivateEndpointDnsOptionsArgs', 'VpcPrivateEndpointDnsOptionsArgsDict']] dns_options: Private endpoint DNS options block.
        :param pulumi.Input[Union['VpcPrivateEndpointEndpointAddressArgs', 'VpcPrivateEndpointEndpointAddressArgsDict']] endpoint_address: Private endpoint address specification block.
        :param pulumi.Input[str] folder_id: ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels to apply to this resource. A list of key/value pairs.
        :param pulumi.Input[str] name: Name of the private endpoint. Provided by the client when the private endpoint is created.
        :param pulumi.Input[str] network_id: ID of the network which private endpoint belongs to.
        :param pulumi.Input[str] status: Status of the private endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _VpcPrivateEndpointState.__new__(_VpcPrivateEndpointState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_options"] = dns_options
        __props__.__dict__["endpoint_address"] = endpoint_address
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["object_storage"] = object_storage
        __props__.__dict__["status"] = status
        return VpcPrivateEndpoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Creation timestamp of the key.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsOptions")
    def dns_options(self) -> pulumi.Output['outputs.VpcPrivateEndpointDnsOptions']:
        """
        Private endpoint DNS options block.
        """
        return pulumi.get(self, "dns_options")

    @property
    @pulumi.getter(name="endpointAddress")
    def endpoint_address(self) -> pulumi.Output['outputs.VpcPrivateEndpointEndpointAddress']:
        """
        Private endpoint address specification block.
        """
        return pulumi.get(self, "endpoint_address")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder that the resource belongs to. If it is not provided, the default provider folder is used.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Labels to apply to this resource. A list of key/value pairs.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the private endpoint. Provided by the client when the private endpoint is created.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        ID of the network which private endpoint belongs to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="objectStorage")
    def object_storage(self) -> pulumi.Output['outputs.VpcPrivateEndpointObjectStorage']:
        return pulumi.get(self, "object_storage")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the private endpoint.
        """
        return pulumi.get(self, "status")

