# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['YdbDatabaseDedicatedArgs', 'YdbDatabaseDedicated']

@pulumi.input_type
class YdbDatabaseDedicatedArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 resource_preset_id: pulumi.Input[str],
                 scale_policy: pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'],
                 storage_config: pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 sleep_after: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a YdbDatabaseDedicated resource.
        :param pulumi.Input[str] network_id: ID of the network to attach the Yandex Database cluster to.
        :param pulumi.Input[str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'] scale_policy: Scaling policy for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'] storage_config: A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs to attach the Yandex Database cluster to.
        :param pulumi.Input[bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
        :param pulumi.Input[str] description: A description for the Yandex Database cluster.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Database cluster.
        :param pulumi.Input['YdbDatabaseDedicatedLocationArgs'] location: Location for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[str] name: Name of the Yandex Database cluster.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "resource_preset_id", resource_preset_id)
        pulumi.set(__self__, "scale_policy", scale_policy)
        pulumi.set(__self__, "storage_config", storage_config)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if assign_public_ips is not None:
            pulumi.set(__self__, "assign_public_ips", assign_public_ips)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sleep_after is not None:
            pulumi.set(__self__, "sleep_after", sleep_after)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        ID of the network to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> pulumi.Input[str]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @resource_preset_id.setter
    def resource_preset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_preset_id", value)

    @property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']:
        """
        Scaling policy for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']):
        pulumi.set(self, "scale_policy", value)

    @property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']:
        """
        A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']):
        pulumi.set(self, "storage_config", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of subnet IDs to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @assign_public_ips.setter
    def assign_public_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_public_ips", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the database. Can be either `true` or `false`
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Yandex Database cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Database cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]:
        """
        Location for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Yandex Database cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "sleep_after")

    @sleep_after.setter
    def sleep_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sleep_after", value)


@pulumi.input_type
class _YdbDatabaseDedicatedState:
    def __init__(__self__, *,
                 assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 database_path: Optional[pulumi.Input[str]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 resource_preset_id: Optional[pulumi.Input[str]] = None,
                 scale_policy: Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']] = None,
                 sleep_after: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 storage_config: Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[bool]] = None,
                 ydb_api_endpoint: Optional[pulumi.Input[str]] = None,
                 ydb_full_endpoint: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering YdbDatabaseDedicated resources.
        :param pulumi.Input[bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[str] created_at: The Yandex Database cluster creation timestamp.
        :param pulumi.Input[str] database_path: Full database path of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
        :param pulumi.Input[str] description: A description for the Yandex Database cluster.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Database cluster.
        :param pulumi.Input['YdbDatabaseDedicatedLocationArgs'] location: Location for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[str] name: Name of the Yandex Database cluster.
        :param pulumi.Input[str] network_id: ID of the network to attach the Yandex Database cluster to.
        :param pulumi.Input[str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs'] scale_policy: Scaling policy for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] status: Status of the Yandex Database cluster.
        :param pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs'] storage_config: A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs to attach the Yandex Database cluster to.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[str] ydb_api_endpoint: API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[str] ydb_full_endpoint: Full endpoint of the Yandex Database cluster.
        """
        if assign_public_ips is not None:
            pulumi.set(__self__, "assign_public_ips", assign_public_ips)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if database_path is not None:
            pulumi.set(__self__, "database_path", database_path)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder_id is not None:
            pulumi.set(__self__, "folder_id", folder_id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if location_id is not None:
            pulumi.set(__self__, "location_id", location_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if resource_preset_id is not None:
            pulumi.set(__self__, "resource_preset_id", resource_preset_id)
        if scale_policy is not None:
            pulumi.set(__self__, "scale_policy", scale_policy)
        if sleep_after is not None:
            pulumi.set(__self__, "sleep_after", sleep_after)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_config is not None:
            pulumi.set(__self__, "storage_config", storage_config)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if ydb_api_endpoint is not None:
            pulumi.set(__self__, "ydb_api_endpoint", ydb_api_endpoint)
        if ydb_full_endpoint is not None:
            pulumi.set(__self__, "ydb_full_endpoint", ydb_full_endpoint)

    @property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @assign_public_ips.setter
    def assign_public_ips(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "assign_public_ips", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The Yandex Database cluster creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> Optional[pulumi.Input[str]]:
        """
        Full database path of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @database_path.setter
    def database_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_path", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Inhibits deletion of the database. Can be either `true` or `false`
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the Yandex Database cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @folder_id.setter
    def folder_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "folder_id", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A set of key/value label pairs to assign to the Yandex Database cluster.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]:
        """
        Location for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedLocationArgs']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> Optional[pulumi.Input[str]]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @location_id.setter
    def location_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Yandex Database cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the network to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @resource_preset_id.setter
    def resource_preset_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_preset_id", value)

    @property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']]:
        """
        Scaling policy for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "scale_policy")

    @scale_policy.setter
    def scale_policy(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedScalePolicyArgs']]):
        pulumi.set(self, "scale_policy", value)

    @property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "sleep_after")

    @sleep_after.setter
    def sleep_after(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sleep_after", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of the Yandex Database cluster.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']]:
        """
        A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "storage_config")

    @storage_config.setter
    def storage_config(self, value: Optional[pulumi.Input['YdbDatabaseDedicatedStorageConfigArgs']]):
        pulumi.set(self, "storage_config", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of subnet IDs to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @ydb_api_endpoint.setter
    def ydb_api_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ydb_api_endpoint", value)

    @property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Full endpoint of the Yandex Database cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")

    @ydb_full_endpoint.setter
    def ydb_full_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ydb_full_endpoint", value)


class YdbDatabaseDedicated(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 resource_preset_id: Optional[pulumi.Input[str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
                 sleep_after: Optional[pulumi.Input[int]] = None,
                 storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Yandex Database (dedicated) resource. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

        ## Example Usage

        {{ tffile "examples/ydb_database_dedicated/r_ydb_database_dedicated_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
        :param pulumi.Input[str] description: A description for the Yandex Database cluster.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Database cluster.
        :param pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']] location: Location for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[str] name: Name of the Yandex Database cluster.
        :param pulumi.Input[str] network_id: ID of the network to attach the Yandex Database cluster to.
        :param pulumi.Input[str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']] scale_policy: Scaling policy for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']] storage_config: A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs to attach the Yandex Database cluster to.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: YdbDatabaseDedicatedArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Database (dedicated) resource. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/serverless_and_dedicated).

        ## Example Usage

        {{ tffile "examples/ydb_database_dedicated/r_ydb_database_dedicated_1.tf" }}

        :param str resource_name: The name of the resource.
        :param YdbDatabaseDedicatedArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(YdbDatabaseDedicatedArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 assign_public_ips: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 folder_id: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
                 location_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 resource_preset_id: Optional[pulumi.Input[str]] = None,
                 scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
                 sleep_after: Optional[pulumi.Input[int]] = None,
                 storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = YdbDatabaseDedicatedArgs.__new__(YdbDatabaseDedicatedArgs)

            __props__.__dict__["assign_public_ips"] = assign_public_ips
            __props__.__dict__["deletion_protection"] = deletion_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["folder_id"] = folder_id
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["location_id"] = location_id
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if resource_preset_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_preset_id'")
            __props__.__dict__["resource_preset_id"] = resource_preset_id
            if scale_policy is None and not opts.urn:
                raise TypeError("Missing required property 'scale_policy'")
            __props__.__dict__["scale_policy"] = scale_policy
            __props__.__dict__["sleep_after"] = sleep_after
            if storage_config is None and not opts.urn:
                raise TypeError("Missing required property 'storage_config'")
            __props__.__dict__["storage_config"] = storage_config
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["created_at"] = None
            __props__.__dict__["database_path"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["tls_enabled"] = None
            __props__.__dict__["ydb_api_endpoint"] = None
            __props__.__dict__["ydb_full_endpoint"] = None
        super(YdbDatabaseDedicated, __self__).__init__(
            'yandex:index/ydbDatabaseDedicated:YdbDatabaseDedicated',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assign_public_ips: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            database_path: Optional[pulumi.Input[str]] = None,
            deletion_protection: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            folder_id: Optional[pulumi.Input[str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            location: Optional[pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']]] = None,
            location_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            resource_preset_id: Optional[pulumi.Input[str]] = None,
            scale_policy: Optional[pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']]] = None,
            sleep_after: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            storage_config: Optional[pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tls_enabled: Optional[pulumi.Input[bool]] = None,
            ydb_api_endpoint: Optional[pulumi.Input[str]] = None,
            ydb_full_endpoint: Optional[pulumi.Input[str]] = None) -> 'YdbDatabaseDedicated':
        """
        Get an existing YdbDatabaseDedicated resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] assign_public_ips: Whether public IP addresses should be assigned to the Yandex Database cluster.
        :param pulumi.Input[str] created_at: The Yandex Database cluster creation timestamp.
        :param pulumi.Input[str] database_path: Full database path of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[bool] deletion_protection: Inhibits deletion of the database. Can be either `true` or `false`
        :param pulumi.Input[str] description: A description for the Yandex Database cluster.
        :param pulumi.Input[str] folder_id: ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: A set of key/value label pairs to assign to the Yandex Database cluster.
        :param pulumi.Input[Union['YdbDatabaseDedicatedLocationArgs', 'YdbDatabaseDedicatedLocationArgsDict']] location: Location for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] location_id: Location ID for the Yandex Database cluster.
        :param pulumi.Input[str] name: Name of the Yandex Database cluster.
        :param pulumi.Input[str] network_id: ID of the network to attach the Yandex Database cluster to.
        :param pulumi.Input[str] resource_preset_id: The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        :param pulumi.Input[Union['YdbDatabaseDedicatedScalePolicyArgs', 'YdbDatabaseDedicatedScalePolicyArgsDict']] scale_policy: Scaling policy for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[str] status: Status of the Yandex Database cluster.
        :param pulumi.Input[Union['YdbDatabaseDedicatedStorageConfigArgs', 'YdbDatabaseDedicatedStorageConfigArgsDict']] storage_config: A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: List of subnet IDs to attach the Yandex Database cluster to.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[str] ydb_api_endpoint: API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        :param pulumi.Input[str] ydb_full_endpoint: Full endpoint of the Yandex Database cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _YdbDatabaseDedicatedState.__new__(_YdbDatabaseDedicatedState)

        __props__.__dict__["assign_public_ips"] = assign_public_ips
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["database_path"] = database_path
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["folder_id"] = folder_id
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["location_id"] = location_id
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["resource_preset_id"] = resource_preset_id
        __props__.__dict__["scale_policy"] = scale_policy
        __props__.__dict__["sleep_after"] = sleep_after
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_config"] = storage_config
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tls_enabled"] = tls_enabled
        __props__.__dict__["ydb_api_endpoint"] = ydb_api_endpoint
        __props__.__dict__["ydb_full_endpoint"] = ydb_full_endpoint
        return YdbDatabaseDedicated(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignPublicIps")
    def assign_public_ips(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether public IP addresses should be assigned to the Yandex Database cluster.
        """
        return pulumi.get(self, "assign_public_ips")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The Yandex Database cluster creation timestamp.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="databasePath")
    def database_path(self) -> pulumi.Output[str]:
        """
        Full database path of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "database_path")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Inhibits deletion of the database. Can be either `true` or `false`
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the Yandex Database cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderId")
    def folder_id(self) -> pulumi.Output[str]:
        """
        ID of the folder that the Yandex Database cluster belongs to. It will be deduced from provider configuration if not set explicitly.
        """
        return pulumi.get(self, "folder_id")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A set of key/value label pairs to assign to the Yandex Database cluster.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[Optional['outputs.YdbDatabaseDedicatedLocation']]:
        """
        Location for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="locationId")
    def location_id(self) -> pulumi.Output[str]:
        """
        Location ID for the Yandex Database cluster.
        """
        return pulumi.get(self, "location_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Yandex Database cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        ID of the network to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="resourcePresetId")
    def resource_preset_id(self) -> pulumi.Output[str]:
        """
        The Yandex Database cluster preset. Available presets can be obtained via `yc ydb resource-preset list` command.
        """
        return pulumi.get(self, "resource_preset_id")

    @property
    @pulumi.getter(name="scalePolicy")
    def scale_policy(self) -> pulumi.Output['outputs.YdbDatabaseDedicatedScalePolicy']:
        """
        Scaling policy for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "scale_policy")

    @property
    @pulumi.getter(name="sleepAfter")
    def sleep_after(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "sleep_after")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of the Yandex Database cluster.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="storageConfig")
    def storage_config(self) -> pulumi.Output['outputs.YdbDatabaseDedicatedStorageConfig']:
        """
        A list of storage configuration options for the Yandex Database cluster. The structure is documented below.
        """
        return pulumi.get(self, "storage_config")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        List of subnet IDs to attach the Yandex Database cluster to.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[bool]:
        """
        Whether TLS is enabled for the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="ydbApiEndpoint")
    def ydb_api_endpoint(self) -> pulumi.Output[str]:
        """
        API endpoint of the Yandex Database cluster. Useful for SDK configuration.
        """
        return pulumi.get(self, "ydb_api_endpoint")

    @property
    @pulumi.getter(name="ydbFullEndpoint")
    def ydb_full_endpoint(self) -> pulumi.Output[str]:
        """
        Full endpoint of the Yandex Database cluster.
        """
        return pulumi.get(self, "ydb_full_endpoint")

