# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['YdbTableArgs', 'YdbTable']

@pulumi.input_type
class YdbTableArgs:
    def __init__(__self__, *,
                 columns: pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]],
                 connection_string: pulumi.Input[str],
                 path: pulumi.Input[str],
                 primary_keys: pulumi.Input[Sequence[pulumi.Input[str]]],
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 families: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]] = None,
                 key_bloom_filter: Optional[pulumi.Input[bool]] = None,
                 partitioning_settings: Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']] = None,
                 read_replicas_settings: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input['YdbTableTtlArgs']] = None):
        """
        The set of arguments for constructing a YdbTable resource.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]] columns: A list of column configuration options. The structure is documented below.
        :param pulumi.Input[str] connection_string: Connection string for database.
        :param pulumi.Input[str] path: Table path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: A list of table columns to be uased as primary key.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map of table attributes.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]] families: A list of column group configuration options. The structure is documented below.
        :param pulumi.Input[bool] key_bloom_filter: Use the Bloom filter for the primary key
        :param pulumi.Input['YdbTablePartitioningSettingsArgs'] partitioning_settings: Table partiotioning settings The structure is documented below.
        :param pulumi.Input[str] read_replicas_settings: Read replication settings
        :param pulumi.Input['YdbTableTtlArgs'] ttl: ttl TTL settings The structure is documented below.
        """
        pulumi.set(__self__, "columns", columns)
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "primary_keys", primary_keys)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if families is not None:
            pulumi.set(__self__, "families", families)
        if key_bloom_filter is not None:
            pulumi.set(__self__, "key_bloom_filter", key_bloom_filter)
        if partitioning_settings is not None:
            pulumi.set(__self__, "partitioning_settings", partitioning_settings)
        if read_replicas_settings is not None:
            pulumi.set(__self__, "read_replicas_settings", read_replicas_settings)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]]:
        """
        A list of column configuration options. The structure is documented below.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[str]:
        """
        Connection string for database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[str]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Table path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        A list of table columns to be uased as primary key.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "primary_keys", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of table attributes.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]]:
        """
        A list of column group configuration options. The structure is documented below.
        """
        return pulumi.get(self, "families")

    @families.setter
    def families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]]):
        pulumi.set(self, "families", value)

    @property
    @pulumi.getter(name="keyBloomFilter")
    def key_bloom_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the Bloom filter for the primary key
        """
        return pulumi.get(self, "key_bloom_filter")

    @key_bloom_filter.setter
    def key_bloom_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_bloom_filter", value)

    @property
    @pulumi.getter(name="partitioningSettings")
    def partitioning_settings(self) -> Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']]:
        """
        Table partiotioning settings The structure is documented below.
        """
        return pulumi.get(self, "partitioning_settings")

    @partitioning_settings.setter
    def partitioning_settings(self, value: Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']]):
        pulumi.set(self, "partitioning_settings", value)

    @property
    @pulumi.getter(name="readReplicasSettings")
    def read_replicas_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Read replication settings
        """
        return pulumi.get(self, "read_replicas_settings")

    @read_replicas_settings.setter
    def read_replicas_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_replicas_settings", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['YdbTableTtlArgs']]:
        """
        ttl TTL settings The structure is documented below.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['YdbTableTtlArgs']]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _YdbTableState:
    def __init__(__self__, *,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 families: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]] = None,
                 key_bloom_filter: Optional[pulumi.Input[bool]] = None,
                 partitioning_settings: Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_replicas_settings: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input['YdbTableTtlArgs']] = None):
        """
        Input properties used for looking up and filtering YdbTable resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map of table attributes.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]] columns: A list of column configuration options. The structure is documented below.
        :param pulumi.Input[str] connection_string: Connection string for database.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]] families: A list of column group configuration options. The structure is documented below.
        :param pulumi.Input[bool] key_bloom_filter: Use the Bloom filter for the primary key
        :param pulumi.Input['YdbTablePartitioningSettingsArgs'] partitioning_settings: Table partiotioning settings The structure is documented below.
        :param pulumi.Input[str] path: Table path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: A list of table columns to be uased as primary key.
        :param pulumi.Input[str] read_replicas_settings: Read replication settings
        :param pulumi.Input['YdbTableTtlArgs'] ttl: ttl TTL settings The structure is documented below.
        """
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if columns is not None:
            pulumi.set(__self__, "columns", columns)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if families is not None:
            pulumi.set(__self__, "families", families)
        if key_bloom_filter is not None:
            pulumi.set(__self__, "key_bloom_filter", key_bloom_filter)
        if partitioning_settings is not None:
            pulumi.set(__self__, "partitioning_settings", partitioning_settings)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if primary_keys is not None:
            pulumi.set(__self__, "primary_keys", primary_keys)
        if read_replicas_settings is not None:
            pulumi.set(__self__, "read_replicas_settings", read_replicas_settings)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A map of table attributes.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def columns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]]]:
        """
        A list of column configuration options. The structure is documented below.
        """
        return pulumi.get(self, "columns")

    @columns.setter
    def columns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableColumnArgs']]]]):
        pulumi.set(self, "columns", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[str]]:
        """
        Connection string for database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter
    def families(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]]:
        """
        A list of column group configuration options. The structure is documented below.
        """
        return pulumi.get(self, "families")

    @families.setter
    def families(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTableFamilyArgs']]]]):
        pulumi.set(self, "families", value)

    @property
    @pulumi.getter(name="keyBloomFilter")
    def key_bloom_filter(self) -> Optional[pulumi.Input[bool]]:
        """
        Use the Bloom filter for the primary key
        """
        return pulumi.get(self, "key_bloom_filter")

    @key_bloom_filter.setter
    def key_bloom_filter(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "key_bloom_filter", value)

    @property
    @pulumi.getter(name="partitioningSettings")
    def partitioning_settings(self) -> Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']]:
        """
        Table partiotioning settings The structure is documented below.
        """
        return pulumi.get(self, "partitioning_settings")

    @partitioning_settings.setter
    def partitioning_settings(self, value: Optional[pulumi.Input['YdbTablePartitioningSettingsArgs']]):
        pulumi.set(self, "partitioning_settings", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Table path.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of table columns to be uased as primary key.
        """
        return pulumi.get(self, "primary_keys")

    @primary_keys.setter
    def primary_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "primary_keys", value)

    @property
    @pulumi.getter(name="readReplicasSettings")
    def read_replicas_settings(self) -> Optional[pulumi.Input[str]]:
        """
        Read replication settings
        """
        return pulumi.get(self, "read_replicas_settings")

    @read_replicas_settings.setter
    def read_replicas_settings(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_replicas_settings", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input['YdbTableTtlArgs']]:
        """
        ttl TTL settings The structure is documented below.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input['YdbTableTtlArgs']]):
        pulumi.set(self, "ttl", value)


class YdbTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableColumnArgs', 'YdbTableColumnArgsDict']]]]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableFamilyArgs', 'YdbTableFamilyArgsDict']]]]] = None,
                 key_bloom_filter: Optional[pulumi.Input[bool]] = None,
                 partitioning_settings: Optional[pulumi.Input[Union['YdbTablePartitioningSettingsArgs', 'YdbTablePartitioningSettingsArgsDict']]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_replicas_settings: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[Union['YdbTableTtlArgs', 'YdbTableTtlArgsDict']]] = None,
                 __props__=None):
        """
        Yandex Database table resource.

        ## Example Usage

        {{ tffile "examples/ydb_table/r_ydb_table_1.tf" }}

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map of table attributes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableColumnArgs', 'YdbTableColumnArgsDict']]]] columns: A list of column configuration options. The structure is documented below.
        :param pulumi.Input[str] connection_string: Connection string for database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableFamilyArgs', 'YdbTableFamilyArgsDict']]]] families: A list of column group configuration options. The structure is documented below.
        :param pulumi.Input[bool] key_bloom_filter: Use the Bloom filter for the primary key
        :param pulumi.Input[Union['YdbTablePartitioningSettingsArgs', 'YdbTablePartitioningSettingsArgsDict']] partitioning_settings: Table partiotioning settings The structure is documented below.
        :param pulumi.Input[str] path: Table path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: A list of table columns to be uased as primary key.
        :param pulumi.Input[str] read_replicas_settings: Read replication settings
        :param pulumi.Input[Union['YdbTableTtlArgs', 'YdbTableTtlArgsDict']] ttl: ttl TTL settings The structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: YdbTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Yandex Database table resource.

        ## Example Usage

        {{ tffile "examples/ydb_table/r_ydb_table_1.tf" }}

        :param str resource_name: The name of the resource.
        :param YdbTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(YdbTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableColumnArgs', 'YdbTableColumnArgsDict']]]]] = None,
                 connection_string: Optional[pulumi.Input[str]] = None,
                 families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableFamilyArgs', 'YdbTableFamilyArgsDict']]]]] = None,
                 key_bloom_filter: Optional[pulumi.Input[bool]] = None,
                 partitioning_settings: Optional[pulumi.Input[Union['YdbTablePartitioningSettingsArgs', 'YdbTablePartitioningSettingsArgsDict']]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 read_replicas_settings: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[Union['YdbTableTtlArgs', 'YdbTableTtlArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = YdbTableArgs.__new__(YdbTableArgs)

            __props__.__dict__["attributes"] = attributes
            if columns is None and not opts.urn:
                raise TypeError("Missing required property 'columns'")
            __props__.__dict__["columns"] = columns
            if connection_string is None and not opts.urn:
                raise TypeError("Missing required property 'connection_string'")
            __props__.__dict__["connection_string"] = connection_string
            __props__.__dict__["families"] = families
            __props__.__dict__["key_bloom_filter"] = key_bloom_filter
            __props__.__dict__["partitioning_settings"] = partitioning_settings
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if primary_keys is None and not opts.urn:
                raise TypeError("Missing required property 'primary_keys'")
            __props__.__dict__["primary_keys"] = primary_keys
            __props__.__dict__["read_replicas_settings"] = read_replicas_settings
            __props__.__dict__["ttl"] = ttl
        super(YdbTable, __self__).__init__(
            'yandex:index/ydbTable:YdbTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            columns: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableColumnArgs', 'YdbTableColumnArgsDict']]]]] = None,
            connection_string: Optional[pulumi.Input[str]] = None,
            families: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTableFamilyArgs', 'YdbTableFamilyArgsDict']]]]] = None,
            key_bloom_filter: Optional[pulumi.Input[bool]] = None,
            partitioning_settings: Optional[pulumi.Input[Union['YdbTablePartitioningSettingsArgs', 'YdbTablePartitioningSettingsArgsDict']]] = None,
            path: Optional[pulumi.Input[str]] = None,
            primary_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            read_replicas_settings: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[Union['YdbTableTtlArgs', 'YdbTableTtlArgsDict']]] = None) -> 'YdbTable':
        """
        Get an existing YdbTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] attributes: A map of table attributes.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableColumnArgs', 'YdbTableColumnArgsDict']]]] columns: A list of column configuration options. The structure is documented below.
        :param pulumi.Input[str] connection_string: Connection string for database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTableFamilyArgs', 'YdbTableFamilyArgsDict']]]] families: A list of column group configuration options. The structure is documented below.
        :param pulumi.Input[bool] key_bloom_filter: Use the Bloom filter for the primary key
        :param pulumi.Input[Union['YdbTablePartitioningSettingsArgs', 'YdbTablePartitioningSettingsArgsDict']] partitioning_settings: Table partiotioning settings The structure is documented below.
        :param pulumi.Input[str] path: Table path.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] primary_keys: A list of table columns to be uased as primary key.
        :param pulumi.Input[str] read_replicas_settings: Read replication settings
        :param pulumi.Input[Union['YdbTableTtlArgs', 'YdbTableTtlArgsDict']] ttl: ttl TTL settings The structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _YdbTableState.__new__(_YdbTableState)

        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["columns"] = columns
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["families"] = families
        __props__.__dict__["key_bloom_filter"] = key_bloom_filter
        __props__.__dict__["partitioning_settings"] = partitioning_settings
        __props__.__dict__["path"] = path
        __props__.__dict__["primary_keys"] = primary_keys
        __props__.__dict__["read_replicas_settings"] = read_replicas_settings
        __props__.__dict__["ttl"] = ttl
        return YdbTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A map of table attributes.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def columns(self) -> pulumi.Output[Sequence['outputs.YdbTableColumn']]:
        """
        A list of column configuration options. The structure is documented below.
        """
        return pulumi.get(self, "columns")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[str]:
        """
        Connection string for database.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter
    def families(self) -> pulumi.Output[Optional[Sequence['outputs.YdbTableFamily']]]:
        """
        A list of column group configuration options. The structure is documented below.
        """
        return pulumi.get(self, "families")

    @property
    @pulumi.getter(name="keyBloomFilter")
    def key_bloom_filter(self) -> pulumi.Output[bool]:
        """
        Use the Bloom filter for the primary key
        """
        return pulumi.get(self, "key_bloom_filter")

    @property
    @pulumi.getter(name="partitioningSettings")
    def partitioning_settings(self) -> pulumi.Output['outputs.YdbTablePartitioningSettings']:
        """
        Table partiotioning settings The structure is documented below.
        """
        return pulumi.get(self, "partitioning_settings")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Table path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="primaryKeys")
    def primary_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of table columns to be uased as primary key.
        """
        return pulumi.get(self, "primary_keys")

    @property
    @pulumi.getter(name="readReplicasSettings")
    def read_replicas_settings(self) -> pulumi.Output[str]:
        """
        Read replication settings
        """
        return pulumi.get(self, "read_replicas_settings")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional['outputs.YdbTableTtl']]:
        """
        ttl TTL settings The structure is documented below.
        """
        return pulumi.get(self, "ttl")

