# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['YdbTopicArgs', 'YdbTopic']

@pulumi.input_type
class YdbTopicArgs:
    def __init__(__self__, *,
                 database_endpoint: pulumi.Input[str],
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metering_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_write_speed_kbps: Optional[pulumi.Input[int]] = None,
                 partitions_count: Optional[pulumi.Input[int]] = None,
                 retention_period_hours: Optional[pulumi.Input[int]] = None,
                 retention_storage_mb: Optional[pulumi.Input[int]] = None,
                 supported_codecs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a YdbTopic resource.
        :param pulumi.Input[str] database_endpoint: YDB database endpoint. Types: string, required. Default value: "".
        :param pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]] consumers: Topic Readers. Types: array[consumer], optional. Default value: null.
        :param pulumi.Input[str] metering_mode: Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        :param pulumi.Input[str] name: Topic name. Type: string, required. Default value: "".
        :param pulumi.Input[int] partition_write_speed_kbps: Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        :param pulumi.Input[int] partitions_count: Number of partitions. Types: integer, optional. Default value: 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_codecs: Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        pulumi.set(__self__, "database_endpoint", database_endpoint)
        if consumers is not None:
            pulumi.set(__self__, "consumers", consumers)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metering_mode is not None:
            pulumi.set(__self__, "metering_mode", metering_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_write_speed_kbps is not None:
            pulumi.set(__self__, "partition_write_speed_kbps", partition_write_speed_kbps)
        if partitions_count is not None:
            pulumi.set(__self__, "partitions_count", partitions_count)
        if retention_period_hours is not None:
            pulumi.set(__self__, "retention_period_hours", retention_period_hours)
        if retention_storage_mb is not None:
            pulumi.set(__self__, "retention_storage_mb", retention_storage_mb)
        if supported_codecs is not None:
            pulumi.set(__self__, "supported_codecs", supported_codecs)

    @property
    @pulumi.getter(name="databaseEndpoint")
    def database_endpoint(self) -> pulumi.Input[str]:
        """
        YDB database endpoint. Types: string, required. Default value: "".
        """
        return pulumi.get(self, "database_endpoint")

    @database_endpoint.setter
    def database_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_endpoint", value)

    @property
    @pulumi.getter
    def consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]]:
        """
        Topic Readers. Types: array[consumer], optional. Default value: null.
        """
        return pulumi.get(self, "consumers")

    @consumers.setter
    def consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]]):
        pulumi.set(self, "consumers", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        """
        return pulumi.get(self, "metering_mode")

    @metering_mode.setter
    def metering_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metering_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Topic name. Type: string, required. Default value: "".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="partitionWriteSpeedKbps")
    def partition_write_speed_kbps(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        """
        return pulumi.get(self, "partition_write_speed_kbps")

    @partition_write_speed_kbps.setter
    def partition_write_speed_kbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_write_speed_kbps", value)

    @property
    @pulumi.getter(name="partitionsCount")
    def partitions_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of partitions. Types: integer, optional. Default value: 2.
        """
        return pulumi.get(self, "partitions_count")

    @partitions_count.setter
    def partitions_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions_count", value)

    @property
    @pulumi.getter(name="retentionPeriodHours")
    def retention_period_hours(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retention_period_hours")

    @retention_period_hours.setter
    def retention_period_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period_hours", value)

    @property
    @pulumi.getter(name="retentionStorageMb")
    def retention_storage_mb(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retention_storage_mb")

    @retention_storage_mb.setter
    def retention_storage_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_storage_mb", value)

    @property
    @pulumi.getter(name="supportedCodecs")
    def supported_codecs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        return pulumi.get(self, "supported_codecs")

    @supported_codecs.setter
    def supported_codecs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_codecs", value)


@pulumi.input_type
class _YdbTopicState:
    def __init__(__self__, *,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]] = None,
                 database_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metering_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_write_speed_kbps: Optional[pulumi.Input[int]] = None,
                 partitions_count: Optional[pulumi.Input[int]] = None,
                 retention_period_hours: Optional[pulumi.Input[int]] = None,
                 retention_storage_mb: Optional[pulumi.Input[int]] = None,
                 supported_codecs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering YdbTopic resources.
        :param pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]] consumers: Topic Readers. Types: array[consumer], optional. Default value: null.
        :param pulumi.Input[str] database_endpoint: YDB database endpoint. Types: string, required. Default value: "".
        :param pulumi.Input[str] metering_mode: Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        :param pulumi.Input[str] name: Topic name. Type: string, required. Default value: "".
        :param pulumi.Input[int] partition_write_speed_kbps: Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        :param pulumi.Input[int] partitions_count: Number of partitions. Types: integer, optional. Default value: 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_codecs: Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        if consumers is not None:
            pulumi.set(__self__, "consumers", consumers)
        if database_endpoint is not None:
            pulumi.set(__self__, "database_endpoint", database_endpoint)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if metering_mode is not None:
            pulumi.set(__self__, "metering_mode", metering_mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition_write_speed_kbps is not None:
            pulumi.set(__self__, "partition_write_speed_kbps", partition_write_speed_kbps)
        if partitions_count is not None:
            pulumi.set(__self__, "partitions_count", partitions_count)
        if retention_period_hours is not None:
            pulumi.set(__self__, "retention_period_hours", retention_period_hours)
        if retention_storage_mb is not None:
            pulumi.set(__self__, "retention_storage_mb", retention_storage_mb)
        if supported_codecs is not None:
            pulumi.set(__self__, "supported_codecs", supported_codecs)

    @property
    @pulumi.getter
    def consumers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]]:
        """
        Topic Readers. Types: array[consumer], optional. Default value: null.
        """
        return pulumi.get(self, "consumers")

    @consumers.setter
    def consumers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['YdbTopicConsumerArgs']]]]):
        pulumi.set(self, "consumers", value)

    @property
    @pulumi.getter(name="databaseEndpoint")
    def database_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        YDB database endpoint. Types: string, required. Default value: "".
        """
        return pulumi.get(self, "database_endpoint")

    @database_endpoint.setter
    def database_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_endpoint", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        """
        return pulumi.get(self, "metering_mode")

    @metering_mode.setter
    def metering_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metering_mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Topic name. Type: string, required. Default value: "".
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="partitionWriteSpeedKbps")
    def partition_write_speed_kbps(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        """
        return pulumi.get(self, "partition_write_speed_kbps")

    @partition_write_speed_kbps.setter
    def partition_write_speed_kbps(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partition_write_speed_kbps", value)

    @property
    @pulumi.getter(name="partitionsCount")
    def partitions_count(self) -> Optional[pulumi.Input[int]]:
        """
        Number of partitions. Types: integer, optional. Default value: 2.
        """
        return pulumi.get(self, "partitions_count")

    @partitions_count.setter
    def partitions_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions_count", value)

    @property
    @pulumi.getter(name="retentionPeriodHours")
    def retention_period_hours(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retention_period_hours")

    @retention_period_hours.setter
    def retention_period_hours(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_period_hours", value)

    @property
    @pulumi.getter(name="retentionStorageMb")
    def retention_storage_mb(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "retention_storage_mb")

    @retention_storage_mb.setter
    def retention_storage_mb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_storage_mb", value)

    @property
    @pulumi.getter(name="supportedCodecs")
    def supported_codecs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        return pulumi.get(self, "supported_codecs")

    @supported_codecs.setter
    def supported_codecs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "supported_codecs", value)


class YdbTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTopicConsumerArgs', 'YdbTopicConsumerArgsDict']]]]] = None,
                 database_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metering_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_write_speed_kbps: Optional[pulumi.Input[int]] = None,
                 partitions_count: Optional[pulumi.Input[int]] = None,
                 retention_period_hours: Optional[pulumi.Input[int]] = None,
                 retention_storage_mb: Optional[pulumi.Input[int]] = None,
                 supported_codecs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manage a YDB Topic. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/#ydb).

        ## Example Usage

        {{ tffile "examples/ydb_topic/r_ydb_topic_1.tf" }}

        ## Consumer data type description

        * `name` - Reader's name. Type: string, required. Default value: "".
        * `supported_codecs` - Supported data encodings. Types:Types: array[string], optional. Default value: ["gzip", "raw", "zstd"].
        * `starting_message_timestamp_ms` - Timestamp in UNIX timestamp format from which the reader will start reading data. Type: integer, optional. Default value: 0.
        * `important` - Defines an important consumer. No data will be deleted from the topic until all the important consumers read them. Value type: boolean, default value: false.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTopicConsumerArgs', 'YdbTopicConsumerArgsDict']]]] consumers: Topic Readers. Types: array[consumer], optional. Default value: null.
        :param pulumi.Input[str] database_endpoint: YDB database endpoint. Types: string, required. Default value: "".
        :param pulumi.Input[str] metering_mode: Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        :param pulumi.Input[str] name: Topic name. Type: string, required. Default value: "".
        :param pulumi.Input[int] partition_write_speed_kbps: Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        :param pulumi.Input[int] partitions_count: Number of partitions. Types: integer, optional. Default value: 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_codecs: Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: YdbTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a YDB Topic. For more information, see [the official documentation](https://yandex.cloud/docs/ydb/concepts/#ydb).

        ## Example Usage

        {{ tffile "examples/ydb_topic/r_ydb_topic_1.tf" }}

        ## Consumer data type description

        * `name` - Reader's name. Type: string, required. Default value: "".
        * `supported_codecs` - Supported data encodings. Types:Types: array[string], optional. Default value: ["gzip", "raw", "zstd"].
        * `starting_message_timestamp_ms` - Timestamp in UNIX timestamp format from which the reader will start reading data. Type: integer, optional. Default value: 0.
        * `important` - Defines an important consumer. No data will be deleted from the topic until all the important consumers read them. Value type: boolean, default value: false.

        :param str resource_name: The name of the resource.
        :param YdbTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(YdbTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTopicConsumerArgs', 'YdbTopicConsumerArgsDict']]]]] = None,
                 database_endpoint: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 metering_mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 partition_write_speed_kbps: Optional[pulumi.Input[int]] = None,
                 partitions_count: Optional[pulumi.Input[int]] = None,
                 retention_period_hours: Optional[pulumi.Input[int]] = None,
                 retention_storage_mb: Optional[pulumi.Input[int]] = None,
                 supported_codecs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = YdbTopicArgs.__new__(YdbTopicArgs)

            __props__.__dict__["consumers"] = consumers
            if database_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'database_endpoint'")
            __props__.__dict__["database_endpoint"] = database_endpoint
            __props__.__dict__["description"] = description
            __props__.__dict__["metering_mode"] = metering_mode
            __props__.__dict__["name"] = name
            __props__.__dict__["partition_write_speed_kbps"] = partition_write_speed_kbps
            __props__.__dict__["partitions_count"] = partitions_count
            __props__.__dict__["retention_period_hours"] = retention_period_hours
            __props__.__dict__["retention_storage_mb"] = retention_storage_mb
            __props__.__dict__["supported_codecs"] = supported_codecs
        super(YdbTopic, __self__).__init__(
            'yandex:index/ydbTopic:YdbTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consumers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['YdbTopicConsumerArgs', 'YdbTopicConsumerArgsDict']]]]] = None,
            database_endpoint: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            metering_mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            partition_write_speed_kbps: Optional[pulumi.Input[int]] = None,
            partitions_count: Optional[pulumi.Input[int]] = None,
            retention_period_hours: Optional[pulumi.Input[int]] = None,
            retention_storage_mb: Optional[pulumi.Input[int]] = None,
            supported_codecs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'YdbTopic':
        """
        Get an existing YdbTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['YdbTopicConsumerArgs', 'YdbTopicConsumerArgsDict']]]] consumers: Topic Readers. Types: array[consumer], optional. Default value: null.
        :param pulumi.Input[str] database_endpoint: YDB database endpoint. Types: string, required. Default value: "".
        :param pulumi.Input[str] metering_mode: Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        :param pulumi.Input[str] name: Topic name. Type: string, required. Default value: "".
        :param pulumi.Input[int] partition_write_speed_kbps: Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        :param pulumi.Input[int] partitions_count: Number of partitions. Types: integer, optional. Default value: 2.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] supported_codecs: Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _YdbTopicState.__new__(_YdbTopicState)

        __props__.__dict__["consumers"] = consumers
        __props__.__dict__["database_endpoint"] = database_endpoint
        __props__.__dict__["description"] = description
        __props__.__dict__["metering_mode"] = metering_mode
        __props__.__dict__["name"] = name
        __props__.__dict__["partition_write_speed_kbps"] = partition_write_speed_kbps
        __props__.__dict__["partitions_count"] = partitions_count
        __props__.__dict__["retention_period_hours"] = retention_period_hours
        __props__.__dict__["retention_storage_mb"] = retention_storage_mb
        __props__.__dict__["supported_codecs"] = supported_codecs
        return YdbTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def consumers(self) -> pulumi.Output[Sequence['outputs.YdbTopicConsumer']]:
        """
        Topic Readers. Types: array[consumer], optional. Default value: null.
        """
        return pulumi.get(self, "consumers")

    @property
    @pulumi.getter(name="databaseEndpoint")
    def database_endpoint(self) -> pulumi.Output[str]:
        """
        YDB database endpoint. Types: string, required. Default value: "".
        """
        return pulumi.get(self, "database_endpoint")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="meteringMode")
    def metering_mode(self) -> pulumi.Output[str]:
        """
        Resource metering mode (`reserved_capacity` - based on the allocated resources or `request_units` - based on actual usage). This option applies to topics in serverless databases. Value type: String.
        """
        return pulumi.get(self, "metering_mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Topic name. Type: string, required. Default value: "".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="partitionWriteSpeedKbps")
    def partition_write_speed_kbps(self) -> pulumi.Output[int]:
        """
        Maximum allowed write speed per partition. If a write speed for a given partition exceeds this value, the write speed will be capped. Value type: integer, default value: 1024 (1MB).
        """
        return pulumi.get(self, "partition_write_speed_kbps")

    @property
    @pulumi.getter(name="partitionsCount")
    def partitions_count(self) -> pulumi.Output[int]:
        """
        Number of partitions. Types: integer, optional. Default value: 2.
        """
        return pulumi.get(self, "partitions_count")

    @property
    @pulumi.getter(name="retentionPeriodHours")
    def retention_period_hours(self) -> pulumi.Output[int]:
        return pulumi.get(self, "retention_period_hours")

    @property
    @pulumi.getter(name="retentionStorageMb")
    def retention_storage_mb(self) -> pulumi.Output[int]:
        return pulumi.get(self, "retention_storage_mb")

    @property
    @pulumi.getter(name="supportedCodecs")
    def supported_codecs(self) -> pulumi.Output[Sequence[str]]:
        """
        Supported data encodings. Types: array[string]. Default value: ["gzip", "raw", "zstd"].
        """
        return pulumi.get(self, "supported_codecs")

