"""
    Bundeshaushalt API

    Mit unserem Tool „Bundeshaushalt digital“ können Sie sich eine visualisierte Darstellung der Haushaltsdaten der letzten Jahre anzeigen lassen. Sie können sowohl Ausgaben und Einnahmen als auch Soll- und Ist-Werte abrufen und mithilfe des Jahresvergleichs gegenüberstellen. Zudem steht Ihnen eine Vielzahl weiterer Filteroptionen zur Verfügung.<br>  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: anetz@gmx.net
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from deutschland.bundeshaushalt.api_client import ApiClient
from deutschland.bundeshaushalt.api_client import Endpoint as _Endpoint
from deutschland.bundeshaushalt.model.bad_request import BadRequest
from deutschland.bundeshaushalt.model.budget_data_response import BudgetDataResponse
from deutschland.bundeshaushalt.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types,
)


class BudgetDataApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.budget_data_endpoint = _Endpoint(
            settings={
                "response_type": (BudgetDataResponse,),
                "auth": [],
                "endpoint_path": "/internalapi/budgetData",
                "operation_id": "budget_data",
                "http_method": "GET",
                "servers": None,
            },
            params_map={
                "all": [
                    "year",
                    "account",
                    "quota",
                    "unit",
                    "id",
                ],
                "required": [
                    "year",
                    "account",
                ],
                "nullable": [],
                "enum": [
                    "year",
                    "account",
                    "quota",
                    "unit",
                ],
                "validation": [],
            },
            root_map={
                "validations": {},
                "allowed_values": {
                    ("year",): {
                        "2012": 2012,
                        "2013": 2013,
                        "2014": 2014,
                        "2015": 2015,
                        "2016": 2016,
                        "2017": 2017,
                        "2018": 2018,
                        "2019": 2019,
                        "2020": 2020,
                        "2021": 2021,
                    },
                    ("account",): {"EXPENSES": "expenses", "INCOME": "income"},
                    ("quota",): {"ACTUAL": "actual", "TARGET": "target"},
                    ("unit",): {
                        "SINGLE": "single",
                        "FUNCTION": "function",
                        "GROUP": "group",
                    },
                },
                "openapi_types": {
                    "year": (int,),
                    "account": (str,),
                    "quota": (str,),
                    "unit": (str,),
                    "id": (str,),
                },
                "attribute_map": {
                    "year": "year",
                    "account": "account",
                    "quota": "quota",
                    "unit": "unit",
                    "id": "id",
                },
                "location_map": {
                    "year": "query",
                    "account": "query",
                    "quota": "query",
                    "unit": "query",
                    "id": "query",
                },
                "collection_format_map": {},
            },
            headers_map={
                "accept": ["application/json"],
                "content_type": [],
            },
            api_client=api_client,
        )

    def budget_data(self, year, account, **kwargs):
        """Anfrage von Budgetdaten des Bundeshaushalts.  # noqa: E501

        Haupteinstiegspunkt für alle Anfragen.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.budget_data(year, account, async_req=True)
        >>> result = thread.get()

        Args:
            year (int): Haushaltsjahr
            account (str): <b>income</b>: Einnahmen. Die Einnahmen des Bundes setzen sich aus Steuern, sonstigen Einnahmen und Krediten zusammen.<br><b>expenses</b>: Ausgaben. Der größte Teil der Ausgaben wird für Sozialausgaben geleistet. Weitere große Ausgabeposten sind die Ausgabebereiche Verteidigung, Verkehrs- und Nachrichtenwesen und auch Bildung und Forschung.

        Keyword Args:
            quota (str): <b>target</b>: Sollwerte <i>(default)</i><br><b>actual</b>: Istwerte.. [optional]
            unit (str): <b>single</b>: Einzelplan. <i>(default)</i><br><b>function</b>: Funktion.<br><b>group</b>: Gruppe.. [optional]
            id (str): ID, die sich aus der Budgetnummer ergibt. Die Budgetnummer ist eine numerische Bezeichnung im Rahmen der Gliederung des Haushaltsplans, die sich aus der Einzelplan-, Kapitel und Titelnummer zusammensetzt. Gruppen-IDs starten mit 'G-', Funktions-IDs mit 'F-'. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            async_req (bool): execute request asynchronously

        Returns:
            BudgetDataResponse
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs["async_req"] = kwargs.get("async_req", False)
        kwargs["_return_http_data_only"] = kwargs.get("_return_http_data_only", True)
        kwargs["_preload_content"] = kwargs.get("_preload_content", True)
        kwargs["_request_timeout"] = kwargs.get("_request_timeout", None)
        kwargs["_check_input_type"] = kwargs.get("_check_input_type", True)
        kwargs["_check_return_type"] = kwargs.get("_check_return_type", True)
        kwargs["_spec_property_naming"] = kwargs.get("_spec_property_naming", False)
        kwargs["_content_type"] = kwargs.get("_content_type")
        kwargs["_host_index"] = kwargs.get("_host_index")
        kwargs["_request_auths"] = kwargs.get("_request_auths", None)
        kwargs["year"] = year
        kwargs["account"] = account
        return self.budget_data_endpoint.call_with_http_info(**kwargs)
