# coding: utf-8

"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Created by: https://snaptrade.com/
"""

from datetime import date, datetime  # noqa: F401
import decimal  # noqa: F401
import functools  # noqa: F401
import io  # noqa: F401
import re  # noqa: F401
import typing  # noqa: F401
import typing_extensions  # noqa: F401
import uuid  # noqa: F401

import frozendict  # noqa: F401

from snaptrade_client import schemas  # noqa: F401


class StrategyImpact(
    schemas.DictSchema
):
    """
    This class is auto generated by Konfig (https://konfigthis.com)

    The strategy impact
    """


    class MetaOapg:
        
        class properties:
            estimatedCommissions = schemas.NumberSchema
            buyingPowerEffect = schemas.NumberSchema
            buyingPowerResult = schemas.NumberSchema
            maintExcessEffect = schemas.NumberSchema
            maintExcessResult = schemas.NumberSchema
            tradeValueCalculation = schemas.StrSchema
        
            @staticmethod
            def legs() -> typing.Type['StrategyImpactLegs']:
                return StrategyImpactLegs
            side = schemas.StrSchema
            effect = schemas.StrSchema
            price = schemas.NumberSchema
            strategy = schemas.StrSchema
            __annotations__ = {
                "estimatedCommissions": estimatedCommissions,
                "buyingPowerEffect": buyingPowerEffect,
                "buyingPowerResult": buyingPowerResult,
                "maintExcessEffect": maintExcessEffect,
                "maintExcessResult": maintExcessResult,
                "tradeValueCalculation": tradeValueCalculation,
                "legs": legs,
                "side": side,
                "effect": effect,
                "price": price,
                "strategy": strategy,
            }
        additional_properties = schemas.AnyTypeSchema
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["estimatedCommissions"]) -> MetaOapg.properties.estimatedCommissions: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["buyingPowerEffect"]) -> MetaOapg.properties.buyingPowerEffect: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["buyingPowerResult"]) -> MetaOapg.properties.buyingPowerResult: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["maintExcessEffect"]) -> MetaOapg.properties.maintExcessEffect: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["maintExcessResult"]) -> MetaOapg.properties.maintExcessResult: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["tradeValueCalculation"]) -> MetaOapg.properties.tradeValueCalculation: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["legs"]) -> 'StrategyImpactLegs': ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["side"]) -> MetaOapg.properties.side: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["effect"]) -> MetaOapg.properties.effect: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["price"]) -> MetaOapg.properties.price: ...
    
    @typing.overload
    def __getitem__(self, name: typing_extensions.Literal["strategy"]) -> MetaOapg.properties.strategy: ...
    
    @typing.overload
    def __getitem__(self, name: str) -> MetaOapg.additional_properties: ...
    
    def __getitem__(self, name: typing.Union[typing_extensions.Literal["estimatedCommissions"], typing_extensions.Literal["buyingPowerEffect"], typing_extensions.Literal["buyingPowerResult"], typing_extensions.Literal["maintExcessEffect"], typing_extensions.Literal["maintExcessResult"], typing_extensions.Literal["tradeValueCalculation"], typing_extensions.Literal["legs"], typing_extensions.Literal["side"], typing_extensions.Literal["effect"], typing_extensions.Literal["price"], typing_extensions.Literal["strategy"], str, ]):
        # dict_instance[name] accessor
        return super().__getitem__(name)
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["estimatedCommissions"]) -> typing.Union[MetaOapg.properties.estimatedCommissions, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["buyingPowerEffect"]) -> typing.Union[MetaOapg.properties.buyingPowerEffect, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["buyingPowerResult"]) -> typing.Union[MetaOapg.properties.buyingPowerResult, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["maintExcessEffect"]) -> typing.Union[MetaOapg.properties.maintExcessEffect, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["maintExcessResult"]) -> typing.Union[MetaOapg.properties.maintExcessResult, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["tradeValueCalculation"]) -> typing.Union[MetaOapg.properties.tradeValueCalculation, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["legs"]) -> typing.Union['StrategyImpactLegs', schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["side"]) -> typing.Union[MetaOapg.properties.side, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["effect"]) -> typing.Union[MetaOapg.properties.effect, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["price"]) -> typing.Union[MetaOapg.properties.price, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: typing_extensions.Literal["strategy"]) -> typing.Union[MetaOapg.properties.strategy, schemas.Unset]: ...
    
    @typing.overload
    def get_item_oapg(self, name: str) -> typing.Union[MetaOapg.additional_properties, schemas.Unset]: ...
    
    def get_item_oapg(self, name: typing.Union[typing_extensions.Literal["estimatedCommissions"], typing_extensions.Literal["buyingPowerEffect"], typing_extensions.Literal["buyingPowerResult"], typing_extensions.Literal["maintExcessEffect"], typing_extensions.Literal["maintExcessResult"], typing_extensions.Literal["tradeValueCalculation"], typing_extensions.Literal["legs"], typing_extensions.Literal["side"], typing_extensions.Literal["effect"], typing_extensions.Literal["price"], typing_extensions.Literal["strategy"], str, ]):
        return super().get_item_oapg(name)

    def __new__(
        cls,
        *args: typing.Union[dict, frozendict.frozendict, ],
        estimatedCommissions: typing.Union[MetaOapg.properties.estimatedCommissions, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        buyingPowerEffect: typing.Union[MetaOapg.properties.buyingPowerEffect, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        buyingPowerResult: typing.Union[MetaOapg.properties.buyingPowerResult, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        maintExcessEffect: typing.Union[MetaOapg.properties.maintExcessEffect, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        maintExcessResult: typing.Union[MetaOapg.properties.maintExcessResult, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        tradeValueCalculation: typing.Union[MetaOapg.properties.tradeValueCalculation, str, schemas.Unset] = schemas.unset,
        legs: typing.Union['StrategyImpactLegs', schemas.Unset] = schemas.unset,
        side: typing.Union[MetaOapg.properties.side, str, schemas.Unset] = schemas.unset,
        effect: typing.Union[MetaOapg.properties.effect, str, schemas.Unset] = schemas.unset,
        price: typing.Union[MetaOapg.properties.price, decimal.Decimal, int, float, schemas.Unset] = schemas.unset,
        strategy: typing.Union[MetaOapg.properties.strategy, str, schemas.Unset] = schemas.unset,
        _configuration: typing.Optional[schemas.Configuration] = None,
        **kwargs: typing.Union[MetaOapg.additional_properties, dict, frozendict.frozendict, str, date, datetime, uuid.UUID, int, float, decimal.Decimal, bool, None, list, tuple, bytes, io.FileIO, io.BufferedReader, ],
    ) -> 'StrategyImpact':
        return super().__new__(
            cls,
            *args,
            estimatedCommissions=estimatedCommissions,
            buyingPowerEffect=buyingPowerEffect,
            buyingPowerResult=buyingPowerResult,
            maintExcessEffect=maintExcessEffect,
            maintExcessResult=maintExcessResult,
            tradeValueCalculation=tradeValueCalculation,
            legs=legs,
            side=side,
            effect=effect,
            price=price,
            strategy=strategy,
            _configuration=_configuration,
            **kwargs,
        )

from snaptrade_client.model.strategy_impact_legs import StrategyImpactLegs
