
# Autogenerated by mlir-tblgen; don't manually edit.

from ._ods_common import _cext as _ods_cext
from ._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_result_or_value as _get_op_result_or_value,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "hw"

@_ods_cext.register_operation(_Dialect)
class AggregateConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.aggregate_constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, fields, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fields"] = (fields if (
    isinstance(fields, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(fields, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def fields(self):
    return self.operation.attributes["fields"]

  @fields.setter
  def fields(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fields"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def aggregate_constant(result, fields, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(AggregateConstantOp(result=result, fields=fields, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ArrayConcatOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.array_concat"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_concat(result, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ArrayConcatOp(result=result, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ArrayCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.array_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_create(result, inputs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ArrayCreateOp(result=result, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ArrayGetOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.array_get"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, index, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(index))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def index(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def array_get(input, index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ArrayGetOp(input=input, index=index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ArraySliceOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.array_slice"

  _ODS_REGIONS = (0, True)

  def __init__(self, dst, input, lowIndex, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(lowIndex))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(dst)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def lowIndex(self):
    return self.operation.operands[1]

  @builtins.property
  def dst(self):
    return self.operation.results[0]

def array_slice(dst, input, low_index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ArraySliceOp(dst=dst, input=input, lowIndex=low_index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class BitcastOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.bitcast"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def bitcast(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(BitcastOp(result=result, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('APIntAttr')) else
      _ods_ir.AttrBuilder.get('APIntAttr')(value, context=_ods_context))
    _ods_result_type_source_attr = attributes["value"]
    _ods_derived_result_type = (
        _ods_ir.TypeAttr(_ods_result_type_source_attr).value
        if _ods_ir.TypeAttr.isinstance(_ods_result_type_source_attr) else
        _ods_result_type_source_attr.type)
    results.extend([_ods_derived_result_type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def constant(value, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ConstantOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class EnumCmpOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.enum.cmp"

  _ODS_REGIONS = (0, True)

  def __init__(self, lhs, rhs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(lhs))
    operands.append(_get_op_result_or_value(rhs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def lhs(self):
    return self.operation.operands[0]

  @builtins.property
  def rhs(self):
    return self.operation.operands[1]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def enum_cmp(lhs, rhs, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(EnumCmpOp(lhs=lhs, rhs=rhs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class EnumConstantOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.enum.constant"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, field, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["field"] = (field if (
    isinstance(field, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EnumFieldAttr')) else
      _ods_ir.AttrBuilder.get('EnumFieldAttr')(field, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def field(self):
    return self.operation.attributes["field"]

  @field.setter
  def field(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["field"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def enum_constant(result, field, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(EnumConstantOp(result=result, field=field, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HWGeneratorSchemaOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.generator.schema"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, descriptor, requiredAttrs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["descriptor"] = (descriptor if (
    isinstance(descriptor, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(descriptor, context=_ods_context))
    attributes["requiredAttrs"] = (requiredAttrs if (
    isinstance(requiredAttrs, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(requiredAttrs, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def descriptor(self):
    return self.operation.attributes["descriptor"]

  @descriptor.setter
  def descriptor(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["descriptor"] = value

  @builtins.property
  def requiredAttrs(self):
    return self.operation.attributes["requiredAttrs"]

  @requiredAttrs.setter
  def requiredAttrs(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["requiredAttrs"] = value

def generator_schema(sym_name, descriptor, required_attrs, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HWGeneratorSchemaOp(sym_name=sym_name, descriptor=descriptor, requiredAttrs=required_attrs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HWModuleExternOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.module.extern"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, module_type, parameters, *, per_port_attrs=None, port_locs=None, verilogName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["module_type"] = (module_type if (
    isinstance(module_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_554')) else
      _ods_ir.AttrBuilder.get('anonymous_554')(module_type, context=_ods_context))
    if per_port_attrs is not None: attributes["per_port_attrs"] = (per_port_attrs if (
        isinstance(per_port_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(per_port_attrs, context=_ods_context))
    if port_locs is not None: attributes["port_locs"] = (port_locs if (
        isinstance(port_locs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LocationArrayAttr')) else
          _ods_ir.AttrBuilder.get('LocationArrayAttr')(port_locs, context=_ods_context))
    attributes["parameters"] = (parameters if (
    isinstance(parameters, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ParamDeclArrayAttr')) else
      _ods_ir.AttrBuilder.get('ParamDeclArrayAttr')(parameters, context=_ods_context))
    if verilogName is not None: attributes["verilogName"] = (verilogName if (
        isinstance(verilogName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verilogName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def module_type(self):
    return self.operation.attributes["module_type"]

  @module_type.setter
  def module_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module_type"] = value

  @builtins.property
  def per_port_attrs(self):
    if "per_port_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["per_port_attrs"]

  @per_port_attrs.setter
  def per_port_attrs(self, value):
    if value is not None:
      self.operation.attributes["per_port_attrs"] = value
    elif "per_port_attrs" in self.operation.attributes:
      del self.operation.attributes["per_port_attrs"]

  @per_port_attrs.deleter
  def per_port_attrs(self):
    del self.operation.attributes["per_port_attrs"]

  @builtins.property
  def port_locs(self):
    if "port_locs" not in self.operation.attributes:
      return None
    return self.operation.attributes["port_locs"]

  @port_locs.setter
  def port_locs(self, value):
    if value is not None:
      self.operation.attributes["port_locs"] = value
    elif "port_locs" in self.operation.attributes:
      del self.operation.attributes["port_locs"]

  @port_locs.deleter
  def port_locs(self):
    del self.operation.attributes["port_locs"]

  @builtins.property
  def parameters(self):
    return self.operation.attributes["parameters"]

  @parameters.setter
  def parameters(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["parameters"] = value

  @builtins.property
  def verilogName(self):
    if "verilogName" not in self.operation.attributes:
      return None
    return self.operation.attributes["verilogName"]

  @verilogName.setter
  def verilogName(self, value):
    if value is not None:
      self.operation.attributes["verilogName"] = value
    elif "verilogName" in self.operation.attributes:
      del self.operation.attributes["verilogName"]

  @verilogName.deleter
  def verilogName(self):
    del self.operation.attributes["verilogName"]

  @builtins.property
  def body(self):
    return self.regions[0]

def module_extern(sym_name, module_type, parameters, *, per_port_attrs=None, port_locs=None, verilog_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HWModuleExternOp(sym_name=sym_name, module_type=module_type, parameters=parameters, per_port_attrs=per_port_attrs, port_locs=port_locs, verilogName=verilog_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HWModuleGeneratedOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.module.generated"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, generatorKind, module_type, parameters, *, per_port_attrs=None, port_locs=None, verilogName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["generatorKind"] = (generatorKind if (
    isinstance(generatorKind, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(generatorKind, context=_ods_context))
    attributes["module_type"] = (module_type if (
    isinstance(module_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_554')) else
      _ods_ir.AttrBuilder.get('anonymous_554')(module_type, context=_ods_context))
    if per_port_attrs is not None: attributes["per_port_attrs"] = (per_port_attrs if (
        isinstance(per_port_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(per_port_attrs, context=_ods_context))
    if port_locs is not None: attributes["port_locs"] = (port_locs if (
        isinstance(port_locs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LocationArrayAttr')) else
          _ods_ir.AttrBuilder.get('LocationArrayAttr')(port_locs, context=_ods_context))
    attributes["parameters"] = (parameters if (
    isinstance(parameters, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ParamDeclArrayAttr')) else
      _ods_ir.AttrBuilder.get('ParamDeclArrayAttr')(parameters, context=_ods_context))
    if verilogName is not None: attributes["verilogName"] = (verilogName if (
        isinstance(verilogName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verilogName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def generatorKind(self):
    return self.operation.attributes["generatorKind"]

  @generatorKind.setter
  def generatorKind(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["generatorKind"] = value

  @builtins.property
  def module_type(self):
    return self.operation.attributes["module_type"]

  @module_type.setter
  def module_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module_type"] = value

  @builtins.property
  def per_port_attrs(self):
    if "per_port_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["per_port_attrs"]

  @per_port_attrs.setter
  def per_port_attrs(self, value):
    if value is not None:
      self.operation.attributes["per_port_attrs"] = value
    elif "per_port_attrs" in self.operation.attributes:
      del self.operation.attributes["per_port_attrs"]

  @per_port_attrs.deleter
  def per_port_attrs(self):
    del self.operation.attributes["per_port_attrs"]

  @builtins.property
  def port_locs(self):
    if "port_locs" not in self.operation.attributes:
      return None
    return self.operation.attributes["port_locs"]

  @port_locs.setter
  def port_locs(self, value):
    if value is not None:
      self.operation.attributes["port_locs"] = value
    elif "port_locs" in self.operation.attributes:
      del self.operation.attributes["port_locs"]

  @port_locs.deleter
  def port_locs(self):
    del self.operation.attributes["port_locs"]

  @builtins.property
  def parameters(self):
    return self.operation.attributes["parameters"]

  @parameters.setter
  def parameters(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["parameters"] = value

  @builtins.property
  def verilogName(self):
    if "verilogName" not in self.operation.attributes:
      return None
    return self.operation.attributes["verilogName"]

  @verilogName.setter
  def verilogName(self, value):
    if value is not None:
      self.operation.attributes["verilogName"] = value
    elif "verilogName" in self.operation.attributes:
      del self.operation.attributes["verilogName"]

  @verilogName.deleter
  def verilogName(self):
    del self.operation.attributes["verilogName"]

  @builtins.property
  def body(self):
    return self.regions[0]

def module_generated(sym_name, generator_kind, module_type, parameters, *, per_port_attrs=None, port_locs=None, verilog_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HWModuleGeneratedOp(sym_name=sym_name, generatorKind=generator_kind, module_type=module_type, parameters=parameters, per_port_attrs=per_port_attrs, port_locs=port_locs, verilogName=verilog_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HWModuleOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.module"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, module_type, parameters, *, per_port_attrs=None, result_locs=None, comment=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["module_type"] = (module_type if (
    isinstance(module_type, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_554')) else
      _ods_ir.AttrBuilder.get('anonymous_554')(module_type, context=_ods_context))
    if per_port_attrs is not None: attributes["per_port_attrs"] = (per_port_attrs if (
        isinstance(per_port_attrs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('DictArrayAttr')) else
          _ods_ir.AttrBuilder.get('DictArrayAttr')(per_port_attrs, context=_ods_context))
    if result_locs is not None: attributes["result_locs"] = (result_locs if (
        isinstance(result_locs, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('LocationArrayAttr')) else
          _ods_ir.AttrBuilder.get('LocationArrayAttr')(result_locs, context=_ods_context))
    attributes["parameters"] = (parameters if (
    isinstance(parameters, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ParamDeclArrayAttr')) else
      _ods_ir.AttrBuilder.get('ParamDeclArrayAttr')(parameters, context=_ods_context))
    if comment is not None: attributes["comment"] = (comment if (
        isinstance(comment, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(comment, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def module_type(self):
    return self.operation.attributes["module_type"]

  @module_type.setter
  def module_type(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["module_type"] = value

  @builtins.property
  def per_port_attrs(self):
    if "per_port_attrs" not in self.operation.attributes:
      return None
    return self.operation.attributes["per_port_attrs"]

  @per_port_attrs.setter
  def per_port_attrs(self, value):
    if value is not None:
      self.operation.attributes["per_port_attrs"] = value
    elif "per_port_attrs" in self.operation.attributes:
      del self.operation.attributes["per_port_attrs"]

  @per_port_attrs.deleter
  def per_port_attrs(self):
    del self.operation.attributes["per_port_attrs"]

  @builtins.property
  def result_locs(self):
    if "result_locs" not in self.operation.attributes:
      return None
    return self.operation.attributes["result_locs"]

  @result_locs.setter
  def result_locs(self, value):
    if value is not None:
      self.operation.attributes["result_locs"] = value
    elif "result_locs" in self.operation.attributes:
      del self.operation.attributes["result_locs"]

  @result_locs.deleter
  def result_locs(self):
    del self.operation.attributes["result_locs"]

  @builtins.property
  def parameters(self):
    return self.operation.attributes["parameters"]

  @parameters.setter
  def parameters(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["parameters"] = value

  @builtins.property
  def comment(self):
    if "comment" not in self.operation.attributes:
      return None
    return self.operation.attributes["comment"]

  @comment.setter
  def comment(self, value):
    if value is not None:
      self.operation.attributes["comment"] = value
    elif "comment" in self.operation.attributes:
      del self.operation.attributes["comment"]

  @comment.deleter
  def comment(self):
    del self.operation.attributes["comment"]

  @builtins.property
  def body(self):
    return self.regions[0]

def module(sym_name, module_type, parameters, *, per_port_attrs=None, result_locs=None, comment=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HWModuleOp(sym_name=sym_name, module_type=module_type, parameters=parameters, per_port_attrs=per_port_attrs, result_locs=result_locs, comment=comment, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class HierPathOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.hierpath"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, namepath, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["namepath"] = (namepath if (
    isinstance(namepath, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('NameRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('NameRefArrayAttr')(namepath, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def namepath(self):
    return self.operation.attributes["namepath"]

  @namepath.setter
  def namepath(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["namepath"] = value

def hierpath(sym_name, namepath, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(HierPathOp(sym_name=sym_name, namepath=namepath, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InstanceChoiceOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.instance_choice"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, instanceName, moduleNames, optionName, caseNames, inputs, argNames, resultNames, parameters, *, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["instanceName"] = (instanceName if (
    isinstance(instanceName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(instanceName, context=_ods_context))
    attributes["moduleNames"] = (moduleNames if (
    isinstance(moduleNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefArrayAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefArrayAttr')(moduleNames, context=_ods_context))
    attributes["optionName"] = (optionName if (
    isinstance(optionName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(optionName, context=_ods_context))
    attributes["caseNames"] = (caseNames if (
    isinstance(caseNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(caseNames, context=_ods_context))
    attributes["argNames"] = (argNames if (
    isinstance(argNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(argNames, context=_ods_context))
    attributes["resultNames"] = (resultNames if (
    isinstance(resultNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(resultNames, context=_ods_context))
    attributes["parameters"] = (parameters if (
    isinstance(parameters, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ParamDeclArrayAttr')) else
      _ods_ir.AttrBuilder.get('ParamDeclArrayAttr')(parameters, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def instanceName(self):
    return self.operation.attributes["instanceName"]

  @instanceName.setter
  def instanceName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["instanceName"] = value

  @builtins.property
  def moduleNames(self):
    return self.operation.attributes["moduleNames"]

  @moduleNames.setter
  def moduleNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["moduleNames"] = value

  @builtins.property
  def optionName(self):
    return self.operation.attributes["optionName"]

  @optionName.setter
  def optionName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["optionName"] = value

  @builtins.property
  def caseNames(self):
    return self.operation.attributes["caseNames"]

  @caseNames.setter
  def caseNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["caseNames"] = value

  @builtins.property
  def argNames(self):
    return self.operation.attributes["argNames"]

  @argNames.setter
  def argNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["argNames"] = value

  @builtins.property
  def resultNames(self):
    return self.operation.attributes["resultNames"]

  @resultNames.setter
  def resultNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["resultNames"] = value

  @builtins.property
  def parameters(self):
    return self.operation.attributes["parameters"]

  @parameters.setter
  def parameters(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["parameters"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def instance_choice(results_, instance_name, module_names, option_name, case_names, inputs, arg_names, result_names, parameters, *, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InstanceChoiceOp(results_=results_, instanceName=instance_name, moduleNames=module_names, optionName=option_name, caseNames=case_names, inputs=inputs, argNames=arg_names, resultNames=result_names, parameters=parameters, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InstanceOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.instance"

  _ODS_REGIONS = (0, True)

  def __init__(self, results_, instanceName, moduleName, inputs, argNames, resultNames, parameters, *, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["instanceName"] = (instanceName if (
    isinstance(instanceName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrAttr')) else
      _ods_ir.AttrBuilder.get('StrAttr')(instanceName, context=_ods_context))
    attributes["moduleName"] = (moduleName if (
    isinstance(moduleName, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('FlatSymbolRefAttr')) else
      _ods_ir.AttrBuilder.get('FlatSymbolRefAttr')(moduleName, context=_ods_context))
    attributes["argNames"] = (argNames if (
    isinstance(argNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(argNames, context=_ods_context))
    attributes["resultNames"] = (resultNames if (
    isinstance(resultNames, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('StrArrayAttr')) else
      _ods_ir.AttrBuilder.get('StrArrayAttr')(resultNames, context=_ods_context))
    attributes["parameters"] = (parameters if (
    isinstance(parameters, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ParamDeclArrayAttr')) else
      _ods_ir.AttrBuilder.get('ParamDeclArrayAttr')(parameters, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.extend(results_)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def instanceName(self):
    return self.operation.attributes["instanceName"]

  @instanceName.setter
  def instanceName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["instanceName"] = value

  @builtins.property
  def moduleName(self):
    return self.operation.attributes["moduleName"]

  @moduleName.setter
  def moduleName(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["moduleName"] = value

  @builtins.property
  def argNames(self):
    return self.operation.attributes["argNames"]

  @argNames.setter
  def argNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["argNames"] = value

  @builtins.property
  def resultNames(self):
    return self.operation.attributes["resultNames"]

  @resultNames.setter
  def resultNames(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["resultNames"] = value

  @builtins.property
  def parameters(self):
    return self.operation.attributes["parameters"]

  @parameters.setter
  def parameters(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["parameters"] = value

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def results_(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def instance(results_, instance_name, module_name, inputs, arg_names, result_names, parameters, *, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(InstanceOp(results_=results_, instanceName=instance_name, moduleName=module_name, inputs=inputs, argNames=arg_names, resultNames=result_names, parameters=parameters, inner_sym=inner_sym, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class OutputOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.output"

  _ODS_REGIONS = (0, True)

  def __init__(self, outputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(outputs))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def outputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def output(outputs, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(OutputOp(outputs=outputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ParamValueOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.param.value"

  _ODS_REGIONS = (0, True)

  def __init__(self, value, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["value"] = (value if (
    isinstance(value, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('AnyAttr')) else
      _ods_ir.AttrBuilder.get('AnyAttr')(value, context=_ods_context))
    _ods_result_type_source_attr = attributes["value"]
    _ods_derived_result_type = (
        _ods_ir.TypeAttr(_ods_result_type_source_attr).value
        if _ods_ir.TypeAttr.isinstance(_ods_result_type_source_attr) else
        _ods_result_type_source_attr.type)
    results.extend([_ods_derived_result_type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def value(self):
    return self.operation.attributes["value"]

  @value.setter
  def value(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["value"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def param_value(value, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(ParamValueOp(value=value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StructCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.struct_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def struct_create(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StructCreateOp(result=result, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StructExplodeOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.struct_explode"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    results.extend(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def result(self):
    _ods_variadic_group_length = len(self.operation.results) - 1 + 1
    return self.operation.results[0:0 + _ods_variadic_group_length]

def struct_explode(result, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StructExplodeOp(result=result, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StructExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.struct_extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, input, fieldIndex, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fieldIndex"] = (fieldIndex if (
    isinstance(fieldIndex, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(fieldIndex, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def fieldIndex(self):
    return self.operation.attributes["fieldIndex"]

  @fieldIndex.setter
  def fieldIndex(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fieldIndex"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def struct_extract(result, input, field_index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StructExtractOp(result=result, input=input, fieldIndex=field_index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class StructInjectOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.struct_inject"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, fieldIndex, newValue, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    operands.append(_get_op_result_or_value(newValue))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fieldIndex"] = (fieldIndex if (
    isinstance(fieldIndex, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(fieldIndex, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def newValue(self):
    return self.operation.operands[1]

  @builtins.property
  def fieldIndex(self):
    return self.operation.attributes["fieldIndex"]

  @fieldIndex.setter
  def fieldIndex(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fieldIndex"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def struct_inject(input, field_index, new_value, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(StructInjectOp(input=input, fieldIndex=field_index, newValue=new_value, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TriggeredOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.triggered"

  _ODS_REGIONS = (1, True)

  def __init__(self, event, trigger, inputs, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(trigger))
    operands.extend(_get_op_results_or_values(inputs))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["event"] = (event if (
    isinstance(event, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('EventControlAttr')) else
      _ods_ir.AttrBuilder.get('EventControlAttr')(event, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def trigger(self):
    return self.operation.operands[0]

  @builtins.property
  def inputs(self):
    _ods_variadic_group_length = len(self.operation.operands) - 2 + 1
    return self.operation.operands[1:1 + _ods_variadic_group_length]

  @builtins.property
  def event(self):
    return self.operation.attributes["event"]

  @event.setter
  def event(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["event"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def triggered(event, trigger, inputs, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TriggeredOp(event=event, trigger=trigger, inputs=inputs, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TypeScopeOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.type_scope"

  _ODS_REGIONS = (1, True)

  def __init__(self, sym_name, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def type_scope(sym_name, *, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TypeScopeOp(sym_name=sym_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class TypedeclOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.typedecl"

  _ODS_REGIONS = (0, True)

  def __init__(self, sym_name, type_, *, verilogName=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["sym_name"] = (sym_name if (
    isinstance(sym_name, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('SymbolNameAttr')) else
      _ods_ir.AttrBuilder.get('SymbolNameAttr')(sym_name, context=_ods_context))
    attributes["type"] = (type_ if (
    isinstance(type_, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('TypeAttr')) else
      _ods_ir.AttrBuilder.get('TypeAttr')(type_, context=_ods_context))
    if verilogName is not None: attributes["verilogName"] = (verilogName if (
        isinstance(verilogName, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(verilogName, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def sym_name(self):
    return self.operation.attributes["sym_name"]

  @sym_name.setter
  def sym_name(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["sym_name"] = value

  @builtins.property
  def type_(self):
    return self.operation.attributes["type"]

  @type_.setter
  def type_(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["type"] = value

  @builtins.property
  def verilogName(self):
    if "verilogName" not in self.operation.attributes:
      return None
    return self.operation.attributes["verilogName"]

  @verilogName.setter
  def verilogName(self, value):
    if value is not None:
      self.operation.attributes["verilogName"] = value
    elif "verilogName" in self.operation.attributes:
      del self.operation.attributes["verilogName"]

  @verilogName.deleter
  def verilogName(self):
    del self.operation.attributes["verilogName"]

def typedecl(sym_name, type_, *, verilog_name=None, loc=None, ip=None) -> _ods_ir.Operation:
  return _get_op_result_or_op_results(TypedeclOp(sym_name=sym_name, type_=type_, verilogName=verilog_name, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnionCreateOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.union_create"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, fieldIndex, input, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fieldIndex"] = (fieldIndex if (
    isinstance(fieldIndex, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(fieldIndex, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def fieldIndex(self):
    return self.operation.attributes["fieldIndex"]

  @fieldIndex.setter
  def fieldIndex(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fieldIndex"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def union_create(result, field_index, input, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnionCreateOp(result=result, fieldIndex=field_index, input=input, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class UnionExtractOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.union_extract"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, fieldIndex, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["fieldIndex"] = (fieldIndex if (
    isinstance(fieldIndex, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(fieldIndex, context=_ods_context))
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def fieldIndex(self):
    return self.operation.attributes["fieldIndex"]

  @fieldIndex.setter
  def fieldIndex(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["fieldIndex"] = value

  @builtins.property
  def result(self):
    return self.operation.results[0]

def union_extract(input, field_index, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(UnionExtractOp(input=input, fieldIndex=field_index, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class WireOp(_ods_ir.OpView):
  OPERATION_NAME = "hw.wire"

  _ODS_REGIONS = (0, True)

  def __init__(self, input, *, name=None, inner_sym=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(_get_op_result_or_value(input))
    _ods_context = _ods_get_default_loc_context(loc)
    if name is not None: attributes["name"] = (name if (
        isinstance(name, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('StrAttr')) else
          _ods_ir.AttrBuilder.get('StrAttr')(name, context=_ods_context))
    if inner_sym is not None: attributes["inner_sym"] = (inner_sym if (
        isinstance(inner_sym, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('InnerSymAttr')) else
          _ods_ir.AttrBuilder.get('InnerSymAttr')(inner_sym, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.build_generic(attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip))

  @builtins.property
  def input(self):
    return self.operation.operands[0]

  @builtins.property
  def name(self):
    if "name" not in self.operation.attributes:
      return None
    return self.operation.attributes["name"]

  @name.setter
  def name(self, value):
    if value is not None:
      self.operation.attributes["name"] = value
    elif "name" in self.operation.attributes:
      del self.operation.attributes["name"]

  @name.deleter
  def name(self):
    del self.operation.attributes["name"]

  @builtins.property
  def inner_sym(self):
    if "inner_sym" not in self.operation.attributes:
      return None
    return self.operation.attributes["inner_sym"]

  @inner_sym.setter
  def inner_sym(self, value):
    if value is not None:
      self.operation.attributes["inner_sym"] = value
    elif "inner_sym" in self.operation.attributes:
      del self.operation.attributes["inner_sym"]

  @inner_sym.deleter
  def inner_sym(self):
    del self.operation.attributes["inner_sym"]

  @builtins.property
  def result(self):
    return self.operation.results[0]

def wire(input, *, name=None, inner_sym=None, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(WireOp(input=input, name=name, inner_sym=inner_sym, loc=loc, ip=ip))
