# generated by datamodel-codegen:
#   filename:  openapi.public.json

from __future__ import annotations

from datetime import datetime
from enum import Enum
from typing import Annotated, Any, Dict, List, Literal, Optional, Union

from pydantic import BaseModel, Field, RootModel


class PodItemReference(BaseModel):
    orderId: str
    itemId: str


class SeriesPrefix(Enum):
    BOOK = "BOOK"
    ISSUE = "ISSUE"
    NUMBER = "NUMBER"
    VOLUME = "VOLUME"
    EDITION = "EDITION"


class SeriesStatus(Enum):
    ACTIVE = "ACTIVE"
    INACTIVE = "INACTIVE"


class Relationship(Enum):
    ALTERNATIVE_ENDING = "ALTERNATIVE_ENDING"
    CROSSOVER_CONTENT = "CROSSOVER_CONTENT"
    NOVELLA = "NOVELLA"
    PREQUEL = "PREQUEL"
    SHORT_STORY = "SHORT_STORY"
    OTHER = "OTHER"


class SeriesRelatedContent(BaseModel):
    reference: PodItemReference
    relationship: Annotated[
        Relationship,
        Field(
            description="How the publication relates to the series. This only applies to Related Content.",
            examples=["PREQUEL"],
        ),
    ]


class ArtworkError(BaseModel):
    filename: Annotated[
        str,
        Field(
            description="The filename of the artwork file with the error",
            examples=["cover.pdf"],
        ),
    ]
    page: Annotated[
        int,
        Field(
            description="The page number where the error was detected",
            examples=[1],
            ge=1,
        ),
    ]
    message: Annotated[
        str,
        Field(description="Detected artwork error", examples=["Invalid color profile"]),
    ]


class DateTimestamp(BaseModel):
    date: Annotated[
        Optional[str],
        Field(
            description="Date object representing the date",
            examples=["2023-05-01T08:00:00.000Z"],
        ),
    ] = None
    timestamp: Annotated[
        Optional[datetime], Field(description="Timestamp in milliseconds since epoch")
    ] = None


class ItemSource(Enum):
    API = "API"
    PEPPER = "PEPPER"
    ADOBE_EXPRESS = "ADOBE_EXPRESS"


class ExternalItemMetadata(BaseModel):
    externalItemId: Annotated[
        str,
        Field(
            description="The unique identifier for the external item",
            examples=["ITEM-123456"],
        ),
    ]
    itemSource: Annotated[
        ItemSource, Field(description="The source of the order", examples=["API"])
    ]


class ExternalOrderMetadata(BaseModel):
    externalOrderId: Annotated[
        str,
        Field(
            description="The unique identifier for the external order",
            examples=["ORDER-123456"],
        ),
    ]
    statusCallbackUrl: Annotated[
        str,
        Field(
            description="URL to send status callbacks",
            examples=["https://example.com/callback"],
        ),
    ]


class ItemStatus(BaseModel):
    itemId: Annotated[
        str,
        Field(description="The ID of the item", examples=["667c0ef90b4b5b505b546af9"]),
    ]
    metadata: ExternalItemMetadata
    errors: Optional[List[ArtworkError]] = None
    hasErrors: Optional[bool] = None


class Status(Enum):
    INIT = "INIT"
    PENDING = "PENDING"
    RIPE = "RIPE"
    ONHOLD = "ONHOLD"
    LOCKED = "LOCKED"
    PROOF = "PROOF"
    CONFIRMED = "CONFIRMED"
    INPRODUCTION = "INPRODUCTION"
    ACCEPTED = "ACCEPTED"
    DISPATCHED = "DISPATCHED"
    CLOSED = "CLOSED"
    CANCELED = "CANCELED"


class ShipmentSummary(BaseModel):
    itemsInShipment: Annotated[
        Dict[str, int],
        Field(
            description="Map of items in the shipment with their quantities",
            examples=[{"item1": 10, "item2": 5}],
        ),
    ]
    trackingUrl: Annotated[
        Optional[str],
        Field(
            description="URL for tracking the shipment",
            examples=["http://trackingurl.com/track?12345"],
        ),
    ] = None
    consignmentNumber: Annotated[
        Optional[str],
        Field(
            description="Consignment number for the shipment", examples=["CN123456789"]
        ),
    ] = None
    courier: Annotated[
        Optional[str],
        Field(description="Name of the courier service", examples=["DHL"]),
    ] = None
    parcelNumbers: Optional[List[str]] = None
    date: DateTimestamp


class LocationType(Enum):
    business_dock = "business dock"
    business_no_dock = "business no dock"
    residential = "residential"
    limited_access = "limited access"
    trade_show = "trade show"
    construction = "construction"
    farm = "farm"


class Address(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier for the address.",
            examples=["507f1f77bcf86cd799439011"],
        ),
    ] = None
    firstName: Annotated[
        str, Field(description="First name of the person.", examples=["Sherlock"])
    ]
    lastName: Annotated[
        str, Field(description="Last name of the person.", examples=["Holmes"])
    ]
    postcode: Annotated[
        str,
        Field(description="Postcode or Zipcode of the address.", examples=["NW1 6XE"]),
    ]
    line1: Annotated[
        str,
        Field(description="First line of the address.", examples=["221B Baker Street"]),
    ]
    line2: Annotated[
        Optional[str], Field(description="Second line of the address.")
    ] = None
    line3: Annotated[Optional[str], Field(description="Third line of the address.")] = (
        None
    )
    town: Annotated[
        str, Field(description="Town or city of the address.", examples=["London"])
    ]
    county: Annotated[
        Optional[str],
        Field(
            description="County, State, or Region of the address.",
            examples=["Marylebone"],
        ),
    ] = None
    country: Annotated[str, Field(description="ISO2 Country Code", examples=["GB"])]
    phone: Annotated[
        str,
        Field(
            description="Phone number associated with the address.",
            examples=["+44 20 7224 3688"],
        ),
    ]
    company: Annotated[
        Optional[str],
        Field(
            description="Company name associated with the address.",
            examples=["Holmes Investigations"],
        ),
    ] = None
    instructions: Annotated[
        Optional[str],
        Field(
            description="Special instructions for the address.",
            examples=["Leave with the doorman if not available."],
        ),
    ] = None
    email: Annotated[
        Optional[str],
        Field(
            description="Email address associated with the address.",
            examples=["sherlock.holmes@example.com"],
        ),
    ] = None
    locationType: Annotated[
        Optional[LocationType],
        Field(
            description="Enumeration of possible location types for an address.",
            examples=["residential"],
        ),
    ] = None
    valid: Optional[bool] = None
    postBox: Optional[bool] = None


class Author(BaseModel):
    name: Annotated[
        str, Field(description="Name of the author.", examples=["Arthur Conan Doyle"])
    ]
    imageUrl: Annotated[
        Optional[str],
        Field(
            description="URL to the author's image.",
            examples=["https://example.com/images/arthur-conan-doyle.jpg"],
        ),
    ] = None
    bio: Annotated[
        Optional[str],
        Field(
            description="Biography of the author, up to 2048 characters.",
            examples=[
                "Arthur Conan Doyle was a British writer, best known for his detective fiction featuring the character Sherlock Holmes."
            ],
            max_length=2048,
            min_length=0,
        ),
    ] = None


class Type(Enum):
    STAPLED = "STAPLED"
    PERFECT = "PERFECT"
    PUR = "PUR"
    CASE = "CASE"
    WIRO = "WIRO"
    LOOP = "LOOP"
    CALENDAR_WIRO = "CALENDAR_WIRO"
    SMYTH_SEWN = "SMYTH_SEWN"
    COIL = "COIL"


class Edge(Enum):
    LEFT_RIGHT = "LEFT_RIGHT"
    TOP_BOTTOM = "TOP_BOTTOM"


class Colour(Enum):
    BLACK = "BLACK"
    WHITE = "WHITE"
    SILVER = "SILVER"
    GRAY = "GRAY"
    CLEAR = "CLEAR"
    RED = "RED"
    BLUE = "BLUE"
    REFLEX_BLUE = "REFLEX_BLUE"
    YELLOW = "YELLOW"
    COLLEGE_ORANGE = "COLLEGE_ORANGE"
    RED_WINE = "RED_WINE"
    BURGUNDY = "BURGUNDY"
    PINK = "PINK"
    PASTEL_PINK = "PASTEL_PINK"
    FUSCHIA = "FUSCHIA"
    NAVY_BLUE = "NAVY_BLUE"
    PASTEL_BLUE = "PASTEL_BLUE"
    ROYAL_BLUE = "ROYAL_BLUE"
    TEAL = "TEAL"
    MEDIUM_GREEN = "MEDIUM_GREEN"
    PASTEL_GREEN = "PASTEL_GREEN"
    APPLE_GREEN = "APPLE_GREEN"
    PEARL_GREY = "PEARL_GREY"
    DARK_BROWN = "DARK_BROWN"
    PASTEL_BEIGE = "PASTEL_BEIGE"
    CHOCOLATE_BROWN = "CHOCOLATE_BROWN"
    NEON_GREEN = "NEON_GREEN"
    ORANGE = "ORANGE"
    NEON_PINK = "NEON_PINK"
    NEON_ORANGE = "NEON_ORANGE"
    WARM_RED = "WARM_RED"
    PURPLE = "PURPLE"
    VIOLET = "VIOLET"
    FOREST_GREEN = "FOREST_GREEN"
    DARK_GREEN = "DARK_GREEN"
    GOLD = "GOLD"


class Loops(Enum):
    TWO_LOOPS = "TWO_LOOPS"
    FOUR_LOOPS = "FOUR_LOOPS"


class HeadAndTailBands(Enum):
    NONE = "NONE"
    NAVY_BLUE_AND_WHITE = "NAVY_BLUE_AND_WHITE"
    BLACK_AND_GREEN = "BLACK_AND_GREEN"
    RED_AND_BLACK = "RED_AND_BLACK"
    PURPLE_AND_WHITE = "PURPLE_AND_WHITE"
    RED_AND_GREY = "RED_AND_GREY"
    RED_AND_WHITE = "RED_AND_WHITE"
    YELLOW_AND_BROWN = "YELLOW_AND_BROWN"
    DARK_BROWN_AND_WHITE = "DARK_BROWN_AND_WHITE"
    BLUE_AND_YELLOW = "BLUE_AND_YELLOW"
    RED_AND_GREEN = "RED_AND_GREEN"
    YELLOW_AND_GREEN = "YELLOW_AND_GREEN"
    BLUE_AND_WHITE = "BLUE_AND_WHITE"
    DARK_BLUE_AND_WHITE = "DARK_BLUE_AND_WHITE"
    RED_AND_YELLOW = "RED_AND_YELLOW"
    MAROON_AND_WHITE = "MAROON_AND_WHITE"
    YELLOW_AND_BLACK = "YELLOW_AND_BLACK"
    GREEN_AND_WHITE = "GREEN_AND_WHITE"
    BLACK_AND_WHITE = "BLACK_AND_WHITE"
    DARK_GREEN_AND_BLACK = "DARK_GREEN_AND_BLACK"
    DARK_GREEN_AND_WHITE = "DARK_GREEN_AND_WHITE"
    RED = "RED"
    BLACK = "BLACK"
    GREY = "GREY"
    WHITE = "WHITE"
    DARK_BLUE = "DARK_BLUE"
    YELLOW = "YELLOW"


class Binding(BaseModel):
    type: Annotated[
        Type, Field(description="Enumeration of Binding Types", examples=["STAPLED"])
    ]
    edge: Annotated[
        Edge,
        Field(
            description="Enumeration of binding edges for a bound component",
            examples=["LEFT_RIGHT"],
        ),
    ] = "LEFT_RIGHT"
    sewn: Annotated[
        bool,
        Field(
            description="Whether the binding is sewn. Only applicable to case bound books",
            examples=[False],
        ),
    ]
    colour: Annotated[
        Colour,
        Field(
            description="Enumeration of binding colours for a wiro or coil bound item",
            examples=["BLACK"],
        ),
    ] = "BLACK"
    loops: Annotated[
        Loops,
        Field(
            description="Enumeration of binding loops for a bound item",
            examples=["TWO_LOOPS"],
        ),
    ] = "TWO_LOOPS"
    headAndTailBands: Annotated[
        HeadAndTailBands,
        Field(description="Enumeration of head and tail bands.", examples=["NONE"]),
    ] = "NONE"


class Lamination(Enum):
    NONE = "NONE"
    MATT = "MATT"
    GLOSS = "GLOSS"
    SOFT = "SOFT"
    UV_MATT = "UV_MATT"
    UV_GLOSS = "UV_GLOSS"
    SPOT_UV_MATT = "SPOT_UV_MATT"
    SPOT_UV_GLOSS = "SPOT_UV_GLOSS"
    SPOT_3D_UV_MATT = "SPOT_3D_UV_MATT"
    SPOT_3D_UV_GLOSS = "SPOT_3D_UV_GLOSS"
    MATT_SPOT_UV = "MATT_SPOT_UV"
    MATT_ANTI_SCUFF = "MATT_ANTI_SCUFF"


class RibbonColour(Enum):
    NONE = "NONE"
    WHITE = "WHITE"
    CREAM = "CREAM"
    GOLD = "GOLD"
    ORANGE = "ORANGE"
    RED = "RED"
    MAROON = "MAROON"
    PINK = "PINK"
    PURPLE = "PURPLE"
    LIGHT_BLUE = "LIGHT_BLUE"
    BLUE = "BLUE"
    NAVY_BLUE = "NAVY_BLUE"
    GREEN = "GREEN"
    DARK_GREEN = "DARK_GREEN"
    GREY = "GREY"
    BLACK = "BLACK"


class ComponentType(Enum):
    FLAT = "FLAT"
    FOLDED = "FOLDED"
    BOUND = "BOUND"
    COVER = "COVER"
    END_PAPERS = "END_PAPERS"
    DUST_JACKET = "DUST_JACKET"
    FRAMED = "FRAMED"
    ENVELOPE = "ENVELOPE"
    SHRINK_WRAP = "SHRINK_WRAP"
    SAMPLE_PACK = "SAMPLE_PACK"


class Colours(Enum):
    NONE = "NONE"
    PROCESS = "PROCESS"
    GRAYSCALE = "GRAYSCALE"


class Orientation(Enum):
    PORTRAIT = "PORTRAIT"
    LANDSCAPE = "LANDSCAPE"


class PreDrilledHoles(Enum):
    NONE = "NONE"
    ONE_HOLE_OPPOSITE_BINDING_CENTER = "ONE_HOLE_OPPOSITE_BINDING_CENTER"
    ONE_HOLE_TOP_CENTER = "ONE_HOLE_TOP_CENTER"


class StandardSize(Enum):
    NONE = "NONE"
    MM_10_X_30 = "MM_10_X_30"
    MM_15_X_35 = "MM_15_X_35"
    MM_15_X_45 = "MM_15_X_45"
    MM_20_X_40 = "MM_20_X_40"
    MM_20_X_50 = "MM_20_X_50"
    MM_21_X_68 = "MM_21_X_68"
    MM_25_X_50 = "MM_25_X_50"
    MM_30_X_70 = "MM_30_X_70"
    MM_35_X_105 = "MM_35_X_105"
    MM_35_X_210 = "MM_35_X_210"
    MM_35_X_316 = "MM_35_X_316"
    MM_40_X_50 = "MM_40_X_50"
    MM_48_X_70 = "MM_48_X_70"
    MM_51_X_298 = "MM_51_X_298"
    MM_51_X_420 = "MM_51_X_420"
    MM_52_X_210 = "MM_52_X_210"
    MM_55_X_85 = "MM_55_X_85"
    MM_55_X_148 = "MM_55_X_148"
    MM_55_X_173 = "MM_55_X_173"
    MM_71_X_96 = "MM_71_X_96"
    MM_95_X_145 = "MM_95_X_145"
    MM_95_X_45 = "MM_95_X_45"
    MM_95_X_210 = "MM_95_X_210"
    MM_98_X_210 = "MM_98_X_210"
    MM_98_X_420 = "MM_98_X_420"
    MM_105_X_297 = "MM_105_X_297"
    MM_120_X_125 = "MM_120_X_125"
    MM_124_X_140 = "MM_124_X_140"
    MM_130_X_150 = "MM_130_X_150"
    MM_130_X_190 = "MM_130_X_190"
    MM_135_X_210 = "MM_135_X_210"
    MM_138_X_297 = "MM_138_X_297"
    MM_140_X_297 = "MM_140_X_297"
    MM_150_X_265 = "MM_150_X_265"
    MM_160_X_240 = "MM_160_X_240"
    MM_168_X_240 = "MM_168_X_240"
    MM_170_X_240 = "MM_170_X_240"
    MM_170_X_590 = "MM_170_X_590"
    MM_183_X_273 = "MM_183_X_273"
    MM_193_X_260 = "MM_193_X_260"
    MM_199_X_210 = "MM_199_X_210"
    MM_200_X_200 = "MM_200_X_200"
    MM_210_X_280 = "MM_210_X_280"
    MM_200_X_250 = "MM_200_X_250"
    MM_240_X_340 = "MM_240_X_340"
    MM_200_X_300 = "MM_200_X_300"
    MM_200_X_600 = "MM_200_X_600"
    MM_300_X_300 = "MM_300_X_300"
    MM_300_X_400 = "MM_300_X_400"
    MM_300_X_600 = "MM_300_X_600"
    MM_300_X_800 = "MM_300_X_800"
    MM_300_X_1000 = "MM_300_X_1000"
    MM_400_X_400 = "MM_400_X_400"
    MM_400_X_500 = "MM_400_X_500"
    MM_400_X_600 = "MM_400_X_600"
    MM_400_X_1500 = "MM_400_X_1500"
    MM_500_X_500 = "MM_500_X_500"
    MM_500_X_600 = "MM_500_X_600"
    MM_500_X_700 = "MM_500_X_700"
    MM_500_X_750 = "MM_500_X_750"
    MM_500_X_1000 = "MM_500_X_1000"
    MM_600_X_600 = "MM_600_X_600"
    MM_600_X_750 = "MM_600_X_750"
    MM_600_X_800 = "MM_600_X_800"
    MM_750_X_750 = "MM_750_X_750"
    MM_750_X_1000 = "MM_750_X_1000"
    MM_800_X_1200 = "MM_800_X_1200"
    MM_895_X_1280 = "MM_895_X_1280"
    MM_700_X_1000 = "MM_700_X_1000"
    MM_1000_X_1000 = "MM_1000_X_1000"
    MM_1000_X_1400 = "MM_1000_X_1400"
    MM_1000_X_1200 = "MM_1000_X_1200"
    MM_1000_X_1500 = "MM_1000_X_1500"
    MM_1000_X_2000 = "MM_1000_X_2000"
    MM_1185_X_1750 = "MM_1185_X_1750"
    MM_135_X_205 = "MM_135_X_205"
    MM_125_X_190 = "MM_125_X_190"
    MM_115_X_185 = "MM_115_X_185"
    MM_114_X_172 = "MM_114_X_172"
    MM_148_X_156 = "MM_148_X_156"
    MM_294_X_300 = "MM_294_X_300"
    MM_120_X_190 = "MM_120_X_190"
    IN_2_X_3_5 = "IN_2_X_3_5"
    IN_2_X_6 = "IN_2_X_6"
    IN_2_X_8 = "IN_2_X_8"
    IN_3_X_4 = "IN_3_X_4"
    IN_3_5_X_8_5 = "IN_3_5_X_8_5"
    IN_3_66_X_4_25 = "IN_3_66_X_4_25"
    IN_4_X_4 = "IN_4_X_4"
    IN_4_X_6 = "IN_4_X_6"
    IN_4_X_9 = "IN_4_X_9"
    IN_4_125_X_5_875 = "IN_4_125_X_5_875"
    IN_4_25_X_55 = "IN_4_25_X_55"
    IN_4_25_X_6_87 = "IN_4_25_X_6_87"
    IN_4_25_X_11 = "IN_4_25_X_11"
    IN_5_X_7 = "IN_5_X_7"
    IN_5_X_8 = "IN_5_X_8"
    IN_5_06_X_7_81 = "IN_5_06_X_7_81"
    IN_5_125X_7 = "IN_5_125X_7"
    IN_5_25_X_8 = "IN_5_25_X_8"
    IN_5_25_X_8_375 = "IN_5_25_X_8_375"
    IN_5_375_X_8_375 = "IN_5_375_X_8_375"
    IN_5_5_X_8_5 = "IN_5_5_X_8_5"
    IN_5_5_X_10 = "IN_5_5_X_10"
    IN_5_8_X_9_25 = "IN_5_8_X_9_25"
    IN_6_X_8 = "IN_6_X_8"
    IN_6_63_X_10_25 = "IN_6_63_X_10_25"
    IN_6_X_9 = "IN_6_X_9"
    IN_6_X_11 = "IN_6_X_11"
    IN_6_14_X_9_21 = "IN_6_14_X_9_21"
    IN_6_69_X_9_61 = "IN_6_69_X_9_61"
    IN_7_X_8_5 = "IN_7_X_8_5"
    IN_7_X_9 = "IN_7_X_9"
    IN_7_X_10 = "IN_7_X_10"
    IN_7_25_X_9_5 = "IN_7_25_X_9_5"
    IN_7_44_X_9_69 = "IN_7_44_X_9_69"
    IN_7_5_X_8_5 = "IN_7_5_X_8_5"
    IN_7_5_X_9_25 = "IN_7_5_X_9_25"
    IN_8_X_10 = "IN_8_X_10"
    IN_8_X_11 = "IN_8_X_11"
    IN_8_X_12 = "IN_8_X_12"
    IN_8_25_X_6 = "IN_8_25_X_6"
    IN_8_375_X_10_875 = "IN_8_375_X_10_875"
    IN_8_5_X_3_5 = "IN_8_5_X_3_5"
    IN_8_5_X_5_5 = "IN_8_5_X_5_5"
    IN_8_5_X_11 = "IN_8_5_X_11"
    IN_8_5_X_14 = "IN_8_5_X_14"
    IN_8_5_X_17 = "IN_8_5_X_17"
    IN_8_5_X_22 = "IN_8_5_X_22"
    IN_8_75_X_11 = "IN_8_75_X_11"
    IN_9_X_12 = "IN_9_X_12"
    IN_9_X_16 = "IN_9_X_16"
    IN_9_5_X_12 = "IN_9_5_X_12"
    IN_10_X_15 = "IN_10_X_15"
    IN_11_X_14 = "IN_11_X_14"
    IN_11_X_17 = "IN_11_X_17"
    IN_11_X_25_5 = "IN_11_X_25_5"
    IN_11_5_X_17_5 = "IN_11_5_X_17_5"
    IN_12_X_16 = "IN_12_X_16"
    IN_12_X_18 = "IN_12_X_18"
    IN_13_X_19 = "IN_13_X_19"
    IN_17_X_22 = "IN_17_X_22"
    IN_18_X_24 = "IN_18_X_24"
    IN_19_X_27 = "IN_19_X_27"
    IN_20_X_30 = "IN_20_X_30"
    IN_24_X_36 = "IN_24_X_36"
    IN_26_X_39 = "IN_26_X_39"
    IN_30_X_40 = "IN_30_X_40"
    IN_40_X_60 = "IN_40_X_60"
    SQUARE_10_MM = "SQUARE_10_MM"
    SQUARE_15_MM = "SQUARE_15_MM"
    SQUARE_20_MM = "SQUARE_20_MM"
    SQUARE_21_MM = "SQUARE_21_MM"
    SQUARE_25_MM = "SQUARE_25_MM"
    SQUARE_30_MM = "SQUARE_30_MM"
    SQUARE_35_MM = "SQUARE_35_MM"
    SQUARE_40_MM = "SQUARE_40_MM"
    SQUARE_45_MM = "SQUARE_45_MM"
    SQUARE_50_MM = "SQUARE_50_MM"
    SQUARE_55_MM = "SQUARE_55_MM"
    SQUARE_60_MM = "SQUARE_60_MM"
    SQUARE_70_MM = "SQUARE_70_MM"
    SQUARE_80_MM = "SQUARE_80_MM"
    SQUARE_95_MM = "SQUARE_95_MM"
    SQUARE_98_MM = "SQUARE_98_MM"
    SQUARE_100_MM = "SQUARE_100_MM"
    SQUARE_105_MM = "SQUARE_105_MM"
    SQUARE_120_MM = "SQUARE_120_MM"
    SQUARE_140_MM = "SQUARE_140_MM"
    SQUARE_148_MM = "SQUARE_148_MM"
    SQUARE_210_MM = "SQUARE_210_MM"
    SQUARE_280_MM = "SQUARE_280_MM"
    SQUARE_297_MM = "SQUARE_297_MM"
    SQUARE_4_75_IN = "SQUARE_4_75_IN"
    SQUARE_6_IN = "SQUARE_6_IN"
    SQUARE_7_IN = "SQUARE_7_IN"
    SQUARE_7_5_IN = "SQUARE_7_5_IN"
    SQUARE_8_IN = "SQUARE_8_IN"
    SQUARE_8_25_IN = "SQUARE_8_25_IN"
    SQUARE_8_5_IN = "SQUARE_8_5_IN"
    SQUARE_12_IN = "SQUARE_12_IN"
    SQUARE_10_IN = "SQUARE_10_IN"
    SQUARE_11_8_IN = "SQUARE_11_8_IN"
    ENVELOPE_C5 = "ENVELOPE_C5"
    ENVELOPE_C4 = "ENVELOPE_C4"
    ENVELOPE_DL = "ENVELOPE_DL"
    A1_LONG = "A1_LONG"
    A2_LONG = "A2_LONG"
    A5_LONG = "A5_LONG"
    A6_LONG = "A6_LONG"
    A7_LONG = "A7_LONG"
    A7_MINI = "A7_MINI"
    AB = "AB"
    B0 = "B0"
    B1 = "B1"
    B2 = "B2"
    B5 = "B5"
    B6 = "B6"
    DL = "DL"
    DL_SMALL_99_MM = "DL_SMALL_99_MM"
    DL_SMALL_100_MM = "DL_SMALL_100_MM"
    BUSINESS_CARD = "BUSINESS_CARD"
    BUSINESS_CARD_2 = "BUSINESS_CARD_2"
    BUSINESS_CARD_3 = "BUSINESS_CARD_3"
    UK_STANDARD = "UK_STANDARD"
    US_STANDARD = "US_STANDARD"
    US_TRADE = "US_TRADE"
    US_BUSINESS_CARD = "US_BUSINESS_CARD"
    US_POSTCARD_550 = "US_POSTCARD_550"
    US_POSTCARD_425 = "US_POSTCARD_425"
    MANGA_STANDARD = "MANGA_STANDARD"
    B_FORMAT_UK = "B_FORMAT_UK"
    PINCHED_CROWN_QUARTO = "PINCHED_CROWN_QUARTO"
    CROWN_QUARTO = "CROWN_QUARTO"
    NOVEL = "NOVEL"
    STANDARD_BOOK = "STANDARD_BOOK"
    DEMY = "DEMY"
    SILVER_AGE = "SILVER_AGE"
    GOLDEN_AGE = "GOLDEN_AGE"
    JIS_B5 = "JIS_B5"
    JIS_B40 = "JIS_B40"
    HAN_46 = "HAN_46"
    HOBONICHI = "HOBONICHI"
    US_ROYAL = "US_ROYAL"
    ROYAL = "ROYAL"
    KITCHEN = "KITCHEN"


class BackColours(Enum):
    NONE = "NONE"
    PROCESS = "PROCESS"
    GRAYSCALE = "GRAYSCALE"


class BackLamination(Enum):
    NONE = "NONE"
    MATT = "MATT"
    GLOSS = "GLOSS"
    SOFT = "SOFT"
    UV_MATT = "UV_MATT"
    UV_GLOSS = "UV_GLOSS"
    SPOT_UV_MATT = "SPOT_UV_MATT"
    SPOT_UV_GLOSS = "SPOT_UV_GLOSS"
    SPOT_3D_UV_MATT = "SPOT_3D_UV_MATT"
    SPOT_3D_UV_GLOSS = "SPOT_3D_UV_GLOSS"
    MATT_SPOT_UV = "MATT_SPOT_UV"
    MATT_ANTI_SCUFF = "MATT_ANTI_SCUFF"


class CoverArea(Enum):
    FRONT_AND_BACK = "FRONT_AND_BACK"
    FRONT_ONLY = "FRONT_ONLY"


class UnitFormat(Enum):
    field_0 = "0"
    field_1 = "1"


class CustomSize(BaseModel):
    unitFormat: Annotated[
        UnitFormat,
        Field(
            description="Unit format used for the custom size. METRIC (mm) is 0, IMPERIAL (in) is 1",
            examples=["0"],
        ),
    ] = "0"
    width: Annotated[
        float, Field(description="Width of the custom size", examples=[210.0])
    ]
    height: Annotated[
        float, Field(description="Height of the custom size", examples=[297.0])
    ]


class DeliveryGroupSummary(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="The unique identifier of the delivery group summary",
            examples=["7bb49fd6-57ad-4a0a-b61f-2dde2f592feb"],
        ),
    ] = None
    itemIds: Annotated[
        Optional[List[str]], Field(description="List of item IDs in the delivery group")
    ] = None
    serviceId: Annotated[
        Optional[str],
        Field(
            description="The ID for the delivery. This encompasses both the courier & the service code",
            examples=["DHL-DHL_EXPRESS_DOMESTIC-zxa-1"],
        ),
    ] = None
    courier: Annotated[
        Optional[str],
        Field(description="The courier used for delivery", examples=["DHL"]),
    ] = None
    courierCode: Annotated[
        Optional[str],
        Field(description="The courier code used for delivery", examples=["DHL"]),
    ] = None
    service: Annotated[
        Optional[str],
        Field(
            description="The service used for delivery",
            examples=["DHL Express Domestic"],
        ),
    ] = None
    serviceCode: Annotated[
        Optional[str],
        Field(description="The service code used for delivery", examples=["N"]),
    ] = None
    cost: Annotated[
        Optional[float], Field(description="The cost of the delivery", examples=[6.99])
    ] = None
    weight: Annotated[
        Optional[float], Field(description="The weight of the delivery", examples=[1.9])
    ] = None
    dispatchDate: Optional[DateTimestamp] = None
    deliveryDate: Optional[DateTimestamp] = None
    includeShipment: Annotated[
        Optional[bool],
        Field(
            description="Indicates if the shipping cost was included in the item price"
        ),
    ] = None
    locationType: Annotated[
        Optional[LocationType],
        Field(description="Enumeration of possible location types for an address."),
    ] = None


class DeliverySummary(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="The unique identifier of the delivery",
            examples=["b02b892c-b70a-44bd-a438-35a326cde438"],
        ),
    ] = None
    deliveryAddress: Address
    quantitiesOfItems: Annotated[
        Dict[str, Any],
        Field(
            description="A map of item IDs to their quantities in the delivery",
            examples=[{"4c59f364-5af1-43ed-bc77-1639a0186ab0": 1000}],
        ),
    ]
    deliveryGroups: Annotated[
        Optional[List[DeliveryGroupSummary]],
        Field(description="A list of delivery group summaries"),
    ] = None
    taxAmount: Annotated[
        Optional[float], Field(description="The total tax for the delivery")
    ] = None
    taxRate: Annotated[
        Optional[float], Field(description="The tax rate for the delivery")
    ] = None
    taxProvince: Annotated[
        Optional[str],
        Field(
            description="The province or state where the state tax is applied. This is mainly for US orders where tax has to be calculated on a per state basis"
        ),
    ] = None


class SizeFormat(Enum):
    field_0 = "0"
    field_1 = "1"


class Dimensions(BaseModel):
    top: Optional[float] = None
    left: Optional[float] = None
    width: Optional[float] = None
    height: Optional[float] = None
    count: Optional[int] = None
    sizeFormat: Optional[SizeFormat] = None


class DisputeAttachment(BaseModel):
    name: Optional[str] = None
    url: Optional[str] = None
    thumbnail: Optional[str] = None
    size: Optional[int] = None


class FlapWidth(Enum):
    AUTOMATIC = "AUTOMATIC"
    CUSTOM = "CUSTOM"
    MM_60 = "MM_60"
    MM_80 = "MM_80"
    IN_2_5 = "IN_2_5"
    IN_3_5 = "IN_3_5"
    PERCENT_50 = "PERCENT_50"


class Embellishments(BaseModel):
    spotUv: Annotated[
        Optional[bool],
        Field(
            description="True if the component requires Spot UV, otherwise false",
            examples=[True],
        ),
    ] = None


class Foiling(BaseModel):
    gold: Annotated[
        bool,
        Field(description="Indicates if gold foiling is applied.", examples=[False]),
    ] = False
    silver: Annotated[
        bool,
        Field(description="Indicates if silver foiling is applied.", examples=[False]),
    ] = False
    copper: Annotated[
        bool,
        Field(description="Indicates if copper foiling is applied.", examples=[False]),
    ] = False
    red: Annotated[
        bool,
        Field(description="Indicates if red foiling is applied.", examples=[False]),
    ] = False
    blue: Annotated[
        bool,
        Field(description="Indicates if blue foiling is applied.", examples=[False]),
    ] = False
    green: Annotated[
        bool,
        Field(description="Indicates if green foiling is applied.", examples=[False]),
    ] = False
    value: Optional[str] = None


class SimpleFold(Enum):
    NONE = "NONE"
    HALF = "HALF"
    ROLE = "ROLE"
    Z = "Z"
    GATE = "GATE"
    CROSS = "CROSS"
    PARALLEL = "PARALLEL"
    ENVELOPE = "ENVELOPE"


class FrameDepth(Enum):
    UNSPECIFIED = "UNSPECIFIED"
    MM_18 = "MM_18"
    MM_38 = "MM_38"


class Border(Enum):
    WRAP_AROUND = "WRAP_AROUND"
    EDGE_TO_EDGE = "EDGE_TO_EDGE"
    PADDED = "PADDED"


class UseCase(Enum):
    PROMOTION = "PROMOTION"
    REWARDS = "REWARDS"


class ItemDiscountCodeExtendedReference(BaseModel):
    discountCodeId: Optional[str] = None
    discountCode: Optional[str] = None
    totalDiscount: Optional[float] = None
    useCase: Optional[UseCase] = None


class Product(Enum):
    BROCHURES = "BROCHURES"
    FLYERS = "FLYERS"
    FOLDED_LEAFLETS = "FOLDED_LEAFLETS"
    POSTERS = "POSTERS"
    LETTERHEADS = "LETTERHEADS"
    BOOK = "BOOK"
    BUSINESS_CARDS = "BUSINESS_CARDS"
    POSTCARDS = "POSTCARDS"
    GREETING_CARDS = "GREETING_CARDS"
    NOTE_BOOKS = "NOTE_BOOKS"
    COMPLIMENT_SLIPS = "COMPLIMENT_SLIPS"
    ENVELOPES = "ENVELOPES"
    LAYFLAT_BOOKS = "LAYFLAT_BOOKS"
    WALL_CALENDARS = "WALL_CALENDARS"
    DESK_CALENDARS = "DESK_CALENDARS"
    VR_WALL_CALENDARS = "VR_WALL_CALENDARS"
    VR_DESK_CALENDARS = "VR_DESK_CALENDARS"
    CANVAS = "CANVAS"
    DUST_JACKET = "DUST_JACKET"
    SAMPLE_PACK = "SAMPLE_PACK"


class ItemStatus1(Enum):
    INIT = "INIT"
    PENDING = "PENDING"
    RIPE = "RIPE"
    ONHOLD = "ONHOLD"
    LOCKED = "LOCKED"
    PROOF = "PROOF"
    CONFIRMED = "CONFIRMED"
    INPRODUCTION = "INPRODUCTION"
    ACCEPTED = "ACCEPTED"
    DISPATCHED = "DISPATCHED"
    CLOSED = "CLOSED"
    CANCELED = "CANCELED"


class Status1(Enum):
    INIT = "INIT"
    PENDING = "PENDING"
    ACCEPTED = "ACCEPTED"
    LABELED = "LABELED"
    COLLECTED = "COLLECTED"
    DELIVERED = "DELIVERED"


class Type1(Enum):
    NONE = "NONE"
    FIXED_RETAIL = "FIXED_RETAIL"
    FIXED_MARKUP = "FIXED_MARKUP"
    PERCENTAGE = "PERCENTAGE"
    DISTRIBUTION = "DISTRIBUTION"


class Markup(BaseModel):
    type: Annotated[
        Type1,
        Field(
            description="Enumeration of the different types of markup applied to items.",
            examples=["NONE"],
        ),
    ]
    value: Annotated[
        float,
        Field(
            description="Value of the markup. Must be non-negative.",
            examples=[0.0],
            ge=0.0,
        ),
    ]


class OrderStatus(Enum):
    INIT = "INIT"
    PENDING = "PENDING"
    RIPE = "RIPE"
    ONHOLD = "ONHOLD"
    LOCKED = "LOCKED"
    PROOF = "PROOF"
    CONFIRMED = "CONFIRMED"
    INPRODUCTION = "INPRODUCTION"
    ACCEPTED = "ACCEPTED"
    DISPATCHED = "DISPATCHED"
    CLOSED = "CLOSED"
    CANCELED = "CANCELED"


class PreviewType(Enum):
    NONE = "NONE"
    ALL_PAGES = "ALL_PAGES"
    LIMITED_PAGES = "LIMITED_PAGES"


class Preview(BaseModel):
    previewType: Annotated[
        PreviewType,
        Field(
            description="Enumeration of preview types available for a publication",
            examples=["ALL_PAGES"],
        ),
    ]
    maxPages: Annotated[
        Optional[int],
        Field(
            description="Maximum number of pages to include in the preview.",
            examples=[10],
        ),
    ] = None


class Status2(Enum):
    field_0 = "0"
    field_10 = "10"
    field_20 = "20"
    field_60 = "60"
    field_94 = "94"


class ProblemCategory(Enum):
    field_0 = "0"
    field_1 = "1"
    field_2 = "2"
    field_3 = "3"
    field_4 = "4"
    field_5 = "5"
    field_6 = "6"
    field_7 = "7"
    field_8 = "8"
    field_9 = "9"
    field_10 = "10"
    field_11 = "11"
    field_12 = "12"
    field_13 = "13"
    field_14 = "14"
    field_15 = "15"
    field_16 = "16"
    field_17 = "17"
    field_18 = "18"


class RequestCategory(Enum):
    field_0 = "0"
    field_1 = "1"
    field_2 = "2"
    field_3 = "3"
    field_4 = "4"


class ProblemWithOrderSummary(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier for the problem with the order",
            examples=["66588e6ee56ff71f589d2d9a"],
        ),
    ] = None
    status: Annotated[
        Optional[Status2],
        Field(description="Current status of the dispute", examples=["CLOSE"]),
    ] = None
    copiesAffected: Annotated[
        Optional[int],
        Field(description="Number of copies affected by the problem", examples=[5]),
    ] = None
    problemCategory: Annotated[
        Optional[ProblemCategory],
        Field(description="Category of the problem", examples=["ARRIVED_DAMAGED"]),
    ] = None
    requestCategory: Annotated[
        Optional[RequestCategory],
        Field(description="Requested action for the problem", examples=["REPRINT"]),
    ] = None
    attachments: Optional[List[DisputeAttachment]] = None
    dateCreated: Optional[DateTimestamp] = None
    dateClosed: Optional[DateTimestamp] = None
    remarks: Annotated[
        Optional[str],
        Field(
            description="Remarks regarding the problem",
            examples=["My order arrived damaged"],
        ),
    ] = None


class Genre(Enum):
    ACADEMIC = "ACADEMIC"
    ACTIVITY_BOOKS = "ACTIVITY_BOOKS"
    ARTS_AND_PHOTOGRAPHY = "ARTS_AND_PHOTOGRAPHY"
    BIOGRAPHIES = "BIOGRAPHIES"
    BROCHURES_CATALOGUES_AND_FLYERS = "BROCHURES_CATALOGUES_AND_FLYERS"
    BUSINESS_AND_MONEY = "BUSINESS_AND_MONEY"
    CALENDARS = "CALENDARS"
    CHILDRENS_BOOKS = "CHILDRENS_BOOKS"
    COMICS_AND_GRAPHIC_NOVELS = "COMICS_AND_GRAPHIC_NOVELS"
    COMPUTERS_AND_TECHNOLOGY = "COMPUTERS_AND_TECHNOLOGY"
    COOKBOOKS_FOOD_AND_WINE = "COOKBOOKS_FOOD_AND_WINE"
    CRAFTS_HOBBIES_AND_HOME = "CRAFTS_HOBBIES_AND_HOME"
    EDUCATION_AND_TEACHING = "EDUCATION_AND_TEACHING"
    ENGINEERING_AND_TRANSPORTATION = "ENGINEERING_AND_TRANSPORTATION"
    HEALTH_FITNESS_AND_DIETING = "HEALTH_FITNESS_AND_DIETING"
    HISTORY = "HISTORY"
    HUMOR_AND_ENTERTAINMENT = "HUMOR_AND_ENTERTAINMENT"
    LAW = "LAW"
    LGBTQ_BOOKS = "LGBTQ_BOOKS"
    LITERATURE_AND_FICTION = "LITERATURE_AND_FICTION"
    LOW_CONTENT_BOOK = "LOW_CONTENT_BOOK"
    MAGAZINES = "MAGAZINES"
    MEDICAL_BOOKS = "MEDICAL_BOOKS"
    MEMOIR_AUTOBIOGRAPHY = "MEMOIR_AUTOBIOGRAPHY"
    MYSTERY_THRILLER_AND_SUSPENSE = "MYSTERY_THRILLER_AND_SUSPENSE"
    PARENTING_AND_RELATIONSHIPS = "PARENTING_AND_RELATIONSHIPS"
    POLITICS_AND_SOCIAL_SCIENCES = "POLITICS_AND_SOCIAL_SCIENCES"
    POETRY = "POETRY"
    POSTERS = "POSTERS"
    REFERENCE = "REFERENCE"
    RELIGION_AND_SPIRITUALITY = "RELIGION_AND_SPIRITUALITY"
    ROMANCE = "ROMANCE"
    SCIENCE_AND_MATHS = "SCIENCE_AND_MATHS"
    SCIENCE_FICTION_AND_FANTASY = "SCIENCE_FICTION_AND_FANTASY"
    SELF_HELP = "SELF_HELP"
    SPORTS_AND_OUTDOORS = "SPORTS_AND_OUTDOORS"
    TEEN_AND_YOUNG_ADULT_BOOKS = "TEEN_AND_YOUNG_ADULT_BOOKS"
    TEST_PREPARATION = "TEST_PREPARATION"
    TRAVEL = "TRAVEL"


class PublishingHouseExtendedReference(BaseModel):
    publishingHouseId: Optional[str] = None
    publishingHouseName: Optional[str] = None
    markup: Optional[Markup] = None


class Type2(Enum):
    PRODUCTS = "PRODUCTS"
    PAPER_SWATCHES = "PAPER_SWATCHES"
    PROFESSIONAL = "PROFESSIONAL"
    ULTIMATE = "ULTIMATE"


class SamplePack(BaseModel):
    type: Annotated[
        Type2, Field(description="Represents different types of sample packs.")
    ]
    enabled: Annotated[
        Optional[bool],
        Field(description="Indicates whether this sample pack is enabled."),
    ] = None
    contents: Annotated[
        Optional[List[str]], Field(description="A list of message keys for i18n.")
    ] = None
    chargeable: Annotated[
        Optional[bool],
        Field(
            description="Indicates whether this sample pack must be purchased (true) or is free (false)."
        ),
    ] = None
    subProductId: Annotated[
        Optional[int], Field(description="Sub product ID for the sample pack")
    ] = None


class SamplePackType(Enum):
    PRODUCTS = "PRODUCTS"
    PAPER_SWATCHES = "PAPER_SWATCHES"
    PROFESSIONAL = "PROFESSIONAL"
    ULTIMATE = "ULTIMATE"


class Design(Enum):
    NONE = "NONE"
    LINED = "LINED"


class Substrate(BaseModel):
    typeId: Annotated[
        int, Field(description="Type identifier for the substrate.", examples=[1])
    ]
    weightId: Annotated[
        int,
        Field(
            description="Weight identifier for the substrate. This is the id of the weight, not the actual gsm or lb weight",
            examples=[3],
        ),
    ]
    colourId: Annotated[
        Optional[int],
        Field(description="Colour identifier for the substrate.", examples=[0]),
    ] = None
    design: Annotated[
        Design,
        Field(description="Enumeration of substrate designs.", examples=["LINED"]),
    ] = "NONE"


class Type3(Enum):
    SHOPIFY = "SHOPIFY"


class SyndicationSummary(BaseModel):
    type: Optional[Type3] = None
    externalId: Optional[str] = None
    namespace: Optional[str] = None


class TaxSummary(BaseModel):
    taxRate: Annotated[
        Optional[float],
        Field(description="VAT/Tax rate (%) applied to the order item", examples=[20]),
    ] = None
    taxAmount: Annotated[
        Optional[float],
        Field(description="Total VAT/Tax amount for the order item", examples=[30.0]),
    ] = None


class AddressSummary(BaseModel):
    company: Annotated[
        Optional[str],
        Field(
            description="The company name of the recipient",
            examples=["Holmes Investigations"],
        ),
    ] = None
    firstName: Annotated[
        str, Field(description="The first name of the recipient", examples=["Sherlock"])
    ]
    lastName: Annotated[
        str, Field(description="The last name of the recipient", examples=["Holmes"])
    ]
    postcode: Annotated[
        str, Field(description="The postal code of the address", examples=["NW1 6XE"])
    ]
    line1: Annotated[
        str,
        Field(
            description="The first line of the address", examples=["221B Baker Street"]
        ),
    ]
    line2: Annotated[
        Optional[str], Field(description="The second line of the address")
    ] = None
    line3: Annotated[
        Optional[str], Field(description="The third line of the address")
    ] = None
    town: Annotated[
        str, Field(description="The town or city of the address", examples=["London"])
    ]
    county: Annotated[
        str,
        Field(
            description="The county or state of the address", examples=["Marylebone"]
        ),
    ]
    country: Annotated[
        str,
        Field(description="ISO2 Country Code", examples=["GB"], pattern="^[A-Z]{2}$"),
    ]
    phoneNumber: Annotated[
        str,
        Field(
            description="Phone number in international format",
            examples=["+44 1923 594 252"],
        ),
    ]
    emailAddress: Annotated[
        str, Field(description="Email address", examples=["customer@example.com"])
    ]


class PaymentMethod(Enum):
    ACCOUNT = "ACCOUNT"
    CARD_ON_FILE = "CARD_ON_FILE"
    TEST_ORDER = "TEST_ORDER"


class PrintLinkCreateOrderRequest(BaseModel):
    publicationId: Annotated[str, Field(description="The ID of publication to order")]
    copies: Annotated[int, Field(description="Number of copies to order", ge=1)]
    metadata: ExternalOrderMetadata
    deliveryAddress: AddressSummary
    paymentMethod: Annotated[
        PaymentMethod,
        Field(
            description="Payment methods available for transactions",
            examples=["TEST_ORDER"],
        ),
    ]


class QuoteType(Enum):
    QUOTE = "QUOTE"
    PUBLICATION = "PUBLICATION"
    PRINT_ON_DEMAND = "PRINT_ON_DEMAND"
    FOURTHWALL = "FOURTHWALL"
    ADOBE_EXPRESS = "ADOBE_EXPRESS"


class CreateOrderRequestItemAsset(BaseModel):
    url: Annotated[
        str,
        Field(
            description="URL of the asset", examples=["http://example.com/asset.pdf"]
        ),
    ]
    name: Annotated[str, Field(description="Name of the asset", examples=["cover.pdf"])]


class ItemDeliveryDetails(BaseModel):
    itemId: Annotated[
        str,
        Field(
            description="The unique identifier of the item. This is your external itemId that you sent across with the item",
            examples=["ITEM-123456"],
        ),
    ]
    copies: Annotated[
        int,
        Field(
            description="The number of copies of the item to be delivered",
            examples=[1000],
            ge=1,
        ),
    ]


class Type4(Enum):
    MACHINE = "MACHINE"
    GLOBAL = "GLOBAL"
    PRODUCT_BASED = "PRODUCT_BASED"


class Overhead(BaseModel):
    price: Optional[float] = None
    percent: Optional[float] = None
    type: Optional[Type4] = None


class VatPolicy(BaseModel):
    rate: Optional[float] = None
    included: Optional[bool] = None
    fixed: Optional[bool] = None
    vatCountryCodes: Optional[List[str]] = None


class CreateMailingListRequest(BaseModel):
    name: Annotated[
        str,
        Field(
            description="Name of the mailing list",
            examples=["A Good Day For a Mailing List"],
        ),
    ]
    description: Annotated[
        Optional[str],
        Field(
            description="Description of the mailing list", examples=["A description"]
        ),
    ] = None


class AddItemToCartResponse(BaseModel):
    orderId: Annotated[
        Optional[str],
        Field(description="Order ID", examples=["66b11f8f1c89cd5a696e4958"]),
    ] = None
    itemId: Annotated[
        Optional[str],
        Field(description="Item ID", examples=["bc86305e-9f92-49bb-bdzc-590992f39d51"]),
    ] = None
    cartId: Annotated[
        Optional[str],
        Field(description="Cart ID", examples=["66b11f8f1c89cd5a696w4955"]),
    ] = None


class DesignOption(Enum):
    UPLOAD = "UPLOAD"
    DESIGN_ONLINE = "DESIGN_ONLINE"
    DESIGN_SERVICE = "DESIGN_SERVICE"


class AddItemToCartRequest(BaseModel):
    universalKey: Annotated[
        Optional[str],
        Field(
            description="Universal key returned by the offer",
            examples=["203~4-ft{5c-3f-1st-3sw}"],
        ),
    ] = None
    quoteType: Annotated[
        Optional[QuoteType],
        Field(description="Enumeration of possible quote types.", examples=["QUOTE"]),
    ] = "QUOTE"
    subProductId: Annotated[
        Optional[int],
        Field(description="The sub product ID of the item", examples=[10001]),
    ] = None
    productName: Annotated[
        Optional[str],
        Field(description="The name of the product", examples=["Posters"]),
    ] = None
    designOption: Annotated[
        Optional[DesignOption], Field(description="Design option", examples=["UPLOAD"])
    ] = None
    spineWidth: Annotated[
        Optional[float],
        Field(
            description="Spine width given using the appropriate UnitType. Used for standalone DustJackets",
            examples=[10],
        ),
    ] = None
    offerId: Annotated[
        Optional[str],
        Field(
            description="The ID of the offer",
            examples=["CA90DEDACBC32EA2B22CB829CZB1F9B1"],
        ),
    ] = None


class AddressBook(BaseModel):
    addresses: Optional[List[Address]] = None
    defaultShippingAddressId: Annotated[
        Optional[str],
        Field(
            description="Identifier for the default shipping address.",
            examples=["507f1f77bcf86cd799439012"],
        ),
    ] = None
    defaultBillingAddressId: Annotated[
        Optional[str],
        Field(
            description="Identifier for the default billing address.",
            examples=["507f1f77bcf86cd799439013"],
        ),
    ] = None
    defaultBillingAddress: Optional[Address] = None
    defaultShippingAddress: Optional[Address] = None


class Status3(Enum):
    PENDING = "PENDING"
    APPROVED = "APPROVED"
    REJECTED = "REJECTED"
    EXPIRED = "EXPIRED"


class TaxExemptionCertificate(BaseModel):
    id: Optional[str] = None
    status: Optional[Status3] = None
    certificateNumber: Optional[str] = None
    expiryDate: Optional[datetime] = None
    issueDate: Optional[datetime] = None
    organization: Optional[str] = None
    certificateFile: Optional[str] = None
    state: Optional[str] = None
    states: Optional[List[str]] = None
    internalNotes: Optional[str] = None
    rejectionReason: Optional[str] = None
    memberId: Optional[str] = None
    shopId: Optional[str] = None
    customerName: Optional[str] = None
    requestDate: Optional[datetime] = None
    certificateExpired: Optional[bool] = None
    noExpiryDate: Optional[bool] = None


class PrintOnDemandSource(Enum):
    SHOPIFY = "SHOPIFY"
    EMBEDDABLE_PRINTLINK = "EMBEDDABLE_PRINTLINK"
    PRINTLINK = "PRINTLINK"
    PEPPER = "PEPPER"


class Type5(Enum):
    field_0 = "0"
    field_1 = "1"
    field_2 = "2"


class XeroAction(BaseModel):
    type: Optional[Type5] = None
    date: Optional[datetime] = None
    reference: Optional[str] = None
    status: Optional[str] = None
    invoice: Optional[str] = None
    total: Optional[float] = None


class SantaOptionMetadata(BaseModel):
    productId: Annotated[
        Optional[int], Field(description="ID of the product", examples=[7])
    ] = None
    subProductId: Annotated[
        Optional[int], Field(description="ID of the sub-product", examples=[0])
    ] = None
    title: Annotated[
        str, Field(description="Title of the option", examples=["Hardcover"])
    ]
    imageUrl: Annotated[
        Optional[str],
        Field(
            description="URL of the image representing the option",
            examples=["http://example.com/image.png"],
        ),
    ] = None


class SantaPageImageMetadata(BaseModel):
    imageUrl: Annotated[
        str,
        Field(
            description="URL of the image", examples=["http://example.com/image.png"]
        ),
    ]
    webpUrl: Annotated[
        str,
        Field(
            description="URL of the WebP format of the image",
            examples=["http://example.com/image.webp"],
        ),
    ]
    altText: Annotated[
        str,
        Field(
            description="Alternative text for the image",
            examples=["A festive holiday scene"],
        ),
    ]
    title: Annotated[
        str,
        Field(description="Title of the image", examples=["Paperback reading book"]),
    ]
    creditText: Annotated[
        Optional[str],
        Field(description="Credit text for the image", examples=["Photo by John Doe"]),
    ] = None
    creditUrl: Annotated[
        Optional[str],
        Field(
            description="URL for the image credit",
            examples=["http://example.com/credit"],
        ),
    ] = None
    categoryImage: Annotated[
        Optional[bool],
        Field(
            description="Whether the image is being used as a category image",
            examples=[True],
        ),
    ] = None
    featuredImage: Annotated[
        Optional[bool],
        Field(
            description="Whether the image is being used as a featured image",
            examples=[True],
        ),
    ] = None


class BindingColour(Enum):
    BLACK = "BLACK"
    WHITE = "WHITE"
    SILVER = "SILVER"
    GRAY = "GRAY"
    CLEAR = "CLEAR"
    RED = "RED"
    BLUE = "BLUE"
    REFLEX_BLUE = "REFLEX_BLUE"
    YELLOW = "YELLOW"
    COLLEGE_ORANGE = "COLLEGE_ORANGE"
    RED_WINE = "RED_WINE"
    BURGUNDY = "BURGUNDY"
    PINK = "PINK"
    PASTEL_PINK = "PASTEL_PINK"
    FUSCHIA = "FUSCHIA"
    NAVY_BLUE = "NAVY_BLUE"
    PASTEL_BLUE = "PASTEL_BLUE"
    ROYAL_BLUE = "ROYAL_BLUE"
    TEAL = "TEAL"
    MEDIUM_GREEN = "MEDIUM_GREEN"
    PASTEL_GREEN = "PASTEL_GREEN"
    APPLE_GREEN = "APPLE_GREEN"
    PEARL_GREY = "PEARL_GREY"
    DARK_BROWN = "DARK_BROWN"
    PASTEL_BEIGE = "PASTEL_BEIGE"
    CHOCOLATE_BROWN = "CHOCOLATE_BROWN"
    NEON_GREEN = "NEON_GREEN"
    ORANGE = "ORANGE"
    NEON_PINK = "NEON_PINK"
    NEON_ORANGE = "NEON_ORANGE"
    WARM_RED = "WARM_RED"
    PURPLE = "PURPLE"
    VIOLET = "VIOLET"
    FOREST_GREEN = "FOREST_GREEN"
    DARK_GREEN = "DARK_GREEN"
    GOLD = "GOLD"


class BindingColourOption(BaseModel):
    value: Optional[int] = None
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    bindingColour: Annotated[
        Optional[BindingColour],
        Field(
            description="Enumeration of binding colours for a wiro or coil bound item"
        ),
    ] = None


class BindingEdge(Enum):
    LEFT_RIGHT = "LEFT_RIGHT"
    TOP_BOTTOM = "TOP_BOTTOM"


class BindingEdgeMetadata(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    bindingEdge: Annotated[
        Optional[BindingEdge],
        Field(description="Enumeration of binding edges for a bound component"),
    ] = None


class BindingType(Enum):
    STAPLED = "STAPLED"
    PERFECT = "PERFECT"
    PUR = "PUR"
    CASE = "CASE"
    WIRO = "WIRO"
    LOOP = "LOOP"
    CALENDAR_WIRO = "CALENDAR_WIRO"
    SMYTH_SEWN = "SMYTH_SEWN"
    COIL = "COIL"


class PreDrilledHoles10(Enum):
    UNAVAILABLE = "UNAVAILABLE"
    OPTIONAL = "OPTIONAL"
    REQUIRED = "REQUIRED"


class Sewing(Enum):
    UNAVAILABLE = "UNAVAILABLE"
    OPTIONAL = "OPTIONAL"
    REQUIRED = "REQUIRED"


class SeparateCover(Enum):
    UNAVAILABLE = "UNAVAILABLE"
    OPTIONAL = "OPTIONAL"
    REQUIRED = "REQUIRED"


class Capacity(BaseModel):
    x: Optional[float] = None
    y: Optional[float] = None
    z: Optional[float] = None


class ColoursOption(BaseModel):
    label: Optional[str] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    santaDefault: Optional[bool] = None
    sameAsFront: Optional[bool] = None


class ComponentRequirement(BaseModel):
    componentType: Annotated[
        Optional[ComponentType], Field(description="Enumeration of component types")
    ] = None
    minimumInstances: Annotated[
        Optional[int],
        Field(description="Gets the minimum number of instances required."),
    ] = None
    maximumInstances: Annotated[
        Optional[int],
        Field(description="Gets the maximum number of instances allowed."),
    ] = None
    isRequired: Annotated[
        Optional[bool],
        Field(
            description="Indicates if the component is required based on minimum instances."
        ),
    ] = None


class CopiesMetadata(BaseModel):
    initialValue: Annotated[
        int,
        Field(
            description="The default number of copies to display",
            examples=[100],
            ge=1,
            le=100000,
        ),
    ] = 100
    stepValue: Annotated[
        int,
        Field(
            description="The step value used for incrementing the number of copies. We do not limit the copies to be an increment of this number, this is purely for UI interface",
            examples=[50],
            ge=1,
        ),
    ] = 50
    minimumValue: Annotated[
        int,
        Field(description="The minimum number of copies allowed", examples=[1], ge=1),
    ] = 1
    maximumValue: Annotated[
        int,
        Field(
            description="The maximum number of copies allowed", examples=[1], le=100000
        ),
    ] = 100000


class CustomSizeMetadata(BaseModel):
    maxWidth: Optional[float] = None
    sizeFormat: Optional[str] = None
    minWidth: Optional[float] = None
    minHeight: Optional[float] = None
    maxHeight: Optional[float] = None


class EndPaperColour(Enum):
    WHITE = "WHITE"
    BLACK = "BLACK"
    COLORPLAN_ADRIATIC = "COLORPLAN_ADRIATIC"
    COLORPLAN_AMETHYST = "COLORPLAN_AMETHYST"
    COLORPLAN_AZURE_BLUE = "COLORPLAN_AZURE_BLUE"
    COLORPLAN_BARK = "COLORPLAN_BARK"
    COLORPLAN_BITTER_CHOCOLATE = "COLORPLAN_BITTER_CHOCOLATE"
    COLORPLAN_BRIGHT_RED = "COLORPLAN_BRIGHT_RED"
    COLORPLAN_BRIGHT_WHITE = "COLORPLAN_BRIGHT_WHITE"
    COLORPLAN_CANDY_PINK = "COLORPLAN_CANDY_PINK"
    COLORPLAN_LIMESTONE_WHITE = "COLORPLAN_LIMESTONE_WHITE"
    COLORPLAN_CITRINE = "COLORPLAN_CITRINE"
    COLORPLAN_CLARET = "COLORPLAN_CLARET"
    COLORPLAN_COBALT = "COLORPLAN_COBALT"
    COLORPLAN_COOL_BLUE = "COLORPLAN_COOL_BLUE"
    COLORPLAN_COOL_GREY = "COLORPLAN_COOL_GREY"
    COLORPLAN_DARK_GREY = "COLORPLAN_DARK_GREY"
    COLORPLAN_EBONY = "COLORPLAN_EBONY"
    COLORPLAN_EMERALD = "COLORPLAN_EMERALD"
    COLORPLAN_FACTORY_YELLOW = "COLORPLAN_FACTORY_YELLOW"
    COLORPLAN_FOREST = "COLORPLAN_FOREST"
    COLORPLAN_FUSCHIA_PINK = "COLORPLAN_FUSCHIA_PINK"
    COLORPLAN_HARVEST = "COLORPLAN_HARVEST"
    COLORPLAN_HOT_PINK = "COLORPLAN_HOT_PINK"
    COLORPLAN_ICE_WHITE = "COLORPLAN_ICE_WHITE"
    COLORPLAN_LOCH_BLUE = "COLORPLAN_LOCH_BLUE"
    COLORPLAN_LAVENDAR = "COLORPLAN_LAVENDAR"
    COLORPLAN_LOCKWOOD_GREEN = "COLORPLAN_LOCKWOOD_GREEN"
    COLORPLAN_MANDARIN = "COLORPLAN_MANDARIN"
    COLORPLAN_MARRS_GREEN = "COLORPLAN_MARRS_GREEN"
    COLORPLAN_MID_GREEN = "COLORPLAN_MID_GREEN"
    COLORPLAN_MIST = "COLORPLAN_MIST"
    COLORPLAN_NATURAL = "COLORPLAN_NATURAL"
    COLORPLAN_NEW_BLUE = "COLORPLAN_NEW_BLUE"
    COLORPLAN_NUBUCK_BROWN = "COLORPLAN_NUBUCK_BROWN"
    COLORPLAN_PALE_GREY = "COLORPLAN_PALE_GREY"
    COLORPLAN_PARK_GREEN = "COLORPLAN_PARK_GREEN"
    COLORPLAN_PISTACHIO = "COLORPLAN_PISTACHIO"
    COLORPLAN_POWDER_GREEN = "COLORPLAN_POWDER_GREEN"
    COLORPLAN_PRISTINE_WHITE = "COLORPLAN_PRISTINE_WHITE"
    COLORPLAN_PURPLE = "COLORPLAN_PURPLE"
    COLORPLAN_RACING_GREEN = "COLORPLAN_RACING_GREEN"
    COLORPLAN_REAL_GREY = "COLORPLAN_REAL_GREY"
    COLORPLAN_ROYAL_BLUE = "COLORPLAN_ROYAL_BLUE"
    COLORPLAN_SAPPHIRE = "COLORPLAN_SAPPHIRE"
    COLORPLAN_SCARLET = "COLORPLAN_SCARLET"
    COLORPLAN_SMOKE = "COLORPLAN_SMOKE"
    COLORPLAN_SORBET_YELLOW = "COLORPLAN_SORBET_YELLOW"
    COLORPLAN_STONE = "COLORPLAN_STONE"
    COLORPLAN_TABRIZ_BLUE = "COLORPLAN_TABRIZ_BLUE"
    COLORPLAN_TURQUOISE = "COLORPLAN_TURQUOISE"
    COLORPLAN_VELLUM_WHITE = "COLORPLAN_VELLUM_WHITE"
    COLORPLAN_VERMILLION = "COLORPLAN_VERMILLION"
    COLORPLAN_WHITE_FROST = "COLORPLAN_WHITE_FROST"


class EndPaperMetadata(BaseModel):
    label: Optional[str] = None
    colourId: Optional[int] = None
    santaDefault: Optional[bool] = None
    endPaperColour: Annotated[
        Optional[EndPaperColour], Field(description="Enumeration of end paper colours")
    ] = None
    colourCode: Optional[str] = None


class FlapWidthOption(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    flapWidth: Annotated[
        Optional[FlapWidth], Field(description="Enumeration for dust jacket flap width")
    ] = "AUTOMATIC"


class FoilingColour(Enum):
    GOLD = "GOLD"
    SILVER = "SILVER"
    COPPER = "COPPER"
    RED = "RED"
    BLUE = "BLUE"
    GREEN = "GREEN"


class SupportedLamination(Enum):
    NONE = "NONE"
    MATT = "MATT"
    GLOSS = "GLOSS"
    SOFT = "SOFT"
    UV_MATT = "UV_MATT"
    UV_GLOSS = "UV_GLOSS"
    SPOT_UV_MATT = "SPOT_UV_MATT"
    SPOT_UV_GLOSS = "SPOT_UV_GLOSS"
    SPOT_3D_UV_MATT = "SPOT_3D_UV_MATT"
    SPOT_3D_UV_GLOSS = "SPOT_3D_UV_GLOSS"
    MATT_SPOT_UV = "MATT_SPOT_UV"
    MATT_ANTI_SCUFF = "MATT_ANTI_SCUFF"


class FoilingOption(BaseModel):
    label: Optional[str] = None
    foilingColour: Annotated[
        Optional[FoilingColour], Field(description="Enumeration of foiling colours.")
    ] = None
    supportedLaminations: Optional[List[SupportedLamination]] = None


class FrameDepthOption(BaseModel):
    value: Optional[int] = None
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    frameDepth: Annotated[
        Optional[FrameDepth], Field(description="Enumeration of frame depths.")
    ] = "UNSPECIFIED"


class FramedMetadata(BaseModel):
    frameDepthOptions: Optional[List[FrameDepthOption]] = None


class HeadAndTailBandMetadata(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    headAndTailBands: Annotated[
        Optional[HeadAndTailBands],
        Field(description="Enumeration of head and tail bands."),
    ] = "NONE"
    colourCode: Optional[str] = None


class LaminationOption(BaseModel):
    value: Optional[int] = None
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    lamination: Optional[str] = None


class PageCountMetadata(BaseModel):
    bindingTypeId: Optional[int] = None
    min: Optional[int] = None
    max: Optional[int] = None
    increment: Optional[int] = None
    bindingType: Annotated[
        Optional[BindingType], Field(description="Enumeration of Binding Types")
    ] = None


class PreDrilledHoles11(Enum):
    NONE = "NONE"
    ONE_HOLE_OPPOSITE_BINDING_CENTER = "ONE_HOLE_OPPOSITE_BINDING_CENTER"
    ONE_HOLE_TOP_CENTER = "ONE_HOLE_TOP_CENTER"


class PreDrilledHoleOption(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles11],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None


class PreDrilledHolesMetadata(BaseModel):
    preDrilledHoleOptions: Optional[List[PreDrilledHoleOption]] = None


class SantaType(Enum):
    QUOTE = "QUOTE"
    PUBLICATION = "PUBLICATION"
    PRINT_ON_DEMAND = "PRINT_ON_DEMAND"
    FOURTHWALL = "FOURTHWALL"
    ADOBE_EXPRESS = "ADOBE_EXPRESS"


class DefaultOrientation(Enum):
    PORTRAIT = "PORTRAIT"
    LANDSCAPE = "LANDSCAPE"


class RoundedCorners(Enum):
    UNAVAILABLE = "UNAVAILABLE"
    OPTIONAL = "OPTIONAL"
    REQUIRED = "REQUIRED"


class PublicationMetadata(BaseModel):
    supportsSelfPublishing: Optional[bool] = None


class RibbonMetadata(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    ribbonColour: Annotated[
        Optional[RibbonColour],
        Field(
            description="Enumeration of ribbon colours for a bound item. Only applicable to case bound books"
        ),
    ] = "NONE"
    colourCode: Optional[str] = None


class SubstrateType(Enum):
    NONE = "NONE"
    SILK = "SILK"
    GLOSS = "GLOSS"
    UNCOATED = "UNCOATED"
    COLORPLAN = "COLORPLAN"
    RECYCLED_UNCOATED = "RECYCLED_UNCOATED"
    RECYCLED_NATURAL = "RECYCLED_NATURAL"
    BLUEBACK_POSTER_PAPER = "BLUEBACK_POSTER_PAPER"
    POSTCARD_BOARD = "POSTCARD_BOARD"
    LINEN = "LINEN"
    PEARL_POLAR = "PEARL_POLAR"
    PEARL_OYSTER = "PEARL_OYSTER"
    UNCOATED_CREME_PAPER = "UNCOATED_CREME_PAPER"
    TINTORETTO_GESSO = "TINTORETTO_GESSO"
    KRAFT = "KRAFT"
    ICE_GOLD = "ICE_GOLD"
    FRESCO_GESSO = "FRESCO_GESSO"
    RIVES_SHETLAND = "RIVES_SHETLAND"
    RECYCLED_SILK = "RECYCLED_SILK"
    BOOKWOVE = "BOOKWOVE"
    POLYESTER = "POLYESTER"
    CREME = "CREME"
    MATTE_PAPER = "MATTE_PAPER"
    PREMIUM_WHITE = "PREMIUM_WHITE"
    POLYFILL_BAG = "POLYFILL_BAG"
    E_PHOTO_PAPER = "E_PHOTO_PAPER"
    E_PHOTO_SILK_LUSTRE = "E_PHOTO_SILK_LUSTRE"
    ARCHIVAL_MATT = "ARCHIVAL_MATT"
    ARCHIVAL_UNCOATED = "ARCHIVAL_UNCOATED"
    ARCHIVAL_TEXTURED_MATT = "ARCHIVAL_TEXTURED_MATT"
    PHOTO_LUSTRE = "PHOTO_LUSTRE"
    WRAPPED_GREYBOARD = "WRAPPED_GREYBOARD"
    BUCKRAM = "BUCKRAM"
    LAID = "LAID"
    AQUERELLO = "AQUERELLO"
    NETTUNO = "NETTUNO"
    LUX_LAYERED_KRAFT = "LUX_LAYERED_KRAFT"
    LUX_LAYERED_WHITE = "LUX_LAYERED_WHITE"
    ETCHING = "ETCHING"
    RAG_PEARL = "RAG_PEARL"


class ShrinkWrapOption(BaseModel):
    substrateTypeId: Optional[int] = None
    capacity: Optional[Capacity] = None
    label: Optional[str] = None
    substrateType: Annotated[
        Optional[SubstrateType],
        Field(
            description="Represents the type of substrate (paper or material) used for printing"
        ),
    ] = None
    substrateWeightId: Optional[int] = None
    bundleMinimum: Optional[int] = None
    bundleIncrement: Optional[int] = None
    bundleDefault: Optional[int] = None


class DeliveredFlat(Enum):
    UNAVAILABLE = "UNAVAILABLE"
    OPTIONAL = "OPTIONAL"
    REQUIRED = "REQUIRED"


class SimpleFoldOption(BaseModel):
    value: Optional[int] = None
    label: Optional[str] = None
    simpleFold: Annotated[
        Optional[SimpleFold], Field(description="Enumeration of simple fold types")
    ] = "NONE"
    santaDefault: Optional[bool] = None
    availableSides: Optional[List[int]] = None
    deliveredFlat: Optional[DeliveredFlat] = None


class Colour1(Enum):
    NONE = "NONE"
    BLACK = "BLACK"
    RED = "RED"
    ORANGE = "ORANGE"
    YELLOW = "YELLOW"
    GREEN = "GREEN"
    BLUE = "BLUE"
    INDIGO = "INDIGO"
    VIOLET = "VIOLET"
    PURPLE = "PURPLE"
    PINK = "PINK"
    TURQUOISE = "TURQUOISE"
    SILVER = "SILVER"
    GOLD = "GOLD"
    GREY = "GREY"
    ROSE = "ROSE"
    CREAM = "CREAM"
    DARK_GREEN = "DARK_GREEN"
    RUBY = "RUBY"
    BUTTERMILK = "BUTTERMILK"
    SAPPHIRE_BLUE = "SAPPHIRE_BLUE"
    GRAPHITE = "GRAPHITE"
    PASTEL_PINK = "PASTEL_PINK"
    PASTEL_GREEN = "PASTEL_GREEN"
    LEAFBIRD_GREEN = "LEAFBIRD_GREEN"
    PUFFIN_BLUE = "PUFFIN_BLUE"
    SKYLARK_VIOLET = "SKYLARK_VIOLET"


class SubstrateDesign(Enum):
    NONE = "NONE"
    LINED = "LINED"


class SubstrateDesignMetadata(BaseModel):
    label: Optional[str] = None
    santaDefault: Optional[bool] = None
    substrateDesign: Annotated[
        Optional[SubstrateDesign],
        Field(description="Enumeration of substrate designs."),
    ] = None


class Unit(Enum):
    GSM = "GSM"
    LBS_TEXT = "LBS_TEXT"
    LBS_COVER = "LBS_COVER"
    MICRONS = "MICRONS"
    SHIROKU_BAN = "SHIROKU_BAN"


class SubstrateWeightMetadata(BaseModel):
    id: Optional[int] = None
    label: Optional[str] = None
    weight: Optional[int] = None
    unit: Optional[Unit] = None
    pageCounts: Optional[List[PageCountMetadata]] = None
    gsm: Optional[int] = None
    santaDefault: Optional[bool] = None
    supportsLamination: Optional[bool] = None
    caliper: Optional[float] = None


class MailingListSummary(BaseModel):
    id: Annotated[
        str,
        Field(
            description="Unique identifier of the mailing list",
            examples=["6706a5aa7cefb67404ffd3cx"],
        ),
    ]
    name: Annotated[
        str,
        Field(
            description="Name of the mailing list",
            examples=["Daily Newsletters"],
            max_length=100,
            min_length=0,
        ),
    ]
    description: Annotated[
        Optional[str],
        Field(
            description="Description of the mailing list",
            examples=["A list for daily newsletter subscriptions"],
            max_length=250,
            min_length=0,
        ),
    ] = None
    memberId: Annotated[
        str,
        Field(
            description="Member ID associated with the mailing list",
            examples=["6706a5aa7cefb67414ffd3cf"],
        ),
    ]
    addressCount: Annotated[
        Optional[int],
        Field(
            description="Count of addresses in the mailing list", examples=[100], ge=0
        ),
    ] = None


class MailingList(BaseModel):
    id: Annotated[
        str,
        Field(
            description="Unique identifier for the mailing list",
            examples=["6716a5fa7cexb67404ffd3cq"],
        ),
    ]
    name: Annotated[
        str,
        Field(
            description="Name of the mailing list",
            examples=["Newsletter List"],
            max_length=100,
            min_length=1,
        ),
    ]
    description: Annotated[
        Optional[str],
        Field(
            description="Description of the mailing list",
            examples=["Monthly newsletter mailing list"],
            max_length=255,
            min_length=0,
        ),
    ] = None
    addresses: Annotated[
        Optional[List[Address]],
        Field(description="List of addresses in the mailing list"),
    ] = None
    memberId: Annotated[
        str,
        Field(
            description="Unique identifier for the member associated with the mailing list",
            examples=["6382122d66187f03b74377ec"],
        ),
    ]


class UnitType(Enum):
    MILLIMETERS = "MILLIMETERS"
    INCHES = "INCHES"


class Dimension(BaseModel):
    width: Annotated[Optional[float], Field(description="Width of the item")] = None
    height: Annotated[Optional[float], Field(description="Height of the item")] = None
    unitType: Annotated[
        Optional[UnitType],
        Field(description="Enumeration representing the unit type for dimensions"),
    ] = None
    label: Annotated[Optional[str], Field(description="Dimension Label")] = None


class Colour2(Enum):
    NONE = "NONE"
    PROCESS = "PROCESS"
    GRAYSCALE = "GRAYSCALE"


class HeadAndTailBand(Enum):
    NONE = "NONE"
    NAVY_BLUE_AND_WHITE = "NAVY_BLUE_AND_WHITE"
    BLACK_AND_GREEN = "BLACK_AND_GREEN"
    RED_AND_BLACK = "RED_AND_BLACK"
    PURPLE_AND_WHITE = "PURPLE_AND_WHITE"
    RED_AND_GREY = "RED_AND_GREY"
    RED_AND_WHITE = "RED_AND_WHITE"
    YELLOW_AND_BROWN = "YELLOW_AND_BROWN"
    DARK_BROWN_AND_WHITE = "DARK_BROWN_AND_WHITE"
    BLUE_AND_YELLOW = "BLUE_AND_YELLOW"
    RED_AND_GREEN = "RED_AND_GREEN"
    YELLOW_AND_GREEN = "YELLOW_AND_GREEN"
    BLUE_AND_WHITE = "BLUE_AND_WHITE"
    DARK_BLUE_AND_WHITE = "DARK_BLUE_AND_WHITE"
    RED_AND_YELLOW = "RED_AND_YELLOW"
    MAROON_AND_WHITE = "MAROON_AND_WHITE"
    YELLOW_AND_BLACK = "YELLOW_AND_BLACK"
    GREEN_AND_WHITE = "GREEN_AND_WHITE"
    BLACK_AND_WHITE = "BLACK_AND_WHITE"
    DARK_GREEN_AND_BLACK = "DARK_GREEN_AND_BLACK"
    DARK_GREEN_AND_WHITE = "DARK_GREEN_AND_WHITE"
    RED = "RED"
    BLACK = "BLACK"
    GREY = "GREY"
    WHITE = "WHITE"
    DARK_BLUE = "DARK_BLUE"
    YELLOW = "YELLOW"


class BorderType(Enum):
    WRAP_AROUND = "WRAP_AROUND"
    EDGE_TO_EDGE = "EDGE_TO_EDGE"
    PADDED = "PADDED"


class BindingLoop(Enum):
    TWO_LOOPS = "TWO_LOOPS"
    FOUR_LOOPS = "FOUR_LOOPS"


class PreDrilledHole(Enum):
    NONE = "NONE"
    ONE_HOLE_OPPOSITE_BINDING_CENTER = "ONE_HOLE_OPPOSITE_BINDING_CENTER"
    ONE_HOLE_TOP_CENTER = "ONE_HOLE_TOP_CENTER"


class GetCatalogueResponse(BaseModel):
    products: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description="Map of products and product ids",
            examples=[
                {"1": {"id": 1, "name": "BROCHURES"}, "2": {"id": 2, "name": "FLYERS"}}
            ],
        ),
    ] = None
    dinSizes: Optional[Dimension] = None
    standardSizes: Optional[Dimension] = None
    orientations: Optional[List[Orientation]] = None
    colours: Optional[List[Colour2]] = None
    bindingTypes: Optional[List[BindingType]] = None
    componentTypes: Optional[List[ComponentType]] = None
    laminations: Optional[List[Lamination]] = None
    ribbonColours: Optional[List[RibbonColour]] = None
    headAndTailBands: Optional[List[HeadAndTailBand]] = None
    bindingColours: Optional[List[BindingColour]] = None
    endPaperColours: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description="Map of end paper colours and and their ids (used to construct a Substrate within an ItemSpecification)",
            examples=[
                {"1": {"id": 0, "name": "WHITE"}, "2": {"id": 1, "name": "BLACK"}}
            ],
        ),
    ] = None
    foilingColours: Optional[List[FoilingColour]] = None
    borderTypes: Optional[List[BorderType]] = None
    simpleFolds: Optional[List[SimpleFold]] = None
    coverAreas: Optional[List[CoverArea]] = None
    frameDepths: Optional[List[FrameDepth]] = None
    unitFormats: Optional[List[UnitFormat]] = None
    substrateDesigns: Optional[List[SubstrateDesign]] = None
    bindingLoops: Optional[List[BindingLoop]] = None
    designOptions: Optional[List[DesignOption]] = None
    bindingEdges: Optional[List[BindingEdge]] = None
    preDrilledHoles: Optional[List[PreDrilledHole]] = None
    substrateTypes: Annotated[
        Optional[Dict[str, Any]],
        Field(
            description="Map of substrate types",
            examples=[{"1": "Silk", "2": "Gloss", "3": "Uncoated"}],
        ),
    ] = None
    quoteTypes: Optional[List[QuoteType]] = None
    supportedLocales: Optional[List[str]] = None


class PublicationSeries(BaseModel):
    name: Annotated[str, Field(description="Name of the Series")]
    seriesPrefix: Annotated[
        Optional[SeriesPrefix],
        Field(
            description="The prefix that is added to each item within the series",
            examples=["BOOK"],
        ),
    ] = None
    seriesStatus: Annotated[
        SeriesStatus,
        Field(
            description="The current status of the series", examples=["ACTIVE/INACTIVE"]
        ),
    ]
    mainPublications: Annotated[
        Optional[List[PodItemReference]],
        Field(
            description="Ids of publications - Main publications to include in this Series, should be strongly related to each other in some way"
        ),
    ] = None
    relatedPublications: Annotated[
        Optional[List[SeriesRelatedContent]],
        Field(
            description="Ids of publications - Related publications to include in this Series, these are related to the Main Publications but in a non-direct way"
        ),
    ] = None


class OrderStatusResponse(BaseModel):
    orderId: Annotated[
        str, Field(description="The ID of the order", examples=["ORDER12345"])
    ]
    metadata: ExternalOrderMetadata
    status: Annotated[Status, Field(description="The status of the order")]
    statusReason: Annotated[
        Optional[str], Field(description="The reason for the status of the order")
    ] = None
    items: Annotated[
        Optional[List[ItemStatus]], Field(max_length=2147483647, min_length=1)
    ] = None
    shipments: Optional[List[ShipmentSummary]] = None
    artworkComplete: Annotated[
        bool,
        Field(
            description="Indicates if all the required artwork is complete and has been processed"
        ),
    ]
    hasErrors: Optional[bool] = None


class Component10(SamplePack):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["9"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class PublicationConfig(BaseModel):
    title: Annotated[
        str, Field(description="Title of the publication", examples=["Sherlock Holmes"])
    ]
    description: Annotated[
        str,
        Field(
            description="Description of the publication",
            examples=["A collection of Sherlock Holmes stories."],
        ),
    ]
    active: Annotated[
        Optional[bool],
        Field(description="Indicates if the publication is active", examples=[True]),
    ] = None
    authors: Annotated[
        List[Author],
        Field(description="List of authors associated with the publication"),
    ]
    markup: Markup
    preview: Preview
    syndicationSummaries: Annotated[
        Optional[List[SyndicationSummary]],
        Field(description="List of syndication summaries for the publication"),
    ] = None
    publishingHouseExtendedReference: Optional[PublishingHouseExtendedReference] = None
    genres: Annotated[
        Optional[List[Genre]],
        Field(description="A list of enumerations of Genres, based on Amazon"),
    ] = None
    policyId: Annotated[
        Optional[str],
        Field(description="The policy id associated with the publication"),
    ] = None


class CreateOrderDelivery(BaseModel):
    address: AddressSummary
    itemDeliveryDetails: Annotated[
        List[ItemDeliveryDetails],
        Field(
            description="A list of item delivery details including item ID and quantities",
            examples=[[{"itemId": "ITEM-123456", "copies": 10}]],
            max_length=2147483647,
            min_length=1,
        ),
    ]


class OfferInsights(BaseModel):
    mid: Annotated[str, Field(description="Machine")]
    pid: Annotated[str, Field(description="Provider ID")]
    provider: Annotated[str, Field(description="Provider Name")]
    value: Annotated[Optional[float], Field(description="Value")] = None
    markup: Optional[Overhead] = None
    totalBeforeRounding: Annotated[
        Optional[float], Field(description="Total Price Before The Offer Is Rounded")
    ] = None


class GetUserResponse(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier of the user",
            examples=["5f28202ebb78cb0027b0c284"],
        ),
    ] = None
    email: Annotated[
        Optional[str],
        Field(
            description="Email address of the user",
            examples=["sherlock@bakerstreet.com"],
        ),
    ] = None
    firstName: Annotated[
        Optional[str],
        Field(description="First name of the user", examples=["Sherlock"]),
    ] = None
    lastname: Annotated[
        Optional[str], Field(description="Last name of the user", examples=["Holmes"])
    ] = None
    preferredLanguage: Annotated[
        Optional[str],
        Field(description="Preferred language of the user", examples=["en"]),
    ] = None
    createdDate: Optional[DateTimestamp] = None
    firstOrderDate: Optional[DateTimestamp] = None
    lastOrderDate: Optional[DateTimestamp] = None
    lastLoginDate: Optional[DateTimestamp] = None
    confirmedOrderCount: Annotated[
        Optional[int],
        Field(
            description="Total number of confirmed orders placed by the user",
            examples=[542],
        ),
    ] = None
    addressBook: Optional[AddressBook] = None
    creditLimit: Annotated[
        Optional[float], Field(description="Credit limit for the user", examples=[0.0])
    ] = None
    shopId: Annotated[
        Optional[str],
        Field(
            description="ID of the shop the user belongs to",
            examples=["5f28202ebb78cb0027b0c284"],
        ),
    ] = None
    taxExemptionCertificates: Annotated[
        Optional[List[TaxExemptionCertificate]],
        Field(
            description="List of tax exemption certificates",
            examples=[
                [
                    {
                        "certificateId": "123",
                        "validFrom": "2023-01-01",
                        "validTo": "2023-12-31",
                    }
                ]
            ],
        ),
    ] = None


class AccountInvoiceItem(BaseModel):
    orderId: Optional[str] = None
    caseNumber: Optional[str] = None
    xeroAction: Optional[XeroAction] = None
    invoiceUrl: Optional[str] = None
    printOnDemandSource: Annotated[
        Optional[PrintOnDemandSource],
        Field(
            description="Enumeration of sources from which 'PrintLink' orders can originate"
        ),
    ] = None


class GetUserInvoicesResponse(BaseModel):
    invoices: Optional[List[AccountInvoiceItem]] = None


class ProductSummary(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier for the product page",
            examples=["6316056db99a9d25039fcdbc"],
        ),
    ] = None
    locale: Annotated[
        str, Field(description="Locale of the product page", examples=["en_GB"])
    ]
    title: Annotated[
        str, Field(description="Title of the product page", examples=["Hardcover Book"])
    ]
    menuLabel: Annotated[
        str,
        Field(
            description="Menu label for the product page", examples=["Hardcover Books"]
        ),
    ]
    description: Annotated[
        str,
        Field(
            description="Description of the product page",
            examples=["This is a detailed description of the hardcover book"],
        ),
    ]
    images: Optional[List[SantaPageImageMetadata]] = None
    options: Optional[List[SantaOptionMetadata]] = None
    quoteType: Annotated[
        QuoteType,
        Field(description="Enumeration of possible quote types.", examples=["QUOTE"]),
    ]
    uri: Annotated[
        str, Field(description="URI of the product page", examples=["/books"])
    ]


class BindingTypeOption(BaseModel):
    value: Optional[int] = None
    label: Optional[str] = None
    defaultPages: Optional[int] = None
    bindingType: Annotated[
        Optional[BindingType], Field(description="Enumeration of Binding Types")
    ] = None
    requiredSubstrate: Optional[Substrate] = None
    preDrilledHoles: Optional[PreDrilledHoles10] = None
    santaDefault: Optional[bool] = None
    colourOptions: Optional[List[BindingColourOption]] = None
    separateCoverOuterColoursOptions: Optional[List[ColoursOption]] = None
    separateCoverInnerColoursOptions: Optional[List[ColoursOption]] = None
    sewing: Optional[Sewing] = None
    supportsEndPapers: Optional[bool] = None
    supportsDustJacket: Optional[bool] = None
    supportsRibbons: Optional[bool] = None
    supportsHeadAndTailBands: Optional[bool] = None
    separateCover: Optional[SeparateCover] = None
    caliper: Optional[float] = None


class BoundMetadata(BaseModel):
    pagesIncrement: Optional[int] = None
    defaultPages: Optional[int] = None
    pagesPerLeaf: Optional[int] = None
    ribbonMetadata: Optional[List[RibbonMetadata]] = None
    headAndTailBandMetadata: Optional[List[HeadAndTailBandMetadata]] = None
    endPaperMetadata: Optional[List[EndPaperMetadata]] = None
    bindingTypeOptions: Optional[List[BindingTypeOption]] = None
    bindingEdgeOptions: Optional[List[BindingEdgeMetadata]] = None
    supportsSewing: Optional[bool] = None


class ColoursMetadata(BaseModel):
    coloursOptions: Optional[List[ColoursOption]] = None
    backColoursOptions: Optional[List[ColoursOption]] = None
    outerCoverColoursOptions: Optional[List[ColoursOption]] = None
    innerCoverColoursOptions: Optional[List[ColoursOption]] = None
    jacketColoursOptions: Optional[List[ColoursOption]] = None


class FlapMetadata(BaseModel):
    flapWidthOptions: Optional[List[FlapWidthOption]] = None


class FoilingMetadata(BaseModel):
    coverFoiling: Optional[List[FoilingOption]] = None
    dustJacketFoiling: Optional[List[FoilingOption]] = None
    frontFoiling: Optional[List[FoilingOption]] = None
    backFoiling: Optional[List[FoilingOption]] = None


class FoldingOptions(BaseModel):
    portraitOptions: Optional[List[SimpleFoldOption]] = None
    landscapeOptions: Optional[List[SimpleFoldOption]] = None


class LaminationMetadata(BaseModel):
    frontOptions: Optional[List[LaminationOption]] = None
    coverOptions: Optional[List[LaminationOption]] = None
    backOptions: Optional[List[LaminationOption]] = None
    dustJacketOptions: Optional[List[LaminationOption]] = None


class ShrinkWrapMetadata(BaseModel):
    options: Optional[List[ShrinkWrapOption]] = None


class StandardSizeMetadata(BaseModel):
    name: Optional[str] = None
    format: Optional[int] = None
    width: Optional[float] = None
    foldingOptions: Optional[FoldingOptions] = None
    height: Optional[float] = None
    santaDefault: Optional[bool] = None
    secondaryFormat: Optional[int] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    unitFormat: Optional[UnitFormat] = "0"
    santaValue: Optional[str] = None
    label: Optional[str] = None


class SubstrateColourMetadata(BaseModel):
    hexColour: Optional[str] = None
    weights: Optional[List[SubstrateWeightMetadata]] = None
    id: Optional[int] = None
    label: Optional[str] = None
    colour: Optional[Colour1] = None
    allowPrinting: Optional[bool] = None


class SubstrateTypeMetadata(BaseModel):
    id: Optional[int] = None
    substrateColours: Optional[List[SubstrateColourMetadata]] = None
    santaDefault: Optional[bool] = None
    substrateType: Annotated[
        Optional[SubstrateType],
        Field(
            description="Represents the type of substrate (paper or material) used for printing"
        ),
    ] = None
    label: Optional[str] = None


class PublicationSummary(BaseModel):
    orderId: str
    itemId: str
    caseNumber: int
    thumbnailUrl: str
    total: Optional[float] = None
    cost: Optional[float] = None
    commission: Optional[float] = None
    publicationConfig: Optional[PublicationConfig] = None
    description: Optional[str] = None
    shareId: Optional[str] = None


class GetOfferResponseEntry(BaseModel):
    offerId: Annotated[
        Optional[str],
        Field(
            description="ID for the offer. This is required for creating an order",
            examples=["64b54fa0c0ed1613ac987d70"],
        ),
    ] = None
    price: Annotated[
        Optional[float], Field(description="Total price", examples=[860.5])
    ] = None
    productionDays: Annotated[
        Optional[int], Field(description="Number of days for production", examples=[7])
    ] = None
    pid: Annotated[
        Optional[str],
        Field(description="Product ID", examples=["64b54fa0c0ed1613ac987d70"]),
    ] = None
    mid: Annotated[
        Optional[str], Field(description="Merchant ID", examples=["US-B1-NS"])
    ] = None
    pressType: Annotated[
        Optional[str],
        Field(description="Printing press", examples=["Heidelberg SM XL106"]),
    ] = None
    includeShipment: Annotated[
        Optional[bool],
        Field(description="Price includes shipping cost", examples=[False]),
    ] = None
    printType: Annotated[
        Optional[str], Field(description="Type of print", examples=["LITHO"])
    ] = None
    printQuality: Annotated[
        Optional[str], Field(description="Quality of print", examples=["PREMIUM"])
    ] = None
    countryOfOrigin: Annotated[
        Optional[str], Field(description="Country of origin", examples=["US"])
    ] = None
    currencyCode: Annotated[
        Optional[str],
        Field(description="Currency code prices are in", examples=["USD"]),
    ] = None
    estimatedDeliveryDate: Optional[DateTimestamp] = None
    insights: Optional[OfferInsights] = None
    bestPrice: Optional[bool] = None
    bestTime: Optional[bool] = None
    express: Optional[bool] = None


class GetProductsResponse(BaseModel):
    products: Optional[List[ProductSummary]] = None


class GetPublicationsResponse(BaseModel):
    publications: Optional[PublicationSummary] = None


class GetOfferResponse(BaseModel):
    weight: Annotated[
        Optional[float],
        Field(description="Weight of the item in grams", examples=[500.0]),
    ] = None
    weightKg: Annotated[
        Optional[float],
        Field(description="Weight of the item in kilograms", examples=[0.5]),
    ] = None
    turnaroundMin: Annotated[
        Optional[int],
        Field(description="Minimum turnaround time in days", examples=[3]),
    ] = None
    turnaroundMax: Annotated[
        Optional[int],
        Field(description="Maximum turnaround time in days", examples=[7]),
    ] = None
    spine: Annotated[
        Optional[float],
        Field(description="Spine thickness in millimeters", examples=[10.0]),
    ] = None
    offers: Annotated[
        Optional[List[GetOfferResponseEntry]], Field(description="List of offers")
    ] = None
    vat: Optional[VatPolicy] = None
    forceVatable: Annotated[
        Optional[bool],
        Field(description="Indicates if VAT is forcefully applied", examples=[True]),
    ] = None
    includeShipment: Annotated[
        Optional[bool],
        Field(
            description="Indicates if shipment cost is included in the offer price",
            examples=[True],
        ),
    ] = None
    universalKey: Annotated[
        Optional[str],
        Field(
            description="Universal key for the offer",
            examples=["10~1-bd{4bt-5c-4f-200p-1st-3sw}-cr{5c-5c+-4f-4l-1st-7sw}"],
        ),
    ] = None
    packagingCost: Annotated[
        Optional[float], Field(description="Cost of packaging", examples=[2.5])
    ] = None
    printOnDemandAvailable: Annotated[
        Optional[bool],
        Field(description="Indicates if print-on-demand is available", examples=[True]),
    ] = None
    quoteLink: Annotated[
        Optional[str],
        Field(
            description="A link to the mixam site which shows the offer prices for the given specification",
            examples=["true"],
        ),
    ] = None


class Component(BaseModel):
    root: Annotated[
        Union[
            Component1,
            Component2,
            Component3,
            Component4,
            Component5,
            Component6,
            Component7,
            Component8,
            Component9,
            Component10,
        ],
        Field(
            description="List of components for the specification",
            discriminator="componentType",
            examples=[
                [
                    {
                        "componentType": "BOUND",
                        "format": 4,
                        "standardSize": "NONE",
                        "orientation": "PORTRAIT",
                        "colours": "PROCESS",
                        "substrate": {"typeId": 1, "weightId": 3, "colourId": 0},
                        "pages": 200,
                        "lamination": "NONE",
                        "binding": {"type": "PUR"},
                    },
                    {
                        "componentType": "COVER",
                        "format": 4,
                        "standardSize": "NONE",
                        "orientation": "PORTRAIT",
                        "colours": "PROCESS",
                        "substrate": {"typeId": 1, "weightId": 7, "colourId": 0},
                        "lamination": "GLOSS",
                        "backColours": "PROCESS",
                        "backLamination": "NONE",
                    },
                ]
            ],
        ),
    ]


class CreateOrderResponse(BaseModel):
    order: OrderSummary


class ItemSpecification(BaseModel):
    copies: Annotated[
        int, Field(description="Number of copies to be printed", examples=[1])
    ]
    product: Annotated[
        Product, Field(description="Enumeration of product types", examples=["POSTERS"])
    ]
    components: List[
        Union[
            BoundComponent,
            CoverComponent,
            DustJacketComponent,
            EndPapersComponent,
            EnvelopeComponent,
            FlatComponent,
            FoldedComponent,
            FramedComponent,
            SamplePackComponent,
            ShrinkWrapComponent,
        ]
    ]
    bound: Optional[bool] = None
    customSize: Optional[bool] = None
    requiresArtwork: Optional[bool] = None
    hasFoiling: Optional[bool] = None


class ItemSummary(BaseModel):
    total: Annotated[
        Optional[float],
        Field(description="Total amount for the order item", examples=[150.0]),
    ] = None
    itemStatus: Annotated[
        Optional[ItemStatus1], Field(description="Status of the order item")
    ] = None
    status: Annotated[
        Optional[Status1], Field(description="Article status of the order item")
    ] = None
    thumbnailUrl: Annotated[
        Optional[str],
        Field(
            description="URL for the thumbnail image of the order item",
            examples=["https://example.com/thumbnail.jpg"],
        ),
    ] = None
    itemDescription: Annotated[
        Optional[str],
        Field(
            description="Description of the order item",
            examples=["This is a description of the order item."],
        ),
    ] = None
    viewThisQuoteLink: Annotated[
        Optional[str],
        Field(
            description="Link to view the quote for the order item",
            examples=["https://example.com/viewQuote"],
        ),
    ] = None
    customDimensions: Optional[Dimensions] = None
    alternativeTitle: Annotated[
        Optional[str],
        Field(
            description="Alternative title for the order item",
            examples=["My custom booklet"],
        ),
    ] = None
    alternativeDescription: Annotated[
        Optional[str],
        Field(
            description="Alternative description for the order item",
            examples=["Edition 1 of my custom booklet"],
        ),
    ] = None
    discountCodes: Optional[List[ItemDiscountCodeExtendedReference]] = None
    publicationConfig: Optional[PublicationConfig] = None
    problemReports: Optional[List[ProblemWithOrderSummary]] = None
    externalMetadata: ExternalItemMetadata
    discountTotal: Annotated[
        Optional[float],
        Field(description="Total discount amount for the order item", examples=[20.0]),
    ] = None
    universalKey: Annotated[
        Optional[str],
        Field(
            description="Universal Key: This is a shorthand notation of the item specification",
            examples=["10~1-bd{4bt-5c-4f-200p-1st-3sw}-cr{5c-5c+-4f-4l-1st-7sw}"],
        ),
    ] = None
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier for the order item",
            examples=["4cb78867-c6c7-4915-b1a5-68b5f6bef572"],
        ),
    ] = None
    allowReorder: Annotated[
        Optional[bool],
        Field(
            description="Indicates if reordering is allowed for the order item",
            examples=[True],
        ),
    ] = None
    itemSpecification: Optional[ItemSpecification] = None


class OrderSummary(BaseModel):
    id: Annotated[
        Optional[str],
        Field(
            description="Unique identifier for the order",
            examples=["66588e6ee56ff71f589d2d9a"],
        ),
    ] = None
    orderNumber: Annotated[
        Optional[int],
        Field(description="Customer facing order reference", examples=[123456]),
    ] = None
    orderStatus: Annotated[
        Optional[OrderStatus], Field(description="Current status of the order")
    ] = None
    lastModifiedDate: Optional[DateTimestamp] = None
    createdDate: Optional[DateTimestamp] = None
    confirmedDate: Optional[DateTimestamp] = None
    total: Annotated[
        Optional[float],
        Field(description="Total amount for the order", examples=[150.0]),
    ] = None
    totalPaid: Annotated[
        Optional[float],
        Field(description="Total amount paid for the order", examples=[100.0]),
    ] = None
    tax: Optional[TaxSummary] = None
    externalMetadata: ExternalOrderMetadata
    deliveries: Optional[List[DeliverySummary]] = None
    shipments: Optional[List[ShipmentSummary]] = None
    orderItems: Optional[List[ItemSummary]] = None
    totalAfterDiscount: Annotated[
        Optional[float],
        Field(description="Total amount after applying discounts", examples=[160.0]),
    ] = None
    discountTotal: Annotated[
        Optional[float], Field(description="Total amount of discount", examples=[120.0])
    ] = None


class CreateOrderRequest(BaseModel):
    metadata: ExternalOrderMetadata
    orderItems: Annotated[
        List[CreateOrderRequestItem],
        Field(
            description="Order Items: A list of order items",
            max_length=2147483647,
            min_length=1,
        ),
    ]
    billingAddress: AddressSummary
    invoiceAddress: AddressSummary
    deliveries: Annotated[
        List[CreateOrderDelivery],
        Field(
            description="A list of delivery addresses and the specified number of copies for each item that need to be sent to that address",
            max_length=2147483647,
            min_length=1,
        ),
    ]
    plainPackaging: Annotated[
        bool,
        Field(
            description="Indicates if the item should be shipped with plain unbranded packaging",
            examples=[False],
        ),
    ]
    paymentMethod: Annotated[
        PaymentMethod,
        Field(
            description="Payment methods available for transactions",
            examples=["TEST_ORDER"],
        ),
    ]


class CreateOrderRequestItem(BaseModel):
    product: Annotated[Product, Field(description="Enumeration of product types")]
    subProductId: Annotated[
        int,
        Field(
            description="The 'subProductId' for the item. Must be either '0' or greater than or equal to '100001'",
            ge=0,
            le=100100,
        ),
    ]
    quoteType: Annotated[
        QuoteType,
        Field(description="Enumeration of possible quote types.", examples=["QUOTE"]),
    ]
    itemSpecification: Optional[ItemSpecification] = None
    universalKey: Annotated[
        Optional[str],
        Field(
            description="Universal Key: This is a shorthand notation of the item specification",
            examples=["10~1-bd{4bt-5c-4f-200p-1st-3sw}-cr{5c-5c+-4f-4l-1st-7sw}"],
        ),
    ] = None
    spineWidth: Annotated[
        Optional[float],
        Field(
            description="Spine width given using the appropriate UnitType. Used for standalone DustJackets",
            examples=[10],
        ),
    ] = None
    assets: Annotated[
        List[CreateOrderRequestItemAsset],
        Field(
            description="Assets: A list of assets associated with the order item",
            max_length=2147483647,
            min_length=1,
        ),
    ]
    metadata: ExternalItemMetadata
    offerId: Annotated[
        Optional[str],
        Field(
            description="The ID of the offer. This is returned from the offer API and is associated with each offer type. Leave blank if you want to use the default price offer without doing a price query"
        ),
    ] = None


class GetOfferRequest(BaseModel):
    productId: Annotated[int, Field(description="ID of the product", examples=[1])]
    subProductId: Annotated[
        int, Field(description="ID of the sub-product", examples=[100002])
    ]
    productName: Annotated[
        str,
        Field(description="Name of the product", examples=["My Awesome Comic Book"]),
    ]
    quoteType: Annotated[
        QuoteType,
        Field(description="Enumeration of possible quote types.", examples=["QUOTE"]),
    ]
    itemSpecification: Optional[ItemSpecification] = None
    universalKey: Annotated[
        Optional[str],
        Field(
            description="Universal Key: This is a shorthand notation of the item specification",
            examples=["10~1-bd{4bt-5c-4f-200p-1st-3sw}-cr{5c-5c+-4f-4l-1st-7sw}"],
        ),
    ] = None
    spineWidth: Annotated[
        Optional[float],
        Field(
            description="Spine width given using the appropriate UnitType. Used for standalone DustJackets",
            examples=[10],
        ),
    ] = None


class GetUserQuotesResponse(BaseModel):
    quotes: Optional[List[OrderSummary]] = None


class GetUserOrdersResponse(BaseModel):
    orders: Optional[List[OrderSummary]] = None


class GetProductMetadataResponse(BaseModel):
    productMetadata: Optional[ProductMetadata] = None


class ProductMetadata(BaseModel):
    productId: Optional[int] = None
    subProductId: Optional[int] = None
    santaType: Annotated[
        Optional[SantaType], Field(description="Enumeration of possible quote types.")
    ] = None
    standardSizes: Optional[List[StandardSizeMetadata]] = None
    substrateTypes: Optional[List[SubstrateTypeMetadata]] = None
    productName: Optional[str] = None
    boundMetadata: Optional[BoundMetadata] = None
    coverSubstrateTypes: Optional[List[SubstrateTypeMetadata]] = None
    laminationMetadata: Optional[LaminationMetadata] = None
    coloursMetadata: Optional[ColoursMetadata] = None
    foilingMetadata: Optional[FoilingMetadata] = None
    componentRequirements: Optional[List[ComponentRequirement]] = None
    substrateDesigns: Optional[List[SubstrateDesignMetadata]] = None
    copiesMetadata: Optional[CopiesMetadata] = None
    defaultOrientation: Annotated[
        Optional[DefaultOrientation], Field(description="Enumeration of orientations.")
    ] = None
    envelopeSubstrateTypes: Optional[List[SubstrateTypeMetadata]] = None
    customSizeMetadata: Optional[CustomSizeMetadata] = None
    flapMetadata: Optional[FlapMetadata] = None
    autoOrientable: Optional[bool] = None
    preDrilledHolesMetadata: Optional[PreDrilledHolesMetadata] = None
    shrinkWrapMetadata: Optional[ShrinkWrapMetadata] = None
    customsExportCode: Optional[str] = None
    publicationMetadata: Optional[PublicationMetadata] = None
    initialSpecification: Optional[ItemSpecification] = None
    framedMetadata: Optional[FramedMetadata] = None
    roundedCorners: Optional[RoundedCorners] = None


class GetOrderResponse(BaseModel):
    order: Optional[OrderSummary] = None


class BoundComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    pages: Annotated[
        int, Field(description="Number of pages (not spreads)", examples=[100])
    ]
    binding: Binding
    ribbonColour: Annotated[
        RibbonColour,
        Field(
            description="Enumeration of ribbon colours for a bound item. Only applicable to case bound books",
            examples=["NONE"],
        ),
    ] = "NONE"


class CoverComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    foiling: Optional[Foiling] = None
    backColours: Annotated[
        BackColours,
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing",
            examples=["GRAYSCALE"],
        ),
    ] = "NONE"
    backLamination: Annotated[
        BackLamination,
        Field(description="Enumeration of lamination types.", examples=["GLOSS"]),
    ] = "NONE"
    backFoiling: Optional[Foiling] = None
    coverArea: Annotated[
        CoverArea,
        Field(description="Enumeration of cover areas", examples=["FRONT_AND_BACK"]),
    ] = "FRONT_AND_BACK"


class DustJacketComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    foiling: Optional[Foiling] = None
    backColours: Annotated[
        BackColours,
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing",
            examples=["GRAYSCALE"],
        ),
    ] = "NONE"
    backLamination: Annotated[
        BackLamination,
        Field(description="Enumeration of lamination types.", examples=["GLOSS"]),
    ] = "NONE"
    backFoiling: Optional[Foiling] = None
    flapWidth: Annotated[
        FlapWidth,
        Field(description="Enumeration for dust jacket flap width", examples=["MM_80"]),
    ] = "AUTOMATIC"
    customFlapWidth: Annotated[
        Optional[float],
        Field(
            description="Custom width of the dust-jacket flap if flapWidth is set to CUSTOM",
            examples=[100],
        ),
    ] = None


class EndPapersComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]


class EnvelopeComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    foiling: Optional[Foiling] = None


class FlatComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    foiling: Optional[Foiling] = None
    backColours: Annotated[
        BackColours,
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing",
            examples=["GRAYSCALE"],
        ),
    ] = "NONE"
    backLamination: Annotated[
        BackLamination,
        Field(description="Enumeration of lamination types.", examples=["GLOSS"]),
    ] = "NONE"
    backFoiling: Optional[Foiling] = None
    roundCorners: Annotated[
        bool,
        Field(description="Whether the item has rounded corners.", examples=[False]),
    ] = False


class FoldedComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    lamination: Annotated[
        Lamination,
        Field(description="Enumeration of lamination types.", examples=["NONE"]),
    ]
    foiling: Optional[Foiling] = None
    backColours: Annotated[
        BackColours,
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing",
            examples=["GRAYSCALE"],
        ),
    ] = "NONE"
    backLamination: Annotated[
        BackLamination,
        Field(description="Enumeration of lamination types.", examples=["GLOSS"]),
    ] = "NONE"
    backFoiling: Optional[Foiling] = None
    simpleFold: Annotated[
        SimpleFold,
        Field(description="Enumeration of simple fold types", examples=["HALF"]),
    ]
    sides: Annotated[
        int,
        Field(description="Number of sides/panels for the folded item.", examples=[2]),
    ]
    flatOnDelivery: Annotated[
        bool,
        Field(
            description="Indicates if the item should be delivered flat instead of folded",
            examples=[False],
        ),
    ] = False


class FramedComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    frameDepth: Annotated[
        FrameDepth,
        Field(description="Enumeration of frame depths.", examples=["MM_18"]),
    ]
    border: Annotated[
        Border,
        Field(
            description="Enumeration of border types for framed artwork",
            examples=["WRAP_AROUND"],
        ),
    ]


class SamplePackComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    samplePackType: Annotated[
        SamplePackType,
        Field(
            description="Represents different types of sample packs.",
            examples=["PREMIUM_PRODUCTS"],
        ),
    ]


class ShrinkWrapComponent(BaseModel):
    format: Annotated[
        int,
        Field(
            description="DIN size of the component. The correct format must be specified when a standard size is present.",
            examples=[4],
        ),
    ]
    bundleSize: Annotated[
        int,
        Field(description="The number of items wrapped in each bundle", examples=[10]),
    ]


class Component1(BoundComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["0"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component2(CoverComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["1"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component3(DustJacketComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["2"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component4(EndPapersComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["3"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component5(EnvelopeComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["4"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component6(FlatComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["5"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component7(FoldedComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["6"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component8(FramedComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["7"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


class Component9(ShrinkWrapComponent):
    embellishments: Optional[Embellishments] = None
    laminatedComponent: Optional[bool] = None
    foiledComponent: Optional[bool] = None
    componentType: Annotated[
        Literal["8"], Field(description="Enumeration of component types")
    ]
    format: Optional[int] = None
    colours: Annotated[
        Optional[Colours],
        Field(
            description="Enumeration of printing colours. Indicates if there is printing and if so what type of printing"
        ),
    ] = None
    customSize: Optional[CustomSize] = None
    folded: Optional[bool] = None
    orientation: Annotated[
        Optional[Orientation], Field(description="Enumeration of orientations.")
    ] = None
    substrate: Optional[Substrate] = None
    twoSidedComponent: Optional[bool] = None
    preDrilledHoles: Annotated[
        Optional[PreDrilledHoles],
        Field(description="Enumeration of pre-drilled holes strategies."),
    ] = None
    standardSize: Annotated[
        Optional[StandardSize], Field(description="Enumeration of standard sizes.")
    ] = None
    hasCustomSize: Optional[bool] = None


Component.model_rebuild()
CreateOrderResponse.model_rebuild()
ItemSpecification.model_rebuild()
CreateOrderRequest.model_rebuild()
GetProductMetadataResponse.model_rebuild()
BoundComponent.model_rebuild()
CoverComponent.model_rebuild()
DustJacketComponent.model_rebuild()
EndPapersComponent.model_rebuild()
EnvelopeComponent.model_rebuild()
FlatComponent.model_rebuild()
FoldedComponent.model_rebuild()
FramedComponent.model_rebuild()
SamplePackComponent.model_rebuild()
ShrinkWrapComponent.model_rebuild()
Component1.model_rebuild()
Component2.model_rebuild()
Component3.model_rebuild()
Component4.model_rebuild()
Component5.model_rebuild()
Component6.model_rebuild()
Component7.model_rebuild()
Component8.model_rebuild()
Component9.model_rebuild()

# --- Auto-resolve forward refs (added by generator script) ---
try:
    from pydantic import BaseModel, RootModel  # type: ignore
    _g = globals()
    _models = []
    for _name, _obj in list(_g.items()):
        try:
            if isinstance(_obj, type) and issubclass(_obj, (BaseModel, RootModel)) and _obj.__module__ == __name__:
                _models.append(_obj)
        except Exception:
            pass
    for _m in _models:
        try:
            _m.model_rebuild(_types_namespace=_g)  # type: ignore[attr-defined]
        except Exception:
            pass
except Exception:
    pass
# --- End forward refs patch ---
