import numpy as np
from . import core as jiminy, tree as tree
from .dynamics import State as State, Trajectory as Trajectory
from _typeshed import Incomplete
from typing import Any, Callable, Literal, Sequence, overload

FieldNested: Incomplete
UpdateHook = Callable[[float, np.ndarray, np.ndarray | None], None]
read_log: Incomplete

@overload
def extract_variables_from_log(log_vars: dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[False] = False) -> list[np.ndarray]: ...
@overload
def extract_variables_from_log(log_vars: dict[str, np.ndarray], fieldnames: FieldNested, namespace: str = '', *, as_dict: Literal[True]) -> dict[str, np.ndarray]: ...
def build_robot_from_log(log_data: dict[str, Any], mesh_dir_path: str | None = None, mesh_package_dirs: Sequence[str] = (), *, robot_name: str | None = None) -> jiminy.Robot: ...
def build_robots_from_log(log_data: dict[str, Any], mesh_dir_path: str | None = None, mesh_package_dirs: Sequence[str] = ()) -> Sequence[jiminy.Robot]: ...
def extract_trajectory_from_log(log_data: dict[str, Any], robot: jiminy.Robot | None = None, *, robot_name: str | None = None) -> Trajectory: ...
def extract_trajectories_from_log(log_data: dict[str, Any], robots: Sequence[jiminy.Robot] | None = None) -> dict[str, Trajectory]: ...
def update_sensor_measurements_from_log(log_data: dict[str, Any], robot: jiminy.Model) -> UpdateHook: ...
