"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

import httpx
from typing import Optional
from dataclasses import dataclass

from mollie.models import ClientError

MAX_MESSAGE_LEN = 10_000


@dataclass(frozen=True)
class APIError(ClientError):
    """The fallback error class if no more specific error class is matched."""

    def __init__(
        self, message: str, raw_response: httpx.Response, body: Optional[str] = None
    ):
        body_display = body or raw_response.text or '""'

        if message:
            message += ": "
        message += f"Status {raw_response.status_code}"

        headers = raw_response.headers
        content_type = headers.get("content-type", '""')
        if content_type != "application/json":
            if " " in content_type:
                content_type = f'"{content_type}"'
            message += f" Content-Type {content_type}"

        if len(body_display) > MAX_MESSAGE_LEN:
            truncated = body_display[:MAX_MESSAGE_LEN]
            remaining = len(body_display) - MAX_MESSAGE_LEN
            body_display = f"{truncated}...and {remaining} more chars"

        message += f". Body: {body_display}"
        message = message.strip()

        super().__init__(message, raw_response, body)
