"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .amount_nullable import AmountNullable, AmountNullableTypedDict
from .payment_address import PaymentAddress, PaymentAddressTypedDict
from .payment_line_item import PaymentLineItem, PaymentLineItemTypedDict
from .payment_link_sequence_type import PaymentLinkSequenceType
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, HeaderMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class CreatePaymentLinkApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentLinkApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class CreatePaymentLinkRequestBodyTypedDict(TypedDict):
    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """
    id: NotRequired[str]
    amount: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    minimum_amount: NotRequired[Nullable[AmountNullableTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    redirect_url: NotRequired[Nullable[str]]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """
    webhook_url: NotRequired[Nullable[str]]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    lines: NotRequired[Nullable[List[PaymentLineItemTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[PaymentAddressTypedDict]
    shipping_address: NotRequired[PaymentAddressTypedDict]
    profile_id: NotRequired[Nullable[str]]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    reusable: NotRequired[Nullable[bool]]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """
    expires_at: NotRequired[Nullable[str]]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """
    allowed_methods: NotRequired[Nullable[List[str]]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """
    application_fee: NotRequired[CreatePaymentLinkApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """
    sequence_type: NotRequired[PaymentLinkSequenceType]
    customer_id: NotRequired[Nullable[str]]
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """


class CreatePaymentLinkRequestBody(BaseModel):
    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """

    id: Optional[str] = None

    amount: OptionalNullable[AmountNullable] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    minimum_amount: Annotated[
        OptionalNullable[AmountNullable], pydantic.Field(alias="minimumAmount")
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    lines: OptionalNullable[List[PaymentLineItem]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="billingAddress")
    ] = None

    shipping_address: Annotated[
        Optional[PaymentAddress], pydantic.Field(alias="shippingAddress")
    ] = None

    profile_id: Annotated[OptionalNullable[str], pydantic.Field(alias="profileId")] = (
        UNSET
    )
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    reusable: OptionalNullable[bool] = UNSET
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """

    expires_at: Annotated[OptionalNullable[str], pydantic.Field(alias="expiresAt")] = (
        UNSET
    )
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """

    allowed_methods: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="allowedMethods")
    ] = UNSET
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """

    application_fee: Annotated[
        Optional[CreatePaymentLinkApplicationFee],
        pydantic.Field(alias="applicationFee"),
    ] = None
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    sequence_type: Annotated[
        Optional[PaymentLinkSequenceType], pydantic.Field(alias="sequenceType")
    ] = None

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """

    testmode: OptionalNullable[bool] = UNSET
    r"""Whether to create the entity in test mode or live mode.

    Most API credentials are specifically created for either live mode or test mode, in which case this parameter can be
    omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting
    `testmode` to `true`.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "amount",
            "minimumAmount",
            "redirectUrl",
            "webhookUrl",
            "lines",
            "billingAddress",
            "shippingAddress",
            "profileId",
            "reusable",
            "expiresAt",
            "allowedMethods",
            "applicationFee",
            "sequenceType",
            "customerId",
            "testmode",
        ]
        nullable_fields = [
            "amount",
            "minimumAmount",
            "redirectUrl",
            "webhookUrl",
            "lines",
            "profileId",
            "reusable",
            "expiresAt",
            "allowedMethods",
            "customerId",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CreatePaymentLinkRequestTypedDict(TypedDict):
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
    request_body: NotRequired[CreatePaymentLinkRequestBodyTypedDict]


class CreatePaymentLinkRequest(BaseModel):
    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""

    request_body: Annotated[
        Optional[CreatePaymentLinkRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None
