"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .balance_report_grouping import BalanceReportGrouping
from .sub_group import SubGroup, SubGroupTypedDict
from .url import URL, URLTypedDict
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import validate_open_enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import PlainValidator
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class PendingBalanceTypedDict(TypedDict):
    r"""The pending balance. Only available if grouping is `status-balances`."""

    open: NotRequired[SubGroupTypedDict]
    close: NotRequired[SubGroupTypedDict]
    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]


class PendingBalance(BaseModel):
    r"""The pending balance. Only available if grouping is `status-balances`."""

    open: Optional[SubGroup] = None

    close: Optional[SubGroup] = None

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None


class AvailableBalanceTypedDict(TypedDict):
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: NotRequired[SubGroupTypedDict]
    moved_from_pending: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]
    close: NotRequired[SubGroupTypedDict]


class AvailableBalance(BaseModel):
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: Optional[SubGroup] = None

    moved_from_pending: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedFromPending")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None

    close: Optional[SubGroup] = None


class OpenTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    available: NotRequired[SubGroupTypedDict]


class Open(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    available: Optional[SubGroup] = None


class CloseTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    available: NotRequired[SubGroupTypedDict]


class Close(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    available: Optional[SubGroup] = None


class PaymentsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Payments(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class RefundsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Refunds(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class ChargebacksTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Chargebacks(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class CapitalTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Capital(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class TransfersTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Transfers(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class FeePrepaymentsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class FeePrepayments(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class CorrectionsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Corrections(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class TopupsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[SubGroupTypedDict]
    moved_to_available: NotRequired[SubGroupTypedDict]
    immediately_available: NotRequired[SubGroupTypedDict]


class Topups(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[SubGroup] = None

    moved_to_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[SubGroup], pydantic.Field(alias="immediatelyAvailable")
    ] = None


class TotalsTypedDict(TypedDict):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    pending_balance: NotRequired[Nullable[PendingBalanceTypedDict]]
    r"""The pending balance. Only available if grouping is `status-balances`."""
    available_balance: NotRequired[Nullable[AvailableBalanceTypedDict]]
    r"""The available balance. Only available if grouping is `status-balances`."""
    open: NotRequired[OpenTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    close: NotRequired[CloseTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    payments: NotRequired[PaymentsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    refunds: NotRequired[RefundsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    chargebacks: NotRequired[ChargebacksTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    capital: NotRequired[CapitalTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    transfers: NotRequired[TransfersTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    fee_prepayments: NotRequired[FeePrepaymentsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    corrections: NotRequired[CorrectionsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    topups: NotRequired[TopupsTypedDict]
    r"""Only available on `transaction-categories` grouping."""


class Totals(BaseModel):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    pending_balance: Annotated[
        OptionalNullable[PendingBalance], pydantic.Field(alias="pendingBalance")
    ] = UNSET
    r"""The pending balance. Only available if grouping is `status-balances`."""

    available_balance: Annotated[
        OptionalNullable[AvailableBalance], pydantic.Field(alias="availableBalance")
    ] = UNSET
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: Optional[Open] = None
    r"""Only available on `transaction-categories` grouping."""

    close: Optional[Close] = None
    r"""Only available on `transaction-categories` grouping."""

    payments: Optional[Payments] = None
    r"""Only available on `transaction-categories` grouping."""

    refunds: Optional[Refunds] = None
    r"""Only available on `transaction-categories` grouping."""

    chargebacks: Optional[Chargebacks] = None
    r"""Only available on `transaction-categories` grouping."""

    capital: Optional[Capital] = None
    r"""Only available on `transaction-categories` grouping."""

    transfers: Optional[Transfers] = None
    r"""Only available on `transaction-categories` grouping."""

    fee_prepayments: Annotated[
        Optional[FeePrepayments], pydantic.Field(alias="fee-prepayments")
    ] = None
    r"""Only available on `transaction-categories` grouping."""

    corrections: Optional[Corrections] = None
    r"""Only available on `transaction-categories` grouping."""

    topups: Optional[Topups] = None
    r"""Only available on `transaction-categories` grouping."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "pendingBalance",
            "availableBalance",
            "open",
            "close",
            "payments",
            "refunds",
            "chargebacks",
            "capital",
            "transfers",
            "fee-prepayments",
            "corrections",
            "topups",
        ]
        nullable_fields = ["pendingBalance", "availableBalance"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EntityBalanceReportLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityBalanceReportLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[URL], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EntityBalanceReportTypedDict(TypedDict):
    resource: NotRequired[str]
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this
    endpoint.
    """
    balance_id: NotRequired[str]
    time_zone: NotRequired[str]
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""
    from_: NotRequired[str]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time.
    This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 00:00:00 CET and
    onwards.
    """
    until: NotRequired[str]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET.
    """
    grouping: NotRequired[BalanceReportGrouping]
    totals: NotRequired[TotalsTypedDict]
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """
    links: NotRequired[EntityBalanceReportLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class EntityBalanceReport(BaseModel):
    resource: Optional[str] = None
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this
    endpoint.
    """

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None

    time_zone: Annotated[Optional[str], pydantic.Field(alias="timeZone")] = None
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""

    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time.
    This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 00:00:00 CET and
    onwards.
    """

    until: Optional[str] = None
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET.
    """

    grouping: Annotated[
        Optional[BalanceReportGrouping], PlainValidator(validate_open_enum(False))
    ] = None

    totals: Optional[Totals] = None
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    links: Annotated[
        Optional[EntityBalanceReportLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
