"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .amount import Amount, AmountTypedDict
from .route_destination_type_response import RouteDestinationTypeResponse
from .url import URL, URLTypedDict
from mollie.types import BaseModel
from mollie.utils import validate_open_enum
import pydantic
from pydantic.functional_validators import PlainValidator
from typing_extensions import Annotated, TypedDict


class RouteCreateResponseDestinationTypedDict(TypedDict):
    r"""The destination of the route."""

    type: RouteDestinationTypeResponse
    r"""The type of destination. Currently only the destination type `organization` is supported."""
    organization_id: str


class RouteCreateResponseDestination(BaseModel):
    r"""The destination of the route."""

    type: Annotated[
        RouteDestinationTypeResponse, PlainValidator(validate_open_enum(False))
    ]
    r"""The type of destination. Currently only the destination type `organization` is supported."""

    organization_id: Annotated[str, pydantic.Field(alias="organizationId")]


class RouteCreateResponseLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: URLTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteCreateResponseLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[URL, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: URL
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class RouteCreateResponseTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""
    id: str
    payment_id: str
    amount: AmountTypedDict
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    description: str
    r"""The description of the route. This description is shown in the reports."""
    destination: RouteCreateResponseDestinationTypedDict
    r"""The destination of the route."""
    links: RouteCreateResponseLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class RouteCreateResponse(BaseModel):
    resource: str
    r"""Indicates the response contains a route object. Will always contain the string `route` for this endpoint."""

    id: str

    payment_id: Annotated[str, pydantic.Field(alias="paymentId")]

    amount: Amount
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    description: str
    r"""The description of the route. This description is shown in the reports."""

    destination: RouteCreateResponseDestination
    r"""The destination of the route."""

    links: Annotated[RouteCreateResponseLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
