"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import (
    FieldMetadata,
    HeaderMetadata,
    PathParamMetadata,
    RequestMetadata,
)
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateProfileMode(str, Enum):
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """

    LIVE = "live"
    TEST = "test"


class UpdateProfileRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """
    website: NotRequired[Nullable[str]]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs
    are allowed.
    """
    email: NotRequired[Nullable[str]]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[Nullable[str]]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[Nullable[List[str]]]
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """
    business_category: NotRequired[Nullable[str]]
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types) for all possible options.
    """
    mode: NotRequired[Nullable[UpdateProfileMode]]
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """


class UpdateProfileRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or
    application.
    """

    website: OptionalNullable[str] = UNSET
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs
    are allowed.
    """

    email: OptionalNullable[str] = UNSET
    r"""The email address associated with the profile's trade name or brand."""

    phone: OptionalNullable[str] = UNSET
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = UNSET
    r"""A list of countries where you expect that the majority of the profile's customers reside,
    in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.
    """

    business_category: Annotated[
        OptionalNullable[str], pydantic.Field(alias="businessCategory")
    ] = UNSET
    r"""The industry associated with the profile's trade name or brand. Please refer to the
    [business category list](common-data-types) for all possible options.
    """

    mode: OptionalNullable[UpdateProfileMode] = UNSET
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review
    the profile before it can start accepting payments.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        nullable_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: UpdateProfileRequestBodyTypedDict
    idempotency_key: NotRequired[str]
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""


class UpdateProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        UpdateProfileRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]

    idempotency_key: Annotated[
        Optional[str],
        pydantic.Field(alias="idempotency-key"),
        FieldMetadata(header=HeaderMetadata(style="simple", explode=False)),
    ] = None
    r"""A unique key to ensure idempotent requests. This key should be a UUID v4 string."""
