# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetVmClusterPatchHistoryEntriesResult',
    'AwaitableGetVmClusterPatchHistoryEntriesResult',
    'get_vm_cluster_patch_history_entries',
    'get_vm_cluster_patch_history_entries_output',
]

@pulumi.output_type
class GetVmClusterPatchHistoryEntriesResult:
    """
    A collection of values returned by getVmClusterPatchHistoryEntries.
    """
    def __init__(__self__, filters=None, id=None, patch_history_entries=None, vm_cluster_id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if patch_history_entries and not isinstance(patch_history_entries, list):
            raise TypeError("Expected argument 'patch_history_entries' to be a list")
        pulumi.set(__self__, "patch_history_entries", patch_history_entries)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetVmClusterPatchHistoryEntriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="patchHistoryEntries")
    def patch_history_entries(self) -> Sequence['outputs.GetVmClusterPatchHistoryEntriesPatchHistoryEntryResult']:
        """
        The list of patch_history_entries.
        """
        return pulumi.get(self, "patch_history_entries")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetVmClusterPatchHistoryEntriesResult(GetVmClusterPatchHistoryEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterPatchHistoryEntriesResult(
            filters=self.filters,
            id=self.id,
            patch_history_entries=self.patch_history_entries,
            vm_cluster_id=self.vm_cluster_id)


def get_vm_cluster_patch_history_entries(filters: Optional[Sequence[Union['GetVmClusterPatchHistoryEntriesFilterArgs', 'GetVmClusterPatchHistoryEntriesFilterArgsDict']]] = None,
                                         vm_cluster_id: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterPatchHistoryEntriesResult:
    """
    This data source provides the list of Vm Cluster Patch History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the patch actions performed on the specified VM cluster in an Exadata Cloud@Customer system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_patch_history_entries = oci.Database.get_vm_cluster_patch_history_entries(vm_cluster_id=test_vm_cluster["id"])
    ```


    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterPatchHistoryEntries:getVmClusterPatchHistoryEntries', __args__, opts=opts, typ=GetVmClusterPatchHistoryEntriesResult).value

    return AwaitableGetVmClusterPatchHistoryEntriesResult(
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        patch_history_entries=pulumi.get(__ret__, 'patch_history_entries'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))


@_utilities.lift_output_func(get_vm_cluster_patch_history_entries)
def get_vm_cluster_patch_history_entries_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetVmClusterPatchHistoryEntriesFilterArgs', 'GetVmClusterPatchHistoryEntriesFilterArgsDict']]]]] = None,
                                                vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVmClusterPatchHistoryEntriesResult]:
    """
    This data source provides the list of Vm Cluster Patch History Entries in Oracle Cloud Infrastructure Database service.

    Gets the history of the patch actions performed on the specified VM cluster in an Exadata Cloud@Customer system.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_patch_history_entries = oci.Database.get_vm_cluster_patch_history_entries(vm_cluster_id=test_vm_cluster["id"])
    ```


    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
