# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDesktopResult',
    'AwaitableGetDesktopResult',
    'get_desktop',
    'get_desktop_output',
]

@pulumi.output_type
class GetDesktopResult:
    """
    A collection of values returned by getDesktop.
    """
    def __init__(__self__, defined_tags=None, desktop_id=None, device_policies=None, display_name=None, freeform_tags=None, hosting_options=None, id=None, pool_id=None, state=None, time_created=None, user_name=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if desktop_id and not isinstance(desktop_id, str):
            raise TypeError("Expected argument 'desktop_id' to be a str")
        pulumi.set(__self__, "desktop_id", desktop_id)
        if device_policies and not isinstance(device_policies, list):
            raise TypeError("Expected argument 'device_policies' to be a list")
        pulumi.set(__self__, "device_policies", device_policies)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hosting_options and not isinstance(hosting_options, list):
            raise TypeError("Expected argument 'hosting_options' to be a list")
        pulumi.set(__self__, "hosting_options", hosting_options)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if pool_id and not isinstance(pool_id, str):
            raise TypeError("Expected argument 'pool_id' to be a str")
        pulumi.set(__self__, "pool_id", pool_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if user_name and not isinstance(user_name, str):
            raise TypeError("Expected argument 'user_name' to be a str")
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="desktopId")
    def desktop_id(self) -> str:
        return pulumi.get(self, "desktop_id")

    @property
    @pulumi.getter(name="devicePolicies")
    def device_policies(self) -> Sequence['outputs.GetDesktopDevicePolicyResult']:
        """
        Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policies")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user friendly display name. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostingOptions")
    def hosting_options(self) -> Sequence['outputs.GetDesktopHostingOptionResult']:
        """
        Provides information about where a desktop is hosted.
        """
        return pulumi.get(self, "hosting_options")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The OCID of the desktop pool the desktop is a member of.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the desktop.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The owner of the desktop.
        """
        return pulumi.get(self, "user_name")


class AwaitableGetDesktopResult(GetDesktopResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDesktopResult(
            defined_tags=self.defined_tags,
            desktop_id=self.desktop_id,
            device_policies=self.device_policies,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            hosting_options=self.hosting_options,
            id=self.id,
            pool_id=self.pool_id,
            state=self.state,
            time_created=self.time_created,
            user_name=self.user_name)


def get_desktop(desktop_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDesktopResult:
    """
    This data source provides details about a specific Desktop resource in Oracle Cloud Infrastructure Desktops service.

    Provides information about the desktop with the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop = oci.Desktops.get_desktop(desktop_id=test_desktop_oci_desktops_desktop["id"])
    ```


    :param str desktop_id: The OCID of the desktop.
    """
    __args__ = dict()
    __args__['desktopId'] = desktop_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Desktops/getDesktop:getDesktop', __args__, opts=opts, typ=GetDesktopResult).value

    return AwaitableGetDesktopResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        desktop_id=pulumi.get(__ret__, 'desktop_id'),
        device_policies=pulumi.get(__ret__, 'device_policies'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hosting_options=pulumi.get(__ret__, 'hosting_options'),
        id=pulumi.get(__ret__, 'id'),
        pool_id=pulumi.get(__ret__, 'pool_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        user_name=pulumi.get(__ret__, 'user_name'))


@_utilities.lift_output_func(get_desktop)
def get_desktop_output(desktop_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDesktopResult]:
    """
    This data source provides details about a specific Desktop resource in Oracle Cloud Infrastructure Desktops service.

    Provides information about the desktop with the specified OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_desktop = oci.Desktops.get_desktop(desktop_id=test_desktop_oci_desktops_desktop["id"])
    ```


    :param str desktop_id: The OCID of the desktop.
    """
    ...
