"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuntimeImagesWidget = exports.RUNTIME_IMAGES_NAMESPACE = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const metadata_common_1 = require("@elyra/metadata-common");
exports.RUNTIME_IMAGES_NAMESPACE = 'runtime-images';
const RUNTIME_IMAGES_CLASS = 'elyra-metadata-runtime-images';
const getLinkFromImageName = (imageName) => {
    let hostname = '';
    const fqinParts = imageName.split('/');
    if (fqinParts[0].includes('.') ||
        fqinParts[0].includes(':') ||
        fqinParts[0].includes('localhost')) {
        hostname = fqinParts[0];
        imageName = fqinParts.slice(1).join('/');
    }
    if (!hostname || hostname.includes('docker.io')) {
        hostname = 'hub.docker.com/r';
    }
    const imageRepo = imageName.split(':')[0];
    return `https://${hostname}/${imageRepo}`;
};
/**
 * A React Component for displaying the runtime images list.
 */
class RuntimeImagesDisplay extends metadata_common_1.MetadataDisplay {
    renderExpandableContent(metadata) {
        return (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("h6", { children: "Container Image" }, void 0),
                jsx_runtime_1.jsx("a", Object.assign({ href: getLinkFromImageName(metadata.metadata.image_name), target: "_blank", rel: "noreferrer noopener" }, { children: metadata.metadata.image_name }), void 0)] }, void 0));
    }
}
/**
 * A widget for displaying runtime images.
 */
class RuntimeImagesWidget extends metadata_common_1.MetadataWidget {
    constructor(props) {
        super(props);
    }
    renderDisplay(metadata) {
        return (jsx_runtime_1.jsx(RuntimeImagesDisplay, { metadata: metadata, updateMetadata: this.updateMetadata, openMetadataEditor: this.openMetadataEditor, namespace: exports.RUNTIME_IMAGES_NAMESPACE, sortMetadata: true, className: RUNTIME_IMAGES_CLASS, labelName: () => {
                return 'runtime image';
            } }, void 0));
    }
}
exports.RuntimeImagesWidget = RuntimeImagesWidget;
//# sourceMappingURL=RuntimeImagesWidget.js.map