"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const pipeline_editor_1 = require("@elyra/pipeline-editor");
const application_1 = require("@jupyterlab/application");
const coreutils_1 = require("@jupyterlab/coreutils");
const v4_1 = __importDefault(require("uuid/v4"));
const pipeline_template_json_1 = __importDefault(require("./pipeline-template.json"));
/**
 * A utilities class for static functions.
 */
class Utils {
    /**
     * Utility to create a one node pipeline to submit a single file as a pipeline
     */
    static generateSingleFilePipeline(filename, runtime_platform, runtime_config, runtimeImage, dependencies, envObject, cpu, gpu, memory) {
        const template = JSON.parse(JSON.stringify(pipeline_template_json_1.default));
        const generated_uuid = v4_1.default();
        const artifactName = coreutils_1.PathExt.basename(filename, coreutils_1.PathExt.extname(filename));
        const envVars = Object.entries(envObject).map(([key, val]) => `${key}=${val}`);
        template.id = generated_uuid;
        template.primary_pipeline = generated_uuid;
        template.pipelines[0].id = generated_uuid;
        template.pipelines[0].nodes[0].id = generated_uuid;
        template.pipelines[0].nodes[0].app_data.ui_data.label = coreutils_1.PathExt.basename(filename);
        template.pipelines[0].nodes[0].app_data.component_parameters.filename = filename;
        template.pipelines[0].nodes[0].app_data.component_parameters.runtime_image = runtimeImage;
        template.pipelines[0].nodes[0].app_data.component_parameters.env_vars = envVars;
        template.pipelines[0].nodes[0].app_data.component_parameters.dependencies = dependencies;
        template.pipelines[0].nodes[0].app_data.component_parameters.cpu = cpu;
        template.pipelines[0].nodes[0].app_data.component_parameters.gpu = gpu;
        template.pipelines[0].nodes[0].app_data.component_parameters.memory = memory;
        template.pipelines[0].app_data.name = artifactName;
        template.pipelines[0].app_data.runtime = runtime_platform;
        template.pipelines[0].app_data['runtime-config'] = runtime_config;
        template.pipelines[0].app_data.version = pipeline_editor_1.PIPELINE_CURRENT_VERSION;
        template.pipelines[0].app_data.source = coreutils_1.PathExt.basename(filename);
        return template;
    }
    /**
     * Break an array into an array of "chunks", each "chunk" having "n" elements.
     * The final "chuck" may have less than "n" elements.
     * Example:
     * chunkArray(['a', 'b', 'c', 'd', 'e', 'f', 'g'], 4)
     * -> [['a', 'b', 'c', 'd'], ['e', 'f', 'g']]
     */
    static chunkArray(arr, n) {
        return Array.from(Array(Math.ceil(arr.length / n)), (_, i) => arr.slice(i * n, i * n + n));
    }
    /**
     * Check if the object is not an array, but the result of a Dialog instead
     */
    static isDialogResult(runtimesObj) {
        return runtimesObj && !(runtimesObj instanceof Array) && runtimesObj.button;
    }
}
exports.default = Utils;
/**
 * From a given widget, find the application shell and return it
 */
Utils.getLabShell = (widget) => {
    while (widget !== null && !(widget instanceof application_1.LabShell)) {
        widget = widget.parent;
    }
    return widget;
};
//# sourceMappingURL=utils.js.map