# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06-client-gen.ipynb (unless otherwise specified).

__all__ = ['generate_streams', 'save_api_client']

# Cell
from jinja2 import Template

from . import specgen, rawgen, clientprep

# Cell
def generate_streams(API_yaml_fp):
    request_type_to_date_range_example = {
        'SP_and_date': ('2020-01-01', '2020-01-01 1:30'),
        'date_range': ('2020-01-01', '2020-01-07'),
        'date_time_range': ('2020-01-01', '2020-01-07'),
        'year': ('2019-01-01', '2021-01-01'),
        'year_and_month': ('2020-01-01', '2020-06-01'),
        'year_and_week': ('2020-01-01', '2020-06-01'),
        'non_temporal': (None, None)
    }

    API_yaml = specgen.load_API_yaml(API_yaml_fp)
    functions = rawgen.construct_all_functions(API_yaml)
    method_info = clientprep.construct_method_info_dict(API_yaml_fp)

    streams = list()

    for function in functions:
        name = function['name']
        function_method_info = method_info[name]

        stream = dict()
        stream['name'] = name
        stream['description'] = function['description']
        stream['date_range_example'] = request_type_to_date_range_example[function_method_info['request_type']]
        stream['extra_kwargs'] = [param for param in function['parameters'] if param['name'] not in list(function_method_info['kwargs_map'].values())+['APIKey', 'ServiceType']]
        stream['request_type'] = function_method_info['request_type']
        stream['kwargs_map'] = function_method_info['kwargs_map']
        stream['func_params'] = list(function_method_info['func_kwargs'].keys())

        streams += [stream]

    return streams

# Cell
def save_api_client(
    API_yaml_fp: str,
    in_fp: str='../templates/api.py',
    out_fp: str='../ElexonDataPortal/api.py'
):
    streams = generate_streams(API_yaml_fp)
    rendered_schema = Template(open(in_fp).read()).render(streams=streams)

    with open(out_fp, 'w') as f:
        try:
            f.write(rendered_schema)
        except e as exc:
            raise exc