# id_card_recognition

## 简介

`id_card_recognition` 是一个使用 Moonshot 提供的 AI 模型进行身份证识别的 Python 库。

## 配置

### 创建 .env 文件

在项目根目录下创建一个 `.env` 文件，并添加以下内容：

```env
API_KEY= 你的 moonshot AI 秘钥，申请网址：https://platform.moonshot.cn/
IMAGE_DIRECTORY= 需要识别的身份证照片存放路径，默认为 ./images，图片名称可以是'.png', '.jpg', '.jpeg', '.bmp', '.gif'
RESULT_FILE_NAME= 识别结果文件名称，为文本文件，默认为 result.txt
CHOSEN_MODEL_NAME= 选择的模型名称，默认为 "moonshot-v1-8k"
```

### 示例 .env 文件

```env
API_KEY=sk-XXXXXXXXXXX
IMAGE_DIRECTORY=./images
RESULT_FILE_NAME=result.txt
CHOSEN_MODEL_NAME=moonshot-v1-8k
```

## 使用

### 添加引用

在您的 Python 脚本中添加对 `do_recognition` 函数的引用：

```python
from id_card_recognition.recognition import do_recognition
```

### 调用识别方法

调用 `do_recognition()` 方法返回识别结果。识别结果将保存在 `RESULT_FILE_NAME` 指定的文件中。

### 示例

创建一个新的 Python 文件（例如 `run_id_card_recognition.py`），并编写如下代码：

```python
from id_card_recognition.recognition import do_recognition

if __name__ == "__main__":
    # 运行身份证识别
    results = do_recognition()

    # 打印结果
    print(results)
```

### 运行示例

```bash
python run_id_card_recognition.py
```

## 许可证

MIT License
```

此 `README.md` 文件包含了如何配置环境变量、使用库和运行示例的详细步骤。确保您根据实际情况替换你的 API 密钥。
