# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'JobProgressArgs',
    'JobProgressPhaseArgs',
    'JobProgressPhaseExtractArgs',
    'JobProgressPhaseLogLocationArgs',
    'JobUnsupportedObjectArgs',
    'GetMigrationObjectTypesFilterArgs',
]

@pulumi.input_type
class JobProgressArgs:
    def __init__(__self__, *,
                 current_phase: Optional[pulumi.Input[str]] = None,
                 current_status: Optional[pulumi.Input[str]] = None,
                 phases: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]] = None):
        """
        :param pulumi.Input[str] current_phase: Current phase of the job.
        :param pulumi.Input[str] current_status: Current status of the job.
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]] phases: List of phase status for the job.
        """
        if current_phase is not None:
            pulumi.set(__self__, "current_phase", current_phase)
        if current_status is not None:
            pulumi.set(__self__, "current_status", current_status)
        if phases is not None:
            pulumi.set(__self__, "phases", phases)

    @property
    @pulumi.getter(name="currentPhase")
    def current_phase(self) -> Optional[pulumi.Input[str]]:
        """
        Current phase of the job.
        """
        return pulumi.get(self, "current_phase")

    @current_phase.setter
    def current_phase(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_phase", value)

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[pulumi.Input[str]]:
        """
        Current status of the job.
        """
        return pulumi.get(self, "current_status")

    @current_status.setter
    def current_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "current_status", value)

    @property
    @pulumi.getter
    def phases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]:
        """
        List of phase status for the job.
        """
        return pulumi.get(self, "phases")

    @phases.setter
    def phases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseArgs']]]]):
        pulumi.set(self, "phases", value)


@pulumi.input_type
class JobProgressPhaseArgs:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 duration_in_ms: Optional[pulumi.Input[int]] = None,
                 extracts: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]] = None,
                 is_advisor_report_available: Optional[pulumi.Input[bool]] = None,
                 issue: Optional[pulumi.Input[str]] = None,
                 log_locations: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 progress: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] action: The text describing the action required to fix the issue
        :param pulumi.Input[int] duration_in_ms: Duration of the phase in milliseconds
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]] extracts: Summary of phase status results.
        :param pulumi.Input[bool] is_advisor_report_available: True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        :param pulumi.Input[str] issue: The text describing the root cause of the reported issue
        :param pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]] log_locations: Details to access log file in the specified Object Storage bucket, if any.
        :param pulumi.Input[str] name: Phase name
        :param pulumi.Input[int] progress: Percent progress of job phase.
        :param pulumi.Input[str] status: Phase status
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if duration_in_ms is not None:
            pulumi.set(__self__, "duration_in_ms", duration_in_ms)
        if extracts is not None:
            pulumi.set(__self__, "extracts", extracts)
        if is_advisor_report_available is not None:
            pulumi.set(__self__, "is_advisor_report_available", is_advisor_report_available)
        if issue is not None:
            pulumi.set(__self__, "issue", issue)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the action required to fix the issue
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="durationInMs")
    def duration_in_ms(self) -> Optional[pulumi.Input[int]]:
        """
        Duration of the phase in milliseconds
        """
        return pulumi.get(self, "duration_in_ms")

    @duration_in_ms.setter
    def duration_in_ms(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "duration_in_ms", value)

    @property
    @pulumi.getter
    def extracts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]:
        """
        Summary of phase status results.
        """
        return pulumi.get(self, "extracts")

    @extracts.setter
    def extracts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseExtractArgs']]]]):
        pulumi.set(self, "extracts", value)

    @property
    @pulumi.getter(name="isAdvisorReportAvailable")
    def is_advisor_report_available(self) -> Optional[pulumi.Input[bool]]:
        """
        True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        """
        return pulumi.get(self, "is_advisor_report_available")

    @is_advisor_report_available.setter
    def is_advisor_report_available(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_advisor_report_available", value)

    @property
    @pulumi.getter
    def issue(self) -> Optional[pulumi.Input[str]]:
        """
        The text describing the root cause of the reported issue
        """
        return pulumi.get(self, "issue")

    @issue.setter
    def issue(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issue", value)

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]:
        """
        Details to access log file in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "log_locations")

    @log_locations.setter
    def log_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobProgressPhaseLogLocationArgs']]]]):
        pulumi.set(self, "log_locations", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Phase name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def progress(self) -> Optional[pulumi.Input[int]]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progress")

    @progress.setter
    def progress(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "progress", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Phase status
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class JobProgressPhaseExtractArgs:
    def __init__(__self__, *,
                 message: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] message: Message in entry.
        :param pulumi.Input[str] type: Type of unsupported object
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        Message in entry.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JobProgressPhaseLogLocationArgs:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] bucket: Name of the bucket containing the log file.
        :param pulumi.Input[str] namespace: Object Storage namespace.
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the bucket containing the log file.
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)


@pulumi.input_type
class JobUnsupportedObjectArgs:
    def __init__(__self__, *,
                 object: Optional[pulumi.Input[str]] = None,
                 owner: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] object: Name of the object (regular expression is allowed)
        :param pulumi.Input[str] owner: Owner of the object (regular expression is allowed)
        :param pulumi.Input[str] type: Type of unsupported object
        """
        if object is not None:
            pulumi.set(__self__, "object", object)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[str]]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "owner", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class GetMigrationObjectTypesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Object type name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


