# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'JobProgress',
    'JobProgressPhase',
    'JobProgressPhaseExtract',
    'JobProgressPhaseLogLocation',
    'JobUnsupportedObject',
    'GetJobAdvisorReportReportLocationDetailResult',
    'GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult',
    'GetJobOutputItemResult',
    'GetMigrationObjectTypesFilterResult',
    'GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionResult',
    'GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult',
]

@pulumi.output_type
class JobProgress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "currentPhase":
            suggest = "current_phase"
        elif key == "currentStatus":
            suggest = "current_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobProgress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobProgress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobProgress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 current_phase: Optional[str] = None,
                 current_status: Optional[str] = None,
                 phases: Optional[Sequence['outputs.JobProgressPhase']] = None):
        """
        :param str current_phase: Current phase of the job.
        :param str current_status: Current status of the job.
        :param Sequence['JobProgressPhaseArgs'] phases: List of phase status for the job.
        """
        if current_phase is not None:
            pulumi.set(__self__, "current_phase", current_phase)
        if current_status is not None:
            pulumi.set(__self__, "current_status", current_status)
        if phases is not None:
            pulumi.set(__self__, "phases", phases)

    @property
    @pulumi.getter(name="currentPhase")
    def current_phase(self) -> Optional[str]:
        """
        Current phase of the job.
        """
        return pulumi.get(self, "current_phase")

    @property
    @pulumi.getter(name="currentStatus")
    def current_status(self) -> Optional[str]:
        """
        Current status of the job.
        """
        return pulumi.get(self, "current_status")

    @property
    @pulumi.getter
    def phases(self) -> Optional[Sequence['outputs.JobProgressPhase']]:
        """
        List of phase status for the job.
        """
        return pulumi.get(self, "phases")


@pulumi.output_type
class JobProgressPhase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationInMs":
            suggest = "duration_in_ms"
        elif key == "isAdvisorReportAvailable":
            suggest = "is_advisor_report_available"
        elif key == "logLocations":
            suggest = "log_locations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobProgressPhase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobProgressPhase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobProgressPhase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[str] = None,
                 duration_in_ms: Optional[int] = None,
                 extracts: Optional[Sequence['outputs.JobProgressPhaseExtract']] = None,
                 is_advisor_report_available: Optional[bool] = None,
                 issue: Optional[str] = None,
                 log_locations: Optional[Sequence['outputs.JobProgressPhaseLogLocation']] = None,
                 name: Optional[str] = None,
                 progress: Optional[int] = None,
                 status: Optional[str] = None):
        """
        :param str action: The text describing the action required to fix the issue
        :param int duration_in_ms: Duration of the phase in milliseconds
        :param Sequence['JobProgressPhaseExtractArgs'] extracts: Summary of phase status results.
        :param bool is_advisor_report_available: True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        :param str issue: The text describing the root cause of the reported issue
        :param Sequence['JobProgressPhaseLogLocationArgs'] log_locations: Details to access log file in the specified Object Storage bucket, if any.
        :param str name: Phase name
        :param int progress: Percent progress of job phase.
        :param str status: Phase status
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if duration_in_ms is not None:
            pulumi.set(__self__, "duration_in_ms", duration_in_ms)
        if extracts is not None:
            pulumi.set(__self__, "extracts", extracts)
        if is_advisor_report_available is not None:
            pulumi.set(__self__, "is_advisor_report_available", is_advisor_report_available)
        if issue is not None:
            pulumi.set(__self__, "issue", issue)
        if log_locations is not None:
            pulumi.set(__self__, "log_locations", log_locations)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if progress is not None:
            pulumi.set(__self__, "progress", progress)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def action(self) -> Optional[str]:
        """
        The text describing the action required to fix the issue
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="durationInMs")
    def duration_in_ms(self) -> Optional[int]:
        """
        Duration of the phase in milliseconds
        """
        return pulumi.get(self, "duration_in_ms")

    @property
    @pulumi.getter
    def extracts(self) -> Optional[Sequence['outputs.JobProgressPhaseExtract']]:
        """
        Summary of phase status results.
        """
        return pulumi.get(self, "extracts")

    @property
    @pulumi.getter(name="isAdvisorReportAvailable")
    def is_advisor_report_available(self) -> Optional[bool]:
        """
        True if a Pre-Migration Advisor report is available for this phase. False or null if no report is available.
        """
        return pulumi.get(self, "is_advisor_report_available")

    @property
    @pulumi.getter
    def issue(self) -> Optional[str]:
        """
        The text describing the root cause of the reported issue
        """
        return pulumi.get(self, "issue")

    @property
    @pulumi.getter(name="logLocations")
    def log_locations(self) -> Optional[Sequence['outputs.JobProgressPhaseLogLocation']]:
        """
        Details to access log file in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "log_locations")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Phase name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def progress(self) -> Optional[int]:
        """
        Percent progress of job phase.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        Phase status
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class JobProgressPhaseExtract(dict):
    def __init__(__self__, *,
                 message: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str message: Message in entry.
        :param str type: Type of unsupported object
        """
        if message is not None:
            pulumi.set(__self__, "message", message)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        Message in entry.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobProgressPhaseLogLocation(dict):
    def __init__(__self__, *,
                 bucket: Optional[str] = None,
                 namespace: Optional[str] = None,
                 object: Optional[str] = None):
        """
        :param str bucket: Name of the bucket containing the log file.
        :param str namespace: Object Storage namespace.
        :param str object: Name of the object (regular expression is allowed)
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if object is not None:
            pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[str]:
        """
        Name of the bucket containing the log file.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class JobUnsupportedObject(dict):
    def __init__(__self__, *,
                 object: Optional[str] = None,
                 owner: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str object: Name of the object (regular expression is allowed)
        :param str owner: Owner of the object (regular expression is allowed)
        :param str type: Type of unsupported object
        """
        if object is not None:
            pulumi.set(__self__, "object", object)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def object(self) -> Optional[str]:
        """
        Name of the object (regular expression is allowed)
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def owner(self) -> Optional[str]:
        """
        Owner of the object (regular expression is allowed)
        """
        return pulumi.get(self, "owner")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Type of unsupported object
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetJobAdvisorReportReportLocationDetailResult(dict):
    def __init__(__self__, *,
                 location_in_source: str,
                 object_storage_details: Sequence['outputs.GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult']):
        """
        :param str location_in_source: Path in the Source Registered Connection where the Pre-Migration advisor report can be accessed.
        :param Sequence['GetJobAdvisorReportReportLocationDetailObjectStorageDetailArgs'] object_storage_details: Details to access Pre-Migration Advisor report in the specified Object Storage bucket, if any.
        """
        pulumi.set(__self__, "location_in_source", location_in_source)
        pulumi.set(__self__, "object_storage_details", object_storage_details)

    @property
    @pulumi.getter(name="locationInSource")
    def location_in_source(self) -> str:
        """
        Path in the Source Registered Connection where the Pre-Migration advisor report can be accessed.
        """
        return pulumi.get(self, "location_in_source")

    @property
    @pulumi.getter(name="objectStorageDetails")
    def object_storage_details(self) -> Sequence['outputs.GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult']:
        """
        Details to access Pre-Migration Advisor report in the specified Object Storage bucket, if any.
        """
        return pulumi.get(self, "object_storage_details")


@pulumi.output_type
class GetJobAdvisorReportReportLocationDetailObjectStorageDetailResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 namespace: str,
                 object: str):
        """
        :param str bucket: Name of the bucket containing the Pre-Migration Advisor report.
        :param str namespace: Object Storage namespace.
        :param str object: Pre-Migration Advisor report object name.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "object", object)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        Name of the bucket containing the Pre-Migration Advisor report.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Object Storage namespace.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def object(self) -> str:
        """
        Pre-Migration Advisor report object name.
        """
        return pulumi.get(self, "object")


@pulumi.output_type
class GetJobOutputItemResult(dict):
    def __init__(__self__, *,
                 message: str):
        """
        :param str message: Job output line.
        """
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Job output line.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class GetMigrationObjectTypesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Object type name
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult']):
        """
        :param Sequence['GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemArgs'] items: Items in collection.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult']:
        """
        Items in collection.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetMigrationObjectTypesMigrationObjectTypeSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 name: str):
        """
        :param str name: Object type name
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Object type name
        """
        return pulumi.get(self, "name")


