# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetCatalogResult',
    'AwaitableGetCatalogResult',
    'get_catalog',
    'get_catalog_output',
]

@pulumi.output_type
class GetCatalogResult:
    """
    A collection of values returned by getCatalog.
    """
    def __init__(__self__, attached_catalog_private_endpoints=None, catalog_id=None, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, lifecycle_details=None, locks=None, number_of_objects=None, service_api_url=None, service_console_url=None, state=None, system_tags=None, time_created=None, time_updated=None):
        if attached_catalog_private_endpoints and not isinstance(attached_catalog_private_endpoints, list):
            raise TypeError("Expected argument 'attached_catalog_private_endpoints' to be a list")
        pulumi.set(__self__, "attached_catalog_private_endpoints", attached_catalog_private_endpoints)
        if catalog_id and not isinstance(catalog_id, str):
            raise TypeError("Expected argument 'catalog_id' to be a str")
        pulumi.set(__self__, "catalog_id", catalog_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if number_of_objects and not isinstance(number_of_objects, int):
            raise TypeError("Expected argument 'number_of_objects' to be a int")
        pulumi.set(__self__, "number_of_objects", number_of_objects)
        if service_api_url and not isinstance(service_api_url, str):
            raise TypeError("Expected argument 'service_api_url' to be a str")
        pulumi.set(__self__, "service_api_url", service_api_url)
        if service_console_url and not isinstance(service_console_url, str):
            raise TypeError("Expected argument 'service_console_url' to be a str")
        pulumi.set(__self__, "service_console_url", service_console_url)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="attachedCatalogPrivateEndpoints")
    def attached_catalog_private_endpoints(self) -> Sequence[str]:
        """
        The list of private reverse connection endpoints attached to the catalog
        """
        return pulumi.get(self, "attached_catalog_private_endpoints")

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> str:
        return pulumi.get(self, "catalog_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Data catalog identifier, which can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        An message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in 'Failed' state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetCatalogLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="numberOfObjects")
    def number_of_objects(self) -> int:
        """
        The number of data objects added to the data catalog. Please see the data catalog documentation for further information on how this is calculated.
        """
        return pulumi.get(self, "number_of_objects")

    @property
    @pulumi.getter(name="serviceApiUrl")
    def service_api_url(self) -> str:
        """
        The REST front endpoint URL to the data catalog instance.
        """
        return pulumi.get(self, "service_api_url")

    @property
    @pulumi.getter(name="serviceConsoleUrl")
    def service_console_url(self) -> str:
        """
        The console front endpoint URL to the data catalog instance.
        """
        return pulumi.get(self, "service_console_url")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the data catalog resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the data catalog was created. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the data catalog was updated. An [RFC3339](https://tools.ietf.org/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetCatalogResult(GetCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogResult(
            attached_catalog_private_endpoints=self.attached_catalog_private_endpoints,
            catalog_id=self.catalog_id,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            locks=self.locks,
            number_of_objects=self.number_of_objects,
            service_api_url=self.service_api_url,
            service_console_url=self.service_console_url,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_catalog(catalog_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogResult:
    """
    This data source provides details about a specific Catalog resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a data catalog by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog = oci.DataCatalog.get_catalog(catalog_id=test_catalog_oci_datacatalog_catalog["id"])
    ```


    :param str catalog_id: Unique catalog identifier.
    """
    __args__ = dict()
    __args__['catalogId'] = catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getCatalog:getCatalog', __args__, opts=opts, typ=GetCatalogResult).value

    return AwaitableGetCatalogResult(
        attached_catalog_private_endpoints=pulumi.get(__ret__, 'attached_catalog_private_endpoints'),
        catalog_id=pulumi.get(__ret__, 'catalog_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locks=pulumi.get(__ret__, 'locks'),
        number_of_objects=pulumi.get(__ret__, 'number_of_objects'),
        service_api_url=pulumi.get(__ret__, 'service_api_url'),
        service_console_url=pulumi.get(__ret__, 'service_console_url'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_catalog)
def get_catalog_output(catalog_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogResult]:
    """
    This data source provides details about a specific Catalog resource in Oracle Cloud Infrastructure Data Catalog service.

    Gets a data catalog by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalog = oci.DataCatalog.get_catalog(catalog_id=test_catalog_oci_datacatalog_catalog["id"])
    ```


    :param str catalog_id: Unique catalog identifier.
    """
    ...
