# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetServiceCatalogResult',
    'AwaitableGetServiceCatalogResult',
    'get_service_catalog',
    'get_service_catalog_output',
]

@pulumi.output_type
class GetServiceCatalogResult:
    """
    A collection of values returned by getServiceCatalog.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, service_catalog_id=None, state=None, time_created=None, time_updated=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_catalog_id and not isinstance(service_catalog_id, str):
            raise TypeError("Expected argument 'service_catalog_id' to be a str")
        pulumi.set(__self__, "service_catalog_id", service_catalog_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The Compartment id where the service catalog exists
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The name of the service catalog.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique identifier for the Service catalog.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceCatalogId")
    def service_catalog_id(self) -> str:
        return pulumi.get(self, "service_catalog_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the service catalog.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the service catalog was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2021-05-26T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time the service catalog was last modified, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2021-12-10T05:10:29.721Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetServiceCatalogResult(GetServiceCatalogResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceCatalogResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            service_catalog_id=self.service_catalog_id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_service_catalog(service_catalog_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceCatalogResult:
    """
    This data source provides details about a specific Service Catalog resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets detailed information about the service catalog including name, compartmentId

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog = oci.ServiceCatalog.get_service_catalog(service_catalog_id=test_service_catalog_oci_service_catalog_service_catalog["id"])
    ```


    :param str service_catalog_id: The unique identifier for the service catalog.
    """
    __args__ = dict()
    __args__['serviceCatalogId'] = service_catalog_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ServiceCatalog/getServiceCatalog:getServiceCatalog', __args__, opts=opts, typ=GetServiceCatalogResult).value

    return AwaitableGetServiceCatalogResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        service_catalog_id=pulumi.get(__ret__, 'service_catalog_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_service_catalog)
def get_service_catalog_output(service_catalog_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceCatalogResult]:
    """
    This data source provides details about a specific Service Catalog resource in Oracle Cloud Infrastructure Service Catalog service.

    Gets detailed information about the service catalog including name, compartmentId

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_service_catalog = oci.ServiceCatalog.get_service_catalog(service_catalog_id=test_service_catalog_oci_service_catalog_service_catalog["id"])
    ```


    :param str service_catalog_id: The unique identifier for the service catalog.
    """
    ...
