# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAwsPrivatelinkEndpointResult',
    'AwaitableGetAwsPrivatelinkEndpointResult',
    'get_aws_privatelink_endpoint',
    'get_aws_privatelink_endpoint_output',
]

@pulumi.output_type
class GetAwsPrivatelinkEndpointResult:
    """
    A collection of values returned by getAwsPrivatelinkEndpoint.
    """
    def __init__(__self__, domain_name=None, id=None, region=None, vpc_service_name=None, zone_ids=None):
        if domain_name and not isinstance(domain_name, str):
            raise TypeError("Expected argument 'domain_name' to be a str")
        pulumi.set(__self__, "domain_name", domain_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vpc_service_name and not isinstance(vpc_service_name, str):
            raise TypeError("Expected argument 'vpc_service_name' to be a str")
        pulumi.set(__self__, "vpc_service_name", vpc_service_name)
        if zone_ids and not isinstance(zone_ids, list):
            raise TypeError("Expected argument 'zone_ids' to be a list")
        pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> str:
        """
        The domain name to used in when configuring a private hosted zone in the VPCE connection.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Region to retrieve the Private Link configuration for.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="vpcServiceName")
    def vpc_service_name(self) -> str:
        """
        The VPC service name used to connect to the region.
        """
        return pulumi.get(self, "vpc_service_name")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Sequence[str]:
        """
        The IDs of the availability zones hosting the VPC endpoints.
        """
        return pulumi.get(self, "zone_ids")


class AwaitableGetAwsPrivatelinkEndpointResult(GetAwsPrivatelinkEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAwsPrivatelinkEndpointResult(
            domain_name=self.domain_name,
            id=self.id,
            region=self.region,
            vpc_service_name=self.vpc_service_name,
            zone_ids=self.zone_ids)


def get_aws_privatelink_endpoint(region: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAwsPrivatelinkEndpointResult:
    """
    Use this data source to retrieve information about the AWS Private Link configuration for a given region. Further documentation on how to establish a PrivateLink connection can be found in the ESS [documentation](https://www.elastic.co/guide/en/cloud/current/ec-traffic-filtering-vpc.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ec as ec

    us_east_1 = ec.get_aws_privatelink_endpoint(region="us-east-1")
    ```


    :param str region: Region to retrieve the Private Link configuration for.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('ec:index/getAwsPrivatelinkEndpoint:getAwsPrivatelinkEndpoint', __args__, opts=opts, typ=GetAwsPrivatelinkEndpointResult).value

    return AwaitableGetAwsPrivatelinkEndpointResult(
        domain_name=pulumi.get(__ret__, 'domain_name'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        vpc_service_name=pulumi.get(__ret__, 'vpc_service_name'),
        zone_ids=pulumi.get(__ret__, 'zone_ids'))
def get_aws_privatelink_endpoint_output(region: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAwsPrivatelinkEndpointResult]:
    """
    Use this data source to retrieve information about the AWS Private Link configuration for a given region. Further documentation on how to establish a PrivateLink connection can be found in the ESS [documentation](https://www.elastic.co/guide/en/cloud/current/ec-traffic-filtering-vpc.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_ec as ec

    us_east_1 = ec.get_aws_privatelink_endpoint(region="us-east-1")
    ```


    :param str region: Region to retrieve the Private Link configuration for.
    """
    __args__ = dict()
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('ec:index/getAwsPrivatelinkEndpoint:getAwsPrivatelinkEndpoint', __args__, opts=opts, typ=GetAwsPrivatelinkEndpointResult)
    return __ret__.apply(lambda __response__: GetAwsPrivatelinkEndpointResult(
        domain_name=pulumi.get(__response__, 'domain_name'),
        id=pulumi.get(__response__, 'id'),
        region=pulumi.get(__response__, 'region'),
        vpc_service_name=pulumi.get(__response__, 'vpc_service_name'),
        zone_ids=pulumi.get(__response__, 'zone_ids')))
