# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/langchain.cache.ipynb.

# %% auto 0
__all__ = ['set_llm_cache', 'unset_llm_cache']

# %% ../../nbs/langchain.cache.ipynb 3
import os
from pathlib import Path
from typing import Optional
from langchain_core.caches import BaseCache
from langchain.globals import set_llm_cache as _set_llm_cache

# %% ../../nbs/langchain.cache.ipynb 4
def _resolve_cache_path(path: str | Path | None = None) -> Path:
    if path: 
        return path
    default_path = Path.home() / ".cache/langchain.db"
    return Path(os.getenv("LANGCHAIN_CACHE_PATH", default_path))


def set_llm_cache(value: Optional["BaseCache"], path: Path | str = None):
    if value is None:
        from langchain.cache import SQLiteCache
        value = SQLiteCache(database_path=str(_resolve_cache_path(path)))

    return _set_llm_cache(value)

def unset_llm_cache():
    return _set_llm_cache(None)
