# AUTOGENERATED! DO NOT EDIT! File to edit: ../../../nbs/ml.lang.dataset.ipynb.

# %% auto 0
__all__ = ['alpaca2sharegpt', 'alpaca2openai', 'sharegpt2openai_message', 'openai2sharegpt_message', 'sharegpt2openai',
           'openai2sharegpt']

# %% ../../../nbs/ml.lang.dataset.ipynb 3
def alpaca2sharegpt(example):
    messages = []
    if "instruction" in example:
        messages.append({"from": "system", "value": example["instruction"]})
    messages.append({"from": "human", "value": example["input"]})
    messages.append({"from": "gpt", "value": example["output"]})
    return {"chat": messages}


def alpaca2openai(example):
    messages = []
    if "instruction" in example:
        messages.append({"role": "system", "content": example["instruction"]})
    messages.append({"role": "user", "content": example["input"]})
    messages.append({"role": "assistant", "content": example["output"]})
    return {"chat": messages}


def sharegpt2openai_message(message):
    role = {"system": "system", "human": "user", "gpt": "assistant"}[message["from"]]
    return {"role": role, "content": message["value"]}


def openai2sharegpt_message(message):
    frm = {"system": "system", "user": "human", "assistant": "gpt"}[message["role"]]
    return {"from": frm, "value": message["content"]}


def sharegpt2openai(example):
    return {
        "chat": [sharegpt2openai_message(message) for message in example["chat"]],
    }


def openai2sharegpt(example):
    return {
        "chat": [openai2sharegpt_message(message) for message in example["chat"]],
    }
