"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetectorModel = exports.EventEvaluation = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const core_1 = require("aws-cdk-lib/core");
const aws_iotevents_1 = require("aws-cdk-lib/aws-iotevents");
/**
 * Information about the order in which events are evaluated and how actions are executed.
 */
var EventEvaluation;
(function (EventEvaluation) {
    /**
     * When setting to BATCH, variables within a state are updated and events within a state are
     * performed only after all event conditions are evaluated.
     */
    EventEvaluation["BATCH"] = "BATCH";
    /**
     * When setting to SERIAL, variables are updated and event conditions are evaluated in the order
     * that the events are defined.
     */
    EventEvaluation["SERIAL"] = "SERIAL";
})(EventEvaluation || (exports.EventEvaluation = EventEvaluation = {}));
/**
 * Defines an AWS IoT Events detector model in this stack.
 */
class DetectorModel extends core_1.Resource {
    /**
     * Import an existing detector model.
     */
    static fromDetectorModelName(scope, id, detectorModelName) {
        return new class extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.detectorModelName = detectorModelName;
            }
        }(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.detectorModelName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_DetectorModelProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, DetectorModel);
            }
            throw error;
        }
        if (!props.initialState._onEnterEventsHaveAtLeastOneCondition()) {
            throw new Error('Detector Model must have at least one Input with a condition');
        }
        const role = props.role ?? new iam.Role(this, 'DetectorModelRole', {
            assumedBy: new iam.ServicePrincipal('iotevents.amazonaws.com'),
        });
        const resource = new aws_iotevents_1.CfnDetectorModel(this, 'Resource', {
            detectorModelName: this.physicalName,
            detectorModelDescription: props.description,
            evaluationMethod: props.evaluationMethod,
            key: props.detectorKey,
            detectorModelDefinition: {
                initialStateName: props.initialState.stateName,
                states: props.initialState._collectStateJsons(this, { role }, new Set()),
            },
            roleArn: role.roleArn,
        });
        this.detectorModelName = this.getResourceNameAttribute(resource.ref);
    }
}
exports.DetectorModel = DetectorModel;
_a = JSII_RTTI_SYMBOL_1;
DetectorModel[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.DetectorModel", version: "2.161.1-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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