"""Added API Key Management table

Revision ID: 4fcbfb7f3145
Revises: 821173cf9c5d
Create Date: 2025-03-18 16:31:23.532135

"""

from typing import Sequence, Union

import sqlalchemy
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "4fcbfb7f3145"
down_revision: Union[str, None] = "821173cf9c5d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "api_key_management",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sqlalchemy.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column("title", sa.String(), nullable=True),
        sa.Column("is_active", sa.Boolean(), nullable=False),
        sa.Column("register_email", sa.String(), nullable=False),
        sa.Column("digest", sa.LargeBinary(), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="user_related",
    )


def downgrade() -> None:
    op.drop_table("api_key_management", schema="user_related")
    # ### end Alembic commands ###
