"""context_document

Revision ID: 5d82613c9aca
Revises: e354666f951d
Create Date: 2025-10-08 12:14:40.215929

"""

from typing import Sequence, Union

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "5d82613c9aca"
down_revision: Union[str, None] = "e354666f951d"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "context_document",
        sa.Column(
            "id",
            sa.Uuid(),
            server_default=sa.func.gen_random_uuid(),
            nullable=False,
        ),
        sa.Column("embedding_model_id", sa.Uuid(), nullable=False),
        sa.Column("url", sa.String()),
        sa.Column("full_content", sa.String()),
        sa.Column("title", sa.String(), nullable=False),
        sa.Column("sdg_related", sa.ARRAY(sa.INTEGER()), nullable=False),
        sa.Column(
            "created_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column("embedding", sa.LargeBinary(), nullable=True),
        sa.Column(
            "updated_at", postgresql.TIMESTAMP(), server_default="NOW()", nullable=False
        ),
        sa.Column(
            "context_type",
            postgresql.ENUM(
                "introduction",
                "target",
                "subject",
                name="context_type",
                schema="document_related",
            ),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["embedding_model_id"],
            ["corpus_related.embedding_model.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
        schema="document_related",
    )


def downgrade() -> None:
    op.drop_table("context_document", schema="document_related")
    # ### end Alembic commands ###
